package bidding.web.controller;

import api.query.BiddingQueryApi;
import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingOrderManagerService;
import bidding.web.service.BiddingSupplierOrderManagerService;
import bidding.web.vo.*;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingRole;
import dto.BiddingOrderInfoDto;
import dto.BiddingSupplierOrderMangerDto;
import dto.JcbdBiddingDto;
import dto.JcbdRoleOperationDto;
import lombok.extern.slf4j.Slf4j;
import member.api.QueryOrderApi;
import member.api.dto.shop.MemberInVoiceDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import outsideapi.vo.OrderShippingPackageVo;
import query.BiddingSupplierOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.excel.excelcreate.ExcelCreateUtil;
import utils.excel.excelcreate.vo.ExcelInfoVo;
import utils.web.ResponseMapUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author luoxianwei
 * @date 2018/4/14
 */
@Slf4j
@RestController
@RequestMapping("supplierOperator")
public class BiddingSupplierOrderManagerController {

    /**
     * 分页获取供应商订单管理列表
     *
     * @param biddingSupplierOrderManagerListQuery
     * @return
     */
    @RequestMapping(value = "/getBiddingSupplierOrderMangerList", method = RequestMethod.POST)
    public Map getBiddingSupplierOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, HttpServletRequest request, Pageable pageable) {
        String orderSTime = request.getParameter("orderSTime");
        String orderETime = request.getParameter("orderETime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (!Lang.isEmpty(orderSTime)) {
                orderSTime += " 00:00:00";
                biddingSupplierOrderManagerListQuery.setOrderStartTime(sdf.parse(orderSTime));
            }
            if (!Lang.isEmpty(orderETime)) {
                orderETime += " 23:59:59";
                biddingSupplierOrderManagerListQuery.setOrderEndTime(sdf.parse(orderETime));
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (Lang.isEmpty(biddingSupplierOrderManagerListQuery.getStatus())) {
            biddingSupplierOrderManagerListQuery.setStatus(null);
        }
        //获取当前登录人id
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        biddingSupplierOrderManagerListQuery.setProviderId(biddingMemberId);
        Map resultMap = biddingSupplierOrderManagerService.getBiddingSupplierOrderMangerList(jqueryDataTablesVo, biddingSupplierOrderManagerListQuery, pageable);
        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 导出Excel
     *
     * @param response
     * @param biddingSupplierOrderManagerListQuery
     * @param request
     * @param pageable
     */
    @RequestMapping(value = "/downloadExcel", method = RequestMethod.POST)
    public void download(HttpServletResponse response, BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, HttpServletRequest request, Pageable pageable) {
        String orderSTime = request.getParameter("orderSTime");
        String orderETime = request.getParameter("orderETime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (!Lang.isEmpty(orderSTime)) {
                biddingSupplierOrderManagerListQuery.setOrderStartTime(sdf.parse(orderSTime));
            }
            if (!Lang.isEmpty(orderETime)) {
                biddingSupplierOrderManagerListQuery.setOrderEndTime(sdf.parse(orderETime));
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (Lang.isEmpty(biddingSupplierOrderManagerListQuery.getStatus())) {
            biddingSupplierOrderManagerListQuery.setStatus(null);
        }
        Page<BiddingSupplierOrderMangerDto> page = biddingSupplierOrderManagerService.getSupplierOrderMangerList(biddingSupplierOrderManagerListQuery, pageable);
        List<BiddingSupplierOrderMangerDto> dtoList = page.getContent();

        //excel 2003
        String fileName = "supplierOrderManager.xls";
//      String fileName = "excelCretaeTest.xlsx";        //excel 2007
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
//        ColumnInfoVo excelData = AnnotationUtil.getExcelData(Student.class, studentList1);
//        System.out.println("excelData = " + excelData);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelInfoVo excelInfoVo = new ExcelInfoVo(BiddingSupplierOrderMangerDto.class, dtoList, outputStream, fileName);
//            excelInfoVo.setDateFormat(new SimpleDateFormat("YYYY/MM/DD HH:mm:ss"));
            ExcelCreateUtil.create(excelInfoVo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 所有状态
     *
     * @return
     */
    @RequestMapping(value = "/getAllSupplierStatus", method = RequestMethod.GET)
    public List<QueryStatus> getAllSupplierStatus() {
        List<QueryStatus> allStatusList = biddingSupplierOrderManagerService.getAllSupplierStatus();
        return allStatusList;
    }

    /**
     * 供应商确认订单
     *
     * @param mallOrderNos mallOrderNos
     * @return BaseResponse
     */
    @PostMapping(value = "confirmOrder")
    public BaseResponse<List<String>> confirmOrder(@RequestParam("mallOrderNos") String mallOrderNos,String signValue,
                                                   HttpServletRequest request) {
        String existSignValue = (String) request.getSession().getAttribute(GlobalContants.SESSION_TPCLOUD_SIGN_VALUE);
        if (Lang.isEmpty(existSignValue)){
            return new BaseResponse<>(false,"非法请求");
        }
        if (!existSignValue.equals(signValue)){
            return new BaseResponse<>(false,"非法请求");
        }
        // 清除缓存
        request.getSession().setAttribute(GlobalContants.SESSION_TPCLOUD_SIGN_VALUE,"");
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        long methodStartTime = System.currentTimeMillis();
        log.info("### 供应商确认订单开始 ###");
        log.info("请求参数 mallOrderNos : {}", mallOrderNos);
        List<String> mallOrderIdList = JSONArray.parseArray(mallOrderNos, String.class);
        BaseResponse<List<String>> baseResponse = biddingSupplierOrderManagerService.confirmOrder(mallOrderIdList,biddingMemberId,signValue);
        log.info("### 供应商确认订单结束, 总耗时 {} ms ###", System.currentTimeMillis() - methodStartTime);
        return baseResponse;
    }

    /**
     * 供应商订单删除
     *
     * @param mallOrderNo mallOrderNo
     * @return BaseResponse
     */
    @PostMapping(value = "deleteMallOrder")
    public BaseResponse deleteMallOrder(@RequestParam("mallOrderNo") String mallOrderNo) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### 供应商订单删除 ###");
        log.info("请求参数 mallOrderNo : {}", mallOrderNo);
        BaseResponse baseResponse = biddingSupplierOrderManagerService.deleteMallOrder(mallOrderNo);
        log.info("### 供应商订单删除, 总耗时 {} ms ###", System.currentTimeMillis() - methodStartTime);
        return baseResponse;
    }

    /**
     * 供应商订单详情信息

     * @return
     */
    @RequestMapping(value = "/getSupplierOrderDetailInfo",method = RequestMethod.POST)
    public String getBiddingOrderInfoVo(String orderNo, String biddingCode,String status, HttpServletRequest request){
        Map map = new HashMap(16);
        HttpSession session = request.getSession();
        Map<String, Object> params = new HashMap<>(16);
        params.put("orderNo", orderNo);
        Map<String, Object> orderMap = queryOrderApi.queryOrderDetail(params);

        if (!Lang.isEmpty(orderMap)) {
            OrderMainDto orderMain = (OrderMainDto) orderMap.get("orderMain");
            if(!Lang.isEmpty(orderMain)){
                List<OrderItemDto> orderItems = orderMain.getOrderItems();
                List<List<OrderItemDto>> items = new ArrayList<>();  //订单商品
                List<OrderItemDto> orderItemDtos = new ArrayList<>();
                for (OrderItemDto orderItem : orderItems) {
                    OrderItemDto orderItemDto = BeanMapper.map(orderItem, OrderItemDto.class);
                    orderItemDtos.add(orderItemDto);
                }
                items.add(orderItemDtos);
                orderMap.put("items",items);
                List<String> orderNos = new ArrayList<>();   //子订单号
                String orderNo1 = orderMain.getOrderNo();
                orderNos.add(orderNo1);
                orderMap.put("orderNos",orderNos);
            }
            map.putAll(orderMap);
        }

        //订单类型，供应商名称
        BiddingOrderInfoDto orderInfoDto = biddingOrderManagerService.getOrderInfoByOrderNo(orderNo);
        map.put("orderInfoDto",orderInfoDto);

        biddingOrderManagerService.getFlowSteps(orderInfoDto.getReviewNo(), map);
        List<ImageVo> uploadFiles = biddingOrderManagerService.getOrderUploadFiles(orderNo);

        if (!uploadFiles.isEmpty()) {
            map.put("uploadFiles", uploadFiles);
        }
        map.put("invoiceTypeMap", MemberInVoiceDto.INVOICETYPEMAP);
        String orderStatus = request.getParameter("status");
        map.put("status", orderStatus);
        Map<String,Object> orderTrackResp = (Map<String, Object>) map.get("orderTrackResp");
        List<OrderTrackRespVo> orderTrackRespVoList = new ArrayList<>();
        OrderTrackRespVo orderTrackRespVo = null;
        if(!Lang.isEmpty(orderTrackResp)){
            for (String key : orderTrackResp.keySet()) {
                orderTrackRespVo =  new OrderTrackRespVo();
                orderTrackRespVo.setKey(key);
                OrderShippingPackageVo orderShippingTrackVo = (OrderShippingPackageVo) orderTrackResp.get(key);
                orderTrackRespVo.setOrderShippingTrackVo(BeanMapper.map(orderShippingTrackVo,OrderShippingPackageVo.class));
                orderTrackRespVoList.add(orderTrackRespVo);
            }
        }
        map.put("orderTrackRespVo",orderTrackRespVoList);


        //竞价信息
        //经办人id通过竞价编号取
        //String biddingUserId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        JcbdBiddingDto jcbdBiddingDto = biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);
        JcbdBiddingVo biddingVo = biddingOperatorService.getOperator(jcbdBiddingDto.getOperatorId());
        BiddingInformationVo biddingInformationVo = BeanMapper.map(biddingVo, BiddingInformationVo.class);
        //竞价编号
        biddingInformationVo.setBiddingCode(biddingCode);
        map.put("biddingInformationVo",biddingInformationVo);

        //根据状态获取操作信息
        List<JcbdRoleOperationDto> jcbdRoleOperationDtos =biddingOrderManagerService.getSuperlierOpertionByStatus(status);
        map.put("jcbdRoleOperationDtos",jcbdRoleOperationDtos);
        String orderInfoJsonString = JSON.toJSONString(map);
        return  orderInfoJsonString;
    }



    @Autowired
    BiddingOrderManagerService biddingOrderManagerService;

    @Autowired
    BiddingSupplierOrderManagerService biddingSupplierOrderManagerService;

    @MotanReferer
    QueryOrderApi queryOrderApi;
    @MotanReferer
    BiddingQueryApi biddingQueryApi;
    @Autowired
    BiddingOperatorService biddingOperatorService;
}

