package bidding.web.controller.page;

import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingProviderService;
import bidding.web.vo.BiddingBaseInfoVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Map;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@Controller
@RequestMapping("biddingQuery/page")
public class BiddingQueryPageController {
    @Autowired
    BiddingOperatorService biddingOperatorService;

    @Autowired
    BiddingProviderService biddingProviderService;


    /**
     * 基本信息查询页
     *
     * @return
     */
    @RequestMapping("/biddingBaseInfo")
    public String biddingBaseInfo() {
        return "bidding/query/biddingQueryBaseInfo";
    }

    /**
     * 竞价需求页
     */
    @RequestMapping("/biddingDemand")
    public String biddingDemand() {
        return "bidding/query/biddingQueryDemand";
    }

    /**
     * 竞价响应页
     */
    @RequestMapping("/biddingResponse")
    public String biddingResponse() {
        return "bidding/query/biddingQueryResponse";
    }

    /**
     * 符合性审查查询页
     */
    @RequestMapping("/biddingConformance")
    public String biddingConformance() {
        return "bidding/query/biddingQueryConformance";
    }

    /**
     * 比价页
     */
    @RequestMapping("/biddingComparativePrices")
    public String biddingComparativePrices() {
        return "bidding/query/biddingQueryComparativePrices";
    }

    /**
     * 投票结果页
     */
    @RequestMapping("/biddingVote")
    public String biddingVote() {
        return "bidding/query/biddingQueryVote";
    }

    /**
     * 竞价结果页
     */
    @RequestMapping("/biddingResult")
    public String biddingResult() {
        return "bidding/query/biddingQueryResult";
    }

    /**
     * 执行采购
     */
    @RequestMapping("/biddingOperativeBuy")
    public String biddingOperativeBuy() {
        return "bidding/query/biddingQueryOperativeBuy";
    }

    /**
     * 执行采购结果页
     */
    @RequestMapping("/biddingOperativeBuyResult")
    public String biddingOperativeBuyResult() {
        return "bidding/query/biddingQueryOperativeBuyResult";
    }

    /**
     * 竞价操作记录页
     */
    @RequestMapping("/biddingLog")
    public String biddingLog() {
        return "bidding/query/biddingQueryLog";
    }


    /**
     * 竞价基本信息编辑页面
     */
    @RequestMapping("/biddingBaseInfoEdit")
    public String biddingBaseInfoEdit() {
        return "bidding/query/editNewInformation";
    }

    /**
     * 竞价需求信息编辑页面
     */
    @RequestMapping("/biddingDemandEdit")
    public String biddingDemandEdit() {
        return "bidding/query/editBidDemand";
    }

    /**
     * 发起重新审查基本页面
     */
    @RequestMapping("/auditAgainBaseInfo")
    public String auditAgainBaseInfo() {
        return "bidding/query/auditAgainBaseInfo";
    }


    /**
     * 投票页面
     */
    @RequestMapping("/vote")
    public String vote() {
        return "bidding/query/biddingVote";
    }

    /**
     * 竞价需求信息编辑页面
     */
    @RequestMapping("/auditBiddingResultInformation")
    public String auditBiddingResultInformation() {
        return "bidding/query/auditInformation";
    }

    /**
     * 订单基本信息页面
     */
    @RequestMapping("/queryOrderInfo")
    public String queryOrderInfo() {
        return "bidding/query/orderInfo";
    }


    /**
     * 供应商竞价响应页面
     */
    @RequestMapping("/supplierBiddingRelevant")
    public String supplierBiddingRelevant() {
        return "bidding/query/supplierRelevantEdit";
    }


    /**
     * 供应商确认竞价响应结果
     */
    @RequestMapping("/supplierSureResult")
    public String supplierSureResult() {
        return "bidding/query/supplierSureResultQuery";
    }

    /**
     * 供应商修改sku页面
     */
    @RequestMapping("/modifySku")
    public String modifySku() {
        return "bidding/query/modifySku";
    }

    /**
     * 供应商订单详情页面
     */
    @RequestMapping("/supplierOrderDetail")
    public String supplierOrderDetail() {
        return "bidding/query/supplierOrderDetail";
    }



    /**
     * 符合性审查提交页面
     */
    @RequestMapping("/biddingConformanceSubmit")
    public String biddingConformanceSubmit() {
        return "bidding/query/biddingConformanceSubmit";
    }

    /**
     * 供应商查看竞价响应页面
     */
    @RequestMapping("/supplierBidResponseQuery")
    public String supplierBidResponseQuery(String biddingNo, Map model) {
        BiddingBaseInfoVo biddingBaseInfoVo = biddingProviderService.getBiddingDetail(biddingNo);
        model.put("baseInfo",biddingBaseInfoVo);
        return "bidding/query/supplierBidResponseQuery";
    }

    /**
     * 供应商查看竞价sku页面
     */
    @RequestMapping("/supplierSkuQuery")
    public String supplierSkuQuery() {
        return "bidding/query/supplierSkuQuery";
    }

    /**
     * 符合性审查审核流查看页面
     */
    @RequestMapping("/auditBiddingQueryConformance")
    public String auditBiddingQueryConformance() {
        return "bidding/query/auditBiddingQueryConformance";
    }
}
