package bidding.web.controller.page.auditor;

import bidding.web.service.BiddingGroupService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BiddingAuditInfoVo;
import bidding.web.vo.BiddingStatusVo;
import com.alibaba.fastjson.JSON;
import definition.BiddingRole;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author wangtao.
 * @version 审核人页面控制
 * @date 2018年3月15日19:30:10
 */

@Controller
@RequestMapping("/auditor")
public class BiddingAuditorPageController {

    @Autowired
    BiddingOperatorService biddingOperatorService;
    @Autowired
    BiddingGroupService biddingGroupService;
    /**
     * 基本信息
     * @return
     */
    @RequestMapping("/auditorBaseInfo")
    public String auditorBaseInfo(Map model) {
        model.put("look",false);
        return "/bidding/auditor/auditorBaseInfo";
    }

    /**
     * 竞价需求
     * @return
     */
    @RequestMapping("/auditorBiddingDemand")
    public String auditorBiddingDemand() {
        return "/bidding/auditor/auditorBiddingDemand";
    }


    /**
     * 竞价响应
     * @return
     */
    @RequestMapping("/auditorBiddingRelevant")
    public String auditorBiddingRelevant() {
        return "/bidding/auditor/auditorBiddingRelevant";
    }


    /**
     * 符合性审查
     * @return
     */
    @RequestMapping("/auditorComplianceAudit")
    public String auditorComplianceAudit() {
        return "/bidding/auditor/auditorComplianceAudit";
    }

    /**
     * 竞价结果
     * @return
     */
    @RequestMapping("/auditorBiddingResult")
    public String auditorBiddingResult() {
        return "/bidding/auditor/auditorBiddingResult";
    }


    /**
     * 比价表
     * @return
     */
    @RequestMapping("/auditorCompStatement")
    public String auditorCompStatement() {
        return "/bidding/auditor/auditorCompStatement";
    }


    /**
     * 审核人员-商城竞价管理
     * @return
     */
    @RequestMapping("/biddingManage")
    public String biddingManage(Map model, HttpServletRequest request) {
        List<String> biddingMemberRoles = new ArrayList<>();
        biddingMemberRoles.add(BiddingRole.BIDDING_AUDITOR);
        List<BiddingStatusVo> biddingStatuses = biddingOperatorService.getAllStatusByRoles(biddingMemberRoles);
        BiddingAuditInfoVo biddingVO = new BiddingAuditInfoVo();
        String auditBiddingTempStr = (String) request.getSession().getAttribute("auditBiddingTemp");
        if(!Lang.isEmpty(auditBiddingTempStr)){
            biddingVO = JSON.parseObject(auditBiddingTempStr,BiddingAuditInfoVo.class);
        }
        JqueryDataTablesVo pageVo = new JqueryDataTablesVo();
        String auditBiddingPageTempStr = (String) request.getSession().getAttribute("auditBiddingPageTemp");
        if(!Lang.isEmpty(auditBiddingPageTempStr)){
            pageVo = JSON.parseObject(auditBiddingPageTempStr,JqueryDataTablesVo.class);
        }
        String workId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_AUDITOR_WORK_ID);
        String auditId = (String) request.getSession().getAttribute("auditId");
        if (Lang.equals(workId,auditId)){
            model.put("pageVo",pageVo);
            model.put("biddingVO",biddingVO);
        }else {
            model.put("pageVo",new JqueryDataTablesVo());
            model.put("biddingVO",new BiddingAuditInfoVo());
        }
        model.put("statuses",biddingStatuses);
        return "/bidding/operator/auditBidManage";
    }

    /**
     * 竞价查看
     * @return
     */
    @RequestMapping("/queryBidding")
    public String queryBidding(Map model) {
        model.put("look",true);
        return "/bidding/auditor/auditorBaseInfo";
    }
}
