package bidding.web.controller.page.operator;

import bidding.web.controller.BiddingOperatorController;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.*;
import com.alibaba.fastjson.JSON;
import definition.BiddingRole;
import definition.BiddingStatus;
import dto.JcbdBiddingGroupMemberDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import query.BiddingOperatorQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.excel.excelcreate.ExcelCreateUtil;
import utils.excel.excelcreate.vo.ExcelInfoVo;
import com.google.common.base.Splitter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@Controller
@RequestMapping("/operator")
public class BiddingOperatorPageController {

    @Autowired
    BiddingOperatorService biddingOperatorService;

    /**
     * 符合性审查页
     *
     * @return
     */
    @RequestMapping("/conformanceCheck")
    public String conformanceCheck() {
        return "/bidding/operator/biddingConformanceCheck";
    }

    /**
     * 商城竞价管理
     *
     * @return
     */
    @RequestMapping("/biddingManage")
    public String biddingManage(Map model, HttpServletRequest request) {
        //获取当前登录人角色
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        String biddingEmail = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);

        List<String> biddingMemberRoles = new ArrayList<>();
        boolean JC_CGJBR_FLAG = false;
        String rolesStr = (String) request.getSession().getAttribute(GlobalContants.SESSION_ROLE_CODES);
        if (!Lang.isEmpty(rolesStr)) {
            List<String> userRoleCodeList = Splitter.on(",").trimResults().splitToList(rolesStr);
            if (!Lang.isEmpty(userRoleCodeList)) {
                for (String userRole : userRoleCodeList) {
                    if (GlobalContants.ROLE_CODE_JC_CGJBR.equals(userRole)) {
                        JC_CGJBR_FLAG = true;
                        break;
                    }
                }
            }
        }

        if (JC_CGJBR_FLAG) {
            biddingMemberRoles.add(BiddingRole.BIDDING_OPERATOR);
            biddingMemberRoles.add(BiddingRole.BIDDING_GROUP_MEMBER);
        } else {
            biddingMemberRoles.add(BiddingRole.BIDDING_GROUP_MEMBER);
        }

        List<BiddingStatusVo> biddingStatuses = biddingOperatorService.getAllStatusByRoles(biddingMemberRoles);
        QueryBiddingRequestVO biddingVO = new QueryBiddingRequestVO();
        String operateBiddingTempStr = (String) request.getSession().getAttribute("operateBiddingTemp");
        if(!Lang.isEmpty(operateBiddingTempStr)){
            biddingVO = JSON.parseObject(operateBiddingTempStr,QueryBiddingRequestVO.class);
        }
        JqueryDataTablesVo pageVo = new JqueryDataTablesVo();
        String operateBiddingPageTempStr = (String) request.getSession().getAttribute("operateBiddingPageTemp");
        if(!Lang.isEmpty(operateBiddingPageTempStr)){
            pageVo = JSON.parseObject(operateBiddingPageTempStr,JqueryDataTablesVo.class);
        }
        String biddingMemberRole = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ROLE);
        String operateIdentity = (String) request.getSession().getAttribute("operateIdentity");
        Boolean sameUserFlag = false;
        if(Lang.isEmpty(biddingMemberRole)){
            sameUserFlag = Lang.equals(operateIdentity,biddingEmail);
        }else {
            //采购经办人
            sameUserFlag = Lang.equals(operateIdentity,memberId);
        }
        if (sameUserFlag){
            model.put("pageVo",pageVo);
            model.put("biddingVO",biddingVO);
        }else {
            model.put("pageVo",new JqueryDataTablesVo());
            model.put("biddingVO",new QueryBiddingRequestVO());
        }
        model.put("statuses", biddingStatuses);
        model.put("roles", biddingMemberRoles);
        return "/bidding/operator/bidManage";
    }


    /**
     * 采购经办人 编辑（新建/修改）
     *
     * @return
     */
    @RequestMapping("/editBidding")
    public String editBidding() {
        return "/bidding/operator/editBidding";
    }


    /**
     * 采购经办人 审核
     *
     * @return
     */
    @RequestMapping("/auditBidding")
    public String auditBidding() {
        return "/bidding/operator/auditBidding";
    }


    /**
     * 采购经办人 发布
     *
     * @return
     */
    @RequestMapping("/releaseBidding")
    public String releaseBidding() {
        return "/bidding/operator/releaseBidding";
    }

    /**
     * 采购经办人 开启符合性审查
     *
     * @return
     */
    @RequestMapping("/startComplianceAudit")
    public String startComplianceAudit() {


        return "/bidding/operator/startComplianceAudit";
    }

    /**
     * 采购经办人 符合性审查
     *
     * @return
     */
    @RequestMapping("/complianceAudit")
    public String complianceAudit(HttpServletRequest request,Map model,String source,String biddingNo) {
        if(BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
            String email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
            //获取当前登录人 是否有权限
            String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
            MemberDto memberDto = biddingOperatorService.getMember(memberId);
            if(!Lang.isEmpty(email) && !Lang.isEmpty(memberDto) && !Lang.isEmpty(memberDto.getCoreUser())){
                if(!email.equals(memberDto.getCoreUser().getEmail())){
                    return "error";
                }
            }
            JcbdBiddingVo jcbd = biddingOperatorService.getBiddingByBiddingCode(biddingNo);
            JcbdBiddingGroupMemberDto groupStatus = biddingOperatorService.findGroupStatus(email,jcbd.getId());
            if(!BiddingStatus.OM_CONFORM_AUDIT_IN.getValue().equals(groupStatus.getStatus())){
                model.put("complianceAuditFlag","hadOperator");
            }
        }
        return "/bidding/operator/complianceAudit";
    }


    /**
     * 采购经办人 发起重新审查
     *
     * @return
     */
    @RequestMapping("/auditAgain")
    public String auditAgain() {
        return "/bidding/operator/auditAgain";
    }


    /**
     * 采购经办人 开启报价
     *
     * @return
     */
    @RequestMapping("/startQuotedPrice")
    public String startQuotedPrice() {
        return "/bidding/operator/startQuotedPrice";
    }


    /**
     * 采购经办人 系统随机确定供应商
     *
     * @return
     */
    @RequestMapping("/systemConfirmSupplier")
    public String systemConfirmSupplier() {
        return "/bidding/operator/systemConfirmSupplier";
    }

    /**
     * 采购经办人 发起投票确定供应商
     *
     * @return
     */
    @RequestMapping("/voteConfirmSupplier")
    public String voteConfirmSupplier() {
        return "/bidding/operator/voteConfirmSupplier";
    }

    /**
     * 采购经办人 投票
     *
     * @return
     */
    @RequestMapping("/vote")
    public String vote() {
        return "/bidding/operator/vote";
    }


    /**
     * 采购经办人 提交竞价审核结果
     *
     * @return
     */
    @RequestMapping("/submitBiddingResultAudit")
    public String submitBiddingResultAudit() {
        return "/bidding/operator/submitBiddingResultAudit";
    }


    /**
     * 采购经办人 审核商品编码
     *
     * @return
     */
    @RequestMapping("/auditSku")
    public String auditSku() {
        return "/bidding/operator/auditSku";
    }


    /**
     * 采购经办人 执行采购
     *
     * @return
     */
    @RequestMapping("/conductProcurement")
    public String conductProcurement(HttpServletRequest request, Map model) {
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        CoreCompanyDto companyInfo = biddingOperatorService.getCompanyInfo(memberId);
        model.put("company", companyInfo);
        return "/bidding/operator/conductProcurement";
    }


    /**
     * 采购经办人 查看
     *
     * @return
     */
    @RequestMapping("/queryBidding")
    public String queryBidding(String biddingNo, HttpServletRequest request, Map model) {
        BiddingOperatorQuery biddingOperatorQuery = new BiddingOperatorQuery();
        biddingOperatorQuery.setBiddingNo(biddingNo);
        Object memberIdObj = request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (memberIdObj != null) {
            biddingOperatorQuery.setMemberId(String.valueOf(memberIdObj));
        } else {
            String email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
            biddingOperatorQuery.setEmail(email);
        }

        List<JcbdRoleOperationVo> operates = biddingOperatorService.getRoleBiddingOperates(biddingOperatorQuery);
        List<String> titles = biddingOperatorService.findBiddingShowTitle(biddingNo);
        model.put("operates", operates);
        model.put("showTitles", titles);
        return "/bidding/operator/queryBidding";
    }


    /**
     * 采购经办人 订单管理
     *
     * @return
     */
    @RequestMapping("/orderManage")
    public String orderManage() {
        return "/bidding/operator/orderManage";
    }

    /**
     * 采购经办人 订单详情
     *
     * @return
     */
    @RequestMapping("/orderDetail")
    public String orderDetail() {
        return "/bidding/operator/orderDetail";
    }


    /**
     * 下载批量导入结果
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downLoadResult")
    public void downLoadResult(HttpServletRequest request, HttpServletResponse response) {
        Object importDataVoListObj = request.getSession().getAttribute(BiddingOperatorService.UPLOAD_RESULT_DATA_SESSION);
        List<ExcelImportDataVo> importDataVoList = null;
        if (importDataVoListObj != null) {
            importDataVoList = JSON.parseArray(importDataVoListObj.toString(), ExcelImportDataVo.class);
        }

        //excel 2003
        String fileName = "downLoadResult.xls";
        //excel 2007
//        String fileName = "excelCretaeTest.xlsx";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelInfoVo excelInfoVo = new ExcelInfoVo(ExcelImportDataVo.class, importDataVoList, outputStream, fileName);
            ExcelCreateUtil.create(excelInfoVo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 执行采购临时订单批量下载
     *
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = "/downLoadList")
    public void downLoadList(HttpServletResponse response, String biddingNo) {
        BaseResponse baseResponse = biddingOperatorService.findAllTempOrder(biddingNo);
        List<JcbdTempOrderVo> result = (List<JcbdTempOrderVo>) baseResponse.getResult();
        List<BatchDownLoadVo> batchDownLoad = new ArrayList<>();
        int sequence=1;
        for (JcbdTempOrderVo tempOrder : result) {
            List<JcbdTempGoodsVo> jcbdTempGoodses = tempOrder.getJcbdTempGoodses();
            //转换发票类型（将标识码转换成汉字）
            if(GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL.equals(tempOrder.getInvoiceType())){
                tempOrder.setInvoiceType(BiddingOperatorController.VALUE_ADDED_TAX_SPECIAL_INVOICE);
            }else{
                tempOrder.setInvoiceType(BiddingOperatorController.VALUE_ADDED_TAX_NOMAL_INVOICE);
            }
            for (JcbdTempGoodsVo tempGoodsVo : jcbdTempGoodses) {
                tempOrder.setSequence(String.valueOf(sequence++));
                BatchDownLoadVo batchDownLoadVo = BeanMapper.map(tempOrder, BatchDownLoadVo.class);
                batchDownLoadVo.setSku(tempGoodsVo.getSku());
                batchDownLoadVo.setNum(tempGoodsVo.getNum());
                batchDownLoad.add(batchDownLoadVo);
            }
        }
        //excel 2003
        String fileName = "tempOrder.xls";
        //excel 2007
//        String fileName = "excelCretaeTest.xlsx";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelInfoVo excelInfoVo = new ExcelInfoVo(BatchDownLoadVo.class, batchDownLoad, outputStream, fileName);
            ExcelCreateUtil.create(excelInfoVo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
