package bidding.web.controller.page.supplier;

import bidding.web.service.BiddingProviderService;
import bidding.web.vo.BiddingBaseInfoVo;
import bidding.web.vo.BiddingStatusVo;
import bidding.web.vo.JcbdRoleOperationVo;
import bidding.web.vo.QueryBiddingRequestVO;
import com.alibaba.fastjson.JSON;
import definition.BiddingRole;
import dto.JcbdBdProviderDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author wangtao.
 * @version 供应商页面控制
 * @date 2018年3月15日16:57:00
 */
@Controller
@RequestMapping("/supplier")
public class BiddingSupplierPageController {

    @Autowired
    BiddingProviderService biddingProviderService;

    /**
     * 供应商-商城竞价管理页面
     * @return
     */
    @RequestMapping("/supplierBidManage")
    public String supplierBidManage(Map model, HttpServletRequest request) {
        //获取当前登录人id
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        List<String> biddingMemberRoles = new ArrayList<>();
        biddingMemberRoles.add(BiddingRole.BIDDING_SUPPLIER);
        List<BiddingStatusVo> biddingStatuses = biddingProviderService.getAllStatusByRoles(biddingMemberRoles);
        QueryBiddingRequestVO biddingVO = new QueryBiddingRequestVO();
        String supplierBiddingTempStr = (String) request.getSession().getAttribute("supplierBiddingTemp");
        if(!Lang.isEmpty(supplierBiddingTempStr)){
            biddingVO = JSON.parseObject(supplierBiddingTempStr,QueryBiddingRequestVO.class);
        }
        JqueryDataTablesVo pageVo = new JqueryDataTablesVo();
        String supplierBiddingPageTempStr = (String) request.getSession().getAttribute("supplierBiddingPageTemp");
        if(!Lang.isEmpty(supplierBiddingPageTempStr)){
            pageVo = JSON.parseObject(supplierBiddingPageTempStr,JqueryDataTablesVo.class);
        }
        String supplierId = (String) request.getSession().getAttribute("supplierId");
        if (Lang.equals(supplierId,biddingMemberId)){
            model.put("pageVo",pageVo);
            model.put("biddingVO",biddingVO);
        }else {
            model.put("pageVo",new JqueryDataTablesVo());
            model.put("biddingVO",new QueryBiddingRequestVO());
        }
        model.put("statuses",biddingStatuses);
        return "/bidding/supplier/supplierBidManage";
    }

    /**
     * 供应商-竞价查看页面
     * @return
     */
    @RequestMapping("/querySupplierBidding")
    public String querySupplierBidding(String biddingNo,Map model, HttpServletRequest request) {
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        if (!Lang.isEmpty(supplierId)){
            List<String> titles = biddingProviderService.findBiddingShowTitle(biddingNo, supplierId);
            List<JcbdRoleOperationVo> operates = biddingProviderService.getSupplierBiddingOperateByBiddingCode(biddingNo, supplierId);
            model.put("operates", operates);
            model.put("showTitles",titles);
        }
        return "/bidding/supplier/querySupplierBidding";
    }

    /**
     * 供应商-竞价响应
     * @return
     */
    @RequestMapping("/supplierBidRelevant")
    public String supplierBidRelevant(Map model, String biddingNo,HttpServletRequest request) {
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        BiddingBaseInfoVo biddingBaseInfoVo = biddingProviderService.getBiddingDetail(biddingNo);
        String offerValidity = null;
        if (!Lang.isEmpty(supplierId)&&!Lang.isEmpty(biddingBaseInfoVo.getId())){
            JcbdBdProviderDto provider = biddingProviderService.getProviderByBiddingNoAndSupplierId(biddingBaseInfoVo.getId(), supplierId);
            if (!Lang.isEmpty(provider.getOfferValidity())){
                offerValidity = DateUtils.dateToStr(provider.getOfferValidity(), GlobalContants.DateFormat.YYYY_MM_DD);
            }
        }
        model.put("baseInfo",biddingBaseInfoVo);
        model.put("offerValidity",offerValidity);
        return "/bidding/supplier/supplierBidRelevant";
    }


    /**
     * 供应商-竞价结果
     * @return
     */
    @RequestMapping("/supplierBidResult")
    public String supplierBidResult(Map model, String biddingNo,HttpServletRequest request) {
        BiddingBaseInfoVo biddingBaseInfoVo = biddingProviderService.getBiddingDetail(biddingNo);
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        String offerValidity = null;
        if (!Lang.isEmpty(supplierId)&&!Lang.isEmpty(biddingBaseInfoVo.getId())){
            JcbdBdProviderDto provider = biddingProviderService.getProviderByBiddingNoAndSupplierId(biddingBaseInfoVo.getId(), supplierId);
            if (!Lang.isEmpty(provider.getOfferValidity())){
                offerValidity = DateUtils.dateToStr(provider.getOfferValidity(), GlobalContants.DateFormat.YYYY_MM_DD);
            }
        }
        model.put("baseInfo",biddingBaseInfoVo);
        model.put("offerValidity",offerValidity);
        return "/bidding/supplier/supplierBidResult";
    }


    /**
     * 供应商-编辑商品编码
     * @return
     */
    @RequestMapping("/supplierModifySku")
    public String supplierModifySku() {
        return "/bidding/supplier/supplierModifySku";
    }

    /**
     * 供应商-订单管理
     * @return
     */
    @RequestMapping("/supplierOrderManage")
    public String supplierOrderManage() {
        return "/bidding/supplier/supplierOrderManage";
    }


    /**
     * 供应商-订单详情
     * @return
     */
    @RequestMapping("/supplierOrderDetail")
    public String supplierOrderDetail() {
        return "/bidding/supplier/supplierOrderDetailQuery";
    }

}
