package bidding.web.service;

import bidding.web.vo.*;
import sinomall.global.common.response.BaseResponse;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
public interface BiddingGroupService {
    /**
     * 保存符合性审查
     * @param biddingConformityAuditVO
     * @return
     */
    BaseResponse saveComplianceAudit(BiddingConformityAuditVO biddingConformityAuditVO);


    /**
     * 提交符合性审查结果
     * @param biddingCode
     * @param auditorId
     * @return
     */
    BaseResponse submitComplianceAuditResult(String biddingCode,String auditorId,String email);


    /**
     * 审核竞价
     * @param biddingDemandAuditVo
     * @return
     */
    BaseResponse auditBidding(BiddingDemandAuditVo biddingDemandAuditVo);

    /**
     * 投票确认供应商（开启投票）
     * @param changeStateVo
     * @return
     */
    BaseResponse voteConfirmSupplier(BiddingChangeStateVo changeStateVo,String auditorId);


    /**
     * 对报价相同的供应商投票
     * @param voteDetailVo
     * @param auditorEmail
     * @return
     */
    BaseResponse vote(VoteDetailVo voteDetailVo, String auditorEmail);

    /**
     * 重新发起审核
     * @param resComplianceAuditVo
     * @return
     */
    BaseResponse restartComplianceAudit(ResComplianceAuditVo resComplianceAuditVo,String auditorId);

    /**
     * 判断当前人员是不是完成审查
     * @param biddingNo
     * @param auditorId
     * @return
     */
    BaseResponse compeleteAudit(String biddingNo, String auditorId,String email);
}
