package bidding.web.service;

import bidding.web.vo.*;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdBiddingGroupMemberDto;
import dto.JcbdBiddingOperationLogDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.JsonModel;
import member.api.vo.MemberAddressVo;
import org.springframework.data.domain.Pageable;
import query.BiddingOperatorQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;

import java.util.List;
import java.util.Map;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/

public interface BiddingOperatorService {
    //将上传的结果保存在session中
    public static final String UPLOAD_RESULT_DATA_SESSION = "UPLOAD_RESULT_DATA";

    /**
     * 开启符合性审查（变更竞价状态）
     *
     * @param biddingChangeStateVo
     * @return
     */
    BaseResponse startComplianceAudit(BiddingChangeStateVo biddingChangeStateVo, String biddingMemberId);


    /**
     * 竞价列表查询
     *
     * @param jqueryDataTablesVo
     * @param biddingMemberId
     * @param biddingMemberRoles
     * @param queryBiddingRequestVO
     * @return
     */
    Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String biddingMemberId, String biddingEmail, List<String> biddingMemberRoles, QueryBiddingRequestVO queryBiddingRequestVO);


    /**
     * 审核人员-竞价列表查询
     *
     * @param jqueryDataTablesVo
     * @param userId
     * @param biddingMemberRoles
     * @param biddingAuditInfoVo
     * @return
     */
    Map audirQuerryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String userId, List<String> biddingMemberRoles, BiddingAuditInfoVo biddingAuditInfoVo);

    /**
     * 获得审核人所选状态
     */
    List<QueryStatus> getAuditStatus();

    /**
     * 查询当前角色下拥有的所有的竞价状态
     *
     * @param biddingMemberRoles
     * @return
     */
    List<BiddingStatusVo> getAllStatusByRoles(List<String> biddingMemberRoles);

    /**
     * 发布竞价
     *
     * @param biddingIssueRequestVo
     * @param biddingMemberId
     * @return
     */
    Map issueBidding(BiddingIssueRequestVo biddingIssueRequestVo, String biddingMemberId);

    /**
     * 获取竞价编号
     *
     * @author taofeng
     * @date 2018/3/19
     **/
    String getBiddingCode();

    /**
     * 查询采购经办人信息
     *
     * @author taofeng
     * @date 2018/3/19
     **/
    JcbdBiddingVo getOperator(String memberId);


    MemberDto getMember(String memberId);

    /**
     * 竞价保存更新
     *
     * @param jcbdBiddingVo
     * @param biddingGroups
     * @param hiddenBiddingGroupMemberIds
     * @param hiddenBiddingSpliceStringIds
     * @param imageVoList
     * @param userId
     * @return
     * @author taofeng
     * @date 2018/3/16
     */
    Map saveOrUpdateBiddingBaseInfo(JcbdBiddingVo jcbdBiddingVo, String[] biddingGroups, String[] hiddenBiddingGroupMemberIds, String[] hiddenBiddingSpliceStringIds, List<ImageVo> imageVoList, String userId);

    /**
     * 采购下单
     */
    BaseResponse commitJcbdOrderData(TempPurchaseVo tempPurchaseVo, String memberId);

    /**
     * @author taofeng
     * @date 2018/3/19
     * <p>
     * 查询供应商联系人信息
     */
    List<JcbdBdProviderVo> findStoreContacts(String type);

    /**
     * @author taofeng
     * @date 2018/3/20
     * <p>
     * 竞价需求编号
     **/
    String getDemandCode(String biddingCode);

    /**
     * @author taofeng
     * @date 2018/3/20
     * <p>
     * 竞价需求保存更新
     **/
    void saveOrUpdateBiddingDemand(BiddingDemandVo biddingDemandVo, String[] demandAddress, String[] numberNeed, String[] conformances);

    /**
     * @author taofeng
     * @date 2018/3/22
     * <p>
     * 获取已保存的竞价
     **/
    JcbdBiddingVo getBiddingByBiddingCode(String biddingCode);


    /**
     * 获取角色竞价（包含用户的操作）
     *
     * @param biddingOperatorQuery
     * @return
     */
    List<JcbdRoleOperationVo> getRoleBiddingOperates(BiddingOperatorQuery biddingOperatorQuery);

    /**
     * 更新竞价状态接口
     *
     * @param changeStateVo
     * @return
     */
    void changeBiddingState(BiddingChangeStateVo changeStateVo);

    /**
     * 获取竞价需求列表
     *
     * @param jqueryDataTablesVo
     * @param biddingCode
     * @return
     */
    Map querryPageBiddingDemad(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode);

    /**
     * 供应商竞价响应概要信息查询
     *
     * @param biddingCode
     * @param demandCode
     * @return
     */
    Map queryResponseOutline(String biddingCode, String demandCode);

    /**
     * 查询供应商需求响应
     *
     * @param biddingCode
     * @param demandCode
     * @param supplierId
     * @return
     */
    Map queryDemandResponse(String biddingCode, String demandCode, String supplierId);

    /**
     * 执行采购-下单接口
     *
     * @param tempPurchaseVo
     * @param memberId
     * @return
     */
    BaseResponse createJcbdOrder(TempPurchaseVo tempPurchaseVo, String memberId);

    /**
     * 提交竞价结果审核
     *
     * @param submitResultVo
     * @param memberId
     * @return
     */
    Map submitResultAudit(SubmitResultVo submitResultVo, String memberId);

    /**
     * @author taofeng
     * @date 2018/4/4
     * <p>
     * 竞价结果页_列表
     */
    Map getBiddingResultDemandList(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode);

    /**
     * @author taofeng
     * @date 2018/4/9
     * <p>
     * 竞价结果页_查看
     */
    Map queryBiddingDemandResponse(String biddingNo, String demandCode);

    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 竞价需求列表
     **/
    Map getBiddingDemandList(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode);

    /**
     * @author taofeng
     * @date 2018/3/28
     * <p>
     * 竞价需求_查看
     **/
    BiddingDemandVo getBiddingDemandInfo(String demandCode);

    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 竞价需求_删除
     **/
    BaseResponse deleteBidDemand(String demandCode);

    /**
     * @author taofeng
     * @date 2018/3/30
     * <p>
     * 开启报价
     **/
    BaseResponse openPrice(String biddingNo);

    /**
     * @author taofeng
     * @date 2018/3/30
     * <p>
     * 系统随机确定供应商
     **/
    BaseResponse randomConfirmSupplier(String biddingCode);


    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 查询会员默认地址信息
     **/
    MemberAddressVo defaultAddress(String memberId);

    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 查询会员所有地址信息
     **/
    List<MemberAddressVo> defaultAddressList(String memberId);

    /**
     * 审核sku
     *
     * @param biddingAuditVo
     * @param biddingMemberId
     * @return
     */
    Map auditSku(BiddingAuditVo biddingAuditVo, String biddingMemberId);

    /**
     * 执行采购页临时订单保存
     *
     * @param biddingQueryOperativeBuySaveVo
     * @return
     */
    BaseResponse saveOrderGoodsInfo(BiddingQueryOperativeBuySaveVo biddingQueryOperativeBuySaveVo);


    /**
     * 执行采购页临时订单列表查询
     *
     * @param biddingNo
     * @return
     */
    BaseResponse queryTempOrderInfo(String biddingNo);

    /**
     * 执行采购页临时订单修改
     *
     * @param temOrderId
     * @return
     */
    BaseResponse updateTempOrderInfo(String temOrderId);

    /**
     * 删除临时订单
     *
     * @param temOrderId
     * @return
     */
    BaseResponse deleteTempOrderInfo(List<String> temOrderId);

    /**
     * @author taofeng
     * @date 2018/4/4
     * <p>
     * 操作记录
     */
    Map findbiddingLog(JqueryDataTablesVo jqueryDataTablesVo, String biddingNo);

    /**
     * @author taofeng
     * @date 2018/4/4
     * 根据竞价编号查询竞价需求信息
     */
    List<BiddingDemandVo> findByJcbdBiddingCodeAndIsDelete(String biddingCode);

    /**
     * @author taofeng
     * @date 2018/4/23
     * <p>
     * 根据竞价编号查找竞价信息
     */
    JcbdBiddingVo findByBiddingCodeAndIsDelete(String biddingCode);

    /**
     * 可采购商品信息查询
     *
     * @param biddingNo
     * @return
     */
    BaseResponse queryPermitGoodsInfo(String biddingNo);

    /**
     * 终止竞价
     *
     * @param biddingNo
     * @param remark
     * @param biddingMemberId
     * @return
     */
    Map finishBidding(String biddingNo, String remark, String biddingMemberId);

    /**
     * 查询竞价下的商品是否存在
     *
     * @param biddingNo
     * @param sku
     */
    Boolean goodIsNull(String biddingNo, String sku);

    /**
     * 获取当前登录用户的机构信息
     *
     * @param memberId
     * @return
     */
    CoreCompanyDto getCompanyInfo(String memberId);

    /**
     * 查询纳税人识别号是否存在
     *
     * @param identificationCode
     * @return
     */
    Boolean queryIdentificationCode(String identificationCode);

    /**
     * 查询地址是否存在
     *
     * @param address
     * @return
     */
    Boolean queryAddressExist(String[] address);

    /**
     * @author taofeng
     * @date 2018/4/14
     * <p>
     * 竞价提交审核_给竞价小组人员发送审核邮件
     */
    Map mailOfGroupMembers(String biddingNo, String biddingMemberId);

    /**
     * 查询此用户地址信息是否已经存在memberAddress表里
     *
     * @return
     */
    MemberAddressDto findMemberAddress(String[] address, String detailAddress, String memberName, String memberTel);

    /**
     * 保存模板导入的地址信息
     *
     * @param address
     * @return
     */

    MemberAddressDto saveExcelImportData(String[] address, String detailAddress, String memberName, String memberTel);

    /**
     * 执行采购临时订单批量下载
     *
     * @param biddingNo
     * @return
     */
    BaseResponse findAllTempOrder(String biddingNo);

    /**
     * 更新竞价审核编号
     *
     * @param bidddingNo
     * @return
     */
    String updateBiddingGroupCheckNo(String bidddingNo);


    /**
     * 查询的投票详情
     *
     * @param biddingNo
     * @return
     */
    List<VoteQueryResultVo> voteDetailsQuery(String biddingNo);


    /**
     * 获取运费
     *
     * @param tempPurchaseVo
     * @param memberId
     * @return
     */
    BaseResponse getOrderFee(TempPurchaseVo tempPurchaseVo, String memberId);

    /**
     * 限额校验
     *
     * @param biddingCode
     * @return
     */
    BaseResponse checkLimit(String biddingCode);

    /**
     * 获取是否需要展示投票标签
     *
     * @param biddingNo
     * @return
     */
    BaseResponse<Boolean> getVoteStatus(String biddingNo, String memberId);

    /**
     * 获取审核流条线部门
     *
     * @param tianXianRequestVo
     * @return
     */
    TiaoXianCompanyVo getTiaoXianCompany(TianXianRequestVo tianXianRequestVo);

    /**
     * 重发审查邮件（符合性审查）
     *
     * @param biddingNo
     * @return
     */
    BaseResponse reSendAuditEmail(String biddingNo, String biddingMemberId);


    /**
     * 保存竞价操作记录
     *
     * @param operatorsId
     * @param biddingCode
     * @param jcbdBiddingOperationLogDto
     * @return
     */
    BaseResponse<Boolean> saveOperatorsLog(String operatorsId, String biddingCode, JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto);

	 /**
     * 保存审核操作记录
     * @param operatorsId (workerId)coreCompDepartUserId
     * @param biddingCode
     * @param jcbdBiddingOperationLogDto
     * @return
     */
    BaseResponse<Boolean> saveAuditOperatorsLog(String operatorsId, String biddingCode, JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto);
	
    /**
     * @author taofeng
     * @date 2018/4/21
     * <p>
     * 竞价_删除
     */
    Map deleteBidding(String biddingNo);

    /**
     * 根据sku获取商品价格以及需求id
     *
     * @param biddingNo
     * @param sku
     */
    JcbdBiddingDemandResponseDto findGoodsPriceBySku(String biddingNo, String sku);

    /**
     * 根据sku查询goodsId
     *
     * @param sku
     * @return
     */
    String findGoodsIdBySku(String sku);

    /**
     * 根据sku查询productfashionId
     *
     * @param sku
     * @return
     */
    String findProductFashionId(String sku);

    /**
     * 获取竞价查看页可展示的table标签
     *
     * @param biddingNo
     * @return
     */
    List<String> findBiddingShowTitle(String biddingNo);

    /**
     * 获取竞价结果审核流程条线部门
     *
     * @param userId
     * @param biddingNo
     * @return
     */
    TiaoXianCompanyVo getBiddingResultTiaoXian(String userId, String biddingNo);

    /**
     * 获取订单条线部门
     *
     * @param tianXianRequestVo
     * @return
     */
    public TiaoXianCompanyVo getBiddingOrderTiaoXian(TianXianRequestVo tianXianRequestVo);

    /**
     * 校验商品总计数量与历史下单数量相加是否超过此需求的最高采购数量
     *
     * @param biddingCode
     * @return
     */
    BaseResponse checkGoodNums(String biddingCode);

    /**
     * 获得开票机构
     *
     * @param companyId
     * @return
     */
    CoreCompanyDto getCoreCompanyInfoById(String companyId);

    /**
     * 比较是否属于当前登录人的竞价
     *
     * @param memberId
     * @param biddingCode
     * @return
     */
    Boolean compareCurrentMemberId(String memberId, String biddingCode);

    /**
     * 竞价是否已终止
     *
     * @param biddingNo
     * @return
     */
    Boolean biddingIsFinish(String biddingNo);

    /**
     * 获取竞价小组成员状态
     *
     * @param email
     * @param biddingId
     */
    JcbdBiddingGroupMemberDto findGroupStatus(String email, String biddingId);

    /**
     * 获取竞价操作人姓名
     *
     * @param operatorId
     * @return
     */
    String getOperatorName(String operatorId);


    /**
     * 准备数据供前端左边区域显示组织结构
     * 2018.6.13 added by Aaron Li
     *
     * @return
     */
    List<JsonModel> jsTree();

    /**
     * 准备数据供前端左边区域显示组织结构
     * 2018.6.13 added by Aaron Li
     *
     * @param userId   用户id
     * @param roleCode 用户角色编码
     * @return
     */
    List<JsonModel> compJsTree(String userId, String roleCode);

    /**
     * 准备数据供前端左边区域显示组织结构
     * 2018.6.13 added by Aaron Li
     *
     * @param userId   用户id
     * @param roleCode 用户角色编码
     * @return
     */
//    List<JsonModel> compJsTree4Part(String userId, String roleCode);


    /**
     * 根据输入的查询条件 查询审核人信息列表
     *
     * @param jqueryDataTablesVo
     * @param selectedCompanyOrDepartmentId
     * @param nameLike
     * @param emailLike
     * @param isDelete
     * @param userId
     * @param roleCode
     * @param pageable
     * @return
     */
    Map getTechAuditorListBySearchCondition(JqueryDataTablesVo jqueryDataTablesVo, String selectedCompanyOrDepartmentName, String selectedCompanyOrDepartmentId, String nameLike, String emailLike, boolean isDelete, String userId, String roleCode, Pageable pageable);

    /**
     * @author taofeng
     * @date 2018/7/19
     * <p>
     * 判断当前登陆人是否属于当前竞价的竞价小组成员
     */
    Boolean disJcbdBiddingGroup(String userId, List<JcbdBiddingGroupMemberVo> groupMemberVoList);

    UserInformationVo getOperateInformation(String biddingUserId);

    /**
     * 获取竞价小组成员机构部门信息
     * @param biddingUserId
     * @return
     */
    UserInformationVo getMemberCompanyInformatio(String biddingUserId);

}
