package bidding.web.service;

import bidding.web.vo.ImageVo;
import bidding.web.vo.JcbdMallOrderVo;
import bidding.web.vo.OrderAuditInfoVo;
import bidding.web.vo.QueryStatus;
import dto.*;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import query.BiddingOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;

import java.util.List;
import java.util.Map;

/**
* @author luoxianwei
* @date 2018/4/14
*/
public interface BiddingOrderManagerService {
    /**
     * 查询分页获取订单管理列表
     * @param biddingOrderManagerListQuery
     * @param pageable
     * @param jqueryDataTablesVo
     * @return
     */
    Map getBiddingOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo,  BiddingOrderManagerListQuery biddingOrderManagerListQuery,Pageable pageable);

    /**
     * 状态
     * @return
     */
    List<QueryStatus> getAllStatus();

    /**
     * 更新状态
     * @param status
     * @param orderNo
     * @return
     */
    JcbdMallOrderVo updateStatusByOrderNo(String status, String orderNo);

    /**
     * 删除订单
     * @param orderNo
     * @return
     */
    JcbdMallOrderVo deleteJcbdMallOrderByOrderNo(String orderNo);


    /**
     * 查询审批流信息
     * @param orderNo 订单号
     * @param stringObjectMap 存放审批流信息
     */
    void getFlowSteps(String orderNo, Map<String, Object> stringObjectMap);

    /**
     * 查找上传的附件
     */
    List<ImageVo> getOrderUploadFiles(String orderNo);

    /**
     * 获得审核状态和审核时间
     * @param orderNo
     * @param userId
     * @return
     */
    OrderAuditInfoVo getBusinessWorkFlowInfo(String orderNo, String userId);

    /**
     * 通过订单号获得订单类型和供应商名称
     * @param orderNo
     * @return
     */
    BiddingOrderInfoDto getOrderInfoByOrderNo(String orderNo);

    List<JcbdRoleOperationDto> getOpertionByStatus(String status);

    List<JcbdRoleOperationDto> getSuperlierOpertionByStatus(String status);

    /**
     * 取消购买记录订单
     * @param orderNo
     */
    void cancelPurchaseLogOrder(String orderNo);
}
