package bidding.web.service;

import bidding.web.vo.*;
import dto.JcbdBdProviderDto;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;

import java.util.List;
import java.util.Map;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
public interface BiddingProviderService {

    /**
     * 供应商竞价列表查询
     * @param jqueryDataTablesVo
     * @param biddingMemberId
     * @param biddingMemberRoles
     * @param queryBiddingRequestVO
     * @return
     */
    Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String biddingMemberId, List<String> biddingMemberRoles, QueryBiddingRequestVO queryBiddingRequestVO);

    /**
     *查询当前角色下拥有的所有的竞价状态
     * @param biddingMemberRoles
     * @return
     */
    List<BiddingStatusVo> getAllStatusByRoles(List<String> biddingMemberRoles);

    /**
     * 查询竞价基本信息
     * @param biddingCode
     * @return
     */
    BiddingBaseInfoVo getBiddingDetail(String biddingCode);

    /**
     * 供应商竞价需求列表查询
     *
     * @param biddingCode
     * @return
     */
    Map querryPageBiddingDemand(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, String supplierId);

    /**
     * 供应商查询需求响应
     * @param supplierId
     * @param demandCode
     * @param biddingNo
     * @return
     */
    BiddingDemandResponseVo getBiddingDemadDetail(String supplierId, String demandCode, String biddingNo);

    /**
     *保存竞价需求响应
     * @param biddingDemandResponseVo
     * @param supplierId
     * @return
     */
    Map saveBiddingDemadResp(BiddingDemandResponseVo biddingDemandResponseVo, String supplierId);

    /**
     * 供应商是否已全部响应
     * @param biddingCode
     * @param supplierId
     * @return
     */
    Map checkIsAllRespond(String biddingCode,String supplierId);

    /**
     * 供应商所有需求是否全部符合
     * @param biddingCode
     * @param supplierId
     * @return
     */
    Map checkDemadIsAllAccord(String biddingCode, String supplierId);

    /**
     * 提交竞价需求响应
     * @param supplierBiddingResponseVo
     * @param userId
     * @param supplierId
     * @return
     */
    Map submitResp(SupplierBiddingResponseVo supplierBiddingResponseVo, String userId, String supplierId);

    /**
     * 确认订单
     *
     * @param mallOrderNo String
     * @return BaseResponse
     */
    BaseResponse confirmOrder(String mallOrderNo);

    /**
     * 批量确认订单
     * BiddingOrderResultItemVo只需要传biddingCode，orderNo
     * @param orderResultItemVoList
     * @return
     */
    BaseResponse batchConfirmOrder(List<BiddingOrderResultItemVo> orderResultItemVoList,String storeId, String memberId);

    /**
     * 确认竞价结果
     * @param biddingCode
     * @param signValue 签名值（太平云盾验证）
     * @return
     */
    Map sureResult(String biddingCode,String signValue, String supplierId);

    /**
     * 响应sku列表查询
     * @param biddingCode
     * @param supplierId
     * @return
     */
    Map querryPageSku(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, String supplierId);

    /**
     * 更新sku
     * @param updateSkuVo
     * @param supplierId
     * @param loginId
     * @return
     */
    Map updateSku(UpdateSkuVo updateSkuVo, String supplierId, String loginId);

    /**
     * 提交sku审核
     * @param biddingCode
     * @param supplierId
     * @return
     */
    Map submitSkuAudit(String biddingCode, String supplierId);

    /**
     * 查询sku链接
     * @param sku
     * @param supplierId
     * @return
     */
    Map findUrlBySku(String sku, String supplierId);

    /**
     * 供应商订单删除
     *
     * @param mallOrderNo mallOrderNo
     * @return BaseResponse
     */
    BaseResponse deleteMallOrder(String mallOrderNo);

    /**
     * 是否有修改sku
     * @param biddingCode
     * @param supplierId
     * @return
     */
    Map checkModifySku(String biddingCode, String supplierId);

    /**
     * 获取供应商信息
     * @param biddingId
     * @param supplierId
     * @return
     */
    JcbdBdProviderDto getProviderByBiddingNoAndSupplierId(String biddingId, String supplierId);

    /**
     * 放弃响应
     * @param biddingCode
     * @param supplierId
     * @return
     */
    Map responseGiveUp(String biddingCode, String supplierId);

    /**
     * 获取竞价查看页可展示的table标签
     * @param biddingNo
     * @param supplierId
     * @return
     */
    List<String> findBiddingShowTitle(String biddingNo, String supplierId);

    /**
     * 供应商获取竞价操作
     * @param biddingNo
     * @param supplierId
     * @return
     */
    List<JcbdRoleOperationVo> getSupplierBiddingOperateByBiddingCode(String biddingNo, String supplierId);

    /**
     * 拉取验证二维码
     * @param account
     * @param businessCode 竞价编号
     * @param operateType  操作类型
     * @return
     */
    Map loadQrcode(String account,String businessCode,String operateType);

    /**
     * 获取凭证
     * @param eventId 事件id
     * @return
     */
    Map getAccToken(String eventId);
    /**
     * 获取二维码验证结果
     * @param accToken
     * @return
     */
    Map getSignResult(String accToken);
}



