package bidding.web.service;

import bidding.web.vo.BiddingConformityQueryVo;
import dto.BiddingPriceParityDto;
import dto.JcbdBiddingDto;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;

import java.util.List;
import java.util.Map;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
public interface BiddingQueryService {

    /**
     * 查询所有的竞价信息
     * @return
     */
    List<JcbdBiddingDto> findAllJcbdBidding();

    /**
     * 竞价比价信息查询
     * @param biddingNo
     * @return
     */
    BaseResponse<BiddingPriceParityDto> queryBiddingPriceParity(String biddingNo);

    /**
     * 查詢符合性审查页需求列表
     * @param biddingConformityQueryVo
     * @return
     */
    Map querryPageBiddingDemad(BiddingConformityQueryVo biddingConformityQueryVo,JqueryDataTablesVo jqueryDataTablesVo);
    /**
     * 供应商竞价响应概要信息查询
     * @param biddingConformityQueryVo
     * @return
     */
    Map queryResponseOutline(BiddingConformityQueryVo biddingConformityQueryVo);
    /**
     * 查询供应商需求响应
     * @param biddingConformityQueryVo
     * @return
     */
    Map queryDemandResponse(BiddingConformityQueryVo biddingConformityQueryVo);
}
