package bidding.web.service;

import bidding.web.vo.QueryStatus;
import dto.BiddingSupplierOrderMangerDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import query.BiddingSupplierOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;

import java.util.List;
import java.util.Map;

/**
* @author luoxianwei
* @date 2018/4/14
*/
public interface BiddingSupplierOrderManagerService {
    /**
     * 查询分页获取供应商订单管理列表
     * @param jqueryDataTablesVo
     * @param biddingSupplierOrderManagerListQuery
     * @param pageable
     * @return
     */
    Map getBiddingSupplierOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable);

    /**
     *
     * @param biddingSupplierOrderManagerListQuery
     * @param pageable
     * @return
     */
    Page<BiddingSupplierOrderMangerDto> getSupplierOrderMangerList(BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable);

    /**
     * 状态
     * @return
     */
    List<QueryStatus> getAllSupplierStatus();

    /**
     * 供应商确认订单
     *
     * @param orderIds List<String>
     * @param biddingMemberId
     * @param signValue 太平云盾验证签名值
     * @return BaseResponse<List<String>>
     */
    BaseResponse<List<String>> confirmOrder(List<String> orderIds,String biddingMemberId,String signValue);

    /**
     * 供应商订单删除
     *
     * @param mallOrderNo
     * @return BaseResponse
     */
    BaseResponse deleteMallOrder(String mallOrderNo);
}
