package bidding.web.service.impl;

import api.query.BiddingMainQueryApi;
import bidding.web.service.BiddingAuditorService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BiddingAuditIncomeInfoVo;
import bidding.web.vo.BiddingAuditValidateInfoVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import dto.JcbdBiddingOperationLogDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.Encodes;
import utils.security.Digests;
import workflow.api.WorkFlowQueryApi;
import workflow.api.WorkFlowServiceApi;
import workflow.definition.AuditBusinessCode;
import workflow.dto.WfWorkFlowLogDto;
import workflow.query.WorkFlowInfoQuery;
import workflow.vo.WorkFlowVo;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * @author 陈圣融
 * @date 2018-04-02
 **/
@Slf4j
@Service
public class BiddingAuditorServiceImpl implements BiddingAuditorService {
    @MotanReferer
    WorkFlowServiceApi workFlowServiceApi;
    @MotanReferer
    WorkFlowQueryApi workFlowQueryApi;
    @Value("${bidding.result.baseurl}")
    private String biddingResultBaseUrl;

    @Value("${bid.trading.limit}")
    private String limit;

    @Autowired
    BiddingOperatorService biddingOperatorService;
    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;


    @Override
    public BaseResponse biddingResultAudit(WorkFlowVo workFlowVo) {
        BaseResponse baseResponse = new BaseResponse(true, "审核成功");
        Boolean isCorrect = workFlowQueryApi.checkCorrectOrderById(workFlowVo.getWorkFlowLogId());
        if (isCorrect) {
            WfWorkFlowLogDto workFlowLog = workFlowQueryApi.findById(workFlowVo.getWorkFlowLogId());
            try {
                workFlowServiceApi.handleWorkFlow(workFlowVo);
                // 保存审核操作记录
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("审核竞价结果");
                jcbdBiddingOperationLogDto.setRemark(workFlowVo.getReason());
                biddingOperatorService.saveAuditOperatorsLog(workFlowLog.getWorkerId(), workFlowVo.getOrderId(), jcbdBiddingOperationLogDto);
                return baseResponse;
            } catch (Exception e) {
                log.error("竞价审核出错workFlowVo={}", JSON.toJSONString(workFlowVo), e);
            }
        }
        baseResponse.setSuccess(false);
        baseResponse.setResultMessage("审核参数错误");
        return baseResponse;
    }

    @Override
    public BaseResponse<BiddingAuditValidateInfoVo> getAuditInfo(BiddingAuditIncomeInfoVo biddingAuditIncomeInfoVo) {
        BiddingAuditValidateInfoVo biddingAuditValidateInfoVo = new BiddingAuditValidateInfoVo();
        WfWorkFlowLogDto workFlowLog = null;
        if (StringUtils.isNoneEmpty(biddingAuditIncomeInfoVo.getBiddingNo())) {
            WorkFlowInfoQuery workFlowInfoQuery = new WorkFlowInfoQuery();
            workFlowInfoQuery.setWorkerIds(Arrays.asList(biddingAuditIncomeInfoVo.getWorkerId()));
            workFlowInfoQuery.setBusinessCode(AuditBusinessCode.BIDDING_RESULT_AUDIT.getBusinessCode());
            workFlowInfoQuery.setBusinessNo(biddingAuditIncomeInfoVo.getBiddingNo());
            List<WfWorkFlowLogDto> wfWorkFlowLogDtos = workFlowQueryApi.findByWorkFlowInfoQuery(workFlowInfoQuery);
            if (wfWorkFlowLogDtos != null && !wfWorkFlowLogDtos.isEmpty()) {
                workFlowLog = wfWorkFlowLogDtos.get(0);
            }
        } else if (StringUtils.isNoneEmpty(biddingAuditIncomeInfoVo.getEncryptId())) {
            workFlowLog = workFlowQueryApi.findByEncryptIdAndPass(biddingAuditIncomeInfoVo.getEncryptId(), null);
            //邮件进来验签
            if (workFlowLog == null) {
                return new BaseResponse<>(false, "找不到对应审核记录", biddingAuditValidateInfoVo);
            }
//            String encriptAttestation = encriptAttestation(workFlowLog, biddingResultBaseUrl + "?encryptId=" + biddingAuditIncomeInfoVo.getEncryptId());
//            if (!encriptAttestation.equals(biddingAuditIncomeInfoVo.getAttestation())) {
//                return new BaseResponse<>(false, "验签失败", biddingAuditValidateInfoVo);
//            }
        }

        if (workFlowLog == null) {
            return new BaseResponse<>(false, "找不到对应审核记录", biddingAuditValidateInfoVo);
        }
        biddingAuditValidateInfoVo.setBiddingNo(workFlowLog.getOrderId());
        biddingAuditValidateInfoVo.setFlowLogId(workFlowLog.getId());
        biddingAuditValidateInfoVo.setWorkerId(workFlowLog.getWorkerId());

        BigDecimal price = biddingMainQueryApi.getBiddingGeneralBudget(biddingAuditValidateInfoVo.getBiddingNo());
        biddingAuditValidateInfoVo.setPrice(price);
        if(price.compareTo(new BigDecimal(limit))>0){
            biddingAuditValidateInfoVo.setShowPrompt(true);
        }else {
            biddingAuditValidateInfoVo.setShowPrompt(false);
        }
        return new BaseResponse<>(true, "查询审核信息成功", biddingAuditValidateInfoVo);
    }


    /**
     * 生成验签参数
     *
     * @param workFlowLog
     * @param url
     * @return
     */
    private String encriptAttestation(WfWorkFlowLogDto workFlowLog, String url) {
        String attestation;
        attestation = Encodes.encodeHex(Digests.sha1(url.getBytes(), workFlowLog.getSalt().getBytes(), 1024));
        return attestation;
    }

}
