package bidding.web.service.impl;

import bidding.web.service.BiddingCompanyService;
import bidding.web.vo.JsonModel;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.CoreCompDepartUserApi;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CorePositionDto;
import member.model.core.CoreCompany;
import member.model.repository.core.CompanyRepos;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class BiddingCompanyServiceImpl implements BiddingCompanyService {

    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @Autowired
    CompanyRepos companyRepos;
    @Override
    public List<JsonModel> companyTree(String userId, String positionDtoCode) {
        CoreCompanyDto coreCompanyDto = coreCompDepartUserApi.getCompanyByUserIdAndPositon(userId,positionDtoCode);
        CoreCompany coreCompany = companyRepos.findById(coreCompanyDto.getId());
        /*for (CoreCompDepartUserDto coreCompDepartUser : coreCompDepartUsers) {
            if (!Lang.isEmpty(coreCompDepartUser.getCompanyId())){
                //coreCompany = coreCompanyApi.getCompanyInfo(coreCompDepartUser.getCompanyId());
                coreCompany = companyRepos.findById(coreCompDepartUser.getCompanyId());
                break;
            }
        }*/
        List<JsonModel> companyTree = new ArrayList<>();
        //获取下级
        getChildCompany(coreCompany, companyTree);
        //获取上级
        getParentCompny(coreCompany, companyTree);
        return companyTree;

    }

    private void getParentCompny(CoreCompany company, List<JsonModel> companyTree) {
        CoreCompany companyParent = company.getParent();
        JsonModel jsonModel = new JsonModel();
        jsonModel.setId(company.getId());
        if (companyParent.getCompanyLevel() == CoreCompanyDto.COMPANY_LEVEL_ONE) {
            jsonModel.setParent("#");
        } else {
            jsonModel.setParent(companyParent.getId());
        }
        jsonModel.setText(company.getName());
        jsonModel.setIcon("false");
        jsonModel.setType1("company");
        companyTree.add(jsonModel);
        if (company.getCompanyLevel() != CoreCompanyDto.COMPANY_LEVEL_TWO) {
            getParentCompny(companyParent, companyTree);
        }
    }


    private void getChildCompany(CoreCompany companyParent, List<JsonModel> companyTree) {
        //List<CoreCompany> childCompany = coreCompanyApi.findAllByParent_idAndIsDelete(companyParent.getId(),false);
        List<CoreCompany> childCompany = companyParent.getChild();//companyRepos.findAllByParent_idAndIsDelete(parent_id, isDelete);
        if (childCompany == null) {

            return;
        }
        for (CoreCompany company : childCompany) {
            JsonModel jsonModel = new JsonModel();
            jsonModel.setId(company.getId());
            jsonModel.setParent(companyParent.getId());
            jsonModel.setText(company.getName());
            jsonModel.setIcon("false");
            jsonModel.setType1("company");
            companyTree.add(jsonModel);
            getChildCompany(company, companyTree);
        }

    }
}
