package bidding.web.service.impl;

import api.BiddingConformityReviewApi;
import api.BiddingMainApi;

import api.BiddingVoteApi;
import api.query.BiddingConformityReviewQueryApi;
import api.query.BiddingMainQueryApi;
import api.query.BiddingQueryApi;
import bidding.web.service.BiddingGroupService;
import bidding.web.vo.*;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;

import definition.*;
import dto.*;
import message.MailModule;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.mail.vo.MailTemplateReq;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.*;

/**
 * @author 张代春
 * @date 2018/3/19
 */
@Service
public class BiddingGroupServiceImpl implements BiddingGroupService {

    public static final Logger log = LoggerFactory.getLogger(BiddingGroupServiceImpl.class);

    @MotanReferer
    BiddingConformityReviewApi biddingConformityReviewApi;

    @MotanReferer
    BiddingMainApi biddingMainApi;

    @MotanReferer
    MailApi mailApi;

    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;

    @MotanReferer
    BiddingVoteApi biddingVoteApi;
    
    @MotanReferer
    BiddingQueryApi biddingQueryApi;

    @Value("${spring.mail.username}")
    String mailFrom;


    @MotanReferer
    BiddingConformityReviewQueryApi biddingConformityReviewQueryApi;

    @Autowired
    BiddingOperatorServiceImpl biddingOperatorService;

    /**
     * 保存符合性审查
     */
    @Override
    public BaseResponse saveComplianceAudit(BiddingConformityAuditVO biddingConformityAuditVO) {
        BiddingConformityAuditDTO conformityAudit = BeanMapper.map(biddingConformityAuditVO, BiddingConformityAuditDTO.class);
        //调用符合性审查接口
        BaseResponse baseResponse = biddingConformityReviewApi.saveBiddingConformityReviewAuditData(conformityAudit);
        log.info("保存符合性审查:{}", JSON.toJSONString(conformityAudit));

        if (!Lang.isEmpty(biddingConformityAuditVO.getAuditorId())) {
            biddingOperatorService.getOperatorName(biddingConformityAuditVO.getAuditorId());
        }
        return baseResponse;
    }

    /**
     * 提交符合性审查结果
     *
     * @param biddingCode
     * @param auditorId
     * @return
     */
    @Override
    public BaseResponse submitComplianceAuditResult(String biddingCode, String auditorId, String email) {
        BaseResponse<Boolean> isLastSubmit = biddingConformityReviewApi.isLastBiddingConformityReviewSubmit(biddingCode);
        biddingMainApi.changeBiddingGroupMemberStatus(biddingCode,auditorId,BiddingStatus.M_CONFORM_AUDIT_OK.getValue(),email);
        //变更竞价小组成员审核状态
//        BaseResponse baseResponse = biddingMainApi.changeGroupMemberConfomanceCheck(biddingCode, auditorId, email);
        if (isLastSubmit.getResult()) {
            //检查是否最后一个提交
            BaseResponse<Integer> supplierCount = biddingConformityReviewApi.getBiddingComformanceAuditAvailableCount(biddingCode);
            if (supplierCount.getResult() >= ConformanceAuditThreshold.Threshold.getValue()) {
                //符合性审查满足的供应商数大于两家
                BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(biddingCode);
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_IN.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.IN_CONFORMITY_REVIEW_PASS.getCode());
                //调用竞价状态变更接口变更竞价状态为符合性审查通过
                BiddingStateResponseDto biddingStateResponseDto = biddingMainApi.changeBiddingState(biddingChangeStateDto);
                if (BiddingStatus.OM_CONFORM_AUDIT_YES.getValue().equals(biddingStateResponseDto.getBiddingState())) {
                    return new BaseResponse(true, "操作成功");
                }
                return new BaseResponse(false, "操作失败");
            } else {
                //满足符合性审查的供应商数小于两家
                BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(biddingCode);
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_IN.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.IN_CONFORMITY_REVIEW_NO_PASS.getCode());
                //调用竞价状态变更接口变更竞价状态为符合性审查不通过
                BiddingStateResponseDto biddingStateResponseDto = biddingMainApi.changeBiddingState(biddingChangeStateDto);
                if (biddingStateResponseDto.getBiddingState().equals(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue())) {
                    return new BaseResponse(true, "操作成功");
                }
                return new BaseResponse("操作失败");
            }
        } else {
            return new BaseResponse(true,"等待其他小组成员提交审查");
        }
    }

    /**
     * 审查竞价
     *
     * @param biddingDemandAuditVo
     * @return
     */
    @Override
    public BaseResponse auditBidding(BiddingDemandAuditVo biddingDemandAuditVo) {
        BiddingAuditDTO biddingAudit = BeanMapper.map(biddingDemandAuditVo, BiddingAuditDTO.class);
        BaseResponse baseResponse = biddingMainApi.auditBiddingDemand(biddingAudit);
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        return new BaseResponse(true, "竞价审核信息保存成功");
    }


    /**
     * 发起投票决定供应商
     *
     * @param changeStateVo
     * @return
     */
    @Override
    public BaseResponse voteConfirmSupplier(BiddingChangeStateVo changeStateVo,String auditorId) {
        //判断当前竞价状态
        JcbdBiddingVo biddingByBiddingCode = biddingOperatorService.getBiddingByBiddingCode(changeStateVo.getBiddingNo());
        if(!Lang.isEmpty(biddingByBiddingCode)){
            if(BiddingStatus.OM_VOTE_EVEN.getValue().equals(biddingByBiddingCode.getStatus())){
                changeStateVo.setCurrentState(BiddingStatus.OM_VOTE_EVEN.getValue());
                changeStateVo.setOpcode(BiddingOperateCode.VOTE_CONFIRM_SUPPLIER.getCode());
                biddingMainApi.updateBiddingVoteNo(changeStateVo.getBiddingNo());
            }else if (BiddingStatus.OM_RESULT_SELECT_WAIT_VOTE.getValue().equals(biddingByBiddingCode.getStatus())){
                changeStateVo.setCurrentState(BiddingStatus.OM_RESULT_SELECT_WAIT_VOTE.getValue());
                changeStateVo.setOpcode(BiddingOperateCode.VOTE_CONFIRM_SUPPLIER.getCode());
                biddingMainApi.updateBiddingVoteNo(changeStateVo.getBiddingNo());
            }
        }
        //当前竞价状态及状态变更操作码
        BiddingChangeStateDto changeStateDto = BeanMapper.map(changeStateVo, BiddingChangeStateDto.class);
        log.info("开启投票变更竞价状态参数:{}", JSON.toJSONString(changeStateDto));
        BiddingStateResponseDto responseDto = biddingMainApi.changeBiddingState(changeStateDto);
        if (!BiddingStatus.OM_VOTING.getValue().equals(responseDto.getBiddingState())) {
            log.info("开启投票竞价状态变更异常:返回值{},预期值{}", responseDto.getBiddingState(), BiddingStatus.OM_VOTING.getValue());
            return new BaseResponse("竞价状态异常");
        }
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        //采购经办人直属机构到科室的完整组织机构拼接
        String companyName = biddingOperatorService.getOperateInformation(auditorId).getWholeJobName();
        //获取经办人姓名
        JcbdBiddingVo jcbdBiddingVo = biddingOperatorService.getBiddingByBiddingCode(changeStateVo.getBiddingNo());
        JcbdBiddingVo operator = biddingOperatorService.getOperator(jcbdBiddingVo.getOperatorId());
        //查询要投票的供应商数
        List<JcbdBdProviderDto> byBiddingNoAndStatus = biddingQueryApi.findByBiddingNoAndStatus(changeStateVo.getBiddingNo(), BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
        String providerNum = String.valueOf(byBiddingNoAndStatus.size());
        try {
                //竞价状态符合给竞价小组成员发送符合性审查邮件
                BaseResponse<List<JcbdBiddingGroupMemberDto>> biddingGroupMembers = biddingConformityReviewQueryApi.findBiddingGroupMember(changeStateDto.getBiddingNo());
                int size = biddingGroupMembers.getResult().size();
                //收件邮箱
                String[] sendEmail = new String[size];
                if (biddingGroupMembers.isSuccess()) {
                    for (int i = 0; i < size; i++) {
                        sendEmail[i] = biddingGroupMembers.getResult().get(i).getEmail();
                        mailReq.setTo(new String[]{sendEmail[i]});
                        mailReq.setFrom(operator.getEmail());
                        mailReq.setSentDate(new Date());
                        mailReq.setChannel(MailReq.CHANNEL_JC);
                        mailTemplateReq.setMailReq(mailReq);

                        String templateCode = MailTemplateEnum.BID_VOTE_START.getTemplateCode();
                        String redirectUrl="/operator/vote";
                        String url = biddingOperatorService.makeLoginUrl(StringUtils.join(new String[]{sendEmail[i]}), changeStateDto.getBiddingNo(),redirectUrl);
                        mailTemplateReq.setTemplateCode(templateCode);
                        List<String> subjectArgs = new ArrayList<>();
                        //竞价编号
                        subjectArgs.add(changeStateDto.getBiddingNo());
                        //共5个参数
                        List<String> contextArgs = new ArrayList<>();
                        if (!Lang.isEmpty(biddingGroupMembers.getResult().get(i).getName())) {
                            contextArgs.add(biddingGroupMembers.getResult().get(i).getName());
                        } else {
                            contextArgs.add(biddingGroupMembers.getResult().get(i).getEmail());
                        }
                        contextArgs.add(providerNum);
                        contextArgs.add(companyName);
                        contextArgs.add(operator.getUsername());
                        contextArgs.add(changeStateDto.getBiddingNo());
                        contextArgs.add(url);
                        contextArgs.add(url);
                        mailTemplateReq.setSubjectArgList(subjectArgs);
                        mailTemplateReq.setContentArgList(contextArgs);

                        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                        MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);

                    }
                }
        } catch (Exception e) {
            log.error("系统出错：{}", e);
        }
        return new BaseResponse(true, "操作成功");
    }


    /**
     * 对报价相同的供应商投票
     *
     * @param voteDetailVo
     * @param auditorEmail
     * @return
     */

    @Override
    public BaseResponse vote(VoteDetailVo voteDetailVo, String auditorEmail) {
        voteDetailVo.setBusinessCode(BiddingBusinessCode.BIDDING_VOTE_TO_SUPPLIER.getValue());
        voteDetailVo.setBusinessDescription(BiddingBusinessCode.BIDDING_VOTE_TO_SUPPLIER.getDescription());
        JcbdBiddingDto jcbdBiddingDto = biddingMainQueryApi.queryBidding(voteDetailVo.getBusinessIdentifying());
        voteDetailVo.setVoteNo(jcbdBiddingDto.getVoteNo());
        VoteDetailDto voteDetailDto = BeanMapper.map(voteDetailVo, VoteDetailDto.class);
        voteDetailDto.setVoteEmail(auditorEmail);
        //投票结果保存
        BaseResponse baseResponse = biddingVoteApi.voteSelectionSupplier(voteDetailDto);
        if (baseResponse.isSuccess()) {
            return new BaseResponse(true, "投票信息保存成功");
        }
        return baseResponse;
    }

    /**
     * 重新发起审核
     *
     * @param resComplianceAuditVo
     * @return
     */
    @Override
    public BaseResponse restartComplianceAudit(ResComplianceAuditVo resComplianceAuditVo,String auditorId) {
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        BiddingChangeStateDto biddingChangeStateDto = BeanMapper.map(resComplianceAuditVo, BiddingChangeStateDto.class);
        biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue());
        biddingChangeStateDto.setOpcode(BiddingOperateCode.RESTART_CONFORMITY_REVIEW.getCode());
        //采购经办人直属机构到科室的完整组织机构拼接
        String companyName = biddingOperatorService.getOperateInformation(auditorId).getWholeJobName();
        //获取经办人姓名
        JcbdBiddingVo jcbdBiddingVo = biddingOperatorService.getBiddingByBiddingCode(resComplianceAuditVo.getBiddingNo());
        JcbdBiddingVo operator = biddingOperatorService.getOperator(jcbdBiddingVo.getOperatorId());
        BiddingStateResponseDto responseDto = biddingMainApi.changeBiddingState(biddingChangeStateDto);
        if(!Lang.isEmpty(responseDto)){
            if (!responseDto.getBiddingState().equals(BiddingStatus.OM_CONFORM_AUDIT_IN.getValue())) {
                return new BaseResponse("操作失败");
            }
        }
        List<String> mails = resComplianceAuditVo.getMails();
        List<JcbdBiddingGroupMemberDto> complianceBiddingGroupMembers = new ArrayList<>();
        List<JcbdBiddingGroupMemberDto> noComplianceBiddingGroupMembers = new ArrayList<>();
        //竞价状态符合给竞价小组成员发送符合性审查邮件
        BaseResponse<List<JcbdBiddingGroupMemberDto>> biddingGroupMembers = biddingConformityReviewQueryApi.findBiddingGroupMember(resComplianceAuditVo.getBiddingNo());
        if(!Lang.isEmpty(mails) && !Lang.isEmpty(biddingGroupMembers)){

             for (JcbdBiddingGroupMemberDto biddingGroupMember : biddingGroupMembers.getResult()) {
                  for (int j = 0; j < mails.size(); j++) {
                  if (mails.get(j).equals(biddingGroupMember.getEmail())) {
                      complianceBiddingGroupMembers.add(biddingGroupMember);
                   }
                }
            }
            if(!Lang.isEmpty(complianceBiddingGroupMembers)){
                for(JcbdBiddingGroupMemberDto complianceBiddingGroupMember:complianceBiddingGroupMembers){
                        for(int i=0;i<biddingGroupMembers.getResult().size();i++){
                            if(complianceBiddingGroupMember.getEmail().equals(biddingGroupMembers.getResult().get(i).getEmail())){
                                biddingGroupMembers.getResult().remove(i);
                            }
                        }
                }
            }
            if(!Lang.isEmpty(biddingGroupMembers)){
                for (JcbdBiddingGroupMemberDto noComplianceBiddingGroupMember:biddingGroupMembers.getResult()) {
                    //更改没有被勾选重新发起符合性审查的小组成员状态
                    biddingMainApi.changeBiddingGroupMemberStatus(resComplianceAuditVo.getBiddingNo(),noComplianceBiddingGroupMember.getGroupMemberId(),BiddingStatus.M_CONFORM_AUDIT_OK.getValue(),noComplianceBiddingGroupMember.getEmail());
                }
            }
            if(!Lang.isEmpty(complianceBiddingGroupMembers)){
                for (JcbdBiddingGroupMemberDto complianceBiddingGroupMember:complianceBiddingGroupMembers) {
                    //删除当前选中人员的符合性审查记录
                    biddingConformityReviewQueryApi.deleteComplianceAudit(resComplianceAuditVo.getBiddingNo(),complianceBiddingGroupMember.getEmail(),complianceBiddingGroupMember.getGroupMemberId());
                }
            }
        }
        try {
            int size = complianceBiddingGroupMembers.size();
            //收件邮箱
            String[] sendEmail = new String[size];
            if (biddingGroupMembers.isSuccess()) {
                for (int i = 0; i < size; i++) {
                    //TODO: 2018/3/19邮件模板数据填充
                    sendEmail[i] = complianceBiddingGroupMembers.get(i).getEmail();
                    mailReq.setTo(new String[]{sendEmail[i]});
                    mailReq.setFrom(operator.getEmail());
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel(MailReq.CHANNEL_JC);
                    mailTemplateReq.setMailReq(mailReq);
                            String templateCode = MailTemplateEnum.BID_CONFORMANCE_AUDIT_UNLOCK.getTemplateCode();
                            mailTemplateReq.setTemplateCode(templateCode);
                            String redirectUrl="/operator/complianceAudit";
                            String url = biddingOperatorService.makeLoginUrl(StringUtils.join(new String[]{sendEmail[i]}), biddingChangeStateDto.getBiddingNo(),redirectUrl);
                            List<String> subjectArgs = new ArrayList<>();
                            //竞价编号
                            subjectArgs.add(resComplianceAuditVo.getBiddingNo());
                            //共5个参数
                            List<String> contextArgs = new ArrayList<>();
                            if (!Lang.isEmpty(complianceBiddingGroupMembers.get(i).getName())) {
                                contextArgs.add(complianceBiddingGroupMembers.get(i).getName());
                            } else {
                                contextArgs.add(complianceBiddingGroupMembers.get(i).getEmail());
                            }
                            contextArgs.add(companyName);
                            contextArgs.add(operator.getUsername());
                            contextArgs.add(resComplianceAuditVo.getBiddingNo());
                            contextArgs.add(url);
                            contextArgs.add(url);
                            mailTemplateReq.setSubjectArgList(subjectArgs);
                            mailTemplateReq.setContentArgList(contextArgs);

                            mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                            MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);
                }
            }
            return new BaseResponse(true, "操作成功");
        } catch (Exception e) {
            log.error("系统出错：{}", e);
        }
        return new BaseResponse(true, "操作成功");
    }

    /**
     * 判断当前人员是不是完成审查
     *
     * @param biddingNo
     * @param auditorId
     * @return
     */
    @Override
    public BaseResponse compeleteAudit(String biddingNo, String auditorId, String email) {
        //变更竞价小组成员审核状态
        BaseResponse baseResponse = biddingMainApi.changeGroupMemberConfomanceCheck(biddingNo, auditorId, email);
        BaseResponse<Boolean> biddingConformityReviewAuditComplished = biddingConformityReviewApi.isBiddingConformityReviewAuditComplished(biddingNo, auditorId, email);
        //当前人员未审核完成将小组成员状态变更为未审核
        if(!biddingConformityReviewAuditComplished.isSuccess()){
            biddingMainApi.cancelGroupMemberConfomanceCheck(biddingNo, auditorId, email);
        }
        return biddingConformityReviewAuditComplished;
    }
}
