package bidding.web.service.impl;

import api.*;
import api.query.*;
import bidding.api.vo.BiddingMemberLoginInfoVo;
import bidding.web.service.BiddingOperatorService;
import bidding.web.service.ProtocolService;
import bidding.web.vo.*;
import cart.api.OrderMainApi;
import cart.api.difinication.UserCodeType;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.definition.OrderType;
import cart.api.dto.payment.PaymentConfigDto;
import cart.api.vo.*;
import cms.api.AddressApi;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.*;
import dto.*;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductFashionApi;
import goods.dto.goods.GoodsConfigDto;
import ma.glasnost.orika.MapperFacade;
import member.api.*;
import member.api.dto.common.TianXianDepartmentDto;
import member.api.dto.core.*;
import member.api.dto.menu.MemberMenuRoleDto;
import member.api.dto.menu.MemberMenuRoleUserDto;
import member.api.dto.order.OrderInvoiceDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.JsonModel;
import member.api.vo.MemberAddressVo;
import member.api.vo.MemberVo;
import member.api.vo.cart.InvoiceInfoVo;
import member.api.vo.cart.InvoiceItemInfoVo;
import member.api.vo.cart.InvoiceReceiverVo;
import member.api.vo.cart.OrderSubmitVo;
import member.model.core.CoreCompany;
import member.model.core.CoreDepartment;
import member.model.repository.core.CompanyRepos;
import member.model.repository.core.DepartmentRepos;
import message.MailModule;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.mail.vo.MailTemplateReq;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import query.BiddingDemandListQuery;
import query.BiddingDemandRespQuery;
import query.BiddingOperatorQuery;
import query.SupplierBiddingDamandQuery;
import shipping.api.InvoiceInfoApi;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreExtDto;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import uninogift.api.protocol.SupplierLoginApi;
import uninogift.vo.protocol.SupplierContactDto;
import uninogift.vo.protocol.outside.ContactPersonDto;
import uninogift.vo.protocol.outside.Response;
import uninogift.vo.protocol.outside.VendorDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.security.AesUtil;
import utils.sql.PageVo;
import utils.web.ResponseMapUtils;
import workflow.api.WfWorkFlowRelationApi;
import workflow.api.WorkFlowServiceApi;
import workflow.api.business.bidding.WfBiddingResultDataApi;
import workflow.definition.AuditBusinessCode;
import workflow.definition.AuditFlowImplInstance;
import workflow.definition.WorkFlowCode;
import workflow.dto.*;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

import static definition.BiddingStatus.OM_DO_BUY;
import static java.util.stream.Collectors.counting;
import static java.util.stream.Collectors.groupingBy;

/**
 * @author miaohao on 2018/3/16.
 */
@Service
public class BiddingOperatorServiceImpl implements BiddingOperatorService {

    public static final Logger log = LoggerFactory.getLogger(BiddingOperatorServiceImpl.class);
    public static ExecutorService executorService;
    // 执行采购发票收件地址标记位
    public static final String INVOICE_ADDRESS_FLAG_NO = "0";
    public static final String INVOICE_ADDRESS_FLAG_YES = "1";
    //批量导入结果
    public static final String IMPORT_SUCCESS = "导入成功";

    public static final String BIDDING_TITILE_SHOW_MODULE = "BiddingShow";


    public static final String ORGANIZATIONCODE = "jicai";

    {
        executorService = Executors.newFixedThreadPool(5);
    }

    /**
     * 竞价小组成员竞价状态
     */
    private String GROUPMEMBER_STATUS_TRUE = "1";
    private String GROUPMEMBER_STATUS_FALSE = "0";

    /**
     * 发票收件人是否同收件人地址 1:是，0：否
     */
    private static final String CONSIGNEE_FLAG_TRUE = "1";
    private static final String CONSIGNEE_FLAG_FALSE = "0";

    /**
     * 订单类型
     */
    private static final String ORDER_TYPE = "竞价订单";

    private static final String TPJT = "太平集团";

    /**
     * 竞价编号KEY
     */
    public String BIDDING_CODE_REDIS_KEY = "BIDDING:BIDDING_CODE_REDIS_KEY:";
    /**
     * 竞价需求编号KEY
     */
    public String DEMAND_CODE_REDIS_KEY = "BIDDING:DEMAND_CODE_REDIS_KEY:";
    @MotanReferer
    CoreUserApi coreUserApi;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    BiddingMainApi biddingMainApi;
    @MotanReferer
    BiddingConformityReviewQueryApi biddingConformityReviewQueryApi;
    @MotanReferer
    MailApi mailApi;
    @MotanReferer
    BiddingResponseQueryApi biddingResponseQueryApi;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    ProtocolService protocolService;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    BiddingLogApi biddingLogApi;
    @MotanReferer
    MemberInvoinceApi memberInvoinceApi;
    @MotanReferer
    BiddingResponseApi biddingResponseApi;
    @MotanReferer
    BiddingVoteApi biddingVoteApi;
    @MotanReferer
    BiddingQueryApi biddingQueryApi;
    @MotanReferer
    MallAttachmentApi mallAttachmentApi;
    @MotanReferer
    BiddingLogQueryApi biddingLogQueryApi;
    @MotanReferer
    QueryInformationApi queryInformationApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    BiddingConformityReviewApi biddingConformityReviewApi;
    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;
    @MotanReferer
    WorkFlowServiceApi workFlowServiceApi;

    @MotanReferer
    BiddingDemandApi biddingDemandApi;

    @MotanReferer
    WfBiddingResultDataApi wfBiddingResultDataApi;

    @MotanReferer
    BiddingSupplierOrderManagerApi biddingSupplierOrderManagerApi;

    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;

    @MotanReferer
    BiddingCodeRuleApi biddingCodeRuleApi;
    @MotanReferer
    BdDemandCodeRuleApi bdDemandCodeRuleApi;

    @MotanReferer
    CoreRoleApi coreRoleApi;
    @Autowired
    BiddingOperatorServiceImpl biddingOperatorService;

    @Value("${organization.code}")
    private String organizationCode;//机构code值

    @Value("${bid.trading.limit}")
    private String tradingLimit;

    @Value("${spring.mail.username}")
    String mailFrom;


    @Value("${bidding.result.baseurl}")
    String bidding_result_baseurl;

    @Value("${bidding.groupMember.login.params}")
    String aesKey;

    @Value("${bidding.groupMember.loginUrl}")
    String loginUrl;


    @MotanReferer
    BiddingRoleOperationQueryApi biddingRoleOperationQueryApi;

    @MotanReferer
    AddressApi addressApi;

    @MotanReferer
    ProductFashionApi productFashionApi;

    @MotanReferer
    MemberMenuRoleApi memberMenuRoleApi;

//    ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 6, 5, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());

    /**
     * 开启符合性审查
     *
     * @param biddingChangeStateVo
     * @return
     * @author
     */
    @Override
    public BaseResponse startComplianceAudit(@RequestBody BiddingChangeStateVo biddingChangeStateVo, String biddingMemberId) {
        BiddingStateResponseDto biddingStateResponseDto = null;
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        //采购经办人直属机构到科室的完整组织机构拼接
        String companyName = getOperateInformation(biddingMemberId).getWholeJobName();
        //获取经办人姓名
        JcbdBiddingVo jcbdBiddingVo = getBiddingByBiddingCode(biddingChangeStateVo.getBiddingNo());
        JcbdBiddingVo operator = getOperator(jcbdBiddingVo.getOperatorId());
        try {
            //封装参数
            if (jcbdBiddingVo.getStatus().equals(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue())) {
                biddingChangeStateVo.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue());
                biddingChangeStateVo.setOpcode(BiddingOperateCode.RESTART_CONFORMITY_REVIEW.getCode());
            } else {
                biddingChangeStateVo.setCurrentState(BiddingStatus.OM_RESPONSE_STOP.getValue());
                biddingChangeStateVo.setOpcode(BiddingOperateCode.START_CONFORMITY_REVIEW.getCode());
            }
            BiddingChangeStateDto changeStateDto = BeanMapper.map(biddingChangeStateVo, BiddingChangeStateDto.class);
            biddingStateResponseDto = biddingMainApi.changeBiddingState(changeStateDto);
            //返回值判空处理
            if (!Lang.isEmpty(biddingStateResponseDto.getBiddingState())) {
                log.info("开启符合性审查：请求参数{}，返回参数{}", JSON.toJSONString(changeStateDto), biddingStateResponseDto.getBiddingState());
                //做返回竞价状态与预期竞价状态符合性检查
                if (BiddingStatus.OM_CONFORM_AUDIT_IN.getValue().equals(biddingStateResponseDto.getBiddingState())) {
                    //竞价状态符合给竞价小组成员发送符合性审查邮件
                    BaseResponse<List<JcbdBiddingGroupMemberDto>> biddingGroupMembers = biddingConformityReviewQueryApi.findBiddingGroupMember(changeStateDto.getBiddingNo());
                    int size = biddingGroupMembers.getResult().size();
                    //收件邮箱
                    String[] sendEmail = new String[size];
                    if (biddingGroupMembers.isSuccess()) {
                        for (int i = 0; i < size; i++) {
                            //TODO: 2018/3/19邮件模板数据填充
                            sendEmail[i] = biddingGroupMembers.getResult().get(i).getEmail();
                            mailReq.setTo(new String[]{sendEmail[i]});
                            mailReq.setFrom(operator.getEmail());
                            mailReq.setSentDate(new Date());
                            mailReq.setChannel(MailReq.CHANNEL_JC);
                            mailTemplateReq.setMailReq(mailReq);

                            //BID_AUDIT("1_1_5","竞价审核")
                            // 首位对应模板号，2位对应邮件标题参数subjectArgs,3位对应内容参数contextArgs
                            String templateCode = MailTemplateEnum.BID_CONFORMANCE_AUDIT.getTemplateCode();
                            String redirectUrl = "/operator/complianceAudit";
                            String url = makeLoginUrl(StringUtils.join(new String[]{sendEmail[i]}), changeStateDto.getBiddingNo(), redirectUrl);
                            mailTemplateReq.setTemplateCode(templateCode);
                            List<String> subjectArgs = new ArrayList<>();
                            //竞价编号
                            subjectArgs.add(changeStateDto.getBiddingNo());
                            //共5个参数
                            List<String> contextArgs = new ArrayList<>();
                            if (!Lang.isEmpty(biddingGroupMembers.getResult().get(i).getName())) {
                                contextArgs.add(biddingGroupMembers.getResult().get(i).getName());
                            } else {
                                contextArgs.add(biddingGroupMembers.getResult().get(i).getEmail());
                            }
                            //采购经办人直属机构到科室的完整组织机构拼接
                            contextArgs.add(companyName);
                            //采购经办人的姓名
                            contextArgs.add(operator.getUsername());
                            contextArgs.add(changeStateDto.getBiddingNo());
                            //符合性审查跳转的链接
                            contextArgs.add(url);
                            contextArgs.add(url);
                            mailTemplateReq.setSubjectArgList(subjectArgs);
                            mailTemplateReq.setContentArgList(contextArgs);

                            mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                            mailApi.sendMailByTemplate(mailTemplateReq);
                            log.info("开启符合性审查 邮件发送{}", JSON.toJSON(mailTemplateReq));
                        }
                    }
                }

            }
        } catch (Exception e) {
            log.error("开启符合性审查 发送邮件失败");
        }
        return new BaseResponse(true, "操作成功");
    }

    /**
     * 生成邮件正文中跳转路径
     *
     * @param email
     * @param biddingNo
     * @return
     */
    public String makeLoginUrl(String email, String biddingNo, String redirectUrl) {
        String url = "";
        BiddingMemberLoginInfoVo biddingMemberLoginInfoVo = new BiddingMemberLoginInfoVo();
        biddingMemberLoginInfoVo.setBiddingNo(biddingNo);
        biddingMemberLoginInfoVo.setEmail(email);
        biddingMemberLoginInfoVo.setRedirectUrl(redirectUrl);
        String paramsJsonStr = JSON.toJSONString(biddingMemberLoginInfoVo);
        try {
            String params = AesUtil.Encrypt(paramsJsonStr, aesKey);
            params = new String(Base64.getEncoder().encode(params.getBytes()));
            url = loginUrl + "?params=" + params;
            log.info("生成的url为{}", url);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    @Override
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String biddingMemberId, String biddingEmail, List<String> biddingMemberRoles, QueryBiddingRequestVO queryBiddingRequestVO) {
        Map returnModel = new HashMap();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        JcbdBiddingQueryDto biddingQueryDto = new JcbdBiddingQueryDto();
        biddingQueryDto.setJcbdBiddingNo(queryBiddingRequestVO.getJcbdBiddingNo());
        biddingQueryDto.setDescribe(queryBiddingRequestVO.getJcbdBiddingDescribe());
        if (!Lang.isEmpty(queryBiddingRequestVO.getState())) {
            if (BiddingStatus.OM_RESULT_SELECT_WAIT.getValue().equals(queryBiddingRequestVO.getState())) {
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.OM_RESULT_SELECT_WAIT_VOTE.getValue(), BiddingStatus.OM_RESULT_SELECT_WAIT_RANDOM.getValue()));
            } else {
                biddingQueryDto.setStates(Arrays.asList(queryBiddingRequestVO.getState()));
            }
        }
        if (!Lang.isEmpty(queryBiddingRequestVO.getStartTime())) {
            biddingQueryDto.setStartTime(DateUtils.strToDate(queryBiddingRequestVO.getStartTime(), GlobalContants.DateFormat.YYYY_MM_DD));
        }
        if (!Lang.isEmpty(queryBiddingRequestVO.getEndTime())) {
            biddingQueryDto.setEndTime(DateUtils.strToDate(queryBiddingRequestVO.getEndTime(), GlobalContants.DateFormat.YYYY_MM_DD));
        }
        biddingQueryDto.setRoles(biddingMemberRoles);
        biddingQueryDto.setUserId(biddingMemberId);
        biddingQueryDto.setEmail(biddingEmail);
        biddingQueryDto.setPageable(pageable);
        Long totalElement = 0L;
        Page<JcbdBiddingQueryResultDto> page = biddingMainQueryApi.operatorFindJcbdBiddingByParams(biddingQueryDto);

        List<BiddingResponseListVo> biddingResponseListVos = new ArrayList<>();
        if (!Lang.isEmpty(page)) {
            for (JcbdBiddingQueryResultDto jcbdBiddingQueryResultDto : page.getContent()) {
                BiddingResponseListVo biddingResponseListVo = new BiddingResponseListVo();
                mapperFacade.map(jcbdBiddingQueryResultDto, biddingResponseListVo);
                biddingResponseListVo.setStateName(BiddingStatus.biddingStatusMap.get(jcbdBiddingQueryResultDto.getState()).getDescription());
                biddingResponseListVo.setStartTime(DateUtils.toString(jcbdBiddingQueryResultDto.getStartTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
                biddingResponseListVo.setEndTime(DateUtils.toString(jcbdBiddingQueryResultDto.getEndTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
                if (!Lang.isEmpty(jcbdBiddingQueryResultDto.getOperations())) {
                    biddingResponseListVo.setOperations(mapperFacade.mapAsList(jcbdBiddingQueryResultDto.getOperations(), JcbdRoleOperationVo.class));
                }
                biddingResponseListVos.add(biddingResponseListVo);
            }
            totalElement = page.getTotalElements();
            returnModel.put("aaData", biddingResponseListVos);
            returnModel.put("iTotalRecords", totalElement);
            returnModel.put("iTotalDisplayRecords", totalElement);
        } else {
            returnModel.put("aaData", biddingResponseListVos);
            returnModel.put("iTotalRecords", totalElement);
            returnModel.put("iTotalDisplayRecords", totalElement);
        }
        return returnModel;
    }

    @Override
    public List<BiddingStatusVo> getAllStatusByRoles(List<String> biddingMemberRoles) {
        List<BiddingStatusVo> biddingStatusVos = new ArrayList<>();
        if (biddingMemberRoles.contains(BiddingRole.BIDDING_GROUP_MEMBER)) {
            Map<String, BiddingStatus> stringBiddingStatusMap = BiddingRoleStatus.biddingRoleStatus.get(BiddingRole.BIDDING_GROUP_MEMBER);
            Set<String> strings = stringBiddingStatusMap.keySet();
            strings.forEach(key -> {
                BiddingStatusVo biddingStatusVo = new BiddingStatusVo();
                biddingStatusVo.setStatus(key);
                biddingStatusVo.setStatusName(stringBiddingStatusMap.get(key).getDescription());
                biddingStatusVos.add(biddingStatusVo);
            });
        } else if (biddingMemberRoles.contains(BiddingRole.BIDDING_AUDITOR)) {
            Map<String, BiddingStatus> stringBiddingStatusMap = BiddingRoleStatus.biddingRoleStatus.get(BiddingRole.BIDDING_AUDITOR);
            Set<String> strings = stringBiddingStatusMap.keySet();
            strings.forEach(key -> {
                BiddingStatusVo biddingStatusVo = new BiddingStatusVo();
                biddingStatusVo.setStatus(key);
                biddingStatusVo.setStatusName(stringBiddingStatusMap.get(key).getDescription());
                biddingStatusVos.add(biddingStatusVo);
            });
        }
        biddingStatusVos.forEach(biddingStatus -> {

        });

        return biddingStatusVos;
    }

    @Override
    public Map issueBidding(BiddingIssueRequestVo biddingIssueRequestVo, String biddingMemberId) {
        BaseResponse<JcbdBiddingDto> biddingCodeResp = biddingMainQueryApi.getBiddingByBiddingCode(biddingIssueRequestVo.getBiddingCode());
        if (!biddingCodeResp.isSuccess()) {
            return ResponseMapUtils.error("查询无该竞价信息");
        }
        BaseResponse response = biddingMainApi.updateBiddingTime(biddingIssueRequestVo.getBiddingCode(), new Date(), DateUtils.strToDate(biddingIssueRequestVo.getTimeEndResponse(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        if (!response.isSuccess()) {
            return ResponseMapUtils.error("更新竞价失败");
        }
        BaseResponse baseResponse = biddingResponseApi.supplierInitStatus(biddingIssueRequestVo.getBiddingCode());
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error("初始化供应商竞价状态失败");
        }
        BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
        biddingChangeStateDto.setBiddingNo(biddingIssueRequestVo.getBiddingCode());
        biddingChangeStateDto.setCurrentState(BiddingStatus.OM_ISSUE_WAIT.getValue());
        biddingChangeStateDto.setOpcode(BiddingOperateCode.ISSUE_BIDDING.getCode());
        BiddingStateResponseDto biddingStateResponseDto = biddingMainApi.changeBiddingState(biddingChangeStateDto);
        if (!BiddingStatus.OM_RESPONSE_WAIT.getValue().equals(biddingStateResponseDto.getBiddingState())) {
            return ResponseMapUtils.error("竞价状态变更错误");
        }
        //发送邮件
        try {
            List<JcbdStoreContactsVo> storeContacts = new ArrayList<>();
            List<JcbdBdProviderVo> providerVoList = findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
            if (!Lang.isEmpty(providerVoList)) {
                providerVoList.forEach(jcbdBdProviderVo -> {
                    if (!Lang.isEmpty(jcbdBdProviderVo.getJcbdStoreContactsVos())) {
                        jcbdBdProviderVo.getJcbdStoreContactsVos().forEach(jcbdStoreContactsVo -> {
                            storeContacts.add(jcbdStoreContactsVo);
                        });
                    }
                });
            }
            if (Lang.isEmpty(storeContacts)) {
                log.info("编号为{}的竞价查询供应商联系人失败", biddingIssueRequestVo.getBiddingCode());
            } else {
                MailReq mailReq = new MailReq();
                MailTemplateReq mailTemplateReq = new MailTemplateReq();
                String companyName = getOperateInformation(biddingMemberId).getWholeJobName();
                //获取经办人姓名
                JcbdBiddingVo jcbdBiddingVo = getBiddingByBiddingCode(biddingIssueRequestVo.getBiddingCode());
                JcbdBiddingVo operator = getOperator(jcbdBiddingVo.getOperatorId());
                storeContacts.forEach(supplierContant -> {
                    mailReq.setTo(new String[]{supplierContant.getEmail()});
                    mailReq.setFrom(mailFrom);
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel(MailReq.CHANNEL_JC);
                    mailTemplateReq.setMailReq(mailReq);
                    mailTemplateReq.setTemplateCode(MailTemplateEnum.BID_ISSUE.getTemplateCode());
                    List<String> subjectArgs = new ArrayList<>();
                    //竞价编号
                    subjectArgs.add(biddingIssueRequestVo.getBiddingCode());
                    //共5个参数
                    List<String> contextArgs = new ArrayList<>();
                    contextArgs.add(supplierContant.getName());
                    contextArgs.add(companyName.toString());
                    contextArgs.add(operator.getUsername());
                    contextArgs.add(biddingIssueRequestVo.getBiddingCode());
                    contextArgs.add(biddingIssueRequestVo.getTimeEndResponse());
                    mailTemplateReq.setSubjectArgList(subjectArgs);
                    mailTemplateReq.setContentArgList(contextArgs);
                    mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                    log.info("竞价发布邮件模板封装数据{}", JSON.toJSONString(mailTemplateReq));
                    mailApi.sendMailByTemplate(mailTemplateReq);
                });
            }
        } catch (Exception e) {
            log.error("竞价{}的发布竞价操作邮件通知供应商失败", biddingIssueRequestVo.getBiddingCode(), e);
        }
        return ResponseMapUtils.success("");
    }


    /**
     * @author taofeng
     * @date 2018/3/19
     */
    @Override
    public String getBiddingCode() {

        BaseResponse<String> biddingNo = biddingMainApi.getBiddingNo();
        log.info("biddingNo={}", biddingNo.getResult());
        return biddingNo.getResult();
    }

    /**
     * @author taofeng
     * @date 2018/3/19
     **/
    @Override
    public JcbdBiddingVo getOperator(String memberId) {
        // todo 一般用 findMemberById
        MemberDto member = memberApi.findMemberById(memberId);
        JcbdBiddingVo jcbdBiddingVo = new JcbdBiddingVo();
        if (!Lang.isEmpty(member)) {
            jcbdBiddingVo.setUsername(member.getRealName());
            CoreUserDto coreUser = member.getCoreUser();
            if (!Lang.isEmpty(coreUser)) {
                jcbdBiddingVo.setPhone(coreUser.getPhone());
                jcbdBiddingVo.setEmail(coreUser.getEmail());
            }
        }
        return jcbdBiddingVo;
    }

    @Override
    public MemberDto getMember(String memberId) {
        return memberApi.findMemberById(memberId);
    }


    /**
     * @author taofeng
     * @date 2018/3/19
     * <p>
     * 竞价保存更新
     **/
    @Override
    public Map saveOrUpdateBiddingBaseInfo(JcbdBiddingVo jcbdBiddingVo, String[] biddingGroups, String[] hiddenBiddingGroupMemberIds, String[] hiddenBiddingSpliceStringIds, List<ImageVo> imageVoList, String userId) {        //保存附件
        List<MallAttachmentVo> mallAttachmentVos = new ArrayList<>();

        if (imageVoList != null) {
            for (ImageVo imageVo : imageVoList) {
                MallAttachmentVo mallAttachmentVo = new MallAttachmentVo();
                mallAttachmentVo.setAttachmentCorrelation(jcbdBiddingVo.getBiddingCode());
                mallAttachmentVo.setUrl(imageVo.getAbsoluteFilePath());
                mallAttachmentVo.setPath(imageVo.getFilePath());
                mallAttachmentVo.setAttachmentName(imageVo.getSourceName());
                mallAttachmentVo.setOrganizationCode("jiacai");
                mallAttachmentVo.setBusinessCode(MallAttachmentBusinessCode.BIDBASE_ATTACH_BUSCODE.getValue());
                mallAttachmentVos.add(mallAttachmentVo);
            }
            List<MallAttachmentDto> mallAttachmentDtos = BeanMapper.mapList(mallAttachmentVos, MallAttachmentVo.class, MallAttachmentDto.class);
            if (!Lang.isEmpty(mallAttachmentDtos)) {
                mallAttachmentApi.batchSave(mallAttachmentDtos);
            }
        } else {
            mallAttachmentApi.deleteMallAttachments(jcbdBiddingVo.getBiddingCode(), MallAttachmentBusinessCode.BIDBASE_ATTACH_BUSCODE.getValue());
        }
        //竞价小组
        OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);
        List<JcbdBiddingGroupMemberVo> groupMemberList = new ArrayList<>();


        for (int i = 0; i < biddingGroups.length; i++) {
            if (!Lang.isEmpty(biddingGroups[i]) && !Lang.isEmpty(organization.getId())) {
                JcbdBiddingGroupMemberVo jbgmd = new JcbdBiddingGroupMemberVo();
                jbgmd.setGroupMemberInfo(biddingGroups[i]);
                String[] split = biddingGroups[i].split(",");
                CoreUserDto coreUserDto=null;
                if(!Lang.isEmpty(split[2])){
                    coreUserDto = coreUserApi.findByPhoneOrEmail(split[2], organization.getId());
                }
                List<MemberDto> memberDtoList = null;
                //todo tf 目前只做邮箱格式校验,coreUser不校验
                if (!Lang.isEmpty(coreUserDto)) {
                    memberDtoList = memberApi.findByCoreUserId(coreUserDto.getId());
                    MemberDto memberDto = null;
                    if (!Lang.isEmpty(memberDtoList)) {
                        memberDto = memberDtoList.get(0);
                    }
                    if (!Lang.isEmpty(memberDto)) {
                        jbgmd.setGroupMemberId(memberDto.getId());
                        jbgmd.setName(memberDto.getRealName());
                        jbgmd.setPhone(coreUserDto.getPhone());
                        jbgmd.setEmail(coreUserDto.getEmail());
                    }
                } else {
                    jbgmd.setEmail(split[2]);
                }
                jbgmd.setEffective(BiddingGroupMemberStatus.VALID.getValue());
                groupMemberList.add(jbgmd);


            } else {
                groupMemberList.add(null);
            }
        }
        jcbdBiddingVo.setJcbdBiddingGroupMembers(groupMemberList);

        //查找竞价小组成员角色
        if (!Lang.isEmpty(hiddenBiddingGroupMemberIds) && !Lang.isEmpty(hiddenBiddingSpliceStringIds)) {

            for (int j = 0; j < hiddenBiddingGroupMemberIds.length; j++) {
                if (!Lang.isEmpty(hiddenBiddingGroupMemberIds[j]) && !Lang.isEmpty(hiddenBiddingSpliceStringIds[j])) {

                    try {
                        grantPermission4BiddingGroupMember(hiddenBiddingGroupMemberIds[j], hiddenBiddingSpliceStringIds[j], GlobalContants.ROLE_CODE_JC_JJXZ);

                    } catch (Exception e) {
                        log.error("为第" + (j) + "个竞价小组成员授权出错:", e);
                    }
                }
            }
        }

        //供应商
        List<JcbdBdProviderVo> jcbdBdProviderVos = new ArrayList<>();

        List<StoreDto> storeList = storeApi.findByTpye(StoreDto.STORE_TYPE_SUPLIER);
        for (StoreDto storeDto : storeList) {
            StoreExtDto storeExt = storeDto.getStoreExt();
            Response<VendorDto> response = protocolService.getGysxx(storeExt.getdVendorId());
            VendorDto vendorDto = response.getData();
            //供应商
            if (!Lang.isEmpty(vendorDto) && !Lang.isEmpty(vendorDto.getGysmc())) {
                JcbdBdProviderVo jcbdBdProviderVo = new JcbdBdProviderVo();
                jcbdBdProviderVo.setProviderId(storeDto.getId());
                jcbdBdProviderVo.setProviderName(vendorDto.getGysmc());
                jcbdBdProviderVos.add(jcbdBdProviderVo);
            }
        }
        jcbdBiddingVo.setJcbdBdProviders(jcbdBdProviderVos);

        JcbdBiddingDto jcbdBiddingDto = BeanMapper.map(jcbdBiddingVo, JcbdBiddingDto.class);
        jcbdBiddingDto.setOperatorName(jcbdBiddingVo.getUsername());
        jcbdBiddingDto.setOperatorPhone(jcbdBiddingVo.getPhone());
        jcbdBiddingDto.setProviderInviteNum(jcbdBiddingVo.getJcbdBdProviders().size());
        BaseResponse<JcbdBiddingDto> response = biddingMainApi.saveOrUpdateBiddingBaseInfo(jcbdBiddingDto);

        if (!response.isSuccess()) {
            return ResponseMapUtils.error(response.getResultMessage());
        }
        jcbdBiddingDto = response.getResult();

        JcbdBiddingVo biddingVo = null;
        if (!Lang.isEmpty(jcbdBiddingDto)) {
            biddingVo = BeanMapper.map(jcbdBiddingDto, JcbdBiddingVo.class);
        }
        return ResponseMapUtils.success(biddingVo);
    }

    /**
     * 下单业务（执行采购）
     *
     * @param tempPurchaseVoData
     * @return
     */
    @Override
    public BaseResponse commitJcbdOrderData(TempPurchaseVo tempPurchaseVoData, String memberId) {
        //tempPurchaseVo里的List<TempJcbdOrderVo>， 当初理解是页面按照列表，每一条购买传一项物品的信息
        //现在使用tempOrderDtos理解的是里面一次订单可传多项物品购买
        //以下为按照原来的vo想法重新处理数据 2018.4.13
        TempPurchaseVo tempPurchaseVo = dealTempPurchaseVo(tempPurchaseVoData);
        //验证数据
        log.info("Jcbd执行采购数据处理结果：{}", JSON.toJSONString(tempPurchaseVo));
        BaseResponse response = new BaseResponse();
        response.setSuccess(true);

        //(5)校验此处状态是否为“执行采购”状态，如不是则不可进行采购，
        // 并提示：“供应商提交修改此竞价的商品，商品【商品编码】、商品【商品编码】不可购买”
        JcbdBiddingDto biddingDto = biddingQueryApi.findByBiddingCodeAndIsDelete(tempPurchaseVo.getBiddingCode());
        if (!biddingDto.getStatus().equals(OM_DO_BUY.getValue())) {
            response.setSuccess(false);
            response.setResultMessage("供应商已重新编辑了本次竞价的商品，请审核商品编码后再执行采购！");
        }


        log.info("Jcbd执行采购数据验证通过，会员ID：{}，执行采购竞价编号：{}",memberId,biddingDto.getBiddingCode());
        //校验通过进行下单
        BaseResponse baseResponse = createJcbdOrder(tempPurchaseVo, memberId);
        //删除bidding下的临时订单
        biddingMainApi.deleteTempOrderByBiddingCode(tempPurchaseVo.getBiddingCode());
        return baseResponse;
    }

    /**
     * 处理数据
     *
     * @param tempPurchaseVoData
     * @return
     */
    private TempPurchaseVo dealTempPurchaseVo(TempPurchaseVo tempPurchaseVoData) {
        List<JcbdTempOrderDto> tempOrderDtos = biddingOrderQueryApi.findTempOrderByBiddingCode(tempPurchaseVoData.getBiddingCode());
        TempPurchaseVo tempPurchaseVo = new TempPurchaseVo();
        tempPurchaseVo.setUsageCode(tempPurchaseVoData.getUsageCode());
        tempPurchaseVo.setRemarks(tempPurchaseVoData.getRemarks());
        tempPurchaseVo.setPayMethodCode(tempPurchaseVoData.getPayMethodCode());
        tempPurchaseVo.setMallAttachments(tempPurchaseVoData.getMallAttachments());
        tempPurchaseVo.setBiddingCode(tempPurchaseVoData.getBiddingCode());
        tempPurchaseVo.setProcessId(tempPurchaseVoData.getProcessId());
        tempPurchaseVo.setTianxianDepartMentId(tempPurchaseVoData.getTianxianDepartMentId());
        List<TempJcbdOrderVo> orders = new ArrayList<>();
        for (JcbdTempOrderDto tempOrderDto : tempOrderDtos) {
            //final CoreCompanyDto companyDto = coreCompanyApi.findById(tempOrderDto.getCompanyId());
            tempOrderDto.getJcbdTempGoodses().forEach(n -> {
                TempJcbdOrderVo orderVo = new TempJcbdOrderVo();
                orderVo.setSku(n.getSku());
                orderVo.setResponsePrice(n.getPrice());
                orderVo.setCount(n.getNum());
                orderVo.setJcbdBiddingDemandId(n.getDemandId());
                orderVo.setMemberAddrId(tempOrderDto.getMemberAddressId());
                orderVo.setStoreId(tempOrderDto.getStoreId());
                orderVo.setProductFashionId(n.getProductFashionId());
                orderVo.setGoodsId(n.getGoodsId());
                orderVo.setJcbdBiddingDemandCode(n.getDemandCode());
                MemberAddressDto memberAddressDto = memberAddressApi.findByIdAndIsDelete(tempOrderDto.getMemberAddressId(), false);
                orderVo.setProvinceCode(memberAddressDto.getProvinceCode());
                orderVo.setCityCode(memberAddressDto.getCityCode());
                orderVo.setTownCode(memberAddressDto.getTownCode());
                orderVo.setAreaCode(memberAddressDto.getAreaCode());
                orderVo.setAddressDetail(memberAddressDto.getAddressDetail());
                orderVo.setPhone(memberAddressDto.getPhone());
                orderVo.setUsername(memberAddressDto.getUsername());

                MemberInVoiceVO inVoiceVO = new MemberInVoiceVO();
                inVoiceVO.setType(tempOrderDto.getInvoiceType());
                // 与收件人地址相同 ，取会员地址
                if (CONSIGNEE_FLAG_TRUE.equals(tempOrderDto.getConsigneeFlag())) {
                    inVoiceVO.setSameAsAchiever(true);
                    inVoiceVO.setAddressDetail(memberAddressDto.getAddressDetail());
                    inVoiceVO.setConsigneeName(memberAddressDto.getUsername());
                    inVoiceVO.setConsigneeCityCode(memberAddressDto.getCityCode());
                    inVoiceVO.setConsigneeProvinceCode(memberAddressDto.getProvinceCode());
                    inVoiceVO.setConsigneePhone(memberAddressDto.getTel());
                } else if (CONSIGNEE_FLAG_FALSE.equals(tempOrderDto.getConsigneeFlag())) {
                    inVoiceVO.setSameAsAchiever(false);
                    inVoiceVO.setAddressDetail(tempOrderDto.getAddressDetail());
                    inVoiceVO.setConsigneeName(tempOrderDto.getConsigneeName());
                    inVoiceVO.setConsigneeCityCode(tempOrderDto.getConsigneeCityCode());
                    inVoiceVO.setConsigneeProvinceCode(tempOrderDto.getConsigneeProvinceCode());
                    inVoiceVO.setConsigneePhone(tempOrderDto.getConsigneePhone());
                }
                if (GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL.equals(tempOrderDto.getInvoiceType())) {
                    inVoiceVO.setCompanyId(tempOrderDto.getCompanyId());
                } else if (GlobalContants.InvoiceCode.INVOICE_TYPE_PLAIN.equals(tempOrderDto.getInvoiceType())) {
                    inVoiceVO.setInvoiceName(tempOrderDto.getInvoiceTitle());
                    inVoiceVO.setInvoiceCode(tempOrderDto.getTaxIdentification());
                }
                orderVo.setMemberInVoice(inVoiceVO);
                orders.add(orderVo);
            });
        }
        tempPurchaseVo.setOrders(orders);
        tempPurchaseVo.setRequestId(tempPurchaseVoData.getRequestId());
        return tempPurchaseVo;
    }

    @Override
    public BaseResponse createJcbdOrder(TempPurchaseVo tempPurchaseVo, String memberId) {
        Long startTime = System.currentTimeMillis();
        MemberDto memberDto = memberApi.findMemberById(memberId);
//        String userId = memberDto.getCoreUser().getId();
        BaseResponse response = new BaseResponse();
        response.setSuccess(true);

        //生产的采购log,在生成订单成功后保存
        List<JcbdBiddingPurchaseLogDto> purchaseLogDtos = new ArrayList<>();
        Map<String, List<TempJcbdOrderVo>> listMap = tempPurchaseVo.getOrders().stream().collect(Collectors.groupingBy(TempJcbdOrderVo::getSku));
        for (Map.Entry<String, List<TempJcbdOrderVo>> entry : listMap.entrySet()) {
            JcbdBiddingPurchaseLogDto purchaseLogDto = new JcbdBiddingPurchaseLogDto();
            purchaseLogDto.setSku(entry.getKey());
            List<TempJcbdOrderVo> value = entry.getValue();
            purchaseLogDto.setNumberBuy(value.stream().collect(Collectors.summingInt(TempJcbdOrderVo::getCount)));
            JcbdBiddingDemandDto jcbdBiddingDemand = new JcbdBiddingDemandDto();
            jcbdBiddingDemand.setId(value.get(0).getJcbdBiddingDemandId());
            purchaseLogDto.setJcbdBiddingDemand(jcbdBiddingDemand);
            purchaseLogDtos.add(purchaseLogDto);
        }
        //数据处理
        // 数据事先拷贝一份
        TempPurchaseVo tempOrderData = new TempPurchaseVo();
        mapperFacade.map(tempPurchaseVo,tempOrderData);
        List<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = dealWithBatchPurchaseData(tempPurchaseVo);
        log.info("合并订单处理结果：{}",JSON.toJSONString(tempBatchPurchaseOrderVos));
        log.info("处理提交数据用时：{}ms", System.currentTimeMillis() - startTime);
        Long tempOrderStart = System.currentTimeMillis();
//        log.info("提交临时订单数据{}", tempBatchPurchaseOrderVos.toString());
        //生产临时订单
        BaseResponse<List<TempOrderVo>> baseResponse = orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        log.info("生成临时订单{}", JSON.toJSONString(baseResponse.getResult()));
        if (!baseResponse.isSuccess()) {
            log.error(baseResponse.getResultMessage());
            response.setSuccess(false);
            response.setResultMessage("生成临时订单时失败，请联系管理员");
            return response;
        }
        //String orderType = "3";
        /**
         * 竞价下单类型
         */
        baseResponse.getResult().forEach(tempOrderVo -> {
            tempOrderVo.getStoreList().forEach(tempOrderStoreVo -> {
                tempOrderStoreVo.setType(OrderMainDto.STORE_TYPE_BIDDING);
            });
        });
        Long oderMainStart = System.currentTimeMillis();
        List<TempOrderVo> tempOrderVos = baseResponse.getResult();
        // 重新设置价格
        if (!Lang.isEmpty(tempOrderVos)) {
            if (!Lang.isEmpty(tempOrderData) && !Lang.isEmpty(tempOrderData.getOrders())){
                Map<String, List<TempJcbdOrderVo>> orderMap = tempOrderData.getOrders().stream().collect(Collectors.groupingBy(TempJcbdOrderVo::getSku));
                tempOrderVos.forEach(tempOrder -> {
                    tempOrder.getStoreList().forEach(store -> {
                        store.getOrderItems().forEach(item -> {
                            List<TempJcbdOrderVo> tempJcbdOrderVos = orderMap.get(item.getProductCode());
                            if (!Lang.isEmpty(tempJcbdOrderVos)){
                                TempJcbdOrderVo tempJcbdOrderVo = tempJcbdOrderVos.get(0);
                                item.setSalePrice(tempJcbdOrderVo.getResponsePrice());
                                item.setBusinessCode(tempJcbdOrderVo.getJcbdBiddingDemandCode());
                            }
                        });
                    });
                    String requestId=String.format("%s-%s", tempOrder.getTmpOrderNo(),tempPurchaseVo.getRequestId());
                    // 请求ID
                    tempOrder.setRequestId(requestId);
                });
            }
            log.info("重新设置响应价格处理：{}",JSON.toJSONString(tempOrderVos));
        }
        //批量生产订单
        //List<OrderMainDto> orderMainDtos = null;
        BaseResponse<List<OrderMainDto>> orderBaseRsp = orderMainApi.batchCreateOrder(tempOrderVos, memberId, tempPurchaseVo.getUsageCode(), tempPurchaseVo.getPayMethodCode());
        log.info("生成订单用时：{}ms", System.currentTimeMillis() - oderMainStart);
        if (orderBaseRsp.isSuccess() && !Lang.isEmpty(orderBaseRsp.getResult())) {
            response.setSuccess(true);
            List<OrderMainDto> orderMainDtos  = orderBaseRsp.getResult();
            log.info("生成订单为{}", orderMainDtos.stream().map(OrderMainDto::getOrderNo).collect(Collectors.toList()).toString());
            int orderCreatedNum = orderMainDtos.size();
            BigDecimal totalPriceOfAllOrders = orderMainDtos.stream().map(OrderMainDto::getSumPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            response.setResult(orderMainDtos);
            StringBuffer resultStr = new StringBuffer("执行采购成功，已为您生成").append(orderCreatedNum).
                    append("张订单，总金额").append(totalPriceOfAllOrders.toString()).append("元，生成的全部订单可在本商城竞价的执行采购结果中查看，也可在订单管理中查看");
            response.setResultMessage(resultStr.toString());

            batchCreateInvoices(orderMainDtos, tempPurchaseVo, memberDto);
//            //生成发票
//            executor.execute(new Runnable() {
//                @Override
//                public void run() {
//                    batchCreateInvoices(orderMainDtos, tempPurchaseVo, memberDto);
//                }
//            });
            BaseResponse<JcbdOrderDto> saveJcbdOrderResponse = saveJcbdOrder(orderMainDtos, tempPurchaseVo, totalPriceOfAllOrders, memberId);

//            executorService.execute(new Runnable() {
//                @Override
//                public void run() {
//                    saveJcbdOrder(orderMainDtos, tempPurchaseVo, totalPriceOfAllOrders);
//                }
//            });

//            //保存到bid模块订单
//            executor.execute(new Runnable() {
//                @Override
//                public void run() {
//                    saveJcbdOrder(orderMainDtos, tempPurchaseVo, totalPriceOfAllOrders);
//                }
//            });
            if (saveJcbdOrderResponse.isSuccess()) {
                // TODO: 2018/3/28
                // 开启审核 与工作流
                JcbdOrderDto jcbdOrderDto = saveJcbdOrderResponse.getResult();
                List<String> orderNos = jcbdOrderDto.getJcbdMallOrders().parallelStream().
                        map(JcbdMallOrderDto::getOrderNo).collect(Collectors.toList());
                try {
                    UserInformationVo operateInformation = getOperateInformation(memberId);
                    String organizationName = operateInformation.getWholeJobName();
                    Map<String, Object> bussinessDataMap = new HashMap<>();
                    bussinessDataMap.put("organizationName", organizationName);
                    bussinessDataMap.put("orderTime", new Date());
                    bussinessDataMap.put("biddingNo", tempPurchaseVo.getBiddingCode());
                    List<String> list = new ArrayList<>();
                    list.add(jcbdOrderDto.getBdOrderNo());
                    MemberVo memberInfo = memberApi.getMemberInfo(memberId);
                    WorkFlowRequestDto flowRequestDto = new WorkFlowRequestDto();
                    flowRequestDto.setMemberId(memberId);
                    flowRequestDto.setTiaoxian(tempPurchaseVo.getTianxianDepartMentId());
                    flowRequestDto.setWorkflowId(tempPurchaseVo.getProcessId());
                    flowRequestDto.setUserId(memberInfo.getUser().getId());
                    flowRequestDto.setOrderIds(list);
                    flowRequestDto.setReason(jcbdOrderDto.getRemark());
                    flowRequestDto.setRealName(memberInfo.getMember().getRealName());
                    flowRequestDto.setBussinessCode(AuditBusinessCode.BIDDING_ORDER_AUDIT.getBusinessCode());
                    flowRequestDto.setFlowIdentificationCode(WorkFlowCode.BIDDING_ORDER_WORKFLOW_CODE.getCode());
                    flowRequestDto.setTiaoxian(tempPurchaseVo.getTianxianDepartMentId());
                    flowRequestDto.setTotalMoney(jcbdOrderDto.getTotalMoney());
                    flowRequestDto.setCorePositionCode(CorePositionDto.POSITION_JC_CGJBR);
                    flowRequestDto.setImplementClassBeanName(AuditFlowImplInstance.BIDDING_ORDER_AUDIT.getInstance());
                    flowRequestDto.setBussinessDataMap(bussinessDataMap);
                    workFlowServiceApi.startWorkFlow(flowRequestDto);
                    // 更改订单状态为审核中
                    orderMainDtos.forEach(orderMain -> {
                        orderMainApi.updateOrderStatus(orderMain.getId(), OrderMainDto.order_status_inCheck);
                    });
                    // 保存采购记录
                    biddingLogApi.savePurchaseLog(purchaseLogDtos);
                } catch (Exception e) {
                    log.error("执行采购审核流开启失败：{}",e);
                    // 更改订单状态
                    biddingMainApi.changeBiddingOrderState(orderNos, OrderMainDto.order_status_error);
                    orderMainDtos.forEach(orderMain -> {
                        orderMainApi.updateOrderStatus(orderMain.getId(), OrderMainDto.order_status_error);
                    });
                    response.setSuccess(false);
                    response.setResultMessage("生成订单失败，请联系管理员");
                }
            }
        } else {
            log.info("生成正式订单为：{}",JSON.toJSONString(orderBaseRsp));
            response.setSuccess(false);
            response.setResultMessage("生成订单失败，请联系管理员");
        }
        return response;
    }

    private List<TempBatchPurchaseOrderVo> dealWithBatchPurchaseData(TempPurchaseVo tempPurchaseVo) {
        List<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = new ArrayList<>();
        List<TempJcbdOrderVo> tempJcbdOrderVos = tempPurchaseVo.getOrders();
        //因随后分组可能将tempJcbdOrderVos对象移除，可能需要深拷贝一份
        //处理发票信息,将每单商品信息set回memberInvoice
        for (TempJcbdOrderVo tempJcbdOrderVo : tempJcbdOrderVos) {
            MemberInvoiceItemVo memberInvoiceItemVo = new MemberInvoiceItemVo();
            memberInvoiceItemVo.setSku(tempJcbdOrderVo.getSku());
            memberInvoiceItemVo.setCount(tempJcbdOrderVo.getCount());
            memberInvoiceItemVo.setGoodsId(tempJcbdOrderVo.getGoodsId());
            //将响应价格set到item
            memberInvoiceItemVo.setSalePrice(tempJcbdOrderVo.getResponsePrice());

            List<MemberInvoiceItemVo> memberInvoiceItemVoList = new ArrayList<>();
            memberInvoiceItemVoList.add(memberInvoiceItemVo);
            tempJcbdOrderVo.getMemberInVoice().setMemberInvoiceItemVos(memberInvoiceItemVoList);
        }

        while (tempJcbdOrderVos.size() > 0) {
            List<FashionDetailVo> fashionDetailVoList = new ArrayList<>();//商品
            // 存放重复的FashionDetailVo
            List<FashionDetailVo> tempDetailVoList = new ArrayList<>();
            TempJcbdOrderVo orderVoA = tempJcbdOrderVos.get(0);
            FashionDetailVo fashionDetailVoA = new FashionDetailVo();
            fashionDetailVoA.setCount(orderVoA.getCount());
            fashionDetailVoA.setGoodsId(orderVoA.getGoodsId());
            fashionDetailVoA.setProductFashionId(orderVoA.getProductFashionId());
            //将响应价格set到item
            fashionDetailVoA.setSalePrice(orderVoA.getResponsePrice());
            fashionDetailVoList.add(fashionDetailVoA);
            String memberAddrId = orderVoA.getMemberAddrId();
            String areaCode = orderVoA.getMemberAddrId();

            MemberInVoiceVO memberInVoiceA = tempJcbdOrderVos.get(0).getMemberInVoice();
            List<MemberInVoiceVO> toBeHandledIvoiceVos = new ArrayList<>();
            toBeHandledIvoiceVos.add(memberInVoiceA);

            List<TempJcbdOrderVo> doneComparedOrderVo = new ArrayList<>();//存入已比较过的vo
            doneComparedOrderVo.add(orderVoA);
            //逐个对比是否可合并数据
            for (int j = 1; j <= tempJcbdOrderVos.size() - 1; j++) {
                TempJcbdOrderVo orderVoB = tempJcbdOrderVos.get(j);
                if (StringUtils.equals(orderVoA.getUsername(), orderVoB.getUsername()) && StringUtils.equals(orderVoA.getProvinceCode(), orderVoB.getProvinceCode())
                        && StringUtils.equals(orderVoA.getCityCode(), orderVoB.getCityCode()) && StringUtils.equals(orderVoA.getTownCode(), orderVoB.getTownCode())
                        && StringUtils.equals(orderVoA.getAreaCode(), orderVoB.getAreaCode()) && StringUtils.equals(orderVoA.getAddressDetail(), orderVoB.getAddressDetail())
                        && StringUtils.equals(orderVoA.getPhone(), orderVoB.getPhone()) && StringUtils.equals(orderVoA.getStoreId(), orderVoB.getStoreId())) {
                    Optional<FashionDetailVo> detailVoOptional = fashionDetailVoList.stream().filter(fashionDetailVo -> StringUtils.equals(fashionDetailVo.getGoodsId(), orderVoB.getGoodsId())).findFirst();
                    FashionDetailVo detailVo = null;
                    if (detailVoOptional.isPresent()) {
                        detailVo = detailVoOptional.get();
                    }
                    if (!Lang.isEmpty(detailVo)) {
                        detailVo.setCount(detailVo.getCount() + orderVoB.getCount());
                    } else {
                        FashionDetailVo fashionDetailVoB = new FashionDetailVo();
                        fashionDetailVoB.setGoodsId(orderVoB.getGoodsId());
                        fashionDetailVoB.setCount(orderVoB.getCount());
                        fashionDetailVoB.setProductFashionId(orderVoB.getProductFashionId());
                        fashionDetailVoList.add(fashionDetailVoB);
                    }

//                    if (orderVoB.getSku().equals(orderVoA.getSku())) {//sku一致情况下对商品进行合并
//                        fashionDetailVoA.setCount(fashionDetailVoA.getCount() + orderVoB.getCount());
//                    } else {
//                        FashionDetailVo fashionDetailVoB = new FashionDetailVo();
//                        fashionDetailVoB.setCount(orderVoB.getCount());
//                        fashionDetailVoB.setGoodsId(orderVoB.getGoodsId());
//                        fashionDetailVoB.setProductFashionId(orderVoB.getProductFashionId());
//                        fashionDetailVoB.setSalePrice(orderVoB.getResponsePrice());
//                        for (FashionDetailVo detailVo : fashionDetailVoList) {
//                            if (orderVoB.getGoodsId().equals(detailVo.getGoodsId())) {
//                                fashionDetailVoB.setCount(fashionDetailVoB.getCount() + detailVo.getCount());
//                                tempDetailVoList.add(detailVo);
//                            }
//                        }
//                        fashionDetailVoList.add(fashionDetailVoB);
//                    }

                    toBeHandledIvoiceVos.add(tempJcbdOrderVos.get(j).getMemberInVoice());
                    doneComparedOrderVo.add(orderVoB);
                }
            }
            if (!Lang.isEmpty(tempDetailVoList)) {
                fashionDetailVoList.removeAll(tempDetailVoList);
            }
            tempJcbdOrderVos.removeAll(doneComparedOrderVo);
            tempPurchaseVo.setOrders(doneComparedOrderVo);
            List<TempInvoiceVo> tempInvoiceVoList = new ArrayList<>();//发票
            List<MemberInVoiceVO> doneComparedInvoiceVos = new ArrayList<>();
            while (toBeHandledIvoiceVos.size() > 0) {
                MemberInVoiceVO inVoiceVOA = toBeHandledIvoiceVos.get(0);
                TempInvoiceVo tempInvoiceVo = new TempInvoiceVo();
                tempInvoiceVo.setInvoiceName(inVoiceVOA.getInvoiceName());
                tempInvoiceVo.setInvoiceCode(inVoiceVOA.getInvoiceCode());
                tempInvoiceVo.setInvoiceType(inVoiceVOA.getType());
                tempInvoiceVo.setCompanyId(inVoiceVOA.getCompanyId());
                List<MemberInvoiceItemVo> memberInvoiceItemVos = inVoiceVOA.getMemberInvoiceItemVos();

                TempInvoiceAddrVo tempInvoiceAddrVo = new TempInvoiceAddrVo();
                tempInvoiceAddrVo.setProvinceCode(inVoiceVOA.getConsigneeProvinceCode());
                tempInvoiceAddrVo.setCityCode(inVoiceVOA.getConsigneeCityCode());
                tempInvoiceAddrVo.setName(inVoiceVOA.getConsigneeName());
                tempInvoiceAddrVo.setPhone(inVoiceVOA.getConsigneePhone());
                tempInvoiceAddrVo.setAddress(inVoiceVOA.getAddressDetail());
                tempInvoiceAddrVo.setSameAsAchiever(inVoiceVOA.isSameAsAchiever());
                tempInvoiceVo.setTempInvoiceAddrVo(tempInvoiceAddrVo);

                doneComparedInvoiceVos.add(inVoiceVOA);
                for (int k = 1; k <= toBeHandledIvoiceVos.size() - 1; k++) {
                    MemberInVoiceVO inVoiceVOB = toBeHandledIvoiceVos.get(k);
                    //发票类型、税号、收件信息一致进行合并
                    if (StringUtils.equals(inVoiceVOA.getType(), inVoiceVOB.getType()) && StringUtils.equals(inVoiceVOA.getInvoiceCode(), inVoiceVOB.getInvoiceCode())
                            && StringUtils.equals(inVoiceVOA.getConsigneeName(), inVoiceVOB.getConsigneeName()) && StringUtils.equals(inVoiceVOA.getConsigneePhone(), inVoiceVOB.getConsigneePhone())
                            && StringUtils.equals(inVoiceVOA.getConsigneeProvinceCode(), inVoiceVOB.getConsigneeProvinceCode()) && StringUtils.equals(inVoiceVOA.getConsigneeCityCode(), inVoiceVOB.getConsigneeCityCode())
                            && StringUtils.equals(inVoiceVOA.getAddressDetail(), inVoiceVOB.getAddressDetail())
                            && StringUtils.equals(inVoiceVOA.getInvoiceName(), inVoiceVOB.getInvoiceName())
                            && StringUtils.equals(inVoiceVOA.getCompanyId(), inVoiceVOB.getCompanyId())) {
                        //理论上应该比较是否商品一致合并，后续做

                        memberInvoiceItemVos.addAll(inVoiceVOB.getMemberInvoiceItemVos());
                        doneComparedInvoiceVos.add(inVoiceVOB);
                    }
                }
                //将商品set回Invoice
                List<TempInvoiceItemVo> tempInvoiceItemVos = mapperFacade.mapAsList(memberInvoiceItemVos, TempInvoiceItemVo.class);
                tempInvoiceVo.setTempInvoiceItemVos(tempInvoiceItemVos);
                tempInvoiceVoList.add(tempInvoiceVo);
                toBeHandledIvoiceVos.removeAll(doneComparedInvoiceVos);
            }

            TempBatchPurchaseOrderVo tempBatchPurchaseOrderVo = new TempBatchPurchaseOrderVo();
            tempBatchPurchaseOrderVo.setFashionDetailVoList(fashionDetailVoList);
            tempBatchPurchaseOrderVo.setTempInvoiceVoList(tempInvoiceVoList);
            tempBatchPurchaseOrderVo.setAreaCode(areaCode);
            tempBatchPurchaseOrderVo.setOrganizationCode(organizationCode);
            tempBatchPurchaseOrderVo.setMemberAddrId(memberAddrId);
            tempBatchPurchaseOrderVo.setType(Integer.valueOf(OrderType.bidding.getCode()));
            tempBatchPurchaseOrderVos.add(tempBatchPurchaseOrderVo);
        }
        return tempBatchPurchaseOrderVos;
    }

    private BaseResponse batchCreateInvoices(List<OrderMainDto> orderMainDtos, TempPurchaseVo tempPurchaseVo, MemberDto memberDto) {
        Long invoiceStart = System.currentTimeMillis();
        BaseResponse baseResponse = new BaseResponse();
        //处理发票信息，考虑异步
        List<OrderInvoiceDto> orderInvoiceDtos = new ArrayList<>();
        orderMainDtos.forEach(n -> {
            OrderInvoiceDto orderInvoiceDto = new OrderInvoiceDto();
            OrderSubmitVo orderSubmitVo = new OrderSubmitVo();
            orderSubmitVo.setInvoiceInfos(new ArrayList<>());
            orderSubmitVo.setAddressId(n.getAddressId());
            orderSubmitVo.setNeedBills(true);
            orderSubmitVo.setOrderUsageCode(tempPurchaseVo.getUsageCode());
            orderSubmitVo.setPayMethodCode(tempPurchaseVo.getPayMethodCode());

            List<TempInvoiceVo> tempInvoiceVos = n.getTempInvoiceVoList();
            Boolean hasShippingFee = false;
            BigDecimal freight = n.getFreight();
            BigDecimal evenShippingFee = BigDecimal.ZERO;
            if (freight.compareTo(BigDecimal.ZERO) > 0) {
                hasShippingFee = true;
                //按照总运费均分到各个发票
                evenShippingFee = freight.divide(new BigDecimal(tempInvoiceVos.size()), 2, BigDecimal.ROUND_HALF_UP);
            }
            List<InvoiceInfoVo> invoiceInfoVos = new ArrayList<>();
            for (int i = 0; i < tempInvoiceVos.size(); i++) {
                TempInvoiceVo tempInvoiceVo = tempInvoiceVos.get(i);
                List<InvoiceItemInfoVo> invoiceInfoItems = new ArrayList<>();
                InvoiceInfoVo invoiceInfoVo = new InvoiceInfoVo();
                String invocieType = tempInvoiceVo.getInvoiceType();
                invoiceInfoVo.setInvoiceType(invocieType);
                if (invocieType.equals(GlobalContants.InvoiceCode.INVOICE_TYPE_PLAIN)) {//针对普票，增加抬头的保存
                    String invoiceName = tempInvoiceVo.getInvoiceName();
                    if (!Lang.isEmpty(invoiceName)) {
                        invoiceInfoVo.setName(invoiceName);
                    }
                    // 纳税人识别号
                    invoiceInfoVo.setIdentificationCode(tempInvoiceVo.getInvoiceCode());
                }
                invoiceInfoVo.setCoreConpanyId(tempInvoiceVo.getCompanyId());
                List<TempInvoiceItemVo> tempInvoiceItemVos = tempInvoiceVo.getTempInvoiceItemVos();
                for (TempInvoiceItemVo tempInvoiceItemVo : tempInvoiceItemVos) {
                    InvoiceItemInfoVo invoiceItemInfoVo = new InvoiceItemInfoVo();
                    invoiceItemInfoVo.setCount(tempInvoiceItemVo.getCount());
                    invoiceItemInfoVo.setFreigh(Lang.isEmpty(tempInvoiceItemVo.getFreigh()) ? false : tempInvoiceItemVo.getFreigh());
                    invoiceItemInfoVo.setGoodsId(tempInvoiceItemVo.getGoodsId());
                    //价格
                    invoiceItemInfoVo.setPrice(tempInvoiceItemVo.getSalePrice());
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                //有运费则设置运费
                if (hasShippingFee) {
                    InvoiceItemInfoVo invoiceItemInfoVo = new InvoiceItemInfoVo();
                    invoiceItemInfoVo.setGoodsId("shippingFee");
                    invoiceItemInfoVo.setPrice(evenShippingFee);
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                InvoiceReceiverVo receiverVo = new InvoiceReceiverVo();
                TempInvoiceAddrVo tempInvoiceAddrVo = tempInvoiceVo.getTempInvoiceAddrVo();
                if (tempInvoiceAddrVo.isSameAsAchiever()) {
                    receiverVo.setSameAsAchiever(true);
                } else {
                    receiverVo.setSameAsAchiever(false);
                }
                receiverVo.setAddress(tempInvoiceAddrVo.getAddress());
                receiverVo.setName(tempInvoiceAddrVo.getName());
                receiverVo.setPhone(tempInvoiceAddrVo.getPhone());
                receiverVo.setCityCode(tempInvoiceAddrVo.getCityCode());
                receiverVo.setProvinceCode(tempInvoiceAddrVo.getProvinceCode());

                invoiceInfoVo.setInvoiceItems(invoiceInfoItems);
                invoiceInfoVo.setInvoiceReceiver(receiverVo);
                invoiceInfoVos.add(invoiceInfoVo);
            }
            // 适配发票，最后一张发票金额重新计算
            for (InvoiceItemInfoVo invoiceItemInfoVo : invoiceInfoVos.get(invoiceInfoVos.size() - 1).getInvoiceItems()) {
                if ("shippingFee".equals(invoiceItemInfoVo.getGoodsId())) {
                    invoiceItemInfoVo.setPrice(freight.subtract(evenShippingFee.multiply(new BigDecimal(invoiceInfoVos.size() - 1))));
                }
            }
            orderSubmitVo.setInvoiceInfos(invoiceInfoVos);

            orderInvoiceDto.setMemberDto(memberDto);
            member.api.dto.order.OrderMainDto memberOrderMainDto = mapperFacade.map(n, member.api.dto.order.OrderMainDto.class);
            orderInvoiceDto.setOrderMainDto(memberOrderMainDto);
            orderInvoiceDto.setOrderSubmitVo(orderSubmitVo);

            orderInvoiceDtos.add(orderInvoiceDto);
        });
        baseResponse = memberInvoinceApi.createOrderInvoices(orderInvoiceDtos);
        log.info("生成发票用时：{}ms", System.currentTimeMillis() - invoiceStart);
        if (baseResponse.isSuccess()) {
            log.info("生成发票成功");
        } else {
            log.info("生成发票失败");
        }
        return baseResponse;
    }

    /**
     * 将批量产生的订单保存到bidding模块关联列表
     * JcbdOrder JcbdMallOrder
     *
     * @param orderMainDtos
     * @param memberId
     */
    public BaseResponse<JcbdOrderDto> saveJcbdOrder(List<OrderMainDto> orderMainDtos, TempPurchaseVo tempPurchaseVo,
                                                    BigDecimal totalMoney, String memberId) {
        BaseResponse<JcbdOrderDto> baseResponse = new BaseResponse<>();
        List<JcbdMallOrderDto> jcbdMallOrderDtoList = new ArrayList<>();
        Map<String, List<OrderItemDto>> orderItemDtosMap = new HashMap<>();
        final BigDecimal[] sumFreight = {BigDecimal.ZERO};
        orderMainDtos.forEach(n -> {
            JcbdMallOrderDto mallOrderDto = new JcbdMallOrderDto();
            mallOrderDto.setOrderNo(n.getOrderNo());
            mallOrderDto.setProviderId(n.getStoreId());
            MemberAddressDto addressDto = memberAddressApi.findByIdAndIsDelete(n.getAddressId(), false);
            mallOrderDto.setAddress(addressDto.getAddressDetail());
            mallOrderDto.setStatus(BiddingOrderStatus.ORDER_STATUS_INREVIEW.getCode());
            orderItemDtosMap.put(n.getOrderNo(), n.getOrderItems());
            if (!Lang.isEmpty(n.getFreight())){
                sumFreight[0] = sumFreight[0].add(n.getFreight());
            }
            jcbdMallOrderDtoList.add(mallOrderDto);

        });
        jcbdMallOrderDtoList.parallelStream().forEach(mallOrder -> {
            List<OrderItemDto> orderItemDtos = orderItemDtosMap.get(mallOrder.getOrderNo());
            List<JcbdBiddingOrderItemDto> orderItemDtoList = new ArrayList<>();
            orderItemDtos.parallelStream().forEach(orderItem -> {
                JcbdBiddingOrderItemDto jcbdBiddingOrderItemDto = new JcbdBiddingOrderItemDto();
                jcbdBiddingOrderItemDto.setCount(orderItem.getCount());
                jcbdBiddingOrderItemDto.setSku(orderItem.getSku());
                jcbdBiddingOrderItemDto.setJcbdMallOrder(mallOrder);
                orderItemDtoList.add(jcbdBiddingOrderItemDto);
            });
            mallOrder.setJcbdBiddingOrderItems(orderItemDtoList);
        });

        DecimalFormat df = new DecimalFormat("#.00");
        JcbdOrderDto jcbdOrderDto = new JcbdOrderDto();
        jcbdOrderDto.setRemark(tempPurchaseVo.getRemarks());
        jcbdOrderDto.setTotalMoney(new BigDecimal(df.format(totalMoney.doubleValue())));
        jcbdOrderDto.setStatus(BiddingOrderStatus.ORDER_STATUS_INREVIEW.getCode());
        jcbdOrderDto.setFreight(sumFreight[0]);
        if (!Lang.isEmpty(tempPurchaseVo.getSumfreight())) {
            jcbdOrderDto.setGoodsPrice(df.format(totalMoney.subtract(tempPurchaseVo.getSumfreight()).doubleValue()));
        } else {
            jcbdOrderDto.setGoodsPrice(df.format(totalMoney.doubleValue()));
        }
        jcbdOrderDto.setOrderUse(UserCodeType.userCodeTypeMap.get(tempPurchaseVo.getUsageCode()).getDescription());
        UserInformationVo operateInformation = getOperateInformation(memberId);
        String organizationName = operateInformation.getWholeJobName();
        jcbdOrderDto.setCompanyName(organizationName);
        jcbdOrderDto.setPayType(PaymentConfigDto.payMethodMap.get(tempPurchaseVo.getPayMethodCode()));
        jcbdOrderDto.setOrderType(ORDER_TYPE);
        JcbdBiddingDto biddingDto = biddingQueryApi.findByBiddingCodeAndIsDelete(tempPurchaseVo.getBiddingCode());
        jcbdOrderDto.setJcbdBidding(biddingDto);
        JcbdBdProviderDto jcbdBdProvider = biddingSupplierOrderManagerApi.findJcbdBdProvider(biddingDto.getId(), orderMainDtos.get(0).getStoreId());
        jcbdOrderDto.setSupplierId(jcbdBdProvider.getId());
        jcbdOrderDto.setSupplierName(jcbdBdProvider.getProviderName());
        jcbdOrderDto.setBdOrderNo(orderMainApi.generateOrderNo());
        jcbdOrderDto.setPurchaseNo(orderMainApi.generateOrderNo());//采购编号，暂时用生产订单号接口？
        jcbdOrderDto.setJcbdMallOrders(jcbdMallOrderDtoList);
        JcbdOrderDto saveJcbdOrder = biddingMainApi.saveJcbdOrder(jcbdOrderDto);

        //保存附件
        List<MallAttachmentVo> mallAttachmentVos = tempPurchaseVo.getMallAttachments();
        mallAttachmentVos.parallelStream().forEach(mallAttachmentVo -> {
            mallAttachmentVo.setAttachmentCorrelation(jcbdOrderDto.getBdOrderNo());
            mallAttachmentVo.setBusinessCode(MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getValue());
            mallAttachmentVo.setBusinessDescription(MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getDescription());
            mallAttachmentVo.setOrganizationCode(GlobalContants.ORGANIZATION_CODES.JICAI);
        });
        if (!Lang.isEmpty(mallAttachmentVos)) {
            try {
                List<MallAttachmentDto> mallAttachmentDtos = mapperFacade.mapAsList(mallAttachmentVos, MallAttachmentDto.class);
                mallAttachmentApi.batchSave(mallAttachmentDtos);
            } catch (Exception e) {
                log.error("保存采购下单附件失败,biddingDto={}", JSON.toJSONString(biddingDto), e);
            }
        } else {
            try {
                mallAttachmentApi.deleteMallAttachments(jcbdOrderDto.getBdOrderNo(), MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getValue());
            } catch (Exception e) {
                log.error("清空采购下单附件失败,biddingDto={}", JSON.toJSONString(biddingDto), e);
            }
        }

        baseResponse.setSuccess(true);
        baseResponse.setResult(saveJcbdOrder);
        return baseResponse;
    }


    /**
     * @author taofeng
     * @date 2018/3/19
     * <p>
     * 查询供应商联系人信息
     **/
    @Override
    public List<JcbdBdProviderVo> findStoreContacts(String type) {

        List<JcbdBdProviderVo> jcbdBdProviderVos = new ArrayList<>();

        List<StoreDto> storeList = storeApi.findByTpye(type);

        for (StoreDto storeDto : storeList) {
            List<JcbdStoreContactsVo> jcbdStoreContactsVoList = new ArrayList<>();
            StoreExtDto storeExt = storeDto.getStoreExt();
            Response<VendorDto> response = protocolService.getGysxx(storeExt.getdVendorId());
            log.info("response{}",JSON.toJSONString(response));
            if(response.getSuccess()) {
                VendorDto vendorDto = response.getData();
                //供应商
                if (!Lang.isEmpty(vendorDto) && !Lang.isEmpty(vendorDto.getGysmc())) {
                    JcbdBdProviderVo jcbdBdProviderVo = new JcbdBdProviderVo();
                    jcbdBdProviderVo.setProviderId(storeDto.getId());
                    jcbdBdProviderVo.setProviderName(vendorDto.getGysmc());
                    List<ContactPersonDto> lxrlist = vendorDto.getLxrlist();
                    for (ContactPersonDto contactPersonDto : lxrlist) {
                        JcbdStoreContactsVo jcbdStoreContactsVo = new JcbdStoreContactsVo();
                        jcbdStoreContactsVo.setStoreName(vendorDto.getGysmc());
                        jcbdStoreContactsVo.setName(contactPersonDto.getName());
                        jcbdStoreContactsVo.setPhone(contactPersonDto.getTel());
                        jcbdStoreContactsVo.setEmail(contactPersonDto.getEmail());
                        jcbdStoreContactsVoList.add(jcbdStoreContactsVo);
                    }
                    jcbdBdProviderVo.setJcbdStoreContactsVos(jcbdStoreContactsVoList);
                    jcbdBdProviderVos.add(jcbdBdProviderVo);
                }
            }
        }
        return jcbdBdProviderVos;
    }

    /**
     * @author taofeng
     * @date 2018/3/20
     **/
    @Override
    public String getDemandCode(String biddingCode) {

        //biddingCode B YYYY MM 0001
        //bemandCode B YYYY MM 0001 01

        String one = "D" + (biddingCode + (101 + "").substring(1)).substring(1);

        //根据biddingId查询对应的demandCode的count
        JcbdBiddingDto biddingDto = biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);
        if (!Lang.isEmpty(biddingDto)) {
            Integer countByBid = bdDemandCodeRuleApi.findDemandCountByBid(biddingDto.getId());
            if (Lang.isEmpty(countByBid) || countByBid == 0) {
                return one;
            } else {
                String bdDcode = biddingCode + ((101 + countByBid) + "").substring(1);
                return "D" + bdDcode.substring(1);
            }
        } else {
            return one;
        }
    }


    /**
     * @author taofeng
     * @date 2018/3/20
     **/
    @Override
    public void saveOrUpdateBiddingDemand(BiddingDemandVo biddingDemandVo, String[] demandAddress, String[] numberNeed, String[] conformances) {

        //需求地址及数量
        List<JcbdDemandAddressNumVo> demandAddressNumVos = new ArrayList<>();
        for (int i = 0; i < demandAddress.length; i++) {
            JcbdDemandAddressNumVo demandAddressNumVo = new JcbdDemandAddressNumVo();
            String[] demandAddres = demandAddress[i].split("\\s+");
            if (!Lang.isEmpty(demandAddres[0]) && !Lang.isEmpty(demandAddres[1]) && !Lang.isEmpty(numberNeed[i])) {
                demandAddressNumVo.setProvinceName(demandAddres[0]);
                demandAddressNumVo.setCityName(demandAddres[1]);
                demandAddressNumVo.setNumberNeed(Long.parseLong(numberNeed[i]));
                demandAddressNumVos.add(demandAddressNumVo);
            }
        }
        if (!Lang.isEmpty(demandAddressNumVos)) {
            biddingDemandVo.setJcbdDemandAddressNums(demandAddressNumVos);
        }

        //竞价需求符合性列表
        List<JcbdBiddingConformanceVo> biddingConformanceVoList = new ArrayList<>();
        for (int i = 0; i < conformances.length; i++) {
            if (!Lang.isEmpty(conformances[i])) {
                JcbdBiddingConformanceVo biddingConformanceVo = new JcbdBiddingConformanceVo();
                biddingConformanceVo.setConformance(conformances[i]);
                biddingConformanceVoList.add(biddingConformanceVo);
            }
        }
        if (!Lang.isEmpty(biddingConformanceVoList)) {
            biddingDemandVo.setJcbdBiddingConformances(biddingConformanceVoList);
        }

        //根据需求编号查询是否已存在该需求
        BaseResponse<JcbdBiddingDemandDto> demandInfo = biddingMainQueryApi.getBiddingDemandInfo(biddingDemandVo.getDemandCode());
        JcbdBiddingDemandDto demandDto = demandInfo.getResult();
        if (!Lang.isEmpty(demandDto)) {
            biddingDemandVo.setId(demandDto.getId());
        }

        //保存时间
        biddingDemandVo.setDateRequiredDelivery(DateUtils.strToDate(biddingDemandVo.getDateRequiredDeliveryTime(), GlobalContants.DateFormat.YYYY_MM_DD));

        biddingMainApi.saveOrUpdateBiddingDemand(BeanMapper.map(biddingDemandVo, JcbdBiddingDemandDto.class));
    }

    /**
     * @author taofeng
     * @date 2018/3/22
     * <p>
     * 获取已保存的竞价
     **/
    @Override
    public JcbdBiddingVo getBiddingByBiddingCode(String biddingCode) {

        // 根据biddingCode查询出JcbdBiddingDto
        BaseResponse<JcbdBiddingDto> biddingResponse = biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
        JcbdBiddingDto jcbdBiddingDto = biddingResponse.getResult();

        JcbdBiddingVo biddingVo = BeanMapper.map(jcbdBiddingDto, JcbdBiddingVo.class);

        //查询附件
        BaseResponse<List<MallAttachmentDto>> bidbaseBaseResponse = mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(biddingCode, MallAttachmentBusinessCode.BIDBASE_ATTACH_BUSCODE.getValue());
        if (bidbaseBaseResponse.isSuccess()) {
            if (!Lang.isEmpty(bidbaseBaseResponse.getResult())) {
                biddingVo.setMallAttachmentVos(BeanMapper.mapList(bidbaseBaseResponse.getResult(), MallAttachmentDto.class, MallAttachmentVo.class));
            }
        }

        //在提交竞价结果审核后的查看页面增加显示提交竞价结果审核时上传的附件
        BaseResponse<List<MallAttachmentDto>> bidresulBaseResponse = mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(biddingCode, MallAttachmentBusinessCode.BIDRESUL_ATTACH_BUSCODE.getValue());
        if (bidresulBaseResponse.isSuccess()) {
            if (!Lang.isEmpty(bidresulBaseResponse.getResult())) {
                biddingVo.setBidresulMallAttachmentVos(BeanMapper.mapList(bidresulBaseResponse.getResult(), MallAttachmentDto.class, MallAttachmentVo.class));
            }
        }

        return biddingVo;
    }

    @Override
    public List<JcbdRoleOperationVo> getRoleBiddingOperates(BiddingOperatorQuery biddingOperatorQuery) {
        //查询该竞价的操作
        List<JcbdRoleOperationDto> operates = biddingRoleOperationQueryApi.getOperatorBiddingOperateByBiddingCode(biddingOperatorQuery);
        if (Lang.isEmpty(operates)) {
            return null;
        }
        return mapperFacade.mapAsList(operates, JcbdRoleOperationVo.class);
    }

    /**
     * 更新竞价状态接口
     *
     * @param changeStateVo
     * @return
     */
    @Override
    public void changeBiddingState(BiddingChangeStateVo changeStateVo) {
        BiddingChangeStateDto changeStateDto = mapperFacade.map(changeStateVo, BiddingChangeStateDto.class);
        BiddingStateResponseDto biddingState = biddingMainApi.changeBiddingState(changeStateDto);
        if (!StringUtils.equals(BiddingStatus.OM_AUDIT_WAIT.getValue(), biddingState.getBiddingState())) {
            throw new RuntimeException("修改失败");
        }
    }

    @Override
    public Map querryPageBiddingDemad(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        Map returnModel = new HashMap();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.ASC, "demandCode")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        SupplierBiddingDamandQuery supplierBiddingDamandQuery = new SupplierBiddingDamandQuery();
        supplierBiddingDamandQuery.setBiddingCode(biddingCode);
        supplierBiddingDamandQuery.setPageable(pageable);
        BaseResponse<Page<BiddingResponseDemandOutlineDto>> pageBaseResponse = biddingResponseQueryApi.supplierBiddingResponseDemandOutline(supplierBiddingDamandQuery);

        ArrayList<BiddingSupplierResposeListVo> supplierResposeListVos = new ArrayList<>();
        Long totalElement = 0L;
        if (pageBaseResponse.isSuccess()) {
            if (!Lang.isEmpty(pageBaseResponse.getResult())) {
                pageBaseResponse.getResult().getContent().forEach(biddingDemandOutlineDto -> {
                    BiddingSupplierResposeListVo resposeListVo = mapperFacade.map(biddingDemandOutlineDto, BiddingSupplierResposeListVo.class);
                    resposeListVo.setRequiredDeliveryDateTime(DateUtils.dateToStr(biddingDemandOutlineDto.getRequiredDeliveryDate(), GlobalContants.DateFormat.YYYY_MM_DD));
                    supplierResposeListVos.add(resposeListVo);
                });
                totalElement = Long.valueOf(pageBaseResponse.getResult().getContent().size());
            }
        }
        returnModel.put("aaData", supplierResposeListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }


    @Override
    public Map queryDemandResponse(String biddingCode, String demandCode, String supplierId) {
        BiddingDemandRespQuery biddingDemandRespQuery = new BiddingDemandRespQuery();
        biddingDemandRespQuery.setDemandCode(demandCode);
        biddingDemandRespQuery.setSupplierId(supplierId);
        biddingDemandRespQuery.setBiddingNo(biddingCode);
        BaseResponse<JcbdBiddingDemandResponseDto> demandResponseDtoResponse = biddingResponseQueryApi.queryBiddingDemandResponse(biddingDemandRespQuery);
        if (!demandResponseDtoResponse.isSuccess()) {
            return ResponseMapUtils.error(demandResponseDtoResponse.getResultMessage());
        }
        JcbdBiddingDemandResponseDto demandResponseDto = demandResponseDtoResponse.getResult();
        if (!Lang.isEmpty(demandResponseDto)) {
            BiddingDemandResponseVo demandResponseVo = mapperFacade.map(demandResponseDto, BiddingDemandResponseVo.class);
            if (!Lang.isEmpty(demandResponseDto.getOfferValidity())) {
                demandResponseVo.setOfferValidityTime(DateUtils.dateToStr(demandResponseDto.getOfferValidity(), GlobalContants.DateFormat.YYYY_MM_DD));
            }
            BiddingDemandVo demandVo = new BiddingDemandVo();
            mapperFacade.map(demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
            if (!Lang.isEmpty(demandResponseDto.getJcbdBiddingDemand())) {
                demandVo = mapperFacade.map(demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
                if (!Lang.isEmpty(demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery())) {
                    demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr(demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery(), GlobalContants.DateFormat.YYYY_MM_DD));
                }
            }
            demandResponseVo.setBiddingDemand(demandVo);
            //查询附件
            if (!Lang.isEmpty(demandResponseDto.getId())) {
                BaseResponse<List<MallAttachmentDto>> bidbaseBaseResponse = mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(demandResponseDto.getId(), MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue());
                if (bidbaseBaseResponse.isSuccess()) {
                    if (!Lang.isEmpty(bidbaseBaseResponse.getResult())) {
                        demandResponseVo.setAttachment(BeanMapper.mapList(bidbaseBaseResponse.getResult(), MallAttachmentDto.class, MallAttachmentVo.class));
                    }
                }
            }
            /*if (!Lang.isEmpty(demandResponseDto.getAttachment())) {
                demandResponseVo.setAttachment(mapperFacade.mapAsList(demandResponseDto.getAttachment(), MallAttachmentVo.class));
            }*/
            if (!Lang.isEmpty(demandResponseDto.getJcbdProviderAddressResponses())) {
                demandResponseVo.setProviderAddressResponses(mapperFacade.mapAsList(demandResponseDto.getJcbdProviderAddressResponses(), JcbdProviderAddressResponseVo.class));
            }
            if (!Lang.isEmpty(demandResponseDto.getJcbdProviderConformanceResps())) {
                demandResponseVo.setProviderConformanceResps(mapperFacade.mapAsList(demandResponseDto.getJcbdProviderConformanceResps(), JcbdProviderConformanceRespVo.class));
            }
            return ResponseMapUtils.success(demandResponseVo);
        }
        return ResponseMapUtils.error("未查到该需求响应信息");
    }

    @Override
    public Map submitResultAudit(SubmitResultVo submitResultVo, String memberId) {
        BaseResponse biddingResultResult = biddingMainApi.updateBiddingResultResult(submitResultVo.getBiddingCode(), submitResultVo.getRemark());
        if (!biddingResultResult.isSuccess()) {
            return ResponseMapUtils.error(biddingResultResult.getResultMessage());
        }
        //保存附件
        JcbdBiddingDto biddingDto = biddingQueryApi.findByBiddingCodeAndIsDelete(submitResultVo.getBiddingCode());
        if (!Lang.isEmpty(submitResultVo.getMallAttachmentVos())) {
            List<MallAttachmentDto> mallAttachmentDtos = mapperFacade.mapAsList(submitResultVo.getMallAttachmentVos(), MallAttachmentDto.class);
            mallAttachmentDtos.forEach(mallAttachmentDto -> {
                mallAttachmentDto.setAttachmentCorrelation(biddingDto.getId());
                mallAttachmentDto.setOrganizationCode(ORGANIZATIONCODE);
                mallAttachmentDto.setBusinessCode(MallAttachmentBusinessCode.BIDRESUL_ATTACH_BUSCODE.getValue());
                mallAttachmentDto.setBusinessDescription(BiddingOperateCode.SUBMIT_BIDDING_RESULT.getCodeName());
            });
            mallAttachmentApi.batchSave(mallAttachmentDtos);
        } else {
            mallAttachmentApi.deleteMallAttachments(biddingDto.getId(), MallAttachmentBusinessCode.BIDRESUL_ATTACH_BUSCODE.getValue());
        }


        //开启审核流
        String biddingCode = submitResultVo.getBiddingCode();

        UserInformationVo operateInformation = getOperateInformation(memberId);
        String remark = submitResultVo.getRemark();
        String tiaoxian = submitResultVo.getTiaoxian();
        String organizationName = operateInformation.getWholeJobName();
        BigDecimal totalMoney = null;
        try {
            totalMoney = getResponseBiddingTotalMonay(biddingCode);
//            totalMoney = new BigDecimal(5000);
        } catch (Exception e) {
            log.error("查询竞价响应总金额出错,biddingCode={}", biddingCode);
            return ResponseMapUtils.error(e.getMessage());
        }
//        BigDecimal totalMoney = new BigDecimal("5000");
        Map<String, Object> bussinessDataMap = new HashMap<>();
        bussinessDataMap.put("organizationName", organizationName);
        bussinessDataMap.put("biddingStartTime", biddingDto.getTimeStartResponse());
        bussinessDataMap.put("biddingEndTime", biddingDto.getTimeEndResponse());
//        MemberVo memberInfo = memberApi.getMemberInfo(memberId);
        WorkFlowRequestDto flowRequestDto = new WorkFlowRequestDto();
        flowRequestDto.setWorkflowId(StringUtils.isNoneEmpty(submitResultVo.getProcessId()) ? submitResultVo.getProcessId() : null);
        flowRequestDto.setMemberId(memberId);
        ArrayList<String> list = new ArrayList<>();
        list.add(biddingCode);
        flowRequestDto.setUserId(operateInformation.getUser().getId());
        flowRequestDto.setOrderIds(list);
        flowRequestDto.setReason(remark);
        flowRequestDto.setRealName(operateInformation.getMember().getRealName());
        flowRequestDto.setBussinessCode(AuditBusinessCode.BIDDING_RESULT_AUDIT.getBusinessCode());
        flowRequestDto.setFlowIdentificationCode(WorkFlowCode.BIDDING_RESULT_WORKFLOW_CODE.getCode());
        flowRequestDto.setTiaoxian(tiaoxian);
        flowRequestDto.setTotalMoney(totalMoney);
        flowRequestDto.setCorePositionCode(CorePositionDto.POSITION_JC_CGJBR);
        flowRequestDto.setImplementClassBeanName(AuditFlowImplInstance.BIDDING_RESULT_AUDIT.getInstance());
        flowRequestDto.setBussinessDataMap(bussinessDataMap);
        workFlowServiceApi.startWorkFlow(flowRequestDto);

        //更改状态
        BiddingChangeStateDto stateDto = new BiddingChangeStateDto();
        stateDto.setBiddingNo(submitResultVo.getBiddingCode());
        stateDto.setCurrentState(BiddingStatus.OM_RESULT_SUBMIT_WAIT.getValue());
        stateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_RESULT.getCode());
        BiddingStateResponseDto stateResponseDto = biddingMainApi.changeBiddingState(stateDto);
        if (!BiddingStatus.OM_RESULT_AUDIT_WAIT.getValue().equals(stateResponseDto.getBiddingState())) {
            return ResponseMapUtils.error("状态变更失败");
        }
        return ResponseMapUtils.success("");
    }

    private BigDecimal getResponseBiddingTotalMonay(String biddingCode) {
        BaseResponse<BiddingPriceParityDto> biddingPriceParityDtoBaseResponse = biddingResponseQueryApi.queryBiddingPriceParity(biddingCode);
        if (!biddingPriceParityDtoBaseResponse.isSuccess()) {
            new RuntimeException(biddingPriceParityDtoBaseResponse.getResultMessage());
        }
        List<PriceParityInfoDto> collect = biddingPriceParityDtoBaseResponse.getResult().getPriceParityInfosDtos().stream().sorted(Comparator.comparing(PriceParityInfoDto::getSummation).reversed()).collect(Collectors.toList());
        BigDecimal totalMoney = collect.get(0).getSummation();
        return totalMoney;
    }

    /**
     * @author taofeng
     * @date 2018/4/4
     */
    @Override
    public Map getBiddingResultDemandList(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        Map returnModel = new HashMap();

        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.ASC, "demandCode"),
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);

        BiddingDemandListQuery biddingDemandListQuery = new BiddingDemandListQuery();
        biddingDemandListQuery.setBiddingCode(biddingCode);
        biddingDemandListQuery.setPageable(pageable);

        BaseResponse<Page<BiddingResultDemandQueryDto>> pageBaseResponse = biddingResponseQueryApi.getBiddingResultDemandList(biddingDemandListQuery);
        Page<BiddingResultDemandQueryDto> page = pageBaseResponse.getResult();
        List<BiddingResultDemandQueryVo> resultDemandQueryVos = new ArrayList<>();
        if (page != null && !Lang.isEmpty(page.getContent())) {
            for (BiddingResultDemandQueryDto resultDemandQueryDto : page) {
                BiddingResultDemandQueryVo resultDemandQueryVo = BeanMapper.map(resultDemandQueryDto, BiddingResultDemandQueryVo.class);
                resultDemandQueryVos.add(resultDemandQueryVo);
            }
        }
        Long totalElement = Long.valueOf(resultDemandQueryVos.size());
        returnModel.put("aaData", resultDemandQueryVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);

        return returnModel;
    }

    /**
     * @author taofeng
     * @date 2018/4/9
     */
    @Override
    public Map queryBiddingDemandResponse(String biddingNo, String demandCode) {

        BiddingDemandRespQuery biddingDemandRespQuery = new BiddingDemandRespQuery();

        //查询竞价需求最终成交供应商信息
        BaseResponse<BiddingResultSupplierInfoQueryDto> supplierInfo = biddingResponseQueryApi.getBiddingResultSupplierInfo(demandCode);
        if (supplierInfo.isSuccess()) {
            biddingDemandRespQuery.setSupplierId(supplierInfo.getResult().getSupplierId());
            biddingDemandRespQuery.setBiddingNo(biddingNo);
            biddingDemandRespQuery.setDemandCode(demandCode);

            //供应商需求响应查询
            BaseResponse<JcbdBiddingDemandResponseDto> demandResponse = biddingResponseQueryApi.queryBiddingDemandResponse(biddingDemandRespQuery);
            if (demandResponse.isSuccess()) {
                JcbdBiddingDemandResponseDto responseDto = demandResponse.getResult();
                JcbdBiddingDemandResponseVo demandResponseVo = BeanMapper.map(responseDto, JcbdBiddingDemandResponseVo.class);
                if (responseDto.getOfferValidity() != null) {
                    demandResponseVo.setOfferValidityTime(DateUtils.dateToStr(responseDto.getOfferValidity(), GlobalContants.DateFormat.YYYY_MM_DD));
                }
                return ResponseMapUtils.success(demandResponseVo);
            } else {
                return ResponseMapUtils.error(demandResponse.getResultMessage());
            }
        } else {
            return ResponseMapUtils.error(supplierInfo.getResultMessage());
        }
    }

    /**
     * @author taofeng
     * @date 2018/3/31
     **/
    @Override
    public Map getBiddingDemandList(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        Map returnModel = new HashMap();
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.ASC, "demandCode")

        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        BiddingDemandListQuery biddingDemandListQuery = new BiddingDemandListQuery();
        biddingDemandListQuery.setBiddingCode(biddingCode);
        biddingDemandListQuery.setPageable(pageable);

        BaseResponse<Page<BiddingDemandQueryDto>> biddingDemandList = biddingMainQueryApi.getBiddingDemandList(biddingDemandListQuery);
        List<BiddingDemandQueryVo> biddingDemandVos = new ArrayList<>();

        Page<BiddingDemandQueryDto> page = biddingDemandList.getResult();
        if (!Lang.isEmpty(page.getContent())) {
            for (BiddingDemandQueryDto biddingDemandQueryDto : page.getContent()) {
                BiddingDemandQueryVo demandVo = BeanMapper.map(biddingDemandQueryDto, BiddingDemandQueryVo.class);

                String dateRequiredDelivery = DateUtils.dateToStr(biddingDemandQueryDto.getDateRequiredDelivery(), GlobalContants.DateFormat.YYYY_MM_DD);
                if (!Lang.isEmpty(dateRequiredDelivery)) {
                    demandVo.setDateRequiredDeliveryTime(dateRequiredDelivery);
                }

                biddingDemandVos.add(demandVo);
            }
        }
        Long totalElement = Long.valueOf(biddingDemandVos.size());
        returnModel.put("aaData", biddingDemandVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    /**
     * @author taofeng
     * @date 2018/3/28
     * <p>
     * 竞价需求_查看
     **/
    @Override
    public BiddingDemandVo getBiddingDemandInfo(String demandCode) {
        BaseResponse<JcbdBiddingDemandDto> biddingDemandDto = biddingMainQueryApi.getBiddingDemandInfo(demandCode);
        JcbdBiddingDemandDto demandDto = biddingDemandDto.getResult();

        BiddingDemandVo demandVo = mapperFacade.map(demandDto, BiddingDemandVo.class);
        demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr(demandVo.getDateRequiredDelivery(), GlobalContants.DateFormat.YYYY_MM_DD));

        return demandVo;
    }

    @Override
    public BaseResponse deleteBidDemand(String demandCode) {
        BaseResponse baseResponse = biddingMainApi.deleteBiddingDemand(demandCode);
        return baseResponse;
    }

    /**
     * @author taofeng
     * @date 2018/3/30
     **/
    @Override
    public BaseResponse openPrice(String biddingNo) {

        BaseResponse baseResponse = biddingMainApi.openPrice(biddingNo);

        return baseResponse;
    }

    @Override
    public Map queryResponseOutline(String biddingCode, String demandCode) {
        BaseResponse<List<BiddingResponseOutlineDto>> demandOutlineDtos = biddingResponseQueryApi.queryBiddingResponseOutline(biddingCode, demandCode);
        if (!demandOutlineDtos.isSuccess()) {
            return ResponseMapUtils.error(demandOutlineDtos.getResultMessage());
        }
        if (!Lang.isEmpty(demandOutlineDtos.getResult())) {
            List<BiddingResponseOutlineVo> outlineVos = mapperFacade.mapAsList(demandOutlineDtos.getResult(), BiddingResponseOutlineVo.class);
            return ResponseMapUtils.success(outlineVos);
        }
        return ResponseMapUtils.error("未查到供应商信息");
    }

    /**
     * @author taofeng
     * @date 2018/3/30
     **/
    @Override
    public BaseResponse randomConfirmSupplier(String biddingCode) {
        BaseResponse baseResponse = biddingVoteApi.randomConfirmSupplier(biddingCode);
        if (Lang.isEmpty(baseResponse)) {
            return new BaseResponse(false, "操作失败");
        }
        return baseResponse;
    }

    /**
     * @author taofeng
     * @date 2018/3/31
     **/
    @Override
    public MemberAddressVo defaultAddress(String memberId) {
        MemberAddressDto memberAddressDto = memberAddressApi.defaultAddress(memberId);
        return BeanMapper.map(memberAddressDto, MemberAddressVo.class);
    }

    /**
     * @author taofeng
     * @date 2018/3/31
     **/
    @Override
    public List<MemberAddressVo> defaultAddressList(String memberId) {

        List<MemberAddressDto> list = memberAddressApi.list(memberId);

        return BeanMapper.mapList(list, MemberAddressDto.class, MemberAddressVo.class);
    }

    @Override
    public Map auditSku(BiddingAuditVo biddingAuditVo, String biddingMemberId) {
        JcbdBiddingDto jcbdBiddingDto = biddingMainQueryApi.queryBidding(biddingAuditVo.getBiddingNo());
        BiddingAuditDTO biddingAuditDTO = mapperFacade.map(biddingAuditVo, BiddingAuditDTO.class);
        biddingAuditDTO.setAuditorId(biddingMemberId);
        BaseResponse baseResponse = biddingMainApi.auditBiddingSku(biddingAuditDTO);
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error("审核失败");
        }
        try {
            if (biddingAuditVo.getStatus().equals("0")) {
                // 发邮件
                MailTemplateReq mailTemplateReq = new MailTemplateReq();
                MailReq mailReq = new MailReq();
                //获取已成交供应商
                JcbdBdProviderDto provider = biddingMainQueryApi.getTransactionSupplier(biddingAuditVo.getBiddingNo());
                //获取供应商下所有联系人
                StoreDto storeDto = storeApi.findByStoreId(provider.getProviderId());
                StoreExtDto storeExt = storeDto.getStoreExt();
                Response<VendorDto> response = protocolService.getGysxx(storeExt.getdVendorId());
                VendorDto vendorDto = response.getData();
                if (!Lang.isEmpty(vendorDto) && !Lang.isEmpty(vendorDto.getGysmc())) {
                    List<ContactPersonDto> lxrlist = vendorDto.getLxrlist();
                    lxrlist.forEach(contactPersonDto -> {
                        mailReq.setTo(new String[]{contactPersonDto.getEmail()});
                        mailReq.setFrom(mailFrom);
                        mailReq.setSentDate(new Date());
                        mailReq.setChannel(MailReq.CHANNEL_JC);
                        mailTemplateReq.setTemplateCode(MailTemplateEnum.SKU_NOT_APPROVED.getTemplateCode());
                        List<String> subjectArgs = new ArrayList<>();
                        //竞价编号
                        subjectArgs.add(biddingAuditVo.getBiddingNo());
                        //共5个参数
                        List<String> contextArgs = new ArrayList<>();
                        contextArgs.add(contactPersonDto.getName());
                        contextArgs.add(biddingAuditVo.getBiddingNo());
                        contextArgs.add(biddingAuditVo.getContent());
                        contextArgs.add(jcbdBiddingDto.getOperatorName());
                        contextArgs.add(jcbdBiddingDto.getOperatorPhone());
                        mailTemplateReq.setSubjectArgList(subjectArgs);
                        mailTemplateReq.setContentArgList(contextArgs);
                        mailTemplateReq.setMailReq(mailReq);
                        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                        mailApi.sendMailByTemplate(mailTemplateReq);
                    });
                }
            }
        } catch (Exception e) {
            log.error("竞价{}的sku审核不通过操作邮件通知供应商失败", biddingAuditVo.getBiddingNo(), e);
        } finally {
            return ResponseMapUtils.success("");
        }
    }

    /**
     * 执行采购页临时订单保存
     *
     * @param biddingQueryOperativeBuySaveVo
     * @return
     */
    @Override
    public BaseResponse saveOrderGoodsInfo(BiddingQueryOperativeBuySaveVo biddingQueryOperativeBuySaveVo) {
        JcbdTempOrderDto jcbdTempOrderDto = BeanMapper.map(biddingQueryOperativeBuySaveVo, JcbdTempOrderDto.class);
        log.info("执行采购临时订单数据保存：{}",JSON.toJSONString(jcbdTempOrderDto));
        BaseResponse baseResponse = biddingMainApi.saveBiddingTempOrderInfo(jcbdTempOrderDto);
        return baseResponse;
    }

    @MotanReferer
    MemberAddressApi memberAddressApi;

    /**
     * 执行采购页临时订单列表查询
     *
     * @return
     */
    @Override
    public BaseResponse queryTempOrderInfo(String biddingNo) {
        List<TempBatchVo> tempBatchVoList = new ArrayList<>();
        List<TempBatchDto> tempBatchList = biddingMainQueryApi.getTempBatchList(biddingNo);
        for (TempBatchDto tempBatchDto : tempBatchList) {
            TempBatchVo tempBatchVo = BeanMapper.map(tempBatchDto, TempBatchVo.class);
            List<TempBatchListVo> tempBatchLists = tempBatchVo.getTempBatchLists();
            ArrayList<TempBatchListVo> tempBatchListVoList = new ArrayList<>();
            for (TempBatchListVo tempBatchListVo : tempBatchLists) {
                if (!Lang.isEmpty(tempBatchListVo.getAddressId())) {
                    MemberAddressDto memberAddressDto = memberAddressApi.findById(tempBatchListVo.getAddressId());
                    tempBatchListVo.setAddressName(memberAddressDto.getProvinceName() + memberAddressDto.getCityName() + memberAddressDto.getAreaName() + memberAddressDto.getAddressDetail());
                    tempBatchListVo.setName(memberAddressDto.getUsername());
                    tempBatchListVo.setTel(memberAddressDto.getPhone());
                } else {
                    tempBatchListVo.setAddressName("");
                    tempBatchListVo.setName("");
                    tempBatchListVo.setTel("");
                }
                tempBatchListVoList.add(tempBatchListVo);
                tempBatchVo.setTempBatchLists(tempBatchListVoList);
            }
            tempBatchVoList.add(tempBatchVo);
        }
        return new BaseResponse<>(true, "临时订单获取成功", tempBatchVoList);
    }

    /**
     * 执行采购页临时订单修改
     *
     * @param temOrderId
     * @return
     */
    @Override
    public BaseResponse updateTempOrderInfo(String temOrderId) {
        //根据临时订单号查询订单信息
        JcbdTempOrderDto jcbdTempOrderDto = biddingMainApi.modifyTempOrderById(temOrderId);
        //根据返回值中的addressId查询地址名
        MemberAddressDto memberAddress = memberAddressApi.findById(jcbdTempOrderDto.getMemberAddressId());
        //数据传输实体类转换
        JcbdTempOrderVo jcbdTempOrderVo = BeanMapper.map(jcbdTempOrderDto, JcbdTempOrderVo.class);
        // 查询发票公司信息
        if (!Lang.isEmpty(jcbdTempOrderDto.getCompanyId())) {
            CoreCompanyDto coreCompany = coreCompanyApi.findById(jcbdTempOrderDto.getCompanyId());
            jcbdTempOrderVo.setCompanyAddressAndPhone(coreCompany.getAddress() + " " + coreCompany.getPhone());
            jcbdTempOrderVo.setBankAndAccount(coreCompany.getBankDeposit() + " " + coreCompany.getBankAccount());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(memberAddress.getProvinceName());
        stringBuilder.append(memberAddress.getCityName());
        stringBuilder.append(memberAddress.getAreaName());
        stringBuilder.append(memberAddress.getTownName());
        stringBuilder.append(memberAddress.getAddressDetail());
        jcbdTempOrderVo.setMemberAddressName(stringBuilder.toString());
        jcbdTempOrderVo.setMemberProviceCode(memberAddress.getProvinceCode());
        jcbdTempOrderVo.setMemberCityCode(memberAddress.getCityCode());
        jcbdTempOrderVo.setMemberAreaCode(memberAddress.getAreaCode());
        jcbdTempOrderVo.setMemberTownCode(memberAddress.getTownCode());
        jcbdTempOrderVo.setMemberProviceName(memberAddress.getProvinceName());
        jcbdTempOrderVo.setMemberCityName(memberAddress.getCityName());
        jcbdTempOrderVo.setMemberAreaName(memberAddress.getAreaName());
        jcbdTempOrderVo.setMemberTownName(memberAddress.getTownName());
        jcbdTempOrderVo.setMemberName(memberAddress.getUsername());
        jcbdTempOrderVo.setTel(memberAddress.getTel());

        if (BiddingOperatorServiceImpl.INVOICE_ADDRESS_FLAG_NO.equals(jcbdTempOrderVo.getConsigneeFlag())) {
            String consigneeProvinceName = addressApi.findShortNameById(jcbdTempOrderVo.getConsigneeProvinceCode());
            String consigneeCityName = addressApi.findShortNameById(jcbdTempOrderVo.getConsigneeCityCode());
            jcbdTempOrderVo.setConsigneeProvinceName(consigneeProvinceName);
            jcbdTempOrderVo.setConsigneeCityName(consigneeCityName);
            StringBuffer invoiceAddress = new StringBuffer();
            invoiceAddress.append(consigneeProvinceName);
            invoiceAddress.append(consigneeCityName);
            invoiceAddress.append(jcbdTempOrderVo.getAddressDetail());
            jcbdTempOrderVo.setInvoiceAddress(invoiceAddress.toString());
        }


        return new BaseResponse(true, "临时订单数据获取成功", jcbdTempOrderVo);
    }

    /**
     * 删除临时订单
     *
     * @param temOrderId
     * @return
     */
    @Override
    public BaseResponse deleteTempOrderInfo(List<String> temOrderId) {
        BaseResponse baseResponse = biddingMainApi.deleteTempOrderById(temOrderId);
        return baseResponse;
    }

    /**
     * @author taofeng
     * @date 2018/4/4
     */
    @Override
    public Map findbiddingLog(JqueryDataTablesVo jqueryDataTablesVo, String biddingNo) {
        Map returnModel = new HashMap();
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);

        List<JcbdBiddingOperationLogVo> biddingOperationLogVos = new ArrayList<>();
        Page<JcbdBiddingOperationLogDto> logDtoPage = biddingLogQueryApi.findAllByBiddingNo(biddingNo, pageable);
        if (!Lang.isEmpty(logDtoPage.getContent())) {
            for (JcbdBiddingOperationLogDto logDto : logDtoPage.getContent()) {
                JcbdBiddingOperationLogVo biddingOperationLogVo = BeanMapper.map(logDto, JcbdBiddingOperationLogVo.class);
                biddingOperationLogVo.setOperationTimeNew(DateUtils.dateToStr(biddingOperationLogVo.getOperationTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
                biddingOperationLogVos.add(biddingOperationLogVo);
            }
        }


        returnModel.put("aaData", biddingOperationLogVos);
        returnModel.put("iTotalRecords", logDtoPage.getTotalElements());
        returnModel.put("iTotalDisplayRecords", logDtoPage.getTotalElements());
        return returnModel;
    }


    /**
     * @author taofeng
     * @date 2018/4/4
     */
    @Override
    public List<BiddingDemandVo> findByJcbdBiddingCodeAndIsDelete(String biddingCode) {

        List<JcbdBiddingDemandDto> demandDtos = biddingDemandApi.findByJcbdBiddingCodeAndIsDelete(biddingCode);

        return BeanMapper.mapList(demandDtos, JcbdBiddingDemandDto.class, BiddingDemandVo.class);
    }

    /**
     * @author taofeng
     * @date 2018/4/23
     * <p>
     * 根据竞价编号查找竞价信息
     */
    @Override
    public JcbdBiddingVo findByBiddingCodeAndIsDelete(String biddingCode) {

        JcbdBiddingDto jcbdBiddingDto = biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);

        return BeanMapper.map(jcbdBiddingDto, JcbdBiddingVo.class);
    }

    @MotanReferer
    GoodsApi goodsApi;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    /**
     * 查询可采购商品信息
     *
     * @param biddingNo
     * @return
     */
    @Override
    public BaseResponse queryPermitGoodsInfo(String biddingNo) {
        List<ProcureInformationVo> procureInformationVos = new ArrayList<>();
        List<ProcureInformationDto> biddingDemandSku = biddingMainQueryApi.getBiddingDemandSku(biddingNo);
        if (!Lang.isEmpty(biddingDemandSku)) {
            biddingDemandSku.parallelStream().forEach(biddingDemandGood -> {
                //通过商品sku获取goodsName和goodsId
                List<GoodsConfigDto> goods = goodsConfigApi.findBySkuAndOrganizationCode(biddingDemandGood.getSku(), ORGANIZATIONCODE);
                if (!Lang.isEmpty(goods)) {
                    String goodsId = goods.get(0).getGoodsId();
                    String goodsName = goods.get(0).getTitle();
                    biddingDemandGood.setGoodsName(goodsName);
                    biddingDemandGood.setGoodsId(goodsId);
                }
                ProcureInformationVo procureInformationVo = BeanMapper.map(biddingDemandGood, ProcureInformationVo.class);
                // 封装productfashionId
                List<String> productFashionIds = productFashionApi.findProductFashionIdBySku(biddingDemandGood.getSku());
                if (!Lang.isEmpty(productFashionIds)) {
                    procureInformationVo.setProductFashionId(productFashionIds.get(0));
                }
                procureInformationVos.add(procureInformationVo);
            });
        }
        return new BaseResponse<>(true, "可采购商品查询成功", procureInformationVos);
    }


    @Override
    public Map finishBidding(String biddingNo, String remark, String biddingMemberId) {
        BaseResponse baseResponse = biddingMainApi.finishBidding(biddingNo);
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error("操作失败");
        }
        String companyName = getOperateInformation(biddingMemberId).getWholeJobName();
        //获取经办人姓名
        JcbdBiddingVo jcbdBiddingVo = getBiddingByBiddingCode(biddingNo);
        JcbdBiddingVo operator = getOperator(jcbdBiddingVo.getOperatorId());
        //邮件通知供应商
        try {
            List<JcbdStoreContactsVo> storeContacts = new ArrayList<>();
            List<JcbdBdProviderVo> providerVoList = findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
            if (!Lang.isEmpty(providerVoList)) {
                providerVoList.forEach(jcbdBdProviderVo -> {
                    //查询当前供应商
                    JcbdBdProviderDto provider = biddingMainQueryApi.getProvider(biddingNo, jcbdBdProviderVo.getProviderId());
                    if (!Lang.isEmpty(provider)) {
                        if (!Lang.isEmpty(provider.getPublish()) && provider.getPublish()) {
                            //已发布的竞价才会给发邮件
                            if (!Lang.isEmpty(jcbdBdProviderVo.getJcbdStoreContactsVos())) {
                                jcbdBdProviderVo.getJcbdStoreContactsVos().forEach(jcbdStoreContactsVo -> {
                                    storeContacts.add(jcbdStoreContactsVo);
                                });
                            }
                        }
                    }
                });
            }
            if (Lang.isEmpty(storeContacts)) {
                log.info("编号为{}的竞价查询供应商联系人失败", biddingNo);
            } else {
                MailReq mailReq = new MailReq();
                MailTemplateReq mailTemplateReq = new MailTemplateReq();
                storeContacts.forEach(supplierContant -> {
                    mailReq.setTo(new String[]{supplierContant.getEmail()});
                    mailReq.setFrom(mailFrom);
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel(MailReq.CHANNEL_JC);
                    mailTemplateReq.setMailReq(mailReq);
                    mailTemplateReq.setTemplateCode(MailTemplateEnum.BID_TERMINATED.getTemplateCode());
                    List<String> subjectArgs = new ArrayList<>();
                    //竞价编号
                    subjectArgs.add(biddingNo);
                    //共5个参数
                    List<String> contextArgs = new ArrayList<>();
                    contextArgs.add(supplierContant.getName());
                    contextArgs.add(companyName);
                    contextArgs.add(operator.getUsername());
                    contextArgs.add(biddingNo);
                    contextArgs.add(remark);
                    mailTemplateReq.setSubjectArgList(subjectArgs);
                    mailTemplateReq.setContentArgList(contextArgs);
                    mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                    log.info("竞价终止通知供应商邮件模板封装数据{}", JSON.toJSONString(mailTemplateReq));
                    mailApi.sendMailByTemplate(mailTemplateReq);
                });
            }
        } catch (Exception e) {
            log.error("竞价{}的竞价终止操作邮件通知供应商失败", biddingNo, e);
        }
        //邮件通知竞价小组成员
        try {
            BaseResponse<List<JcbdBiddingGroupMemberDto>> biddingGroupMemberResponse = biddingConformityReviewQueryApi.findBiddingGroupMember(biddingNo);
            if (!biddingGroupMemberResponse.isSuccess()) {
                log.info("编号为{}的竞价获取竞价小组成员信息失败：{}", biddingNo, biddingGroupMemberResponse.getResultMessage());
            } else {
                MailReq mailReq = new MailReq();
                MailTemplateReq mailTemplateReq = new MailTemplateReq();
                List<JcbdBiddingGroupMemberDto> groupMembers = biddingGroupMemberResponse.getResult();
                groupMembers.forEach(groupMember -> {
                    mailReq.setTo(new String[]{groupMember.getEmail()});
                    mailReq.setFrom(mailFrom);
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel(MailReq.CHANNEL_JC);
                    mailTemplateReq.setMailReq(mailReq);
                    mailTemplateReq.setTemplateCode(MailTemplateEnum.BID_TERMINATED.getTemplateCode());
                    List<String> subjectArgs = new ArrayList<>();
                    //竞价编号
                    subjectArgs.add(biddingNo);
                    //共5个参数
                    List<String> contextArgs = new ArrayList<>();
                    if (!Lang.isEmpty(groupMember.getName())) {
                        contextArgs.add(groupMember.getName());
                    } else {
                        contextArgs.add(groupMember.getEmail());
                    }
                    contextArgs.add(companyName);
                    contextArgs.add(operator.getUsername());
                    contextArgs.add(biddingNo);
                    contextArgs.add(remark);
                    mailTemplateReq.setSubjectArgList(subjectArgs);
                    mailTemplateReq.setContentArgList(contextArgs);
                    mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                    log.info("竞价终止通知竞价小组邮件模板封装数据{}", JSON.toJSONString(mailTemplateReq));
                    mailApi.sendMailByTemplate(mailTemplateReq);
                });
            }
        } catch (Exception e) {
            log.error("竞价{}的竞价终止操作邮件通知竞价小组失败", biddingNo, e);
        } finally {
            return ResponseMapUtils.success("");
        }
    }


    /**
     * 查询该竞价下的商品编号是否存在
     *
     * @param biddingNo
     * @return
     */
    @Override
    public Boolean goodIsNull(String biddingNo, String sku) {
        List<ProcureInformationDto> biddingDemandSku = biddingMainQueryApi.getBiddingDemandSku(biddingNo);
        for (ProcureInformationDto biddingDemand : biddingDemandSku) {
            if (biddingDemand.getSku().equals(sku)) {
                return true;
            }
        }
        return false;
    }


    @Override
    public Map audirQuerryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String workId, List<String> biddingMemberRoles, BiddingAuditInfoVo biddingAuditInfoVo) {
        Map returnModel = new HashMap();
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Pageable pageable = new PageRequest(pageindex + 1, jqueryDataTablesVo.getiDisplayLength());

        WfBiddingResultDataQuery wfBiddingResultDataQuery = BeanMapper.map(biddingAuditInfoVo, WfBiddingResultDataQuery.class);
        //取workerId
        List<String> workerIdList = new ArrayList<>();
        workerIdList.add(workId);
        wfBiddingResultDataQuery.setWorkerId(workerIdList);
        //获得biddingNo,status查询结果
        WfBiddingResultDataDto wfBiddingResultDataDto = wfBiddingResultDataApi.getBiddingNo(wfBiddingResultDataQuery, pageable);
        //获得bindding的集合
        List<String> biddingNoList = new ArrayList<>();
        List<WfBiddingResultDto> wfBiddingResultDtos = wfBiddingResultDataDto.getWfBiddingResultDtos();
        for (WfBiddingResultDto wfBiddingResultDto : wfBiddingResultDtos) {
            biddingNoList.add(wfBiddingResultDto.getBiddingNo());
        }
        //根据biddingNo集合在竞价表查询出信息
        List<JcbdBiddingDto> jcbdBiddingDtos = biddingQueryApi.findJcbdBiddingByBiddingNo(biddingNoList);
        //转换成前端的vo
        List<JcbdBiddingVo> jcbdBiddingVoList = mapperFacade.mapAsList(jcbdBiddingDtos, JcbdBiddingVo.class);
        Map<String, JcbdBiddingVo> jcbdBiddingVoMap = new HashMap<>();
        for (JcbdBiddingVo jcbdBiddingVo : jcbdBiddingVoList) {
            jcbdBiddingVoMap.put(jcbdBiddingVo.getBiddingCode(), jcbdBiddingVo);
        }
        List<JcbdBiddingVo> jcbdBiddingVos = new ArrayList<>();
        for (WfBiddingResultDto wfBiddingResultDto : wfBiddingResultDtos) {
            JcbdBiddingVo jcbdBiddingVo = jcbdBiddingVoMap.get(wfBiddingResultDto.getBiddingNo());
            JcbdBiddingVo biddingVo = BeanMapper.map(jcbdBiddingVo, JcbdBiddingVo.class);

            //状态
            biddingVo.setStatus(wfBiddingResultDto.getStatus());
            BiddingAuditStatus biddingAuditStatus = BiddingAuditStatus.biddingAuditStatusMap.get(wfBiddingResultDto.getStatus());
            biddingVo.setStatusDescription(biddingAuditStatus.getDescription());
            //操作
            List<JcbdRoleOperationDto> operationDtoList = biddingQueryApi.findByRoleCodeAndStatusAndModuleOrderByShowIndex(BiddingRole.BIDDING_AUDITOR, wfBiddingResultDto.getStatus(), StatusOperateModule.BIDDING_AUDIT_MANAGE.getCode());
            biddingVo.setOperation(operationDtoList);
            jcbdBiddingVos.add(biddingVo);
        }
        returnModel.put("aaData", jcbdBiddingVos);
        returnModel.put("iTotalRecords", wfBiddingResultDataDto.getITotalRecords());
        returnModel.put("iTotalDisplayRecords", wfBiddingResultDataDto.getITotalRecords());
        return returnModel;
    }

    @Override
    public List<QueryStatus> getAuditStatus() {
        List<QueryStatus> allStatusList = new ArrayList<>();
        Map<String, BiddingAuditStatus> biddingAuditStatusMap = BiddingAuditStatus.biddingAuditStatusMap;
        for (String statusCode : biddingAuditStatusMap.keySet()) {
            QueryStatus queryStatus = new QueryStatus();
            queryStatus.setStatusCode(statusCode);
            BiddingAuditStatus biddingAuditStatus = biddingAuditStatusMap.get(statusCode);
            queryStatus.setStatusDescription(biddingAuditStatus.getDescription());
            allStatusList.add(queryStatus);
        }
        return allStatusList;
    }

    /**
     * 获取用户信息
     * 若memberid为经办人的，则companyName为经办人直属机构到科室的完整组织机构拼接，否则为空字符串
     *
     * @param biddingMemberId
     * @return
     */
    @Override
    public UserInformationVo getOperateInformation(String biddingMemberId) {
        UserInformationVo informationVo = new UserInformationVo();
        Map<String, Object> queryUser = queryInformationApi.queryUser(biddingMemberId);
        //获取多个职位的信息
        List<Map<String, Object>> companyPositions = (List<Map<String, Object>>) queryUser.get("companyPositions");
        StringBuilder companyName = new StringBuilder();
        //筛选出职位为采购经办人的职位信息
        companyPositions.forEach(companyPosition -> {
            String positionCode = (String) companyPosition.get("positionCode");
            if (CorePositionDto.POSITION_JC_CGJBR.equals(positionCode)) {
                List<String> companyNameList = (List) companyPosition.get("companyNames");
                //拼接科室信息
                companyNameList.forEach(name -> {
                    companyName.append(name);
                });
            }
        });
        informationVo.setMember((MemberDto) queryUser.get("member"));
        informationVo.setUser((CoreUserDto) queryUser.get("coreUser"));
        informationVo.setWholeJobName(companyName.toString());
        return informationVo;
    }

    @Override
    public UserInformationVo getMemberCompanyInformatio(String biddingUserId) {
        UserInformationVo informationVo = new UserInformationVo();
        StringBuilder companyName = new StringBuilder();
        long start = System.currentTimeMillis();
        Map<String, Object> queryUser = queryInformationApi.queryUser(biddingUserId);
        log.info("查询用户信息耗时{}",System.currentTimeMillis()-start);
        CoreUserDto coreUser = (CoreUserDto) queryUser.get("coreUser");
        long start1 = System.currentTimeMillis();
        String positionId = queryInformationApi.getPositionId(CorePositionDto.POSITION_JC_CGJBR);
        log.info("查询职位id信息耗时{}",System.currentTimeMillis()-start1);
        long start2 = System.currentTimeMillis();
        CoreCompanyDto coreCompany = coreCompDepartUserApi.getCompanyByUserIdAndPositon(coreUser.getId(), CorePositionDto.POSITION_JC_CGJBR);
        log.info("查询机构信息信息耗时{}",System.currentTimeMillis()-start2);
        long start3 = System.currentTimeMillis();
        CoreCompDepartUserDto coreCompanyAndDepartment = coreCompDepartUserApi.getCoreCompanyAndDepartment(coreCompany.getId(), coreUser.getId(), positionId);
        log.info("查询机构部门映射信息信息耗时{}",System.currentTimeMillis()-start3);
        if(!Lang.isEmpty(coreCompany.getId())){
            long start4 = System.currentTimeMillis();
            String company = coreCompanyApi.getCompanyName(coreCompany.getId());
            log.info("查询机构部门映射中机构信息耗时{}",System.currentTimeMillis()-start4);
            if(!Lang.isEmpty(company)){
                companyName.append(company);
            }
            if(!Lang.isEmpty(coreCompanyAndDepartment.getDepartmentId())){
                long start5 = System.currentTimeMillis();
                String department = coreDepartmentApi.findById(coreCompanyAndDepartment.getDepartmentId());
                log.info("查询机构部门映射中部门信息耗时{}",System.currentTimeMillis()-start5);
                if(!Lang.isEmpty(department) && !Lang.isEmpty(company)){
                    companyName.append("-").append(department);
                }else{
                    companyName.append(department);
                }
            }
        }
        informationVo.setMember((MemberDto) queryUser.get("member"));
        informationVo.setUser((CoreUserDto) queryUser.get("coreUser"));
        informationVo.setWholeJobName(companyName.toString());
        return informationVo;
    }


    @Override
    public CoreCompanyDto getCompanyInfo(String memberId) {
        MemberDto memberDto = memberApi.findMemberById(memberId);
        CoreCompanyDto coreCompanyDto = coreCompDepartUserApi.getBuyerCompany(memberDto.getCoreUser().getId());
        return coreCompanyDto;
    }

    @MotanReferer
    InvoiceInfoApi invoiceInfoApi;

    /**
     * 查询纳税人识别号是否存在
     *
     * @param identificationCode
     * @return
     */
    @Override
    public Boolean queryIdentificationCode(String identificationCode) {
        Boolean byIdentificationCode = invoiceInfoApi.findByIdentificationCode(identificationCode);
        return byIdentificationCode;
    }

    /**
     * 查询地址是否存在
     *
     * @param address
     * @return
     */
    @Override
    public Boolean queryAddressExist(String[] address) {
        for (String addressCode : address) {
            if (!Lang.isEmpty(addressCode)) {
                Boolean byaddressCode = addressApi.findByaddressCode(addressCode);
                if (!byaddressCode) {
                    return byaddressCode;
                }
            }
        }
        return true;
    }

    /**
     * @author taofeng
     * @date 2018/4/14
     * <p>
     * 竞价提交审核_给竞价小组人员发送审核邮件
     */
    @Override
    public Map mailOfGroupMembers(String biddingNo, String biddingMemberId) {
        JcbdBiddingDto jcbdBiddingDto = biddingMainQueryApi.queryBidding(biddingNo);
        //采购经办人直属机构到科室的完整组织机构拼接
        String companyName = getOperateInformation(biddingMemberId).getWholeJobName();
        //获取经办人姓名
        JcbdBiddingVo jcbdBiddingVo = getBiddingByBiddingCode(biddingNo);
        JcbdBiddingVo operator = getOperator(jcbdBiddingVo.getOperatorId());
        if (!Lang.isEmpty(jcbdBiddingDto) && BiddingStatus.OM_AUDIT_WAIT.getValue().equals(jcbdBiddingDto.getStatus())) {
            BaseResponse<List<JcbdBiddingGroupMemberDto>> biddingGroupMemberResponse = biddingConformityReviewQueryApi.findBiddingGroupMember(biddingNo);
            try {
                if (!biddingGroupMemberResponse.isSuccess()) {
                    log.info("编号为{}的竞价获取竞价小组成员信息失败：{}", biddingNo, biddingGroupMemberResponse.getResultMessage());
                } else {
                    biddingGroupMemberResponse.getResult().parallelStream().forEach(biddingGroupMember -> {
                        MailTemplateReq mailTemplateReq = new MailTemplateReq();
                        MailReq mailReq = new MailReq();
                        String[] email = new String[]{biddingGroupMember.getEmail()};
                        mailReq.setTo(email);
                        mailReq.setFrom(operator.getEmail());
                        mailReq.setSentDate(new Date());
                        mailReq.setChannel(MailReq.CHANNEL_JC);
                        mailTemplateReq.setMailReq(mailReq);
                        String templateCode = MailTemplateEnum.BID_AUDIT.getTemplateCode();
                        String redirectUrl = "/operator/auditBidding";
                        String url = makeLoginUrl(StringUtils.join(email), biddingNo, redirectUrl);
                        mailTemplateReq.setTemplateCode(templateCode);
                        List<String> subjectArgs = new ArrayList<>();
                        //竞价编号
                        subjectArgs.add(biddingNo);
                        //共5个参数
                        List<String> contextArgs = new ArrayList<>();
                        contextArgs.add(Lang.isEmpty(biddingGroupMember.getName()) ? biddingGroupMember.getEmail() : biddingGroupMember.getName());
                        contextArgs.add(companyName);
                        contextArgs.add(operator.getUsername());
                        contextArgs.add(biddingNo);
                        contextArgs.add(url);
                        contextArgs.add(url);
                        mailTemplateReq.setSubjectArgList(subjectArgs);
                        mailTemplateReq.setContentArgList(contextArgs);

                        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                        log.info("竞价审核重发邮件模板封装数据{}", JSON.toJSONString(mailTemplateReq));
                        MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);
                    });

                    /*int size = biddingGroupMemberResponse.getResult().size();
                    //收件邮箱
                    String[] sendEmail = new String[size];
                    for (int i = 0; i < size; i++) {
                        sendEmail[i] = biddingGroupMemberResponse.getResult().get(i).getEmail();
                        mailReq.setTo(new String[]{sendEmail[i]});
                        mailReq.setFrom(operator.getEmail());
                        mailReq.setSentDate(new Date());
                        mailReq.setChannel(MailReq.CHANNEL_JC);
                        mailTemplateReq.setMailReq(mailReq);
                        String templateCode = MailTemplateEnum.BID_AUDIT.getTemplateCode();
                        String redirectUrl = "/operator/auditBidding";
                        String url = makeLoginUrl(StringUtils.join(new String[]{sendEmail[i]}), biddingNo, redirectUrl);
                        mailTemplateReq.setTemplateCode(templateCode);
                        List<String> subjectArgs = new ArrayList<>();
                        //竞价编号
                        subjectArgs.add(biddingNo);
                        //共5个参数
                        List<String> contextArgs = new ArrayList<>();
                        if (!Lang.isEmpty(biddingGroupMemberResponse.getResult().get(i).getName())) {
                            contextArgs.add(biddingGroupMemberResponse.getResult().get(i).getName());
                        } else {
                            contextArgs.add(biddingGroupMemberResponse.getResult().get(i).getEmail());
                        }
                        contextArgs.add(companyName);
                        contextArgs.add(operator.getUsername());
                        contextArgs.add(biddingNo);
                        contextArgs.add(url);
                        mailTemplateReq.setSubjectArgList(subjectArgs);
                        mailTemplateReq.setContentArgList(contextArgs);

                        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                        log.info("竞价审核重发邮件模板封装数据{}", JSON.toJSONString(mailTemplateReq));
                        MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);
                    }*/
                }
            } catch (Exception e) {
                log.error("竞价{}的竞价终止操作邮件通知竞价小组失败", biddingNo, e);
            }
        }
        return ResponseMapUtils.success("操作成功");
    }

    /**
     * 查询此用户地址信息是否已经存在memberAddress表里
     *
     * @return
     */
    @Override
    public MemberAddressDto findMemberAddress(String[] address, String detailAddress, String memberName, String
            memberTel) {
        MemberAddressDto memberAddressDto = new MemberAddressDto();
        if (!Lang.isEmpty(address[0])) {
            memberAddressDto.setProvinceCode(address[0]);
        }
        if (!Lang.isEmpty(address[1])) {
            memberAddressDto.setCityCode(address[1]);
        }
        if (!Lang.isEmpty(address[2])) {
            memberAddressDto.setAreaCode(address[2]);
        }
        if (!Lang.isEmpty(address[3])) {
            memberAddressDto.setTownCode(address[3]);
        }
        memberAddressDto.setDetailaddress(detailAddress);
        memberAddressDto.setTel(memberTel);
        memberAddressDto.setUsername(memberName);

        MemberAddressDto byAddressInfo = memberAddressApi.findByAddressInfo(memberAddressDto);
        return byAddressInfo;
    }

    /**
     * 保存模板导入的地址信息
     *
     * @param address
     * @return
     */
    @Override
    public MemberAddressDto saveExcelImportData(String[] address, String detailAddress, String memberName, String
            memberTel) {
        MemberAddressDto memberAddressDto = new MemberAddressDto();
        String[] addressName = new String[5];
        for (int i = 0; i < address.length; i++) {
            if (!Lang.isEmpty(address[i])) {
                String shortName = addressApi.findShortNameById(address[i]);
                addressName[i] = shortName;
            }
        }
        memberAddressDto.setProvinceCode(address[0]);
        memberAddressDto.setProvinceName(addressName[0]);
        memberAddressDto.setCityCode(address[1]);
        memberAddressDto.setCityName(addressName[1]);
        memberAddressDto.setAreaCode(address[2]);
        memberAddressDto.setAreaName(addressName[2]);
        memberAddressDto.setTownCode(address[3]);
        memberAddressDto.setTownName(addressName[3]);
        memberAddressDto.setDetailaddress(detailAddress);
        memberAddressDto.setAddressDetail(detailAddress);
        memberAddressDto.setUsername(memberName);
        memberAddressDto.setTel(memberTel);

        MemberAddressDto memberAddressResp = memberAddressApi.saveAddressInfo(memberAddressDto);
        return memberAddressResp;
    }

    /**
     * 批量下载临时订单
     *
     * @param biddingNo
     * @return
     */
    @Override
    public BaseResponse findAllTempOrder(String biddingNo) {
        List<JcbdTempOrderDto> allTempOrder = biddingMainQueryApi.findAllTempOrderByBiddingNo(biddingNo);
        if (!Lang.isEmpty(allTempOrder)) {
            List<JcbdTempOrderVo> tempOrderVos = mapperFacade.mapAsList(allTempOrder, JcbdTempOrderVo.class);
            for (JcbdTempOrderVo tempOrderVo : tempOrderVos) {
                if (!Lang.isEmpty(tempOrderVo.getMemberAddressId())) {
                    MemberAddressDto memberAddressDto = memberAddressApi.findById(tempOrderVo.getMemberAddressId());
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(memberAddressDto.getProvinceName());
                    stringBuilder.append(memberAddressDto.getCityName());
                    stringBuilder.append(memberAddressDto.getAreaName());
                    stringBuilder.append(memberAddressDto.getTownName());
                    stringBuilder.append(memberAddressDto.getAddressDetail());
                    tempOrderVo.setMemberAddressName(stringBuilder.toString());
                    tempOrderVo.setMemberName(memberAddressDto.getUsername());
                    tempOrderVo.setTel(memberAddressDto.getPhone());

                    StringBuffer consigneeName = new StringBuffer();
                    if (BiddingOperatorServiceImpl.INVOICE_ADDRESS_FLAG_YES.equals(tempOrderVo.getConsigneeFlag())) {
                        consigneeName.append(memberAddressDto.getProvinceName());
                        consigneeName.append(memberAddressDto.getCityName());
                        consigneeName.append(memberAddressDto.getAreaName());
                        consigneeName.append(memberAddressDto.getTownName());
                        consigneeName.append(memberAddressDto.getAddressDetail());
                        tempOrderVo.setInvoiceAddress(consigneeName.toString());
                        tempOrderVo.setConsigneeName(memberAddressDto.getUsername());
                        tempOrderVo.setConsigneePhone(memberAddressDto.getPhone());
                    } else {
                        if (!Lang.isEmpty(tempOrderVo.getConsigneeProvinceCode())) {
                            String consigneeProvince = addressApi.findShortNameById(tempOrderVo.getConsigneeProvinceCode());
                            consigneeName.append(consigneeProvince);
                        }
                        if (!Lang.isEmpty(tempOrderVo.getConsigneeCityCode())) {
                            String consigneeCity = addressApi.findShortNameById(tempOrderVo.getConsigneeCityCode());
                            consigneeName.append(consigneeCity);
                        }
                        consigneeName.append(tempOrderVo.getAddressDetail());
                        tempOrderVo.setInvoiceAddress(consigneeName.toString());
                    }
                } else {
                    tempOrderVo.setMemberAddressName("");
                    tempOrderVo.setMemberName("");
                    tempOrderVo.setTel("");
                    StringBuffer consigneeName = new StringBuffer();
                    if (BiddingOperatorServiceImpl.INVOICE_ADDRESS_FLAG_YES.equals(tempOrderVo.getConsigneeFlag())) {
                        tempOrderVo.setInvoiceAddress("");
                        tempOrderVo.setConsigneeName("");
                        tempOrderVo.setConsigneePhone("");
                    } else {
                        if (!Lang.isEmpty(tempOrderVo.getConsigneeProvinceCode())) {
                            String consigneeProvince = addressApi.findShortNameById(tempOrderVo.getConsigneeProvinceCode());
                            consigneeName.append(consigneeProvince);
                        }
                        if (!Lang.isEmpty(tempOrderVo.getConsigneeCityCode())) {
                            String consigneeCity = addressApi.findShortNameById(tempOrderVo.getConsigneeCityCode());
                            consigneeName.append(consigneeCity);
                        }
                        consigneeName.append(tempOrderVo.getAddressDetail());
                        tempOrderVo.setInvoiceAddress(consigneeName.toString());
                    }
                }

                // 查询发票公司信息
                if (!Lang.isEmpty(tempOrderVo.getCompanyId())) {
                    CoreCompanyDto coreCompany = coreCompanyApi.findById(tempOrderVo.getCompanyId());
                    tempOrderVo.setCompanyAddressAndPhone(coreCompany.getAddress() + " " + coreCompany.getPhone());
                    tempOrderVo.setBankAndAccount(coreCompany.getBankDeposit() + " " + coreCompany.getBankAccount());
                }

            }
            return new BaseResponse(true, "批量临时订单查询完成", tempOrderVos);
        }
        List<JcbdTempOrderVo> tempOrderVos = new ArrayList<>();
        List<JcbdTempGoodsVo> jcbdTempGoodsVos = new ArrayList<>();
        JcbdTempOrderVo jcbdTempOrderVo = new JcbdTempOrderVo();
        jcbdTempOrderVo.setInvoiceAddress("");
        JcbdTempGoodsVo jcbdTempGoodsVo = new JcbdTempGoodsVo();
        jcbdTempGoodsVo.setSku("");
        jcbdTempGoodsVos.add(jcbdTempGoodsVo);
        jcbdTempOrderVo.setJcbdTempGoodses(jcbdTempGoodsVos);
        tempOrderVos.add(jcbdTempOrderVo);
        return new BaseResponse(true, "批量临时订单查询完成", tempOrderVos);
    }

    @Override
    public List<VoteQueryResultVo> voteDetailsQuery(String biddingNo) {
        List<VoteQueryResultDto> voteQueryResultDtos = biddingVoteApi.voteDetailsQuery(biddingNo);
        return mapperFacade.mapAsList(voteQueryResultDtos, VoteQueryResultVo.class);
    }

    @Override
    public String updateBiddingGroupCheckNo(String bidddingNo) {
        return biddingMainApi.updateBiddingGroupCheckNo(bidddingNo);
    }

    /**
     * 获取运费
     *
     * @param tempPurchaseVoData
     * @param memberId
     * @return
     */
    @Override
    public BaseResponse getOrderFee(TempPurchaseVo tempPurchaseVoData, String memberId) {
        TempPurchaseVo tempPurchaseVo = dealTempPurchaseVo(tempPurchaseVoData);
        List<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = this.dealWithBatchPurchaseData(tempPurchaseVo);
        BaseResponse<List<TempOrderVo>> baseResponse = orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        BigDecimal sumOrderFee = BigDecimal.ZERO;
        if (baseResponse.isSuccess()) {
            List<TempOrderVo> tempOrderVos = baseResponse.getResult();
            if (!Lang.isEmpty(tempOrderVos)) {
                for (TempOrderVo tempOrderVo : tempOrderVos) {
                    for (TempOrderStoreVo tempOrderStoreVo : tempOrderVo.getStoreList()) {
                        BigDecimal singleFee = orderMainApi.queryShippingFee(tempOrderStoreVo.getStoreId(), tempOrderStoreVo.getOrderItems(),
                                tempOrderVo.getMemberAddrId());
                        if (!Lang.isEmpty(singleFee)){
                            sumOrderFee = sumOrderFee.add(singleFee);
                        }
                    }
                }
            }
        } else {
            return new BaseResponse<>("获取临时订单失败!");
        }
        return new BaseResponse<>(true, "获取运费成功！", sumOrderFee);
    }

    @Override
    public BaseResponse checkLimit(String biddingCode) {
        List<JcbdTempOrderDto> tempOrderDtos = biddingOrderQueryApi.findTempOrderByBiddingCode(biddingCode);
        TempPurchaseVo tempPurchaseVo = new TempPurchaseVo();
        List<TempJcbdOrderVo> orders = new ArrayList<>();
        for (JcbdTempOrderDto tempOrderDto : tempOrderDtos) {
            tempOrderDto.getJcbdTempGoodses().forEach(n -> {
                TempJcbdOrderVo orderVo = new TempJcbdOrderVo();
                orderVo.setResponsePrice(n.getPrice());
                orderVo.setCount(n.getNum());
                orders.add(orderVo);
            });
        }
        tempPurchaseVo.setOrders(orders);
        //**判断此竞价的采购是否超过100万限额
        List<TempJcbdOrderVo> tempJcbdOrderVos = tempPurchaseVo.getOrders();
        BigDecimal newOrderSumPirce = BigDecimal.ZERO;//本次订单总额
        for (int j = 0; j < tempJcbdOrderVos.size(); j++) {
            if (!Lang.isEmpty(newOrderSumPirce) && !Lang.isEmpty(tempJcbdOrderVos.get(j).getResponsePrice())) {
                newOrderSumPirce = newOrderSumPirce.add(tempJcbdOrderVos.get(j).getResponsePrice().multiply(new BigDecimal(tempJcbdOrderVos.get(j).getCount())));
            }
        }
        List<JcbdOrderDto> b4jcbdOrderDtoList = biddingOrderQueryApi.findByJcbdBiddingId(biddingCode);
        BigDecimal oldOrderSumPrice = BigDecimal.ZERO;
        if (b4jcbdOrderDtoList.size() > 0) {
            for (JcbdOrderDto jcbdOrderDto : b4jcbdOrderDtoList) {
                oldOrderSumPrice = oldOrderSumPrice.add(jcbdOrderDto.getTotalMoney());
            }
        }
        BigDecimal totalPrice = newOrderSumPirce.add(oldOrderSumPrice);
        if (totalPrice.compareTo(new BigDecimal(tradingLimit)) > 0) {
            return new BaseResponse(false, "您此次下单的金额与历史下单金额相加超过100万，不可下单");
        }
        return new BaseResponse(true, "校验通过");
    }

    @Override
    public BaseResponse<Boolean> getVoteStatus(String biddingNo, String memberId) {
        return biddingMainApi.getVoteStatus(biddingNo, memberId);
    }

    @MotanReferer
    SystemConfigApi systemConfigApi;
    @MotanReferer
    CoreDepartmentApi coreDepartmentApi;
    @MotanReferer
    WfWorkFlowRelationApi wfWorkFlowRelationApi;
    @MotanReferer
    CoreCompanyApi coreCompanyApi;

    @Override
    public TiaoXianCompanyVo getTiaoXianCompany(TianXianRequestVo tianXianRequestVo) {
        TiaoXianCompanyVo tiaoXianCompanyVo = new TiaoXianCompanyVo();
        CoreCompanyDto coreCompany = null;
//        long startTime = System.currentTimeMillis();
        coreCompany = coreCompDepartUserApi.getCompanyByUserIdAndPositon(tianXianRequestVo.getUserId(), CorePositionDto.POSITION_JC_CGJBR);
//        log.info("获取coreCompany耗时：{}",System.currentTimeMillis()-startTime);
        if (!Lang.isEmpty(coreCompany)) {
            if (coreCompany.getCompanyLevel() == CoreCompanyDto.COMPANY_LEVEL_FOUR) {//如果是三级机构，需要判断是否走调线
                String parentCode = getParentCode(coreCompany);
                Boolean isIncludeCode = false;//默认走调线
                String excuArray = systemConfigApi.getConfigValue(organizationCode, SystemConfigDto.CONFIG_CODE_WORK_FLOW_STRIPER_EXCU, SystemConfigValueDto.CONFIG_VALUE_TYPE_WORK_FLOW_STRIPER_EXCU, true, true);
                if (!Lang.isEmpty(excuArray) && !Lang.isEmpty(parentCode)) {
                    String[] includeArray = excuArray.split(",");
                    for (String value : includeArray) {
                        if (value.equals(parentCode)) {
                            isIncludeCode = true;
                            break;
                        }
                    }
                }
                if (!isIncludeCode) {
                    String isOpen = systemConfigApi.getConfigValue(organizationCode, SystemConfigDto.CONFIG_CODE_OPEN_CONFIG_WORK_FLOW_STRIPER, SystemConfigValueDto.CONFIG_VALUE_TYPE_OPEN_CONFIG_WORK_FLOW_STRIPER, true, true);
                    if (!Lang.isEmpty(isOpen)) { //是否开启工作流调线
                        if (isOpen.equals("true")) {
                            //工作流人员关联表
                            List<WfWorkFlowRelationDto> workFlowRelations = wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
                            WfWorkFlowDefinitionDto wfWorkFlowDefinition = null; //工作流定义表
                            if (!Lang.isEmpty(workFlowRelations)) {
                                WfWorkFlowRelationDto wfWorkFlowRelation = workFlowRelations.get(0);
                                if (!Lang.isEmpty(wfWorkFlowRelation)) {
                                    wfWorkFlowDefinition = wfWorkFlowRelation.getWorkFlowDefinition();
                                }
                            }
                            ///工作流调线金额
                            String valus = systemConfigApi.getConfigValue(organizationCode, SystemConfigDto.CONFIG_CODE_WORK_FLOW_STRIPER_MOMEY, SystemConfigValueDto.CONFIG_VALUE_TYPE_WORK_FLOW_STRIPER_MOMEY, true, true);
                            Double thirdTiaoxianMoney = 0D;
                            String thirdTiaoxianUnit = "5万";
                            String thirdTiaoxianMoneyStr = "50000";
                            if (!Lang.isEmpty(valus)) {
                                if (!Lang.isEmpty(wfWorkFlowDefinition)) {
                                    JSONArray jsonArray = JSON.parseArray(valus);
                                    for (int i = 0; i < jsonArray.size(); i++) {
                                        JSONObject obj = jsonArray.getJSONObject(i);
                                        String companyCode = obj.getString("companyCode");
                                        if (wfWorkFlowDefinition.getCompanyCode().equals(companyCode)) {
                                            thirdTiaoxianMoneyStr = obj.getString("money");
                                            thirdTiaoxianUnit = obj.getString("unit");
                                        }
                                    }
                                }
                                try {
                                    thirdTiaoxianMoney = Double.parseDouble(thirdTiaoxianMoneyStr);
                                } catch (Exception e) {
                                    log.info("调线价格转换失败");
                                    e.printStackTrace();
                                }
                            }
                            BigDecimal totalMoney = tianXianRequestVo.getTotalMoney();
                            //添加三级部门采购员申请条线
                            if (coreCompany != null) {
                                switch (coreCompany.getCompanyLevel()) {
                                    case 4: //三级机构 处理条线
//                                         startTime = System.currentTimeMillis();
                                        handleThirdTiaoXian(tiaoXianCompanyVo, totalMoney.doubleValue(), coreCompany, thirdTiaoxianMoney, thirdTiaoxianUnit);
//                                        log.info("获取条线部门耗时：{}",System.currentTimeMillis()-startTime);
                                    default:
                                }
                            }
                        }
                    }
                }
            }

            // 获取审核流程
            List<WfWorkFlowRelationDto> workFlowRelations = wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
            List<WfWorkFlowDefinitionDto> wfWorkFlowDefinitions = new ArrayList<>();
            for (WfWorkFlowRelationDto wf_r : workFlowRelations) {
                if (wf_r.getWorkFlowDefinition().getIsDelete() == null || !wf_r.getWorkFlowDefinition().getIsDelete()) {
                    wfWorkFlowDefinitions.add(wf_r.getWorkFlowDefinition());
                }
            }
            tiaoXianCompanyVo.setWfWorkFlowDefinitions(wfWorkFlowDefinitions);
        }
        return tiaoXianCompanyVo;
    }

    private String getParentCode(CoreCompanyDto coreCompany) {
        String parentId = coreCompany.getParent().getId();
        CoreCompanyDto coreCompanyP1 = coreCompanyApi.getParentCompany(parentId, CoreCompanyDto.COMPANY_LEVEL_TWO);
        return coreCompanyP1.getCode();
    }

    //三级机构 处理条线
    public void handleThirdTiaoXian(TiaoXianCompanyVo tiaoXianCompanyVo, Double sumCartPrice, CoreCompanyDto
            coreCompany, Double thirdTiaoxianMoney, String thirdTiaoxianUnit) {
        if (sumCartPrice > thirdTiaoxianMoney) {
            CoreCompanyDto coreCompanyParent = coreCompany.getParent();
            Integer departmentLevel = 1;
            List<TianXianDepartmentDto> tiaoXianDepartment = coreDepartmentApi.findTiaoXianDepartment(coreCompanyParent.getId(), departmentLevel);
            tiaoXianCompanyVo.setIsTiaoXian(true);
            tiaoXianCompanyVo.setTianXianDepartmentDtos(tiaoXianDepartment);
            tiaoXianCompanyVo.setThirdTiaoxianMoney(new BigDecimal(thirdTiaoxianMoney));
        }
    }

    /**
     * 重新发起审查邮件（竞价管理页符合性审查）
     *
     * @param biddingNo
     * @return
     */
    @Override
    public BaseResponse reSendAuditEmail(String biddingNo, String biddingMemberId) {
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        JcbdBiddingDto jcbdBiddingDto = biddingMainQueryApi.queryBidding(biddingNo);
        //采购经办人直属机构到科室的完整组织机构拼接
        String companyName = getOperateInformation(biddingMemberId).getWholeJobName();
        //获取经办人姓名
        JcbdBiddingVo jcbdBiddingVo = getBiddingByBiddingCode(biddingNo);
        JcbdBiddingVo operator = getOperator(jcbdBiddingVo.getOperatorId());
        if (!Lang.isEmpty(jcbdBiddingDto) && BiddingStatus.OM_CONFORM_AUDIT_IN.getValue().equals(jcbdBiddingDto.getStatus())) {
            BaseResponse<List<JcbdBiddingGroupMemberDto>> biddingGroupMembers = biddingConformityReviewQueryApi.findBiddingGroupMember(biddingNo);
            try {
                if (!Lang.isEmpty(biddingGroupMembers)) {
                    int size = biddingGroupMembers.getResult().size();
                    //收件邮箱
                    String[] sendEmail = new String[size];
                    if (biddingGroupMembers.isSuccess()) {
                        for (int i = 0; i < size; i++) {
                            //TODO: 2018/3/19邮件模板数据填充
                            sendEmail[i] = biddingGroupMembers.getResult().get(i).getEmail();
                            mailReq.setTo(new String[]{sendEmail[i]});
                            mailReq.setFrom(operator.getEmail());
                            mailReq.setSentDate(new Date());
                            mailReq.setChannel(MailReq.CHANNEL_JC);
                            mailTemplateReq.setMailReq(mailReq);

                            //BID_AUDIT("1_1_5","竞价审核")
                            // 首位对应模板号，2位对应邮件标题参数subjectArgs,3位对应内容参数contextArgs
                            String templateCode = MailTemplateEnum.BID_CONFORMANCE_AUDIT.getTemplateCode();
                            String redirectUrl = "/operator/complianceAudit";
                            String url = makeLoginUrl(StringUtils.join(new String[]{sendEmail[i]}), biddingNo, redirectUrl);
                            mailTemplateReq.setTemplateCode(templateCode);
                            List<String> subjectArgs = new ArrayList<>();
                            //竞价编号
                            subjectArgs.add(biddingNo);
                            //共5个参数
                            List<String> contextArgs = new ArrayList<>();
                            if (!Lang.isEmpty(biddingGroupMembers.getResult().get(i).getName())) {
                                contextArgs.add(biddingGroupMembers.getResult().get(i).getName());
                            } else {
                                contextArgs.add(biddingGroupMembers.getResult().get(i).getEmail());
                            }
                            contextArgs.add(companyName);
                            contextArgs.add(operator.getUsername());
                            contextArgs.add(biddingNo);
                            contextArgs.add(url);
                            contextArgs.add(url);
                            mailTemplateReq.setSubjectArgList(subjectArgs);
                            mailTemplateReq.setContentArgList(contextArgs);

                            mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                            log.info("符合性审查重发邮件模板封装数据{}", JSON.toJSONString(mailTemplateReq));
                            MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);
                        }
                    }
                }
            } catch (Exception e) {
                log.error("邮件发送失败{}", e);
                return new BaseResponse(false, "邮件发送失败");
            }
        }
        return new BaseResponse(true);
    }

    @Override
    public BaseResponse<Boolean> saveOperatorsLog(String operatorsId, String biddingCode, JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto) {
        JcbdBiddingDto jcbdBiddingDto = biddingMainQueryApi.queryBidding(biddingCode);
        String operatorName = biddingOperatorService.getOperatorName(operatorsId);
        jcbdBiddingOperationLogDto.setOperatorName(operatorName);
        jcbdBiddingOperationLogDto.setOperationTime(new Date());
        jcbdBiddingOperationLogDto.setBiddingId(jcbdBiddingDto.getId());
        biddingLogApi.saveBiddingOperationLog(jcbdBiddingOperationLogDto);
        return new BaseResponse<>(true, "操作成功");
    }
	@Override
    public BaseResponse<Boolean> saveAuditOperatorsLog(String operatorsId, String biddingCode, JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto) {
        JcbdBiddingDto jcbdBiddingDto = biddingMainQueryApi.queryBidding(biddingCode);
        //String operatorName = biddingOperatorService.getOperatorName(operatorsId);
        CoreCompDepartUserDto coreCompDepartUserDto = coreCompDepartUserApi.findByIdAndIsDelete(operatorsId, false);
        CoreUserDto coreUserDto = coreUserApi.findById(coreCompDepartUserDto.getUserId());
        jcbdBiddingOperationLogDto.setOperatorName(coreUserDto.getUsername());
        jcbdBiddingOperationLogDto.setOperationTime(new Date());
        jcbdBiddingOperationLogDto.setBiddingId(jcbdBiddingDto.getId());
        biddingLogApi.saveBiddingOperationLog(jcbdBiddingOperationLogDto);
        return new BaseResponse<>(true, "操作成功");
    }

    /**
     * @author taofeng
     * @date 2018/4/21
     * <p>
     * 竞价_删除
     */
    @Override
    public Map deleteBidding(String biddingNo) {

        BaseResponse baseResponse = biddingMainApi.deleteBidding(biddingNo);
        if (!baseResponse.isSuccess()) {
            ResponseMapUtils.error(baseResponse.getResultMessage());
        }
        return ResponseMapUtils.success(baseResponse.getResultMessage());
    }

    /**
     * 根据sku获取商品价格以及需求id
     *
     * @param biddingNo
     * @param sku
     */
    @Override
    public JcbdBiddingDemandResponseDto findGoodsPriceBySku(String biddingNo, String sku) {
        return biddingResponseQueryApi.findProviderResponsePrice(biddingNo, sku);
    }

    /**
     * 根据sku获取goodsId
     *
     * @param sku
     * @return
     */
    @Override
    public String findGoodsIdBySku(String sku) {
        List<GoodsConfigDto> goodsConfigDtos = goodsConfigApi.findBySkuAndOrganizationCode(sku, ORGANIZATIONCODE);
        if (!Lang.isEmpty(goodsConfigDtos)) {
            return goodsConfigDtos.get(0).getGoodsId();
        }
        return null;
    }

    @Override
    public String findProductFashionId(String sku) {
        List<String> fashionIds = productFashionApi.findProductFashionIdBySku(sku);
        if (!Lang.isEmpty(fashionIds)) {
            return fashionIds.get(0);
        }
        return null;
    }

    @Override
    public List<String> findBiddingShowTitle(String biddingNo) {
        JcbdBiddingDto jcbdBiddingDto = biddingMainQueryApi.queryBidding(biddingNo);
        String status = jcbdBiddingDto.getStatus();
        return biddingRoleOperationQueryApi.getBiddingShowTitle(status, BIDDING_TITILE_SHOW_MODULE);
    }

    @Override
    public TiaoXianCompanyVo getBiddingResultTiaoXian(String userId, String biddingNo) {
        TianXianRequestVo tianXianRequestVo = new TianXianRequestVo();
        tianXianRequestVo.setTotalMoney(getResponseBiddingTotalMonay(biddingNo));
        tianXianRequestVo.setUseCode(WorkFlowCode.BIDDING_RESULT_WORKFLOW_CODE.getCode());
        tianXianRequestVo.setUserId(userId);
        return getTiaoXianCompany(tianXianRequestVo);
    }

    @Override
    public TiaoXianCompanyVo getBiddingOrderTiaoXian(TianXianRequestVo tianXianRequestVo) {
        return getTiaoXianCompany(tianXianRequestVo);
    }

    @Override
    public BaseResponse checkGoodNums(String biddingCode) {
        BaseResponse baseResponse = new BaseResponse();
        List<JcbdTempOrderDto> tempOrderDtos = biddingOrderQueryApi.findTempOrderByBiddingCode(biddingCode);
        TempPurchaseVo tempPurchaseVo = new TempPurchaseVo();
        List<TempJcbdOrderVo> orders = new ArrayList<>();
        for (JcbdTempOrderDto tempOrderDto : tempOrderDtos) {
            tempOrderDto.getJcbdTempGoodses().forEach(n -> {
                TempJcbdOrderVo orderVo = new TempJcbdOrderVo();
                orderVo.setSku(n.getSku());
                orderVo.setResponsePrice(n.getPrice());
                orderVo.setCount(n.getNum());
                orderVo.setJcbdBiddingDemandId(n.getDemandId());
                orderVo.setMemberAddrId(tempOrderDto.getMemberAddressId());
                orderVo.setStoreId(tempOrderDto.getStoreId());
                orderVo.setProductFashionId(n.getProductFashionId());
                orderVo.setGoodsId(n.getGoodsId());
                orders.add(orderVo);
            });
        }
        tempPurchaseVo.setOrders(orders);
        List<TempJcbdOrderVo> tempJcbdOrderVos = tempPurchaseVo.getOrders();
        //**判断竞价的某个需求的采购数量是否超过了“最高采购数量”
        // 根据订单状态统计占用的采购数量
        List<JcbdOrderDto> jcbdOrderDtos = biddingOrderQueryApi.findAllByBiddingCode(biddingCode);
        List<JcbdMallOrderDto> jcbdMallOrderDtos = new ArrayList<>();
        List<String> orderStatusFilter = new ArrayList<>();
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_INREVIEW.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_COMPLETED.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_TOBECONFIRMED.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_TOBERECEIVED.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_HAVEGOODS.getCode());
        List<JcbdBiddingOrderItemDto> orderItems = new ArrayList<>();
        if (!Lang.isEmpty(jcbdOrderDtos)){
            jcbdOrderDtos.forEach(jcbdOrder->{
                jcbdMallOrderDtos.addAll(jcbdOrder.getJcbdMallOrders());
            });
            //  取出占用采购数量额度的订单
            List<JcbdMallOrderDto> mallOrderDtos = jcbdMallOrderDtos.stream().filter(item -> orderStatusFilter.contains(item.getStatus())).collect(Collectors.toList());
            if (!Lang.isEmpty(mallOrderDtos)){
                List<String> orderNos = mallOrderDtos.stream().map(JcbdMallOrderDto::getOrderNo).collect(Collectors.toList());
                mallOrderDtos.forEach(mallOrder->{
                    orderItems.addAll(mallOrder.getJcbdBiddingOrderItems());
                });
            }
        }
        Map<String, List<JcbdBiddingOrderItemDto>> orderItemMap = null;
        if (!Lang.isEmpty(orderItems)){
            orderItemMap = orderItems.stream().collect(Collectors.groupingBy(JcbdBiddingOrderItemDto::getSku));
        }
        Map<String, List<TempJcbdOrderVo>> orderDataMap = tempJcbdOrderVos.stream().collect(groupingBy(TempJcbdOrderVo::getSku));//按sku分组
        List<String> overBuySkuList = new ArrayList<>();//储存购买数超过的sku
        for (String skuKey : orderDataMap.keySet()) {
            List<TempJcbdOrderVo> orderVoList = orderDataMap.get(skuKey);
            TempJcbdOrderVo tempJcbdOrderVo = orderVoList.get(0);
            String demandId = tempJcbdOrderVo.getJcbdBiddingDemandId();//需求Id
            // 当前购买数量
            Integer thisTimeBuyCount = orderVoList.stream().collect(Collectors.reducing(0, TempJcbdOrderVo::getCount, (i, j) -> i + j));
            JcbdBiddingDemandDto demandQuery = new JcbdBiddingDemandDto();
            demandQuery.setId(demandId);
            JcbdBiddingDto jcbdBiddingDto = new JcbdBiddingDto();
            jcbdBiddingDto.setBiddingCode(biddingCode);
            demandQuery.setJcbdBidding(jcbdBiddingDto);
            JcbdBiddingDemandDto demandDto = biddingMainQueryApi.getBiddingDemandFindOne(demandQuery);

            Long maxPurchaseAmount = demandDto.getMaxPurchaseAmount();
            if (!Lang.isEmpty(orderItemMap)){
                List<JcbdBiddingOrderItemDto> orderItemDtos = orderItemMap.get(skuKey);
                if (!Lang.isEmpty(orderItemDtos)){
                    Integer historyBuyCount = orderItemDtos.stream().collect(Collectors.reducing(0, JcbdBiddingOrderItemDto::getCount, (i, j) -> i + j));
                    if ((thisTimeBuyCount + historyBuyCount) > maxPurchaseAmount) {
                        overBuySkuList.add(skuKey);
                    }
                }
            }
        }
        if (overBuySkuList.size() > 0) {
            baseResponse.setSuccess(true);
            StringBuilder sb = new StringBuilder();
            sb.append("您此次下单的【");
            for (int i = 0; i < overBuySkuList.size(); i++) {
                if (i != overBuySkuList.size() - 1) {
                    sb.append(overBuySkuList.get(i)).append(",");
                } else {
                    sb.append(overBuySkuList.get(i));
                }
            }
            sb.append("】商品总计数量与历史下单数量相加超过此需求的最高采购数量，不可下单");
            baseResponse.setResultMessage(sb.toString());
        }
        return baseResponse;
    }

    @Override
    public CoreCompanyDto getCoreCompanyInfoById(String companyId) {
        return coreCompanyApi.getCoreCompanyInfoById(companyId);
    }

    @Override
    public Boolean compareCurrentMemberId(String memberId, String biddingCode) {
        if (Lang.isEmpty(memberId)) {
            return false;
        }
        JcbdBiddingDto jcbdBidding = biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);
        if (StringUtils.equals(memberId, jcbdBidding.getOperatorId())) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean biddingIsFinish(String biddingNo) {
        if (Lang.isEmpty(biddingNo)) {
            return true;
        }
        JcbdBiddingVo biddingVo = getBiddingByBiddingCode(biddingNo);
        if (Lang.isEmpty(biddingVo)) {
            return true;
        }
        return BiddingStatus.OM_BIDDING_END.getValue().equals(biddingVo.getStatus());
    }

    @Override
    public JcbdBiddingGroupMemberDto findGroupStatus(String email, String biddingId) {
        return biddingQueryApi.findGroupStatus(email, biddingId);
    }

    @MotanReferer
    SupplierLoginApi supplierLoginApi;

    @Override
    public String getOperatorName(String operatorId) {
        JcbdBiddingGroupMemberDto jcbdBiddingGroupMember = biddingMainApi.findByMemberId(operatorId);
        if (jcbdBiddingGroupMember != null) {
            if (!Lang.isEmpty(jcbdBiddingGroupMember.getName())) {
                return jcbdBiddingGroupMember.getName();
            } else if (!Lang.isEmpty(jcbdBiddingGroupMember.getEmail())) {
                return jcbdBiddingGroupMember.getEmail();
            }
        } else {
            //供应商登录时 获取供应商及联系人信息
            List<SupplierContactDto> supplierContact = supplierLoginApi.findByDUserIdAndIsDelete(operatorId);
            if (!Lang.isEmpty(supplierContact)) {
                if (!Lang.isEmpty(supplierContact.get(0).getdUserName()) && !Lang.isEmpty(supplierContact.get(0).getdVendorName())) {
                    return new StringBuffer(supplierContact.get(0).getdVendorName()).append("-").append(supplierContact.get(0).getdUserName()).toString();
                }
            }
        }
        return operatorId;
    }

    @Autowired
    CompanyRepos companyRepos;

    @Autowired
    DepartmentRepos departmentRepos;

    /**
     * 准备数据供前端左边区域显示组织结构
     * 2018.6.7 added by Aaron Li
     *
     * @return 组织结构数据
     */
    @Override
    public List<JsonModel> jsTree() {
        List<JsonModel> list = new ArrayList<>();
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("protocol:companyListTree");
        if (boundValueOperations.get() != null) {
            //缓存中获取直接返回
            list = (List<JsonModel>) boundValueOperations.get();
            return list;
        }
        //查询数据库
        List<CoreCompany> hq = companyRepos.findByIsDelete(false);

        List<String> compIds = Lang.grepList(hq, "id", "");
        List<CoreDepartment> allDeparts = getAllDepartment(compIds);

        for (int i = 0; i < hq.size(); i++) {
            if (Lang.isEmpty(hq.get(i).getParent())) {
                JsonModel jsonModel = new JsonModel();
                jsonModel.setId(hq.get(i).getId());
                jsonModel.setParent("#");
                jsonModel.setText(hq.get(i).getName());
                jsonModel.setIcon("false");
                jsonModel.setType1("company");
                list.add(jsonModel);

            } else {
                JsonModel jsonModel = new JsonModel();
                jsonModel.setId(hq.get(i).getId());
                jsonModel.setParent(hq.get(i).getParent().getId());
                jsonModel.setText(hq.get(i).getName());
                jsonModel.setType1("company");
                jsonModel.setIcon("false");
                list.add(jsonModel);
                // 插入部门
                generateDept(list, hq, i, allDeparts);
            }
        }

        boundValueOperations.set(list);
        return list;
    }

    public List<CoreDepartment> getAllDepartment(List<String> companyIds) {
        List<CoreDepartment> departmentList = new ArrayList<>();
        List<List<String>> compIdsPageable = new ArrayList<>();
        List<String> tmpCompIds = new ArrayList<>();
        compIdsPageable.add(tmpCompIds);
        for (String compId : companyIds) {
            if (tmpCompIds.size() < 1000) {
                tmpCompIds.add(compId);
            } else {
                tmpCompIds = new ArrayList<>();
                tmpCompIds.add(compId);
                compIdsPageable.add(tmpCompIds);
            }
        }
        for (List<String> idList : compIdsPageable) {
            List<CoreDepartment> tempDepList = departmentRepos.findAll(new Specification() {
                @Override
                public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
                    return cb.and(
                            root.join("coreCompany").get("id").in(idList),
                            cb.notEqual(root.get("isDelete"), true)
                    );
                }
            });
            departmentList.addAll(tempDepList);
        }
        if (Lang.isEmpty(departmentList)) {
            return null;
        }
        return departmentList;
    }

    //在company下插入部门
    private void generateDept(List<JsonModel> list, List<CoreCompany> hq, int i, List<CoreDepartment> allDeps) {
        // 插入部门
//        List<CoreDepartment> bm = departmentApi.findAllByCompanyIdAndIsDelete(hq.get(i).getId(),false);
        List<CoreDepartment> bm = new ArrayList<>();
        for (CoreDepartment d : allDeps) {
            if (d.getCoreCompany().getId().equals(hq.get(i).getId())) {
                bm.add(d);
            }
        }
        for (int j = 0; j < bm.size(); j++) {
            if (bm.get(j).getParent() == null) {
                JsonModel jsonModel1 = new JsonModel();
                jsonModel1.setId(bm.get(j).getId());
                jsonModel1.setParent(bm.get(j).getCoreCompany().getId());
                if ("2".equals(bm.get(j).getCoreCompany().getCompanyLevel().toString())) {
                    jsonModel1.setType1("department2");
                } else {
                    jsonModel1.setType1("department");
                }
                jsonModel1.setText(bm.get(j).getName());
                jsonModel1.setIcon("false");
                list.add(jsonModel1);
            } else {
                JsonModel jsonModel1 = new JsonModel();
                jsonModel1.setId(bm.get(j).getId());
                jsonModel1.setParent(bm.get(j).getParent().getId());
                jsonModel1.setText(bm.get(j).getName());
                jsonModel1.setType1("department");
                jsonModel1.setIcon("false");
                list.add(jsonModel1);
            }
        }
    }

    /**
     * 准备数据供前端左边区域显示组织结构
     * 2018.6.13 added by Aaron Li
     *
     * @param userId   用户id
     * @param roleCode 用户角色编码
     * @return
     */
    @Override
    public List<JsonModel> compJsTree(String userId, String roleCode) {

        List<JsonModel> companyTree = new ArrayList<>();
        List<JsonModel> list = new ArrayList<>();
        CoreCompDepartUserDto coreCompDepartUserDto = getCompDepartUserByUserIdAndRoleCode(userId, roleCode);
        if (null != coreCompDepartUserDto && !Lang.isEmpty(coreCompDepartUserDto.getCompanyId())) {

            String companyId = coreCompDepartUserDto.getCompanyId();
            Long startTime = System.currentTimeMillis();
            BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("protocol:companyListTree");
            if (boundValueOperations.get() != null) {
                //缓存中获取直接返回
                list = (List<JsonModel>) boundValueOperations.get();

                filterTree4FloatLayer(companyTree, list, companyId);

                Long t1 = System.currentTimeMillis();
                log.info("##竞价小组树查询使用缓存- 耗时 {}毫秒milliseconds##", t1 - startTime);

            } else {
                //查询数据库
                List<CoreCompanyDto> ccDTOs = coreCompanyApi.findByIsDelete(false);
                Long t2 = System.currentTimeMillis();
                log.info("##竞价小组左边树查询数据库- 耗时 {}毫秒milliseconds##", t2 - startTime);
                list = getListFromDTOs(ccDTOs);

                filterTree4FloatLayer(companyTree, list, companyId);

            }

        }

        return companyTree;

    }

    private List<JsonModel> getListFromDTOs(List<CoreCompanyDto> ccDTOs) {
        List<JsonModel> rtnList = new ArrayList<>();
        for (CoreCompanyDto tmpDto : ccDTOs) {
            if (Lang.isEmpty(tmpDto.getParent()) || tmpDto.getCompanyLevel() == 2) {
                if (tmpDto.getCompanyLevel() == 2) {
                    JsonModel jm = new JsonModel();
                    jm.setId(tmpDto.getId());
                    jm.setTpHrId(tmpDto.getTpHrId());
                    jm.setParent("#");
                    jm.setText(tmpDto.getName());
                    jm.setIcon("false");
                    jm.setType1("company");
                    rtnList.add(jm);
                }

            } else {

                JsonModel jsonModel = new JsonModel();
                jsonModel.setId(tmpDto.getId());
                jsonModel.setParent(tmpDto.getParent().getId());
                jsonModel.setTpHrId(tmpDto.getTpHrId());
                jsonModel.setText(tmpDto.getName());
                jsonModel.setType1("company");
                jsonModel.setIcon("false");
                rtnList.add(jsonModel);

            }

        }
        return rtnList;
    }

    private void filterTree4FloatLayer(List<JsonModel> companyTree, List<JsonModel> list, String companyId) {
        for (JsonModel jm : list) {
            if (companyId.equals(jm.getId())) {
                companyTree.add(jm);
            } else if (companyId.equals(jm.getParent())) {
                filterTree4FloatLayer(companyTree, list, jm.getId());
            }
        }
    }

    private CoreCompDepartUserDto getCompDepartUserByUserIdAndRoleCode(String userId, String roleCode) {
        CoreRoleDto crDto = coreRoleApi.findByCode(roleCode);
        CoreCompDepartUserDto coreCompDepartUserDto = new CoreCompDepartUserDto();
        if (!Lang.isEmpty(crDto) && !Lang.isEmpty(crDto.getId())) {
            coreCompDepartUserDto = coreCompDepartUserApi.findByUserIdAndRoleId(userId, crDto.getId(), false);
        }
        return coreCompDepartUserDto;
    }

    /**
     * 根据输入的查询条件 查询竞价成员信息列表
     *
     * @param jqueryDataTablesVo
     * @param selectedCompanyOrDepartmentId
     * @param nameLike
     * @param emailLike
     * @param isDelete
     * @param userId                        用户id
     * @param roleCode                      角色
     * @param pageable
     * @return 分页后的查询结果
     */
    @Override
    public Map getTechAuditorListBySearchCondition(JqueryDataTablesVo jqueryDataTablesVo, String selectedCompanyOrDepartmentName, String selectedCompanyOrDepartmentId, String nameLike, String emailLike, boolean isDelete, String userId, String roleCode, Pageable pageable) {
        Map returnModel = new HashMap();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        long totalElement = 0L;

        PageVo rtnTechAuditorPage;
        Long startTime = System.currentTimeMillis();

        int pageIndex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        pageable = new PageRequest(pageIndex, jqueryDataTablesVo.getiDisplayLength(), null);

        List<AuditorInfoVO> techAuditVOs = new ArrayList();

        //空和太平集团不可查询
        if (Lang.isEmpty(selectedCompanyOrDepartmentName)/* || TPJT.equals(selectedCompanyOrDepartmentName)*/) {
            returnModel.put("aaData", techAuditVOs);
            returnModel.put("iTotalRecords", totalElement);
            returnModel.put("iTotalDisplayRecords", totalElement);

            return returnModel;
        }

        //选定机构部门 的查询
        if (!Lang.isEmpty(selectedCompanyOrDepartmentId)) {

            CoreDepartmentDto coreDepartmentDto = coreDepartmentApi.getDepartmentInfo(selectedCompanyOrDepartmentId);
            if (!Lang.isEmpty(coreDepartmentDto)) {
                rtnTechAuditorPage = coreCompDepartUserApi.getPersonsByCondition(null, selectedCompanyOrDepartmentId, nameLike, emailLike, isDelete, pageable);
            } else {
                rtnTechAuditorPage = coreCompDepartUserApi.getPersonsByCondition(selectedCompanyOrDepartmentId, null, nameLike, emailLike, isDelete, pageable);
            }

        } else {

            rtnTechAuditorPage = coreCompDepartUserApi.getPersonsByCondition(null, null, nameLike, emailLike, isDelete, pageable);

        }

        Long endTime = System.currentTimeMillis();
        log.info("############竞价采购----竞价小组查询 耗时 {}################", endTime - startTime);

        if (!Lang.isEmpty(rtnTechAuditorPage)) {
            List<Map> list = rtnTechAuditorPage.getResult();
            for (Map map : list) {
                AuditorInfoVO aiVO = convertMap2AuditorInfoVO(map);
                techAuditVOs.add(aiVO);

            }
            totalElement = rtnTechAuditorPage.getTotalCount();
            returnModel.put("aaData", techAuditVOs);
            returnModel.put("iTotalRecords", totalElement);
            returnModel.put("iTotalDisplayRecords", totalElement);
        } else {

            returnModel.put("aaData", techAuditVOs);
            returnModel.put("iTotalRecords", totalElement);
            returnModel.put("iTotalDisplayRecords", totalElement);
        }

        return returnModel;
    }

    @Override
    public Boolean disJcbdBiddingGroup(String userId, List<JcbdBiddingGroupMemberVo> groupMemberVoList) {
        if (!Lang.isEmpty(userId)) {
            return false;
        }
        CoreUserDto userDto = coreUserApi.findById(userId);
        if (!Lang.isEmpty(userDto)) {
            String email = userDto.getEmail();
            if (!Lang.isEmpty(email)) {
                for (JcbdBiddingGroupMemberVo groupMemberVo : groupMemberVoList) {
                    if (!Lang.isEmpty(groupMemberVo)) {
                        String gEmail = groupMemberVo.getEmail();
                        if (!Lang.isEmpty(gEmail) && email.equals(gEmail)) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    private AuditorInfoVO convertMap2AuditorInfoVO(Map map) {

        AuditorInfoVO rtnVO = new AuditorInfoVO();
        if (!Lang.isEmpty(map)) {
            rtnVO.setId((String) map.get("ID"));
            rtnVO.setUsername((String) map.get("USERNAME"));
            rtnVO.setEmail((String) map.get("EMAIL"));
            rtnVO.setCompanyId((String) map.get("COMPANY_ID"));
            rtnVO.setCompanyCode((String) map.get("COMPANY_CODE"));
            rtnVO.setHrId((String) map.get("HR_ID"));
            rtnVO.setCompanyName((String) map.get("COMPANY_NAME"));
            rtnVO.setDepartmentId((String) map.get("DEPARTMENT_ID"));
            rtnVO.setDepartmentCode((String) map.get("DEPARTMENT_CODE"));
            rtnVO.setDepartmentName((String) map.get("DEPARTMENT_NAME"));
            rtnVO.setTechAuditorMemberId((String) map.get("MEMBERID"));

        }
        return rtnVO;
    }

    /**
     * 为选定的竞价小组成员 绑定权限
     *
     * @param memberId              会员Id
     * @param biddingSpliceStringId
     * @param roleCode              角色code
     */
    public void grantPermission4BiddingGroupMember(String memberId, String biddingSpliceStringId, String roleCode) {

        /**
         * 保存 角色会员关系表
         */
        MemberMenuRoleUserDto memberMenuRoleUserDto = new MemberMenuRoleUserDto();
        memberMenuRoleUserDto.setMemberId(memberId);
        MemberMenuRoleDto memberMenuRoleDto = null;
        memberMenuRoleDto = memberMenuRoleApi.findByRoleCode(roleCode);
        memberMenuRoleUserDto.setRoleId(memberMenuRoleDto.getId());
        memberMenuRoleApi.saveOrUpdateMenusByMemberIdAndRoleId(memberMenuRoleUserDto);
        /**
         * 保存 机构部门用户 关系表
         */
        CoreRoleDto crDto = coreRoleApi.findByCode(roleCode);

        if (!Lang.isEmpty(crDto)) {

            if (!Lang.isEmpty(biddingSpliceStringId)) {
                String[] strArr = biddingSpliceStringId.split(",");

                String userId = strArr[0];
                String companyId = strArr[2];
                String departmentId = strArr[3];

                CoreCompDepartUserDto ccduDto = coreCompDepartUserApi.findByUserIdAndRoleId(userId, crDto.getId(), false);

                if (Lang.isEmpty(ccduDto)) {
                    CoreCompDepartUserDto dto = new CoreCompDepartUserDto();
                    dto.setRoleId(crDto.getId());
                    dto.setUserId(userId);
                    dto.setCompanyId(companyId);
                    if (!Lang.isEmpty(departmentId)) {
                        dto.setDepartmentId(departmentId);
                    }
                    coreCompDepartUserApi.save(dto);
                }

            }

        }
    }


}
