package bidding.web.service.impl;

import api.query.*;
import bidding.web.service.BiddingOrderManagerService;
import bidding.web.vo.ImageVo;
import bidding.web.vo.JcbdMallOrderVo;
import bidding.web.vo.OrderAuditInfoVo;
import bidding.web.vo.QueryStatus;
import cart.api.OrderItemApi;
import cart.api.OrderMainApi;
import cart.api.OrderMainAttrApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainAttrDto;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOrderStatus;
import definition.BiddingRole;
import definition.MallAttachmentBusinessCode;
import definition.StatusOperateModule;
import dto.*;
import ma.glasnost.orika.MapperFacade;
import member.api.CoreCompDepartUserApi;
import member.api.dto.core.CoreCompDepartUserDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.*;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import query.BiddingOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.rpc.motan.ApiResponseVo;
import workflow.api.WorkFlowQueryApi;
import workflow.api.WorkFlowServiceApi;
import workflow.definition.AuditBusinessCode;
import workflow.dto.OrderAuditInfoDto;
import workflow.dto.WfWorkFlowLogDto;
import workflow.query.WorkFlowInfoQuery;
import workflow.vo.WorkFlowNodeVo;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

import static definition.BiddingRole.BIDDING_OPERATOR;

/**
 * @author luoxianwei
 * @date 2018/4/14
 */
@Service
public class BiddingOrderManagerServiceImpl implements BiddingOrderManagerService {

    public static final Logger log = LoggerFactory.getLogger(BiddingOrderManagerServiceImpl.class);

    @Autowired
    MapperFacade mapperFacade;

    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;

    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderManagerApi biddingOrderManagerApi;
    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;

    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;
    @MotanReferer
    OrderItemApi orderItemApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    OrderMainAttrApi orderMainAttrApi;
    @MotanReferer
    WorkFlowQueryApi workFlowQueryApi;
    @MotanReferer
    WorkFlowServiceApi workFlowServiceApi;
    @MotanReferer
    BiddingRoleOperationQueryApi biddingRoleOperationQueryApi;

    @Override
    public Map getBiddingOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingOrderManagerListQuery biddingOrderManagerListQuery, Pageable pageable) {
        Map returnModel = new HashMap(16);
        Long totalElement = 0L;
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        Page<BiddingOrderMangerDto> page = biddingOrderManagerApi.getBiddingOrderMangerList(biddingOrderManagerListQuery, pageable);
        List<BiddingOrderMangerDto> contentList = page.getContent();
        //联调时打开注释
        for (BiddingOrderMangerDto biddingOrderMangerDto : contentList) {
            //添加商品项数web层赋值
            //BigDecimal count = BigDecimal.ZERO;
            List<OrderItemDto> itemDtoList = orderItemApi.findByOrderNo(biddingOrderMangerDto.getOrderNo());
            if (itemDtoList != null) {
                // 注释原因 ：这里取商品项数，而不是商品总数量
//                for (OrderItemDto orderItemDto : itemDtoList) {
//                    count = count.add(BigDecimal.valueOf(orderItemDto.getCount()));
//                }
                biddingOrderMangerDto.setGoodsNumber(new BigDecimal(itemDtoList.size()));
            }
            //添加下单金额web层赋值
            BigDecimal singleAmount = BigDecimal.ZERO;
            OrderMainDto orderMainDto = orderMainApi.findByOrderNo(biddingOrderMangerDto.getOrderNo());
            if (orderMainDto != null) {
                singleAmount = orderMainDto.getSumPrice();
            }
            biddingOrderMangerDto.setSingleAmount(singleAmount);
        }
        totalElement = page.getTotalElements();
        returnModel.put("aaData", page.getContent());
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    @Override
    public List<QueryStatus> getAllStatus() {
        List<QueryStatus> allStatusList = new ArrayList<>();
        Map<String, BiddingOrderStatus> biddingOrderStatusMap = BiddingOrderStatus.biddingOrderStatusMap;
        for (String statusCode : biddingOrderStatusMap.keySet()) {
            QueryStatus queryStatus = new QueryStatus();
            queryStatus.setStatusCode(statusCode);
            BiddingOrderStatus biddingOrderStatus = biddingOrderStatusMap.get(statusCode);
            queryStatus.setStatusDescription(biddingOrderStatus.getDescription());
            allStatusList.add(queryStatus);
        }
        return allStatusList;
    }

    /**
     * 更新状态
     *
     * @param status
     * @param orderNo
     * @return
     */
    @Override
    public JcbdMallOrderVo updateStatusByOrderNo(String status, String orderNo) {
        JcbdMallOrderDto jcbdMallOrderDto = new JcbdMallOrderDto();
        ApiResponseVo apiResponseVo = orderMainApi.cancelOrder(orderNo, OrderMainApi.CancelOrderType.ERROR);
        if (apiResponseVo.getStatus().equals(GlobalContants.ResponseStatus.SUCCESS)) {
            jcbdMallOrderDto = biddingMallOrderQueryApi.updateStatusByOrderNo(status, orderNo);
            BaseResponse baseResponse = biddingOrderQueryApi.queryBiddingOrderNoByMallOrderNo(orderNo);
            BiddingOrderAffiliationDto biddingOrderAffiliationDto = biddingOrderQueryApi.checkIsBiddingOrder(baseResponse.getResult().toString());
            if (Lang.isEmpty(biddingOrderAffiliationDto.getOrderNos())) {
                biddingOrderQueryApi.updateStatus(baseResponse.getResult().toString(),BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode());
                workFlowServiceApi.cancelWorkFlow(baseResponse.getResult().toString());
            }
            //向购买记录表插入一条负记录
            cancelPurchaseLogOrder(orderNo);

        }
        return mapperFacade.map(jcbdMallOrderDto, JcbdMallOrderVo.class);
    }

    @Override
    public JcbdMallOrderVo deleteJcbdMallOrderByOrderNo(String orderNo) {
        JcbdMallOrderDto jcbdMallOrderDto = biddingMallOrderQueryApi.deleteJcbdMallOrderByOrderNo(orderNo);
        return mapperFacade.map(jcbdMallOrderDto, JcbdMallOrderVo.class);
    }


    @Override
    public void getFlowSteps(String orderNo, Map<String, Object> stringObjectMap) {
        WorkFlowInfoQuery workFlowInfoQuery = new WorkFlowInfoQuery();
        workFlowInfoQuery.setBusinessCode(AuditBusinessCode.BIDDING_ORDER_AUDIT.getBusinessCode());
        workFlowInfoQuery.setBusinessNo(orderNo);
        List<WfWorkFlowLogDto> workFlowLogs = workFlowQueryApi.findByWorkFlowInfoQuery(workFlowInfoQuery);
        if (!Lang.isEmpty(workFlowLogs)) {
            Collections.reverse(workFlowLogs);
            List<Map<String, Object>> flowSteps = getWorkFlowdWholeStepMaps(workFlowLogs);
            stringObjectMap.put("flowSteps", flowSteps);
        }
    }


    /**
     * 获取工作流过程
     *
     * @param workFlowLogs
     * @return
     */
    public List<Map<String, Object>> getWorkFlowdWholeStepMaps(List<WfWorkFlowLogDto> workFlowLogs) {
        List<Map<String, Object>> flowSteps = new ArrayList<>();
        int step = 0;
        Map<String, Object> steps = new HashMap<>();
        List<WorkFlowNodeVo> wholeFlowLog = null;
        String orderId = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<String> wholeFlowStrLog = null;
        if (workFlowLogs != null && !workFlowLogs.isEmpty()) {
            for (WfWorkFlowLogDto workFlowLog : workFlowLogs) {
                if (workFlowLog.getApplyForWorker()) {
                    if (step > 0) {
                        steps.put("currentStep", step);
                        flowSteps.add(steps);
                        steps = new HashMap<>();
                    }
                    step = 0;
//                wholeFlowLog = JSON.parseArray(workFlowLog.getWorkWholeFlow(), String.class);
                    wholeFlowLog = JSON.parseArray(workFlowLog.getWorkWholeFlow(), WorkFlowNodeVo.class);
                    Collections.reverse(wholeFlowLog);
                }
                String dateStr = "";
                Date updateDate = null;
                if (workFlowLog.getHandleTime() != null) {
                    updateDate = workFlowLog.getHandleTime();
                }
                if (step == 0) {
                    updateDate = workFlowLog.getDateCreated();
                }

                if (updateDate != null) {
                    dateStr = format.format(updateDate);
                } else {
                    dateStr = "";
                }

                String reason = workFlowLog.getReason() == null ? "" : workFlowLog.getReason();

                if (workFlowLog.getApplyForWorker()) {
                    reason = reason;
                } else if (workFlowLog.getWorkerId() == null) {
                    reason = "";
                } else if (workFlowLog.getStatus() == null) {
                    reason = "";
                } else if (workFlowLog.getStatus().equals(WfWorkFlowLogDto.check_order_status_pass)) {
                    if (reason == null || reason.trim().equals("")) {
                        reason = "无";
                    }
                    reason = "  审核通过  原因： " + reason;

                } else if (workFlowLog.getStatus().equals(WfWorkFlowLogDto.check_order_status_no_pass)) {
                    if (reason == null || reason.trim().equals("")) {
                        reason = "无";
                    }
                    reason = "  审核不通过  原因： " + reason;
                }
                if (workFlowLog == workFlowLogs.get(workFlowLogs.size() - 1)) {

                    if (workFlowLog.getOrderId() != null) {
                        orderId = workFlowLog.getOrderId();
                        OrderMainDto orderMain = orderMainApi.findById(orderId);
                        if (orderMain != null) {
                            if (orderMain.getStatus().equals(OrderMainDto.order_status_cancel)) {
                                reason = reason + "  采购员已取消订单 ";
                                dateStr = format.format(orderMain.getLastUpdated());
                            } else if (orderMain.getStatus().equals(OrderMainDto.order_status_outoftime_cancel)) {
                                reason = reason + "  审核超过7天，系统已取消订单 ";
                                dateStr = format.format(orderMain.getLastUpdated());
                            }
                        }
                    }
                }

                String style = "";
                if (!dateStr.equals("")) {
//                style = "padding-left: 140px;  margin-top: -25px;";
                }

                if (wholeFlowLog.size() - step - 1 >= 0) {
                    WorkFlowNodeVo node = wholeFlowLog.get(wholeFlowLog.size() - step - 1);
                    node.setRemark(" <div style=' " + style + " '>" + dateStr + node.getRemark() + " " + reason + "</div>");
                }

                step++;
            }

            wholeFlowStrLog = Lang.grepList(wholeFlowLog, "remark", "");
            steps.put("wholeFlowStep", wholeFlowStrLog);
            steps.put("currentStep", step);
            flowSteps.add(steps);
            Collections.reverse(flowSteps);
        }


        return flowSteps;
    }

    @Override
    public List<ImageVo> getOrderUploadFiles(String orderNo) {
        BaseResponse baseResponse = biddingOrderQueryApi.queryBiddingOrderNoByMallOrderNo(orderNo);
        BaseResponse<List<MallAttachmentDto>> mallOrderAttachmentsResponse = mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(baseResponse.getResult().toString(), MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getValue());
        List<MallAttachmentDto> mallAttachmentDtoList = mallOrderAttachmentsResponse.getResult();
        List<ImageVo> imageVos = new ArrayList<>();
        if (mallAttachmentDtoList != null && !mallAttachmentDtoList.isEmpty()) {
            mallAttachmentDtoList.forEach(mallAttachmentDto -> {
                ImageVo imageVo = new ImageVo();
                imageVo.setFilePath(mallAttachmentDto.getPath());
                imageVo.setSourceName(mallAttachmentDto.getAttachmentName());
                imageVos.add(imageVo);
            });
        }
        return imageVos;
    }

    @Override
    public OrderAuditInfoVo getBusinessWorkFlowInfo(String orderNo, String userId) {
        BaseResponse baseResponse = biddingOrderQueryApi.queryBiddingOrderNoByMallOrderNo(orderNo);
        WorkFlowInfoQuery workFlowInfoQuery = new WorkFlowInfoQuery();
        workFlowInfoQuery.setBusinessCode(AuditBusinessCode.BIDDING_ORDER_AUDIT.getBusinessCode());
        workFlowInfoQuery.setBusinessNo(baseResponse.getResult().toString());
        List<CoreCompDepartUserDto> compDepartUserDtos = coreCompDepartUserApi.findByUserId(userId);
        List<String> workerIds = new ArrayList<>();
        compDepartUserDtos.forEach(coreCompDepartUserDto -> workerIds.add(coreCompDepartUserDto.getId()));
//        workFlowInfoQuery.setWorkerIds(workerIds);
        OrderAuditInfoDto auditInfoDto = workFlowQueryApi.findByOrderAuditInfo(workFlowInfoQuery);
        if (auditInfoDto != null) {
            return BeanMapper.map(auditInfoDto, OrderAuditInfoVo.class);
        }
        return null;
    }

    @Override
    public BiddingOrderInfoDto getOrderInfoByOrderNo(String orderNo) {
        return biddingMallOrderQueryApi.getOrderInfoByOrderNo(orderNo);
    }

    @Override
    public List<JcbdRoleOperationDto> getOpertionByStatus(String status) {
        List<JcbdRoleOperationDto> operationDtos = biddingRoleOperationQueryApi.findByRoleCodeAndStatusAndModuleOrderByShowIndex(BiddingRole.BIDDING_OPERATOR, status, StatusOperateModule.BIDDING_ORDER_MANAGE.getCode());
        return operationDtos;
    }

    @Override
    public List<JcbdRoleOperationDto> getSuperlierOpertionByStatus(String status) {
        List<JcbdRoleOperationDto> operationDtos = biddingRoleOperationQueryApi.findByRoleCodeAndStatusAndModuleOrderByShowIndex(BiddingRole.BIDDING_SUPPLIER, status, StatusOperateModule.BIDDING_MANAGE_SUPPLIER.getCode());
        return operationDtos;
    }

    /**
     * 取消购买记录订单
     *
     * @param orderNo
     */
    @Override
    public void cancelPurchaseLogOrder(String orderNo) {
        biddingMallOrderQueryApi.cancelPurchaseLogOrder(orderNo);
    }
}
