package bidding.web.service.impl;

import api.query.*;
import bidding.web.service.BiddingOrderResultService;
import bidding.web.vo.BiddingOrderResultInfoVo;
import cart.api.OrderItemApi;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOrderStatus;
import dto.*;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import query.BiddingOrderManagerListQuery;
import query.BiddingOrderResultListQuery;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static definition.BiddingOrderStatus.ORDER_STATUS_COMPLETED;
import static definition.BiddingOrderStatus.ORDER_STATUS_TOBECONFIRMED;

/**
 * @author luoxianwei
 * @date 2018/4/14
 */
@Service
public class BiddingOrderResultServiceImpl implements BiddingOrderResultService {

    public static final Logger log = LoggerFactory.getLogger(BiddingOrderResultServiceImpl.class);

    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    BiddingDemandApi biddingDemandApi;
    @MotanReferer
    BiddingPurchaseLogApi biddingPurchaseLogApi;
    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;
    @MotanReferer
    BiddingOrderResultApi biddingOrderResultApi;
    @MotanReferer
    BiddingOrderManagerApi biddingOrderManagerApi;
    @MotanReferer
    OrderItemApi orderItemApi;
    @MotanReferer
    OrderMainApi orderMainApi;

    /**
     * 分页获取采购结果列表
     *
     * @param jqueryDataTablesVo
     * @param biddingOrderResultListQuery
     * @param pageable
     * @return
     */
    @Override
    public Map getBiddingOrderResultList(JqueryDataTablesVo jqueryDataTablesVo, BiddingOrderResultListQuery biddingOrderResultListQuery, Pageable pageable) {
        Map returnModel = new HashMap(16);
        Long totalElement = 0L;
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        Page<BiddingOrderResultDto> page = biddingOrderResultApi.getBiddingOrderResultList(biddingOrderResultListQuery, pageable);
        List<BiddingOrderResultDto> contentList = page.getContent();
        //联调时打开注释
        for (BiddingOrderResultDto biddingOrderResultDto : contentList) {
            //添加商品项数web层赋值
            BigDecimal count = BigDecimal.ZERO;
            List<OrderItemDto> itemDtoList = orderItemApi.findByOrderNo(biddingOrderResultDto.getOrderNo());
            if (itemDtoList != null) {
                for (OrderItemDto orderItemDto : itemDtoList) {
                    count = count.add(BigDecimal.valueOf(orderItemDto.getCount()));
                }
            }
            biddingOrderResultDto.setGoodsNumber(count);
            //添加下单金额web层赋值
            BigDecimal singleAmount = BigDecimal.ZERO;
            OrderMainDto orderMainDto = orderMainApi.findByOrderNo(biddingOrderResultDto.getOrderNo());
            if (orderMainDto != null) {
                singleAmount = orderMainDto.getSumPrice();
            }
            biddingOrderResultDto.setSingleAmount(singleAmount);
        }
        totalElement = page.getTotalElements();
        returnModel.put("aaData", page.getContent());
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    /**
     * 获得执行采购结果数据
     *
     * @param biddingCode
     * @return
     */
    @Override
    public BiddingOrderResultInfoVo getPurchaseResult(String biddingCode) {
        //总采购金额
        BigDecimal totalAmount = BigDecimal.ZERO;
        //总采购商品数
        BigDecimal totalNum = BigDecimal.ZERO;
        //共计下单数
        BigDecimal totalSingular = BigDecimal.ZERO;
        //成交下单数
        Integer singularNumber = 0;
        //取消订单
        Integer cancelOrder = 0;
        //未确定订单
        Integer noSingularNumber = 0;

        if (!Lang.isEmpty(biddingCode)) {
            List<JcbdOrderDto> jcbdOrderDtos = biddingOrderQueryApi.findByJcbdBiddingId(biddingCode);
            for (JcbdOrderDto jcbdOrderDto : jcbdOrderDtos) {
                List<JcbdMallOrderDto> jcbdMallOrders = jcbdOrderDto.getJcbdMallOrders();
                for (JcbdMallOrderDto jcbdMallOrder : jcbdMallOrders) {
                    //删除的，取消的，审核没通过的
                    if (!(jcbdMallOrder.getIsDelete() || jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode()) ||
                            jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_AUDITFAILURE.getCode()))){
                        if (jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_COMPLETED.getCode()) || jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_HAVEGOODS.getCode())) {
                            //成交下单数(已完成的，已收货的)
                            singularNumber = singularNumber + 1;
                        }

                        if (jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_TOBECONFIRMED.getCode())) {
                            //未确定订单(待确认的)
                            noSingularNumber = noSingularNumber + 1;
                        }
                        //总采购金额
                        totalAmount = totalAmount.add(jcbdOrderDto.getTotalMoney());
                        //共计下单数
                        totalSingular = totalSingular.add(BigDecimal.valueOf(1));
                        //总采购商品数
                        List<JcbdBiddingOrderItemDto> orderItems = jcbdMallOrder.getJcbdBiddingOrderItems();
                        for (JcbdBiddingOrderItemDto orderItem : orderItems) {
                            totalNum = totalNum.add(BigDecimal.valueOf(orderItem.getCount()));
                        }
                    }
//                    if (jcbdMallOrder.getIsDelete() || jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode()) ||
//                            jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_AUDITFAILURE.getCode())) {
//                    } else {
//                    }
                    if (!jcbdMallOrder.getIsDelete()&&jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode())) {
                        //取消订单(已取消的)
                        cancelOrder = cancelOrder + 1;
                    }
                }
            }
           /* //总采购商品数这种做法不用
            List<JcbdBiddingDemandDto> jcbdBiddingDemandDtoList = biddingDemandApi.findByJcbdBiddingIdAndIsDelete(biddingCode);
            for (JcbdBiddingDemandDto jcbdBiddingDemandDto : jcbdBiddingDemandDtoList) {
                List<JcbdBiddingPurchaseLogDto> purchaseLogDtoList = biddingPurchaseLogApi.findByJcbdBiddingDemandId(jcbdBiddingDemandDto.getId());
                for (JcbdBiddingPurchaseLogDto jcbdBiddingPurchaseLogDto : purchaseLogDtoList) {
                    totalNum = totalNum.add(BigDecimal.valueOf(jcbdBiddingPurchaseLogDto.getNumberBuy()));
                }
            }*/
        }
        return new BiddingOrderResultInfoVo(totalAmount, totalNum, totalSingular, singularNumber, noSingularNumber, cancelOrder);
    }

}