package bidding.web.service.impl;

import api.BiddingLogApi;
import api.BiddingMainApi;
import api.BiddingResponseApi;
import api.query.*;
import bidding.web.service.BiddingProviderService;
import bidding.web.vo.*;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.vo.TempOrderItemVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.*;
import dto.*;
import goods.api.GoodsApi;
import goods.dto.goods.ValidationSkuEffDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import message.MailModule;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.mail.vo.MailTemplateReq;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.*;
import query.BiddingDemandRespQuery;
import query.SupplierBiddingDamandQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import store.api.dto.modeldto.core.StoreDto;
import uninogift.api.protocol.TpCloudShieldApi;
import uninogift.api.protocol.TpCloudVerifyLogApi;
import uninogift.vo.protocol.outside.*;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.web.ResponseMapUtils;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;


/**
 * Created by miaohao on 2018/3/20.
 */
@Slf4j
@Service
public class BiddingProviderServiceImpl implements BiddingProviderService, DisposableBean {

    //响应结束
    static final String RESPONSE_END = "1";

    //存在不符合响应
    static final String RESPONSE_NOT_ACCORD = "2";

    public static final String BIDDING_SUPPLIER_TITILE_SHOW_MODULE = "BiddingSupplierShow";


    @MotanReferer
    BiddingRoleOperationQueryApi biddingRoleOperationQueryApi;
    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;
    @MotanReferer
    BiddingMainApi biddingMainApi;
    @MotanReferer
    BiddingDemandApi biddingDemandApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    BiddingResponseQueryApi biddingResponseQueryApi;
    @MotanReferer
    BiddingResponseApi biddingResponseApi;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    BiddingLogApi biddingLogApi;
    @MotanReferer
    OutsideProductApi outsideProductApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    MailApi mailApi;
    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;

    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;

    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;

    @Autowired
    BiddingOperatorServiceImpl biddingOperatorService;

    @MotanReferer
    TpCloudShieldApi tpCloudShieldApi;
    @MotanReferer
    TpCloudVerifyLogApi tpCloudVerifyLogApi;

    @Value("${spring.mail.username}")
    String mailFrom;

    @Value("${organization.code}")
    private String organiztionCode;



    ThreadPoolTaskExecutor threadPoolTaskExecutor;

    /**
     * 初始化线程池
     */ {
        threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(10);
        threadPoolTaskExecutor.setMaxPoolSize(100);
        threadPoolTaskExecutor.setQueueCapacity(2000);
        threadPoolTaskExecutor.setKeepAliveSeconds(60);
        threadPoolTaskExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
    }

    @Override
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String biddingMemberId, List<String> biddingMemberRoles, QueryBiddingRequestVO queryBiddingRequestVO) {
        Map returnModel = new HashMap();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        JcbdBiddingQueryDto biddingQueryDto = new JcbdBiddingQueryDto();
        biddingQueryDto.setJcbdBiddingNo(queryBiddingRequestVO.getJcbdBiddingNo());
        biddingQueryDto.setDescribe(queryBiddingRequestVO.getJcbdBiddingDescribe());
        if (!Lang.isEmpty(queryBiddingRequestVO.getState())) {
            if(BiddingStatus.SUPPLIER_RESPONSED.getValue().equals(queryBiddingRequestVO.getState())){
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.SUPPLIER_RESPONSE_YES.getValue(), BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue()));
            } else if (BiddingStatus.SUPPLIER_AUDIT_IN.getValue().equals(queryBiddingRequestVO.getState())) {
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue(), BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue()));
            } else if (BiddingStatus.SUPPLIER_BIDDING_DONE.equals(queryBiddingRequestVO.getState())) {
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.SUPPLIER_BIDDING_YES.getValue(), BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue()));
            } else {
                biddingQueryDto.setStates(Arrays.asList(queryBiddingRequestVO.getState()));
            }
        }
        if (!Lang.isEmpty(queryBiddingRequestVO.getStartTime())) {
            biddingQueryDto.setStartTime(DateUtils.toDate(queryBiddingRequestVO.getStartTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        }
        if (!Lang.isEmpty(queryBiddingRequestVO.getEndTime())) {
            biddingQueryDto.setEndTime(DateUtils.toDate(queryBiddingRequestVO.getEndTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        }
        if (!Lang.isEmpty(queryBiddingRequestVO.getStartTime2())) {
            biddingQueryDto.setStartTime2(DateUtils.toDate(queryBiddingRequestVO.getStartTime2(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        }
        if (!Lang.isEmpty(queryBiddingRequestVO.getEndTime2())) {
            biddingQueryDto.setEndTime2(DateUtils.toDate(queryBiddingRequestVO.getEndTime2(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        }
        biddingQueryDto.setRoles(biddingMemberRoles);
        biddingQueryDto.setProviderId(biddingMemberId);
        biddingQueryDto.setPageable(pageable);
        Long totalElement = 0L;
        Page<JcbdBiddingQueryResultDto> page = biddingMainQueryApi.supplierFindJcbdBiddingByParams(biddingQueryDto);
        List<BiddingResponseListVo> biddingResponseListVos = new ArrayList<>();
        if (!Lang.isEmpty(page)) {
            for (JcbdBiddingQueryResultDto jcbdBiddingQueryResultDto : page.getContent()) {
                BiddingResponseListVo biddingResponseListVo = new BiddingResponseListVo();
                mapperFacade.map(jcbdBiddingQueryResultDto, biddingResponseListVo);
                biddingResponseListVo.setStateName(BiddingStatus.biddingStatusMap.get(jcbdBiddingQueryResultDto.getState()).getDescription());
                biddingResponseListVo.setStartTime(DateUtils.toString(jcbdBiddingQueryResultDto.getStartTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
                biddingResponseListVo.setEndTime(DateUtils.toString(jcbdBiddingQueryResultDto.getEndTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
                if (!Lang.isEmpty(jcbdBiddingQueryResultDto.getOperations())) {
                    biddingResponseListVo.setOperations(mapperFacade.mapAsList(jcbdBiddingQueryResultDto.getOperations(), JcbdRoleOperationVo.class));
                }
                biddingResponseListVos.add(biddingResponseListVo);
            }
            totalElement = page.getTotalElements();
        }
        returnModel.put("aaData", biddingResponseListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    @Override
    public List<BiddingStatusVo> getAllStatusByRoles(List<String> biddingMemberRoles) {
        List<BiddingStatusVo> biddingStatusVos = new ArrayList<>();
        if (biddingMemberRoles.contains(BiddingRole.BIDDING_SUPPLIER)) {
            Map<String, BiddingStatus> stringBiddingStatusMap = BiddingRoleStatus.biddingRoleStatus.get(BiddingRole.BIDDING_SUPPLIER);
            Set<String> strings = stringBiddingStatusMap.keySet();
            strings.forEach(key -> {
                BiddingStatusVo biddingStatusVo = new BiddingStatusVo();
                biddingStatusVo.setStatus(key);
                biddingStatusVo.setStatusName(stringBiddingStatusMap.get(key).getDescription());
                biddingStatusVos.add(biddingStatusVo);
            });
        }

        return biddingStatusVos;
    }

    @Override
    public BiddingBaseInfoVo getBiddingDetail(String biddingCode) {
        BiddingBaseInfoVo biddingBaseInfoVo = new BiddingBaseInfoVo();
        BaseResponse<JcbdBiddingDto> biddingDtoBaseResponse = biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
        JcbdBiddingDto jcbdBiddingDto = biddingDtoBaseResponse.getResult();
        MemberVo memberInfo = memberApi.getMemberInfo(jcbdBiddingDto.getOperatorId());
        biddingBaseInfoVo.setId(jcbdBiddingDto.getId());
        biddingBaseInfoVo.setBiddingCode(jcbdBiddingDto.getBiddingCode());
        biddingBaseInfoVo.setStartTime(DateUtils.toString(jcbdBiddingDto.getTimeStartResponse(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        biddingBaseInfoVo.setEndTime(DateUtils.toString(jcbdBiddingDto.getTimeEndResponse(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        biddingBaseInfoVo.setUsername(memberInfo.getUser().getUsername());
        biddingBaseInfoVo.setPhone(memberInfo.getUser().getPhone());
        biddingBaseInfoVo.setEmail(memberInfo.getUser().getEmail());
        return biddingBaseInfoVo;
    }

    @Override
    public Map querryPageBiddingDemand(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, String supplierId) {
        Map returnModel = new HashMap();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.ASC,"demandCode"),
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        SupplierBiddingDamandQuery supplierBiddingDamandQuery = new SupplierBiddingDamandQuery();
        supplierBiddingDamandQuery.setBiddingCode(biddingCode);
        supplierBiddingDamandQuery.setSupplierId(supplierId);
        supplierBiddingDamandQuery.setPageable(pageable);
        BaseResponse<Page<BiddingResponseDemandOutlineDto>> pageBaseResponse = biddingResponseQueryApi.supplierBiddingResponseDemandOutline(supplierBiddingDamandQuery);
        if (!pageBaseResponse.isSuccess()) {
            return ResponseMapUtils.error(pageBaseResponse.getResultMessage());
        }
        Page<BiddingResponseDemandOutlineDto> page = pageBaseResponse.getResult();
        ArrayList<BiddingSupplierResposeListVo> supplierResposeListVos = new ArrayList<>();
        Long totalElement = 0L;
        if (!Lang.isEmpty(page.getContent())) {
            for (BiddingResponseDemandOutlineDto biddingDemandOutlineDto :/*biddingDemandList*/page.getContent()) {
                BiddingSupplierResposeListVo resposeListVo = mapperFacade.map(biddingDemandOutlineDto, BiddingSupplierResposeListVo.class);
                if (!Lang.isEmpty(biddingDemandOutlineDto.getRequiredDeliveryDate())) {
                    resposeListVo.setRequiredDeliveryDateTime(DateUtils.dateToStr(biddingDemandOutlineDto.getRequiredDeliveryDate(), GlobalContants.DateFormat.YYYY_MM_DD));
                }
                supplierResposeListVos.add(resposeListVo);
            }
            totalElement = Long.valueOf(page.getTotalElements());
        }
        returnModel.put("aaData", supplierResposeListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return ResponseMapUtils.success(returnModel);
    }

    @Override
    public BiddingDemandResponseVo getBiddingDemadDetail(String supplierId, String demandCode, String biddingNo) {
        BiddingDemandRespQuery biddingDemandRespQuery = new BiddingDemandRespQuery();
        biddingDemandRespQuery.setBiddingNo(biddingNo);
        biddingDemandRespQuery.setSupplierId(supplierId);
        biddingDemandRespQuery.setDemandCode(demandCode);
        BaseResponse<JcbdBiddingDemandResponseDto> biddingDemandResponseDtoResponse = biddingResponseQueryApi.queryBiddingDemandResponse(biddingDemandRespQuery);
        if (!biddingDemandResponseDtoResponse.isSuccess()) {
            log.info("竞价编号：{}需求编号：{}供应商id：{}获取需求响应失败：{}", biddingNo, demandCode, supplierId, biddingDemandResponseDtoResponse.getResultMessage());
            return null;
        }
        JcbdBiddingDemandResponseDto demandResponseDto = biddingDemandResponseDtoResponse.getResult();
        BiddingDemandResponseVo demandResponseVo = new BiddingDemandResponseVo();
        if (!Lang.isEmpty(demandResponseDto)) {
            demandResponseVo = mapperFacade.map(demandResponseDto, BiddingDemandResponseVo.class);
            BiddingDemandVo demandVo = new BiddingDemandVo();
            if (!Lang.isEmpty(demandResponseDto.getOfferValidity())) {
                demandResponseVo.setOfferValidityTime(DateUtils.dateToStr(demandResponseDto.getOfferValidity(), GlobalContants.DateFormat.YYYY_MM_DD));
            }
            if (!Lang.isEmpty(demandResponseDto.getJcbdBiddingDemand())) {
                demandVo = mapperFacade.map(demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
                if (!Lang.isEmpty(demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery())) {
                    demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr(demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery(), GlobalContants.DateFormat.YYYY_MM_DD));
                }
            }

            demandResponseVo.setBiddingDemand(demandVo);
            //查询附件
            if (!Lang.isEmpty(demandResponseDto.getId())){
                BaseResponse<List<MallAttachmentDto>> bidbaseBaseResponse = mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(demandResponseDto.getId(), MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue());
                if (bidbaseBaseResponse.isSuccess()) {
                    if (!Lang.isEmpty(bidbaseBaseResponse.getResult())) {
                        demandResponseVo.setAttachment(BeanMapper.mapList(bidbaseBaseResponse.getResult(), MallAttachmentDto.class, MallAttachmentVo.class));
                    }
                }
            }

            /*if (!Lang.isEmpty(demandResponseDto.getAttachment())){
                demandResponseVo.setAttachment(mapperFacade.mapAsList(demandResponseDto.getAttachment(),MallAttachmentVo.class));
            }*/
            if (!Lang.isEmpty(demandResponseDto.getJcbdProviderAddressResponses())) {
                demandResponseVo.setProviderAddressResponses(mapperFacade.mapAsList(demandResponseDto.getJcbdProviderAddressResponses(), JcbdProviderAddressResponseVo.class));
            }
            if (!Lang.isEmpty(demandResponseDto.getJcbdProviderConformanceResps())) {
                demandResponseVo.setProviderConformanceResps(mapperFacade.mapAsList(demandResponseDto.getJcbdProviderConformanceResps(), JcbdProviderConformanceRespVo.class));
            }
        }
        return demandResponseVo;
    }

    @Override
    public Map saveBiddingDemadResp(BiddingDemandResponseVo biddingDemandResponseVo, String supplierId) {
        BiddingDemandVo biddingDemand = biddingDemandResponseVo.getBiddingDemand();
        if (Lang.isEmpty(biddingDemand.getBiddingId())) {
            return ResponseMapUtils.error("获取竞价失败");
        }
        if (Lang.isEmpty(biddingDemand.getDemandCode())) {
            return ResponseMapUtils.error("获取竞价需求失败");
        }
        BaseResponse<JcbdBiddingDto> biddingDtoResponse = biddingMainQueryApi.findOne(biddingDemand.getBiddingId());
        if (!biddingDtoResponse.isSuccess()){
            return ResponseMapUtils.error("无此竞价");
        }
        if (System.currentTimeMillis()>biddingDtoResponse.getResult().getTimeEndResponse().getTime()){
            return ResponseMapUtils.error("竞价已经结束响应，不可响应",RESPONSE_END);
        }
        JcbdBiddingDemandResponseDto demandResponseDto = mapperFacade.map(biddingDemandResponseVo, JcbdBiddingDemandResponseDto.class);
        demandResponseDto.setStoreId(supplierId);
        demandResponseDto.setJcbdBiddingDemand(mapperFacade.map(biddingDemand, JcbdBiddingDemandDto.class));
        if (!Lang.isEmpty(biddingDemandResponseVo.getAttachment())) {
            List<MallAttachmentDto> mallAttachmentDtos = mapperFacade.mapAsList(biddingDemandResponseVo.getAttachment(), MallAttachmentDto.class);
            mallAttachmentDtos.forEach(mallAttachmentDto -> {
                mallAttachmentDto.setOrganizationCode("jicai");
                mallAttachmentDto.setBusinessCode(MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue());
                mallAttachmentDto.setBusinessDescription(BiddingOperateCode.RESPOND_BIDDING.getCodeName());
            });
            demandResponseDto.setAttachment(mallAttachmentDtos);
        }
        demandResponseDto.setJcbdProviderAddressResponses(mapperFacade.mapAsList(biddingDemandResponseVo.getProviderAddressResponses(), JcbdProviderAddressResponseDto.class));
        demandResponseDto.setJcbdProviderConformanceResps(mapperFacade.mapAsList(biddingDemandResponseVo.getProviderConformanceResps(), JcbdProviderConformanceRespDto.class));

        BaseResponse response = biddingResponseApi.updateBiddingDemandResponse(demandResponseDto);
        if (!response.isSuccess()) {
            return ResponseMapUtils.error("保存需求响应失败");
        }
        return ResponseMapUtils.success("");
    }

    @Override
    public Map checkIsAllRespond(String biddingCode, String supplierId) {
        BaseResponse baseResponse = biddingResponseQueryApi.isAllDemandAreResponse(biddingCode, supplierId);
        if (baseResponse.isSuccess()) {
            return ResponseMapUtils.success("");
        } else {
            return ResponseMapUtils.error("您还有未响应的需求，无法提交响应！");
        }
    }

    @Override
    public Map checkDemadIsAllAccord(String biddingCode, String supplierId) {
        JcbdBdProviderDto provider = biddingMainQueryApi.getProvider(biddingCode, supplierId);
        if(Lang.isEmpty(provider)) {
            return ResponseMapUtils.error("无此供应商");
        }
        BaseResponse baseResponse = biddingResponseQueryApi.demandResponseIsAllAccord(biddingCode, provider.getId());
        if (baseResponse.isSuccess()) {
            return ResponseMapUtils.success("");
        } else {
            return ResponseMapUtils.error("需求中的要求，您勾选了无法满足，这将造成您竞价结果失败，是否确认提交？",RESPONSE_NOT_ACCORD);
        }
    }

    @Override
    public Map submitResp(SupplierBiddingResponseVo supplierBiddingResponseVo, String userId, String supplierId) {
        BaseResponse<JcbdBiddingDto> biddingDtoResponse = biddingMainQueryApi.getBiddingByBiddingCode(supplierBiddingResponseVo.getJcbdBiddingNo());
        if (!biddingDtoResponse.isSuccess()){
            return ResponseMapUtils.error(biddingDtoResponse.getResultMessage());
        }
        if (System.currentTimeMillis()>biddingDtoResponse.getResult().getTimeEndResponse().getTime()){
            biddingMainApi.biddingResponseFinishValidate(biddingDtoResponse.getResult().getBiddingCode());
            return ResponseMapUtils.error("竞价已经结束响应，不可响应",RESPONSE_END);
        }
        supplierBiddingResponseVo.setProviderId(supplierId);
        supplierBiddingResponseVo.setContactsId(userId);
        SupplierBiddingResponseDto biddingResponseDto = mapperFacade.map(supplierBiddingResponseVo, SupplierBiddingResponseDto.class);
        if (!Lang.isEmpty(supplierBiddingResponseVo.getOfferValidityTime())) {
            biddingResponseDto.setOfferValidity(DateUtils.strToDate(supplierBiddingResponseVo.getOfferValidityTime(), GlobalContants.DateFormat.YYYY_MM_DD));
        }
        BaseResponse biddingResponse = biddingResponseApi.supplierBiddingResponse(biddingResponseDto);
        if (biddingResponse.isSuccess()) {
            // 保存太平云盾验证记录
            TpCloudVerifyLogDto tpCloudVerifyLogDto = new TpCloudVerifyLogDto();
            tpCloudVerifyLogDto.setOperateType(TpCloudVerifyLogDto.OPERATE_BIDDING_SUBMIT_REPONSE);
            tpCloudVerifyLogDto.setSignValue(supplierBiddingResponseVo.getSignValue());
            tpCloudVerifyLogDto.setSource(TpCloudVerifyLogDto.LOG_SOURCE_BIDING);
            tpCloudVerifyLogDto.setUserId(supplierId);
            tpCloudVerifyLogDto.setBusinessCode(supplierBiddingResponseVo.getJcbdBiddingNo());
            tpCloudVerifyLogApi.saveTpCloudVerifyLog(tpCloudVerifyLogDto);
            return ResponseMapUtils.success("");
        } else {
            return ResponseMapUtils.error(biddingResponse.getResultMessage());
        }
    }

    @Override
    public BaseResponse confirmOrder(String mallOrderNo) {
        String orderMainNo = null;
        try {
            long mallOrderTime = System.currentTimeMillis();
            JcbdMallOrderDto mallOrder = biddingMallOrderQueryApi.findByOrderNo(mallOrderNo);
            log.info("查询 MallOrder 耗时 {} ms", System.currentTimeMillis() - mallOrderTime);

            if (Lang.isEmpty(mallOrder)) {
                log.error("供应商确认订单失败, {} 供应商订单数据无效", mallOrderNo);
                return new BaseResponse<>("订单数据有误, 请确认订单 " + mallOrderNo);
            }

            orderMainNo = mallOrder.getOrderNo();
            if(Lang.isEmpty(orderMainNo)) {
                log.error("供应商确认订单失败, {} 供应商订单订单号为空", mallOrderNo);
                return new BaseResponse<>("订单数据有误, 请确认订单 " + mallOrderNo);
            }

            if (!BiddingOrderStatus.SUPPLIER_ORDER_STATUS_TOBECONFIRMED.getCode().equals(mallOrder.getSupplierOrderStatus())) {
                log.error("供应商确认订单失败, {} 供应商订单状态不是待确认", orderMainNo);
                return new BaseResponse<>("订单状态有误, 请确认订单 " + orderMainNo);
            }

            JcbdOrderDto order = biddingOrderQueryApi.findById(mallOrder.getJdbdOrderId());
            if (Lang.isEmpty(order)) {
                log.error("供应商确认订单失败, {} 竞价订单 Order 数据为空", orderMainNo);
                return new BaseResponse<>("订单数据有误, 请确认订单 " + orderMainNo);
            }

            String biddingCode = order.getJcbdBidding().getBiddingCode();
            if (Lang.isEmpty(biddingCode)) {
                log.error("供应商确认订单失败, {} 供应商订单对应的竞价编号为空", orderMainNo);
                return new BaseResponse<>("订单数据有误, 请确认订单 " + orderMainNo);
            }

            String storeId = mallOrder.getProviderId();
            if (Lang.isEmpty(storeId)) {
                log.error("供应商确认订单失败, {} 供应商订单对应的店铺ID为空", orderMainNo);
                return new BaseResponse<>("订单数据有误, 请确认订单 " + orderMainNo);
            }

            OrderMainDto orderMain = orderMainApi.findByOrderNo(orderMainNo);

            List<OrderItemDto> orderItems = orderMain.getOrderItems();

            if (Lang.isEmpty(orderItems)) {
                log.error("供应商确认订单失败, {} 订单 OrderItem 数据为空", orderMainNo);
                return new BaseResponse<>("订单数据有误, 请确认订单 " + orderMainNo);
            }

            if (orderItems.stream().filter(orderItem -> Lang.isEmpty(orderItem.getSku())).collect(Collectors.toList()).size() > 0) {
                log.error("供应商确认订单失败, {} 订单 OrderItem 中 sku 为空", orderMainNo);
                return new BaseResponse<>("订单数据有误, 请确认订单 " + orderMainNo);
            }

            List<FashionPriceParamVo> fashionPriceParamVos = new ArrayList<>();
            orderItems.forEach(n -> {
                FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
                fashionPriceParamVo.setFactionId(n.getProductFashId());
                fashionPriceParamVo.setProductCode(n.getSku());
                fashionPriceParamVos.add(fashionPriceParamVo);
            });

            FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();

            long addressTime = System.currentTimeMillis();
            MemberAddressDto addressDto = memberAddressApi.findById(orderMain.getAddressId());
            log.info("查询订单地址耗时 {} ms", System.currentTimeMillis() - addressTime);

            fashionPriceRequestVo.setProvinceCode(addressDto.getProvinceCode());
            fashionPriceRequestVo.setCityCode(addressDto.getCityCode());
            fashionPriceRequestVo.setCountyCode(addressDto.getAreaCode());
            fashionPriceRequestVo.setTownCode(addressDto.getTownCode());
            fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);

            long queryFashionPriceTime = System.currentTimeMillis();
            HandlerRespVo<List<FashionPriceVo>> listHandlerRespVo = outsideProductApi.queryFashionPrice(storeId, fashionPriceRequestVo);
            log.info("批量查询第三方价格耗时 {} ms", System.currentTimeMillis() - queryFashionPriceTime);

            //对比价格
            List<String> difSkuList = new ArrayList<>();
            List<FashionPriceVo> fashionPriceVos = listHandlerRespVo.getData();
            fashionPriceVos.forEach(m -> {
                for (OrderItemDto orderItemDto : orderItems) {
                    if (m.getFashionId().equals(orderItemDto.getProductFashId())) {
                        if (m.getSalePrice().compareTo(orderItemDto.getSalePrice()) != 0) {
                            difSkuList.add(orderItemDto.getSku());
                        }
                        break;
                    }
                }

            });

            if (difSkuList.size() > 0) {
                String message = "商品 " + difSkuList.get(0) + " 售价与报价不符, 请先调整商品的协议价格后再确认订单 " + orderMainNo;
                log.info(message);
                BaseResponse<String> baseResponse = new BaseResponse<>();
                baseResponse.setResultMessage(message);
                baseResponse.setResultCode("price");
                baseResponse.setResult(orderMainNo);
                return new BaseResponse<>(message);
            }

            //校验库存
            FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
            requetVo.setProvinceCode(addressDto.getProvinceCode());
            requetVo.setCityCode(addressDto.getCityCode());
            requetVo.setCountyCode(addressDto.getAreaCode());
            requetVo.setTownCode(addressDto.getTownCode());

            List<FashionNumsVo> fashionNums = new ArrayList<>();
            orderItems.forEach(m -> {
                FashionNumsVo fashionNumsVo = new FashionNumsVo(m.getProductFashId(), m.getSku(), new Long(m.getCount()));
                fashionNums.add(fashionNumsVo);
            });
            requetVo.setFashionNums(fashionNums);

            StoreDto store = new StoreDto();
            store.setId(storeId);

            long queryFashionStockStateTime = System.currentTimeMillis();
            HandlerRespVo<List<FashionStockStateVo>> fashionStockState = outsideProductApi.getFashionStockState(store, requetVo);
            log.info("批量查询第三方库存状态耗时 {} ms", System.currentTimeMillis() - queryFashionStockStateTime);

            //判断接口返回是否正常
            if (!HandlerRespVo.RESPONSE_STATUS_SUCCESS.equals(fashionStockState.getStatus())) {
                return new BaseResponse(fashionStockState.getMessage());
            }

            List<FashionStockStateVo> data = fashionStockState.getData();
            List<String> noStockAreaList = new ArrayList<>();
            //判断接口返回数据，是否有库存
            data.forEach(o -> {
                if (!o.getOnSale() || o.getStockFlag() != FashionStockStateVo.STOCK_FLAG_HAS_STOCK) {
                    difSkuList.add(o.getProductCode());
                    StringBuffer sb = new StringBuffer();
                    sb.append(addressDto.getProvinceName()).append(addressDto.getCityName())
                            .append(!Lang.isEmpty(addressDto.getAreaName()) ? addressDto.getAreaName() : "")
                            .append(!Lang.isEmpty(addressDto.getTownName()) ? addressDto.getTownName() : "");
                    noStockAreaList.add(sb.toString());
                }
            });
            if (difSkuList.size() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("商品 ").append(difSkuList.get(0)).append(" 在 ").append(noStockAreaList.get(0)).append(" 地区库存不足, 请先保证库存充足后再确认订单 ").append(orderMainNo);
                return new BaseResponse(sb.toString());
            }

            //判断运费是否一致
            List<TempOrderItemVo> tempOrderItemVoList = new ArrayList<>();
            orderItems.forEach(p -> {
                TempOrderItemVo tempOrderItemVo = new TempOrderItemVo();
                tempOrderItemVo.setProductFashionId(p.getProductFashId());
                tempOrderItemVo.setCount(p.getCount());
                tempOrderItemVo.setProductCode(p.getSku());
                tempOrderItemVoList.add(tempOrderItemVo);
            });


            long shippingFeeTime = System.currentTimeMillis();
            BigDecimal shippingFee = orderMainApi.queryShippingFee(storeId, tempOrderItemVoList, orderMain.getAddressId());
            log.info("查询第三方费率耗时 {} ms", System.currentTimeMillis() - shippingFeeTime);

            if (shippingFee.compareTo(orderMain.getFreight()) != 0) {
                //运费不一致，更新订单
                BigDecimal oldSumPrice = orderMain.getSumPrice();
                BigDecimal oldShippingFee = orderMain.getFreight();

                orderMain.setFreight(shippingFee);
                BigDecimal sumPrice = orderMain.getSumNofreightPrice().add(shippingFee);
                orderMain.setSumPrice(sumPrice);
                orderMainApi.save(orderMain);

                //给前端返回一个新的运费以便更新
                BiddingOrderInfoVo orderInfoVo = new BiddingOrderInfoVo();
                orderInfoVo.setOrderNo(orderMain.getOrderNo());
                orderInfoVo.setFreight(shippingFee.toString());
                orderInfoVo.setOrderAmount(sumPrice.toString());
                StringBuffer sb = new StringBuffer();
                sb.append("运费已重新获取，订单金额由 ").append(oldSumPrice).append("元变为 ").append(orderMain.getSumPrice()).append(" 元, 请确认订单 ").append(orderMainNo);

                long biddingTime = System.currentTimeMillis();
                BaseResponse<JcbdBiddingDto> biddingDtoResponse = biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
                log.info("查询竞价耗时 {} ms", System.currentTimeMillis() - biddingTime);

                // 价格有变动，发送邮件通知采购经办人
                sendSumPriceChangeMail(biddingDtoResponse.getResult(), orderMain, oldSumPrice, oldShippingFee);

                return new BaseResponse<>(false, sb.toString(), orderInfoVo);
            }

            // 预占库存
            Map<String, Object> preOccupyStockMap = orderMainApi.occupyStock(orderMain);
            log.info("预占库存响应: {}", JSON.toJSONString(preOccupyStockMap));
            if(!GlobalContants.ResponseStatus.SUCCESS.equals(preOccupyStockMap.get("returnCode"))) {
                log.error("供应商确认订单失败, 预占库存失败: {}", JSON.toJSONString(preOccupyStockMap));
                return new BaseResponse<>("预占库存失败, 请确认订单 " + orderMainNo);
            }

            // 确认预占库存
            orderMainApi.confirmOrder(orderMain.getOrderNo());

            long updateOrderStatusTime = System.currentTimeMillis();
            biddingMallOrderQueryApi.updateStatusAndSupplierStatus(mallOrderNo, BiddingOrderStatus.ORDER_STATUS_TOBERECEIVED.getCode(), BiddingOrderStatus.SUPPLIER_ORDER_STATUS_CONFIRMED.getCode());
            log.info("更新 MallOrder 状态耗时 {} ms", System.currentTimeMillis() - updateOrderStatusTime);

            long biddingTime = System.currentTimeMillis();
            BaseResponse<JcbdBiddingDto> biddingDtoResponse = biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
            log.info("查询竞价耗时 {} ms", System.currentTimeMillis() - biddingTime);

            //保存操作日志
            JcbdBiddingOperationLogDto logDto = new JcbdBiddingOperationLogDto();
            JcbdBiddingDto jcbdBiddingDto = biddingDtoResponse.getResult();
            logDto.setBiddingId(jcbdBiddingDto.getId());
            logDto.setOperationTime(new Date());
            logDto.setOperationContent("供应商确认订单");
            logDto.setOperatorName(order.getSupplierName());
            biddingLogApi.saveBiddingOperationLog(logDto);

            return new BaseResponse<>(true, "确认订单" + orderMainNo + "成功");
        } catch (Exception e) {
            log.error("供应商确认订单异常", e);
            return new BaseResponse<>("确认订单 " + (orderMainNo != null ? orderMainNo : mallOrderNo) + "遇到问题, 请联系管理员");
        }
    }

    @Override
    public BaseResponse batchConfirmOrder(List<BiddingOrderResultItemVo> orderResultItemVoList, String storeId, String memberId) {
        BaseResponse response = new BaseResponse();
        List<String> orderNoList = orderResultItemVoList.stream().map(BiddingOrderResultItemVo::getOrderNo).collect(Collectors.toList());
        //本订单对应的竞价号,所有订单应该都在一次竞价内，所以随意取一个索引则可
        String biddingCode = orderResultItemVoList.get(0).getBiddingCode();
        log.info("批量确认的订单号{}", orderNoList.toString());
        //获取所有订单dto
        List<OrderMainDto> orderMainDtoList = orderMainApi.findByOrderNos(orderNoList);
//        //获取所有订单下的订单物品
//        List<OrderItemDto> orderItemDtoList = orderMainDtoList.stream().map(OrderMainDto::getOrderItems).flatMap(x -> x.stream()).collect(Collectors.toList());

        //记录价格不同的商品sku号
        List<String> difSkuList = new ArrayList<>();
        //记录价格不同的订单号
        List<String> difOrderNoList = new ArrayList<>();
        //记录不同地区
        List<String> noStockAreaList = new ArrayList<>();
        //记录多线程出现异常的订单号
        List<String> exceptionOrderNoList = new ArrayList<>();

        try {
            CountDownLatch countDownLatch = new CountDownLatch(orderMainDtoList.size());
            for (int i = 0; i < orderMainDtoList.size(); i++) {
                OrderMainDto orderMainDto = orderMainDtoList.get(i);
                List<OrderItemDto> orderItems = orderMainDto.getOrderItems();
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        //校验商品价格
                        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
                        List<FashionPriceParamVo> fashionPriceParamVos = new ArrayList<>();
                        orderItems.forEach(n -> {
                            FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
                            fashionPriceParamVo.setFactionId(n.getProductFashId());
                            fashionPriceParamVo.setProductCode(n.getSku());
                            fashionPriceParamVos.add(fashionPriceParamVo);
                        });
                        MemberAddressDto addressDto = memberAddressApi.findDtoByIdAndIsDelete(orderMainDto.getAddressId(), false);
                        fashionPriceRequestVo.setProvinceCode(addressDto.getProvinceCode());
                        fashionPriceRequestVo.setCityCode(addressDto.getCityCode());
                        fashionPriceRequestVo.setCountyCode(addressDto.getAreaCode());
                        fashionPriceRequestVo.setTownCode(addressDto.getTownCode());
                        fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);

                        HandlerRespVo<List<FashionPriceVo>> listHandlerRespVo = outsideProductApi.queryFashionPrice(storeId, fashionPriceRequestVo);
                        //对比价格
                        List<FashionPriceVo> fashionPriceVos = listHandlerRespVo.getData();
                        fashionPriceVos.forEach(m -> {
                            for (OrderItemDto orderItemDto : orderItems) {
                                if (m.getFashionId().equals(orderItemDto.getProductFashId())) {
                                    if (m.getCostPrice().compareTo(orderItemDto.getCostPrice()) != 0) {
                                        difSkuList.add(orderItemDto.getSku());
                                        difOrderNoList.add(orderMainDto.getOrderNo());
                                    }
                                }
                            }
                        });

                        //校验库存
                        FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
                        requetVo.setProvinceCode(addressDto.getProvinceCode());
                        requetVo.setCityCode(addressDto.getCityCode());
                        requetVo.setCountyCode(addressDto.getAreaCode());
                        requetVo.setTownCode(addressDto.getTownCode());

                        List<FashionNumsVo> fashionNums = new ArrayList<>();
                        orderItems.forEach(m -> {
                            FashionNumsVo fashionNumsVo = new FashionNumsVo(m.getProductFashId(), m.getSku(), new Long(m.getCount()));
                            fashionNums.add(fashionNumsVo);
                        });
                        requetVo.setFashionNums(fashionNums);
                        StoreDto storeDto = new StoreDto();
                        storeDto.setId(orderMainDto.getStoreId());
                        HandlerRespVo<List<FashionStockStateVo>> fashionStockState = outsideProductApi.getFashionStockState(storeDto, requetVo);
                        //判断接口返回是否正常
                        if (!fashionStockState.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                            log.info("调用库存查询接口异常，订单号orderNO{}", orderMainDto.getOrderNo());
                        } else {
                            List<FashionStockStateVo> data = fashionStockState.getData();

                            //判断接口返回数据，是否有库存
                            data.forEach(o -> {
                                //o.getIsAreaRestrict()在原来接口已注释掉，这里则不作判定
                                if (!o.getOnSale() || o.getStockFlag() != FashionStockStateVo.STOCK_FLAG_HAS_STOCK) {
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("【商品").append(o.getProductCode()).append("】");
                                    sb.append(addressDto.getProvinceName()).append(addressDto.getCityName())
                                            .append(!Lang.isEmpty(addressDto.getAreaName()) ? addressDto.getAreaName() : "")
                                            .append(!Lang.isEmpty(addressDto.getTownName()) ? addressDto.getTownName() : "")
                                            .append("地区");
                                    noStockAreaList.add(sb.toString());
                                }
                            });
                        }
                    } catch (Exception e) {
                        log.error("确认订单前的报价校验出错，订单号{}", orderMainDto.getOrderNo(), e);
                        exceptionOrderNoList.add(orderMainDto.getOrderNo());
                    } finally {
                        countDownLatch.countDown();
                    }
                });
            }
            countDownLatch.await();
            //先判定多线程中是否出现异常
            if (exceptionOrderNoList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                sb.append("订单号");
                for (String orderNo : exceptionOrderNoList) {
                    sb.append(orderNo).append(",");
                }
                sb.append("校验出现异常，请联系管理员");
                response.setResultMessage(sb.toString());
                return response;
            }
            if (difSkuList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                for (String sku : difSkuList) {
                    sb.append("【商品").append(sku).append("】");
                }
                sb.append("售价与报价不符，请先调整商品的协议价格后再确认");
                for (int i = 0; i < difOrderNoList.size(); i++) {
                    sb.append("订单").append(difOrderNoList.get(i));
                    if (i != difOrderNoList.size() - 1) {
                        sb.append(",");
                    } else {
                        sb.append("。");
                    }
                }
                response.setResultMessage(sb.toString());
                return response;
            }
            if (noStockAreaList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < noStockAreaList.size(); i++) {
                    sb.append(noStockAreaList.get(i)).append(",");
                }
                sb.append("库存不足，\r\n请先保证库存充足后再确认订单");
                response.setResultMessage(sb.toString());
                return response;
            }
        } catch (Exception e) {
            log.error("确认订单，报价校验期间出错", e);
            response.setSuccess(false);
            response.setResultMessage("系统出现异常，请稍后再试");
            return response;
        }

        //校验运费
        //运费可能出现更新表，发送邮件操作，避免出现前台展示过多校验信息，因此单独校验
        try {
            CountDownLatch countDownLatch2 = new CountDownLatch(orderMainDtoList.size());
            List<BiddingOrderInfoVo> orderUpdateVoList = new ArrayList<>();
            List<StringBuffer> infoList = new ArrayList<>();
            orderMainDtoList.forEach(om -> {
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        //判断运费是否一致
                        List<TempOrderItemVo> tempOrderItemVoList = new ArrayList<>();
                        om.getOrderItems().forEach(p -> {
                            TempOrderItemVo tempOrderItemVo = new TempOrderItemVo();
                            tempOrderItemVo.setProductFashionId(p.getProductFashId());
                            tempOrderItemVo.setCount(p.getCount());
                            tempOrderItemVoList.add(tempOrderItemVo);
                        });
                        BigDecimal shippingFee = orderMainApi.queryShippingFee(storeId, tempOrderItemVoList, om.getAddressId());
                        if (shippingFee.compareTo(om.getFreight()) != 0) {
                            //运费不一致，更新订单
                            BigDecimal oldSumPrice = om.getSumPrice();
                            BigDecimal oldFreight = om.getFreight();

                            om.setFreight(shippingFee);
                            BigDecimal sumPrice = om.getSumNofreightPrice().add(shippingFee);
                            om.setSumPrice(sumPrice);
                            orderMainApi.save(om);
                            //记录有运费变更
                            StringBuffer sb = new StringBuffer();
                            sb.append("运费已重新获取，订单金额由").append(oldSumPrice).append("元变为").append(om.getSumPrice()).append("元");
                            infoList.add(sb);

                            //给前端返回一个新的运费以便更新
                            BiddingOrderInfoVo orderInfoVo = new BiddingOrderInfoVo();
                            orderInfoVo.setOrderNo(om.getOrderNo());
                            orderInfoVo.setFreight(shippingFee.toString());
                            orderInfoVo.setOrderAmount(sumPrice.toString());
                            orderUpdateVoList.add(orderInfoVo);
                            //发送邮件
                            sendSumPriceChangeMail(biddingCode, om, oldSumPrice, oldFreight);
                        }
                    } catch (Exception e) {
                        log.error("确认订单前的运费校验出错，订单号{}", om.getOrderNo(), e);
                        exceptionOrderNoList.add(om.getOrderNo());
                    } finally {
                        countDownLatch2.countDown();
                    }
                });
            });
            countDownLatch2.await();
            //先判定多线程中是否出现异常
            if (exceptionOrderNoList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                sb.append("订单号");
                for (String orderNo : exceptionOrderNoList) {
                    sb.append(orderNo).append(",");
                }
                sb.append("校验出现异常，请联系管理员");
                response.setResultMessage(sb.toString());
                return response;
            }
            //判断是否有运费更新
            if (infoList.size() > 0) {
                response.setSuccess(false);
                StringBuffer strBuffer = new StringBuffer();
                for (StringBuffer sb : infoList) {
                    strBuffer.append(sb).append("\r\n");
                }
                response.setResultMessage(strBuffer.toString());
                response.setResult(orderUpdateVoList);//记录更新费用的VO
                return response;
            }

        } catch (Exception e) {
            log.error("确认订单，运费校验期间出错", e);
            response.setSuccess(false);
            response.setResultMessage("系统出现异常，请稍后再试");
            return response;
        }

        //以上校验通过后，更新订单状态
        List<String> orderMainIds = orderMainDtoList.stream().map(OrderMainDto::getId).collect(Collectors.toList());

        /*BaseResponse baseResponse = biddingMainApi.updateOrderStatus(orderMainIds, orderNoList, OrderMainDto.order_status_ounfilled);
        //保存操作日志
        if (baseResponse.isSuccess()) {
            List<JcbdBiddingOperationLogDto> logDtoList = new ArrayList<>();
            BaseResponse<JcbdBiddingDto> biddingDtoResponse = biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
            JcbdBiddingDto jcbdBiddingDto = biddingDtoResponse.getResult();
            MemberDto memberDto = memberApi.findMemberById(memberId);
            String userName = memberDto.getCoreUser().getUsername();
            String biddingId = jcbdBiddingDto.getId();

            List<OrderMainDto> orderMainDtosSaved = (List<OrderMainDto>) baseResponse.getResult();
            orderMainDtosSaved.forEach(n -> {
                JcbdBiddingOperationLogDto logDto = new JcbdBiddingOperationLogDto();
                logDto.setBiddingId(biddingId);
                logDto.setOperationTime(new Date());
                logDto.setOperationContent("确认订单");
                logDto.setOperatorName(userName);
                logDtoList.add(logDto);
            });
            biddingLogApi.saveBiddingOperationLogs(logDtoList);
            response.setSuccess(true);
            //判断多少张订单成功，多少张失败。
            //理论上，只能全部成功或全部失败
            if (orderResultItemVoList.size() != orderMainDtosSaved.size()) {
                response.setResultMessage(new StringBuffer().append(orderMainDtosSaved.size()).append(" 张订单确认成功，")
                        .append(orderResultItemVoList.size() - orderMainDtosSaved.size()).append(" 张订单确认失败").toString());
            } else {
                response.setResultMessage(new StringBuffer().append(orderMainDtosSaved.size()).append(" 张订单确认成功，0 张订单确认失败").toString());
            }
        } else {
            response.setSuccess(false);
            response.setResultMessage("确认订单失败");

        }*/
        return response;
    }

    private void sendSumPriceChangeMail(JcbdBiddingDto bidding, OrderMainDto orderMain, BigDecimal oldSumPrice, BigDecimal oldFreight) {
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        // 采购经办人
        MemberDto buyerMemberDto = memberApi.findMemberById(bidding.getOperatorId());
        mailReq.setTo(new String[]{buyerMemberDto.getCoreUser().getEmail()});
        mailReq.setFrom(mailFrom);
        mailReq.setSentDate(new Date());
        mailReq.setChannel(MailReq.CHANNEL_JC);
        mailTemplateReq.setMailReq(mailReq);
        mailTemplateReq.setTemplateCode(MailTemplateEnum.PRICE_CHANGED_AFTER_ORDER_CONFIRMED.getTemplateCode());
        List<String> subjectArgs = new ArrayList<>();
        //竞价编号
        subjectArgs.add(bidding.getBiddingCode());
        //共2个参数
        List<String> contextArgs = new ArrayList<>();
        StringBuilder mailStr = new StringBuilder();
        mailStr.append(!Lang.isEmpty(buyerMemberDto.getCoreUser().getUsername()) ? buyerMemberDto.getCoreUser().getUsername() : buyerMemberDto.getCoreUser().getEmail());
        mailStr.append(",您好！\r\n");
        mailStr.append("    您在集团集采网上商城商城竞价【竞价编号】提交的订单，在供应商确认订单时发生了价格变动：\r\n");
        mailStr.append("    【订单号 ").append(orderMain.getOrderNo()).append(" 】价格由 ").append(oldSumPrice.setScale(2))
                .append(" 元变更为 ").append(orderMain.getSumPrice().setScale(2)).append("元 \r\n");
        mailStr.append("运费由 ").append(oldFreight.setScale(2)).append(" 元变更为 ").append(orderMain.getFreight().setScale(2)).append(" 元");
        contextArgs.add(mailStr.toString());

        mailTemplateReq.setSubjectArgList(subjectArgs);
        mailTemplateReq.setContentArgList(contextArgs);
        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());

        log.info("发送邮件请求 : {}", JSON.toJSONString(mailTemplateReq));

        MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);
        log.info("供应商邮件发送响应 : {}", JSON.toJSONString(mailReq));
    }

    @Deprecated
    private void sendSumPriceChangeMail(String biddingCode, OrderMainDto orderMainDto, BigDecimal oldSumPrice, BigDecimal oldFreight) {
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        MemberDto buyerMemberDto = memberApi.findMemberById(orderMainDto.getMemberId());
        mailReq.setTo(new String[]{buyerMemberDto.getCoreUser().getEmail()});
        mailReq.setFrom(mailFrom);
        mailReq.setSentDate(new Date());
        mailReq.setChannel(MailReq.CHANNEL_JC);
        mailTemplateReq.setMailReq(mailReq);
        mailTemplateReq.setTemplateCode(MailTemplateEnum.PRICE_CHANGED_AFTER_ORDER_CONFIRMED.getTemplateCode());
        List<String> subjectArgs = new ArrayList<>();
        //竞价编号
        subjectArgs.add(biddingCode);
        //共2个参数
        List<String> contextArgs = new ArrayList<>();
        StringBuilder mailStr = new StringBuilder();
        mailStr.append(!Lang.isEmpty(buyerMemberDto.getCoreUser().getUsername()) ? buyerMemberDto.getCoreUser().getUsername() : buyerMemberDto.getCoreUser().getEmail());
        mailStr.append(",您好！\r\n");
        mailStr.append("    您在集团集采网上商城商城竞价【竞价编号】提交的订单，在供应商确认订单时发生了价格变动：\r\n");
        mailStr.append("    【订单号 ").append(orderMainDto.getOrderNo()).append(" 】价格由 ").append(oldSumPrice.setScale(2))
                .append(" 元变更为 ").append(orderMainDto.getSumPrice().setScale(2)).append("元 \r\n");
        mailStr.append("运费由 ").append(oldFreight.setScale(2)).append(" 元变更为 ").append(orderMainDto.getFreight().setScale(2)).append(" 元");
        contextArgs.add(mailStr.toString());

        mailTemplateReq.setSubjectArgList(subjectArgs);
        mailTemplateReq.setContentArgList(contextArgs);
        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
        MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);
        log.info("供应商邮件发送响应 : {}", JSON.toJSONString(mailReq));
    }

    @Override
    public Map sureResult(String biddingCode,String signValue,String supplierId) {
        List<JcbdBiddingDemandDto> biddingDemands = biddingDemandApi.findByJcbdBiddingCodeAndIsDelete(biddingCode);
        List<String> skus = biddingResponseQueryApi.findBiddingResponseSkus(biddingCode, supplierId);
        ValidationSkuEffDto skuValidity = goodsApi.findSkuValidity(skus, supplierId);
        BiddingChangeStateDto changeStateDto = new BiddingChangeStateDto();
        BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
        if (biddingDemands.size() != skus.size() || !skuValidity.isAllEffective()) {
            //sku校验不通过
            changeStateDto.setBiddingNo(biddingCode);
            changeStateDto.setCurrentState(BiddingStatus.OM_RESULT_CONFIRM_WAIT.getValue());
            changeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_NO.getCode());
            BiddingStateResponseDto stateResponseDto = biddingMainApi.changeBiddingState(changeStateDto);
            if (!BiddingStatus.OM_SKU_MAKEUP_WAIT.getValue().equals(stateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("状态变更错误");
            }
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_NO.getCode());
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_BIDDING_YES.getValue());
            BiddingStateResponseDto biddingStatusChange = biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue().equals(biddingStatusChange.getBiddingState())) {
                return ResponseMapUtils.error("供应商状态变更错误");
            }
        } else {
            changeStateDto.setBiddingNo(biddingCode);
            changeStateDto.setCurrentState(BiddingStatus.OM_RESULT_CONFIRM_WAIT.getValue());
            changeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_YES.getCode());
            BiddingStateResponseDto stateResponseDto = biddingMainApi.changeBiddingState(changeStateDto);
            if (!BiddingStatus.OM_DO_BUY.getValue().equals(stateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("状态变更错误");
            }
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_YES.getCode());
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_BIDDING_YES.getValue());
            BiddingStateResponseDto biddingStatusChange = biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue().equals(biddingStatusChange.getBiddingState())) {
                return ResponseMapUtils.error("供应商状态变更错误");
            }
        }
        // 保存验证日志
        TpCloudVerifyLogDto tpCloudVerifyLogDto = new TpCloudVerifyLogDto();
        tpCloudVerifyLogDto.setBusinessCode(biddingCode);
        tpCloudVerifyLogDto.setUserId(supplierId);
        tpCloudVerifyLogDto.setSource(TpCloudVerifyLogDto.LOG_SOURCE_BIDING);
        tpCloudVerifyLogDto.setSignValue(signValue);
        tpCloudVerifyLogDto.setOperateType(TpCloudVerifyLogDto.OPERATE_BIDDING_SURE_RESULT);
        tpCloudVerifyLogApi.saveTpCloudVerifyLog(tpCloudVerifyLogDto);
        //发送邮件
        try {
            MailTemplateReq mailTemplateReq = new MailTemplateReq();
            MailReq mailReq = new MailReq();
            BiddingBaseInfoVo biddingDetail = getBiddingDetail(biddingCode);
            mailReq.setTo(new String[]{biddingDetail.getEmail()});
            mailReq.setFrom(mailFrom);
            mailReq.setSentDate(new Date());
            mailReq.setChannel(MailReq.CHANNEL_JC);
            mailTemplateReq.setTemplateCode(MailTemplateEnum.SUPPLIER_CONFIRM_BIDRESULT.getTemplateCode());
            List<String> subjectArgs = new ArrayList<>();
            //竞价编号
            subjectArgs.add(biddingDetail.getBiddingCode());
            //共2个参数
            List<String> contextArgs = new ArrayList<>();
            contextArgs.add(biddingDetail.getUsername());
            contextArgs.add(biddingDetail.getBiddingCode());
            mailTemplateReq.setSubjectArgList(subjectArgs);
            mailTemplateReq.setContentArgList(contextArgs);
            mailTemplateReq.setMailReq(mailReq);
            mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
            mailApi.sendMailByTemplate(mailTemplateReq);
        }catch (Exception e){
            log.error("竞价{}的确认竞价结果邮件通知经办人失败", biddingCode, e);
        }
        return ResponseMapUtils.success(biddingCode);
    }

    @Override
    public Map querryPageSku(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, String supplierId) {
        Map returnModel = new HashMap();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.ASC,"demandCode"),
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        DemanResponseParmDto demanResponseParmDto = new DemanResponseParmDto();
        demanResponseParmDto.setBiddingNo(biddingCode);
        demanResponseParmDto.setProviderId(supplierId);
        demanResponseParmDto.setPageable(pageable);
        Page<DemandResponseQueryDto> demandResponsePage = biddingResponseQueryApi.findDemandAndResponse(demanResponseParmDto);
        Long totalElement = 0L;
        List<DemandResponseQueryVo> demandResponseQueryVos = new ArrayList<>();
        if (!Lang.isEmpty(demandResponsePage)) {
            demandResponseQueryVos = mapperFacade.mapAsList(demandResponsePage.getContent(), DemandResponseQueryVo.class);
            totalElement = demandResponsePage.getTotalElements();
        }
        returnModel.put("aaData", demandResponseQueryVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return ResponseMapUtils.success(returnModel);
    }

    @Override
    public Map updateSku(UpdateSkuVo updateSkuVo, String supplierId, String loginId) {
        UpdateSkuDto skuDto = mapperFacade.map(updateSkuVo, UpdateSkuDto.class);
        skuDto.setProviderId(supplierId);
        String operatorName = biddingOperatorService.getOperatorName(loginId);
        skuDto.setOperatorName(operatorName);
        BaseResponse baseResponse = biddingResponseApi.updateBiddingDemandResponseSku(skuDto);
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error("更新sku失败");
        }
        return ResponseMapUtils.success("");
    }

    @Override
    public Map submitSkuAudit(String biddingCode, String supplierId) {
        //验证是否所有需求均补录了商品编码
        List<JcbdBiddingDemandDto> biddingDemands = biddingDemandApi.findByJcbdBiddingCodeAndIsDelete(biddingCode);
        List<String> skus = biddingResponseQueryApi.findBiddingResponseSkus(biddingCode, supplierId);
        if (biddingDemands.size() != skus.size()) {
            return ResponseMapUtils.error("您有需求未填写商品编码，请补录！");
        }
        //验证所有商品编码所代表的商品是否存在于商品池中
        ValidationSkuEffDto skuValidity = goodsApi.findSkuValidity(skus, supplierId);
        if (!skuValidity.isAllEffective()) {
            StringBuilder notSkus = new StringBuilder();
            skuValidity.getSkuAndUrlDtos().forEach(skuAndUrlDto -> {
                if (Lang.isEmpty(skuAndUrlDto.getUrl())) {
                    notSkus.append(skuAndUrlDto.getSku()).append("、");
                }
            });
            notSkus.deleteCharAt(notSkus.length() - 1);
            return ResponseMapUtils.error("您录的商品" + notSkus.toString() + "还未同步到商品池中，请同步到商品池中后再编辑商品编码！");
        }
        JcbdBdProviderDto supplier = biddingMainQueryApi.getProvider(biddingCode, supplierId);
        if (Lang.isEmpty(supplier)) {
            return ResponseMapUtils.error("您不是该竞价的供应商");
        }

        if (BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue().equals(supplier.getStatus())) {
            //第一次提交sku审核

            //更新竞价状态
            BiddingChangeStateDto operaChangeState = new BiddingChangeStateDto();
            operaChangeState.setBiddingNo(biddingCode);
            operaChangeState.setCurrentState(BiddingStatus.OM_SKU_MAKEUP_WAIT.getValue());
            operaChangeState.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            BiddingStateResponseDto operaBiddingStateResponseDto = biddingMainApi.changeBiddingState(operaChangeState);
            if (!operaBiddingStateResponseDto.isSuccess() || !BiddingStatus.OM_SKU_AUDIT_WAIT.getValue().equals(operaBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("更新竞价状态失败");
            }
            //更新供应商竞价状态
            BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue());
            BiddingStateResponseDto supplierBiddingStateResponseDto = biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!supplierBiddingStateResponseDto.isSuccess() || !BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(supplierBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("更新供应商竞价状态失败");
            }
        } else if (BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue().equals(supplier.getStatus())) {
            //再次提交sku审核
            //更新竞价状态
            BiddingChangeStateDto operaChangeState = new BiddingChangeStateDto();
            operaChangeState.setBiddingNo(biddingCode);
            operaChangeState.setCurrentState(BiddingStatus.OM_DO_BUY.getValue());
            operaChangeState.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            BiddingStateResponseDto operaBiddingStateResponseDto = biddingMainApi.changeBiddingState(operaChangeState);
            if (!operaBiddingStateResponseDto.isSuccess() || !BiddingStatus.OM_SKU_AUDIT_WAIT.getValue().equals(operaBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("更新竞价状态失败");
            }
            //更新供应商竞价状态
            BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue());
            BiddingStateResponseDto supplierBiddingStateResponseDto = biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!supplierBiddingStateResponseDto.isSuccess() || !BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(supplierBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("更新供应商竞价状态失败");
            }
        } else if (BiddingStatus.SUPPLIER_SKU_AUDIT_NOT.getValue().equals(supplier.getStatus())){
            //sku审核不通过
            //更新竞价状态
            BiddingChangeStateDto operaChangeState = new BiddingChangeStateDto();
            operaChangeState.setBiddingNo(biddingCode);
            operaChangeState.setCurrentState(BiddingStatus.OM_SKU_AUDIT_NOT.getValue());
            operaChangeState.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            BiddingStateResponseDto operaBiddingStateResponseDto = biddingMainApi.changeBiddingState(operaChangeState);
            if (!operaBiddingStateResponseDto.isSuccess() || !BiddingStatus.OM_SKU_AUDIT_WAIT.getValue().equals(operaBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("更新竞价状态失败");
            }
            //更新供应商竞价状态
            BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_SKU_AUDIT_NOT.getValue());
            BiddingStateResponseDto supplierBiddingStateResponseDto = biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!supplierBiddingStateResponseDto.isSuccess() || !BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(supplierBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error("更新供应商竞价状态失败");
            }
        } else {
            return ResponseMapUtils.error("数据异常");
        }
        //更改是否修改sku标记
        BaseResponse baseResponse = biddingResponseApi.supplierInitModifySku(biddingCode, supplierId);
        return ResponseMapUtils.success("");
    }

    @Override
    public Map findUrlBySku(String sku, String supplierId) {
        ValidationSkuEffDto skuValidity = goodsApi.findSkuValidity(Arrays.asList(sku), supplierId);
        if (!skuValidity.isAllEffective()) {
            return ResponseMapUtils.error("该商品还未同步到商品池中，请同步到商品池中后再编辑商品编码");
        }
        String url = skuValidity.getSkuAndUrlDtos().get(0).getUrl();
        return ResponseMapUtils.success(url);
    }

    /**
     * 供应商订单删除
     *
     * @param mallOrderNo mallOrderNo
     * @return BaseResponse
     */
    @Override
    public BaseResponse deleteMallOrder(String mallOrderNo) {
        try {
            if(Lang.isEmpty(mallOrderNo)) {
                throw new IllegalArgumentException("MallOrderId 不能为空");
            }

            JcbdMallOrderDto mallOrder = biddingMallOrderQueryApi.findByOrderNo(mallOrderNo);

            if(Lang.isEmpty(mallOrder)) {
                throw new IllegalArgumentException("MallOrderId 不是有效数据");
            }

            if (!BiddingOrderStatus.SUPPLIER_ORDER_STATUS_CANCELLED.getCode().equals(mallOrder.getSupplierOrderStatus())) {
                throw new IllegalStateException("MallOrder 供应商订单状态不正确");
            }

            biddingMallOrderQueryApi.deleteJcbdMallOrderByOrderNo(mallOrderNo);

            JcbdOrderDto order = biddingOrderQueryApi.findById(mallOrder.getJdbdOrderId());

            if(!Lang.isEmpty(order)) {
                //保存操作日志
                JcbdBiddingOperationLogDto logDto = new JcbdBiddingOperationLogDto();
                JcbdBiddingDto jcbdBiddingDto = order.getJcbdBidding();
                logDto.setBiddingId(jcbdBiddingDto.getId());
                logDto.setOperationTime(new Date());
                logDto.setOperationContent("供应商删除订单");
                logDto.setOperatorName(order.getSupplierName());
                biddingLogApi.saveBiddingOperationLog(logDto);
            }
            return new BaseResponse<>(true, "操作成功");
        } catch (Exception e) {
            log.error("供应商删除订单异常", e);
            return new BaseResponse<>( "供应商删除订单失败");
        }
    }

    @Override
    public void destroy() throws Exception {
        threadPoolTaskExecutor.shutdown();
    }

    @Override
    public Map checkModifySku(String biddingCode, String supplierId) {
        BaseResponse modifySkuFlag = biddingResponseQueryApi.findModifySkuFlag(biddingCode, supplierId);
        if (!modifySkuFlag.isSuccess()){
            return ResponseMapUtils.error(modifySkuFlag.getResultMessage());
        }
        return ResponseMapUtils.success(modifySkuFlag.getResult(),"");
    }

    @Override
    public JcbdBdProviderDto getProviderByBiddingNoAndSupplierId(String biddingId, String supplierId) {
        return biddingResponseQueryApi.getProviderByBiddingNoAndSupplierId(biddingId,supplierId);
    }

    @Override
    public Map responseGiveUp(String biddingCode, String supplierId) {
        BaseResponse baseResponse = biddingResponseApi.responseGiveUp(biddingCode, supplierId);
        if (baseResponse.isSuccess()){
            return ResponseMapUtils.success("");
        }
        return ResponseMapUtils.error(baseResponse.getResultMessage());
    }

    @Override
    public List<String> findBiddingShowTitle(String biddingNo, String supplierId) {
        JcbdBdProviderDto provider = biddingMainQueryApi.getProvider(biddingNo, supplierId);
        String status = provider.getStatus();
        return biddingRoleOperationQueryApi.getBiddingShowTitle(status, BIDDING_SUPPLIER_TITILE_SHOW_MODULE);
    }

    @Override
    public List<JcbdRoleOperationVo> getSupplierBiddingOperateByBiddingCode(String biddingNo, String supplierId) {
        //查询该竞价的操作
        JcbdBdProviderDto provider = biddingMainQueryApi.getProvider(biddingNo, supplierId);
        List<JcbdRoleOperationDto> operates = biddingRoleOperationQueryApi.getSupplierBiddingOperateByBiddingCode(biddingNo,provider.getStatus());
        if (Lang.isEmpty(operates)) {
            return null;
        }
        return mapperFacade.mapAsList(operates, JcbdRoleOperationVo.class);
    }

    @Override
    public Map loadQrcode(String account,String businessCode,String operateType) {
        StringBuffer originalDataStrBuffer = new StringBuffer();
        originalDataStrBuffer.append(organiztionCode)
                .append(account)
                .append(DateUtils.dateToStr(new Date(),"yyyy-MM-dd HH:mm:ss"))
                .append(businessCode)
                .append(operateType);
        TpCloudQrCodeResponse tpCloundQrCodeResponse = tpCloudShieldApi.createSign(account, originalDataStrBuffer.toString());
        if (!Lang.isEmpty(tpCloundQrCodeResponse)){
            SignQrCodeDto qrCodeDto = tpCloundQrCodeResponse.getData();
            return ResponseMapUtils.success(qrCodeDto);
        }
        return ResponseMapUtils.error("拉取验证二维码失败，请稍后再试");
    }

    @Override
    public Map getAccToken(String eventId) {
        // 获取扫码操作凭证
        TpCloudAccTokenResponse tpCloudAccTokenResponse = tpCloudShieldApi.longUserCheck(eventId);
        log.info("扫码凭证：{},eventId：{}",JSON.toJSONString(tpCloudAccTokenResponse),eventId);
        if (!Lang.isEmpty(tpCloudAccTokenResponse) && !Lang.isEmpty(tpCloudAccTokenResponse.getAccToken())){
            return ResponseMapUtils.success(tpCloudAccTokenResponse,"请使用太平云盾app扫码验证");
        }
        return ResponseMapUtils.error("请使用太平云盾app扫码验证");
    }

    @Override
    public Map getSignResult(String accToken) {
        TpCloudSignResultResponse signResult = tpCloudShieldApi.getSignResult(accToken);
        /**
         * 太平云盾开关
         */
        if (TpCloudSignResultResponse.STAMP_RESULT_TEST.equals(signResult.getStampResult())){
            return ResponseMapUtils.success(signResult.getStampResult(),"太平云盾验证成功");
        }
        if (!Lang.isEmpty(signResult) && !Lang.isEmpty(signResult.getStampResult())){
            // 解码,获取签名值
            try {
                String decoderResult = new String( Base64.getDecoder().decode(signResult.getStampResult()),"UTF-8");
                JSONObject jsonObject = JSONObject.parseObject(decoderResult);
                JSONArray signValues = jsonObject.getJSONArray("signValues");
                JSONObject signValuesJSONObj = signValues.getJSONObject(0);
                String signValue = signValuesJSONObj.getString("signValue");
                return ResponseMapUtils.success(signValue,"太平云盾验证成功");
            } catch (UnsupportedEncodingException e) {
                log.info("获取扫码结果，解码失败：{}",e);
                return ResponseMapUtils.error("验证失败，请重新扫描验证");
            }
        }
        log.info("获取扫码结果：msg:{}",signResult.getMsg());
        return ResponseMapUtils.error("验证失败，请重新扫描验证");
    }
}
