package bidding.web.service.impl;

import api.query.*;
import bidding.web.service.BiddingQueryService;
import bidding.web.vo.*;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.MallAttachmentBusinessCode;
import dto.*;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.web.ResponseMapUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service
public class BiddingQueryServiceImpl implements BiddingQueryService {

    public static final Logger log = LoggerFactory.getLogger(BiddingQueryServiceImpl.class);

    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    BiddingDemandApi biddingDemandApi;
    @MotanReferer
    BiddingPurchaseLogApi biddingPurchaseLogApi;
    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;
    @MotanReferer
    BiddingOrderResultApi biddingOrderResultApi;
    @MotanReferer
    BiddingQueryApi biddingQueryApi;
    @MotanReferer
    BiddingResponseQueryApi biddingResponseQueryApi;
    @MotanReferer
    BiddingConformityReviewQueryApi biddingConformityReviewQueryApi;

    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;


    @Override
    public List<JcbdBiddingDto> findAllJcbdBidding() {
        return biddingQueryApi.findAllJcbdBidding();
    }

    /**
     * 比价页信息查询
     * @param biddingNo
     * @return
     */
    @Override
    public BaseResponse<BiddingPriceParityDto> queryBiddingPriceParity(String biddingNo) {
        BaseResponse<BiddingPriceParityDto> biddingPriceParityDtoBaseResponse = biddingResponseQueryApi.queryBiddingPriceParity(biddingNo);
        return biddingPriceParityDtoBaseResponse;
    }

    /**
     * 查詢符合性审查页需求列表
     * @param biddingConformityQueryVo
     * @return
     */
    @Override
    public Map querryPageBiddingDemad(BiddingConformityQueryVo biddingConformityQueryVo,JqueryDataTablesVo jqueryDataTablesVo) {
        Map returnModel = new HashMap();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.ASC,"demandCode"),
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        Pageable pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(), sort);
        BiddingConformityQueryDto biddingConformityQueryDto = BeanMapper.map(biddingConformityQueryVo, BiddingConformityQueryDto.class);
        biddingConformityQueryDto.setPageable(pageable);
        Page<BiddingConformityListDto> conformityListByQueryDto = biddingConformityReviewQueryApi.getConformityListByQueryDto(biddingConformityQueryDto);
        List<BiddingConformityListDto> biddingConformityListDtos = conformityListByQueryDto.getContent();
        //以下为测试数据
        List<BiddingConformityListVo> biddingConformityListVos = new ArrayList<>();
        Long totalElement = 0L;
        if (!Lang.isEmpty(biddingConformityListDtos)){
            biddingConformityListDtos.forEach(biddingConformityListDto -> {
                BiddingConformityListVo resposeListVo = mapperFacade.map(biddingConformityListDto, BiddingConformityListVo.class);
                resposeListVo.setDateRequiredDelivery(DateUtils.dateToStr(biddingConformityListDto.getDateRequiredDelivery(), GlobalContants.DateFormat.YYYY_MM_DD));
                biddingConformityListVos.add(resposeListVo);
            });
            totalElement = Long.valueOf(biddingConformityListDtos.size());
        }
        returnModel.put("aaData", biddingConformityListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    /**
     * 供应商竞价响应概要信息查询
     *
     * @param biddingConformityQueryVo
     * @return
     */
    @Override
    public Map queryResponseOutline(BiddingConformityQueryVo biddingConformityQueryVo) {
        BiddingConformityQueryDto biddingConformityQueryDto = new BiddingConformityQueryDto();
        biddingConformityQueryDto.setBiddingCode(biddingConformityQueryVo.getBiddingCode());
        biddingConformityQueryDto.setDemandCode(biddingConformityQueryVo.getDemandCode());
        biddingConformityQueryDto.setMemberId(biddingConformityQueryVo.getMemberId());
        biddingConformityQueryDto.setEmail(biddingConformityQueryVo.getEmail());
        BaseResponse<List<BiddingResponseOutlineDto>> demandOutlineDtos = biddingConformityReviewQueryApi.queryConformityOutline(biddingConformityQueryDto);
        if (!demandOutlineDtos.isSuccess()){
            return ResponseMapUtils.error(demandOutlineDtos.getResultMessage());
        }
        if(!Lang.isEmpty(demandOutlineDtos.getResult())){
            List<BiddingResponseOutlineVo> outlineVos = mapperFacade.mapAsList(demandOutlineDtos.getResult(), BiddingResponseOutlineVo.class);
            return ResponseMapUtils.success(outlineVos);
        }
        return ResponseMapUtils.error("未查到供应商信息");
    }

    /**
     * 查询供应商需求响应
     * @param biddingConformityQueryVo
     * @return
     */
    @Override
    public Map queryDemandResponse(BiddingConformityQueryVo biddingConformityQueryVo) {
        BiddingConformityQueryDto biddingConformityQueryDto = new BiddingConformityQueryDto();
        biddingConformityQueryDto.setBiddingCode(biddingConformityQueryVo.getBiddingCode());
        biddingConformityQueryDto.setDemandCode(biddingConformityQueryVo.getDemandCode());
        biddingConformityQueryDto.setProviderId(biddingConformityQueryVo.getProviderId());
        biddingConformityQueryDto.setMemberId(biddingConformityQueryVo.getMemberId());
        biddingConformityQueryDto.setEmail(biddingConformityQueryVo.getEmail());
        BaseResponse<JcbdBiddingDemandResponseDto> demandResponseDtoResponse = biddingConformityReviewQueryApi.getConformityDetail(biddingConformityQueryDto);

        if (!demandResponseDtoResponse.isSuccess()){
            return ResponseMapUtils.error(demandResponseDtoResponse.getResultMessage());
        }
        JcbdBiddingDemandResponseDto demandResponseDto = demandResponseDtoResponse.getResult();
        if (!Lang.isEmpty(demandResponseDto)){
            BiddingDemandResponseVo demandResponseVo = mapperFacade.map(demandResponseDto, BiddingDemandResponseVo.class);

            if(!Lang.isEmpty(demandResponseDto.getOfferValidity())){
                demandResponseVo.setOfferValidityTime(DateUtils.dateToStr(demandResponseDto.getOfferValidity(),GlobalContants.DateFormat.YYYY_MM_DD));
            }
            if (!Lang.isEmpty(demandResponseDto.getJcbdBiddingDemand())){
                BiddingDemandVo demandVo = mapperFacade.map(demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
                demandResponseVo.setBiddingDemand(demandVo);
                if (!Lang.isEmpty(demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery())){
                    demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr(demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery(),GlobalContants.DateFormat.YYYY_MM_DD));
                }
            }
            //查询附件
                if (!Lang.isEmpty(demandResponseDto.getId())){
                    BaseResponse<List<MallAttachmentDto>> bidbaseBaseResponse = mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(demandResponseDto.getId(), MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue());
                    if (bidbaseBaseResponse.isSuccess()) {
                        if (!Lang.isEmpty(bidbaseBaseResponse.getResult())) {
                            demandResponseVo.setAttachment(BeanMapper.mapList(bidbaseBaseResponse.getResult(), MallAttachmentDto.class, MallAttachmentVo.class));
                        }
                    }
                }
            if (!Lang.isEmpty(demandResponseDto.getJcbdProviderAddressResponses())){
                List<JcbdProviderAddressResponseVo> providerAddressResponseVos = mapperFacade.mapAsList(demandResponseDto.getJcbdProviderAddressResponses(), JcbdProviderAddressResponseVo.class);
                providerAddressResponseVos.forEach( n -> {
                    if(JcbdProviderAddressResponseVo.FLAG_PASS.equals(n.getStatus())){
                        n.setStatus(JcbdProviderAddressResponseVo.RESPONSE_FULFILL);
                    }else{
                        n.setStatus(JcbdProviderAddressResponseVo.RESPONSE_FAIL);
                    }
                });
                demandResponseVo.setProviderAddressResponses(providerAddressResponseVos);
            }
            if (!Lang.isEmpty(demandResponseDto.getJcbdProviderConformanceResps())){
                List<JcbdProviderConformanceRespVo> conformanceRespVos = mapperFacade.mapAsList(demandResponseDto.getJcbdProviderConformanceResps(), JcbdProviderConformanceRespVo.class);
                conformanceRespVos.forEach( n -> {
                    if(JcbdProviderConformanceRespVo.RESPONSE_FULFILL.equals(n.getStatus())){
                        n.setStatus(JcbdProviderConformanceRespVo.RESPONSE_FULFILL);
                    }else{
                        n.setStatus(JcbdProviderConformanceRespVo.RESPONSE_FAIL);
                    }
                    n.setSupplierId(biddingConformityQueryVo.getProviderId());
                });
                demandResponseVo.setProviderConformanceResps(conformanceRespVos);
            }
            return ResponseMapUtils.success(demandResponseVo);
        }
        return ResponseMapUtils.error("未查到改需求响应信息");
    }
}
