package bidding.web.service.impl;


import api.query.BiddingSupplierOrderManagerApi;
import bidding.web.service.BiddingProviderService;
import bidding.web.service.BiddingSupplierOrderManagerService;
import bidding.web.vo.QueryStatus;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.google.common.base.Joiner;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOrderStatus;
import dto.BiddingSupplierOrderMangerDto;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import query.BiddingSupplierOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import uninogift.api.protocol.TpCloudVerifyLogApi;
import uninogift.vo.protocol.outside.TpCloudVerifyLogDto;
import utils.Lang;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author luoxianwei
 * @date 2018/4/14
 */
@Service
public class BiddingSupplierOrderManagerServiceImpl implements BiddingSupplierOrderManagerService {

    public static final Logger log = LoggerFactory.getLogger(BiddingSupplierOrderManagerServiceImpl.class);

    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    RedisTemplate redisTemplate;

    @MotanReferer
    BiddingSupplierOrderManagerApi biddingSupplierOrderManagerApi;

    @MotanReferer
    OrderMainApi orderMainApi;

    @Autowired
    BiddingProviderService biddingProviderService;

    @MotanReferer
    MemberAddressApi memberAddressApi;

    @MotanReferer
    TpCloudVerifyLogApi tpCloudVerifyLogApi;

    @Override
    public Map getBiddingSupplierOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable) {
        Map returnModel = new HashMap(16);
        Long totalElement = 0L;
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(
                new Sort.Order(Sort.Direction.DESC, "dateCreated"),
                new Sort.Order(Sort.Direction.DESC, "lastUpdated")
        );
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength(),sort);
        Page<BiddingSupplierOrderMangerDto> page = getSupplierOrderMangerList(biddingSupplierOrderManagerListQuery, pageable);
        totalElement = page.getTotalElements();
        returnModel.put("aaData", page.getContent());
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    @Override
    public Page<BiddingSupplierOrderMangerDto> getSupplierOrderMangerList(BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable) {
        long biddingOrderTime = System.currentTimeMillis();
        Page<BiddingSupplierOrderMangerDto> page = biddingSupplierOrderManagerApi.getBiddingSupplierOrderMangerList(biddingSupplierOrderManagerListQuery, pageable);
        log.info("分页查询供应商订单数据耗时 {} ms", System.currentTimeMillis() - biddingOrderTime);

        biddingOrderTime = System.currentTimeMillis();
        List<BiddingSupplierOrderMangerDto> contentList = page.getContent();

        contentList.parallelStream().forEach(biddingSupplierOrderManger -> {
            OrderMainDto orderMain = orderMainApi.findByOrderNo(biddingSupplierOrderManger.getOrderNo());
            MemberAddressDto memberAddress = memberAddressApi.findById(orderMain.getAddressId());

            StringBuilder address = new StringBuilder(memberAddress.getProvinceName());
            address.append(memberAddress.getCityName());
            address.append(memberAddress.getAreaName());
            address.append(memberAddress.getTownName());
            address.append(biddingSupplierOrderManger.getAddress());
            biddingSupplierOrderManger.setAddress(address.toString().replaceAll("null", ""));

            List<OrderItemDto> orderItems = orderMain.getOrderItems();

            // 商品数量(注释原因，商品项数取商品种类，不取商品总数量)
//            int goodsCount = 0;
//            if (!Lang.isEmpty(orderItems)) {
//                for (OrderItemDto orderItem : orderItems) {
//                    if(!Lang.isEmpty(orderItem.getCount())) {
//                        goodsCount += orderItem.getCount();
//                    }
//                }
//            }
            if (!Lang.isEmpty(orderItems)){
                biddingSupplierOrderManger.setGoodsNumber(orderItems.size());
            }

            // 商品编码
            StringBuilder goodsCode = new StringBuilder();
            for (OrderItemDto orderItem : orderItems) {
                goodsCode.append(orderItem.getSku()).append(",");
            }
            if (!Lang.isEmpty(goodsCode)) {
                goodsCode = goodsCode.replace(goodsCode.length() - 1, goodsCode.length(), "");
            }
            biddingSupplierOrderManger.setGoodsCode(goodsCode.toString());

            //添加下单金额web层赋值
            BigDecimal singleAmount = orderMain.getSumPrice().setScale(2);
            biddingSupplierOrderManger.setSingleAmount(singleAmount);
        });

        log.info("orderMain 查询耗时 {} ms", System.currentTimeMillis() - biddingOrderTime);

        return page;
    }

    @Override
    public List<QueryStatus> getAllSupplierStatus() {
        List<QueryStatus> allStatusList = new ArrayList<>();
        Map<String, BiddingOrderStatus> biddingSupplierOrderStatusMap = BiddingOrderStatus.biddingSupplierOrderStatusMap;
        for (String s : biddingSupplierOrderStatusMap.keySet()) {
            QueryStatus queryStatus = new QueryStatus();
            queryStatus.setStatusCode(s);
            BiddingOrderStatus biddingOrderStatus = biddingSupplierOrderStatusMap.get(s);
            queryStatus.setStatusDescription(biddingOrderStatus.getDescription());
            allStatusList.add(queryStatus);
        }
        return allStatusList;
    }

    /**
     * 供应商确认订单
     *
     * @param mallOrderNos List<String>
     * @return BaseResponse<List<String>>
     */
    @Override
    public BaseResponse<List<String>> confirmOrder(List<String> mallOrderNos,String biddingMemberId,String signValue) {
        List<String> confirmedMessages = new Vector<>();
        List<String> unConfirmedMessages = new Vector<>();
        mallOrderNos.parallelStream().forEach(mallOrderNo -> {
            BaseResponse baseResponseTemp = biddingProviderService.confirmOrder(mallOrderNo);
            if(baseResponseTemp.isSuccess()) {
                confirmedMessages.add(baseResponseTemp.getResultMessage());
            } else {
                unConfirmedMessages.add(baseResponseTemp.getResultMessage());
            }
        });
        List<String> allMessages = new ArrayList<>();
        allMessages.addAll(confirmedMessages);
        allMessages.addAll(unConfirmedMessages);
        // 多张订单确认提示成功以及失败的数量
        if(allMessages.size() > 1) {
            allMessages.add(confirmedMessages.size() + " 张订单确认成功, " + unConfirmedMessages.size() + " 张订单确认失败");
        }
        String resultCode="0";
        if(confirmedMessages.size()>0){
            resultCode ="1";
        }
        // 保存太平云盾验证日志
        TpCloudVerifyLogDto tpCloudVerifyLogDto = new TpCloudVerifyLogDto();
        tpCloudVerifyLogDto.setOperateType(TpCloudVerifyLogDto.OPERATE_BIDDING_SURE_ORDER);
        tpCloudVerifyLogDto.setSignValue(signValue);
        tpCloudVerifyLogDto.setSource(TpCloudVerifyLogDto.LOG_SOURCE_BIDING);
        tpCloudVerifyLogDto.setUserId(biddingMemberId);
        tpCloudVerifyLogDto.setBusinessCode(Joiner.on(",").skipNulls().join(mallOrderNos));
        tpCloudVerifyLogApi.saveTpCloudVerifyLog(tpCloudVerifyLogDto);
        return new BaseResponse(true, "操作成功", allMessages,resultCode);
    }

    /**
     * 供应商订单删除
     *
     * @param mallOrderNo
     * @return BaseResponse
     */
    @Override
    public BaseResponse deleteMallOrder(String mallOrderNo) {
        return biddingProviderService.deleteMallOrder(mallOrderNo);
    }
}
