package bidding.web.service.impl;

import api.BiddingMainApi;
import api.query.DemoQueryApi;
import bidding.web.service.DemoService;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.MailTemplateEnum;
import dto.DemoStudentDto;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.mail.vo.MailTemplateReq;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.stereotype.Service;
import query.DemoQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@Service
public class DemoServiceImpl implements DemoService {
    @MotanReferer
    DemoQueryApi demoQueryApi;

    @MotanReferer
    BiddingMainApi mainApi;





    /**
     * 样例查询方法
     *
     * @param demoQuery
     * @return
     */
    @Override
    public DemoStudentDto getStudent(DemoQuery demoQuery) {
        return demoQueryApi.queryStudent(demoQuery);
    }

    @Override
    public BaseResponse test(String biddingNo) {
        return mainApi.biddingResponseFinishValidate(biddingNo);
    }


    @MockBean
    MailApi mailApi;
    @Value("${spring.mail.username}")
    String mailFrom;

    public MailRsp mailTemplateDemo(String sendEmail){
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        sendEmail = "sinosoft@sinosoft.com.cn";//发送邮箱
        mailReq.setTo(new String[]{sendEmail});
        mailReq.setFrom(mailFrom);
        mailReq.setSentDate(new Date());
        mailReq.setChannel(MailReq.CHANNEL_JC);
        mailTemplateReq.setMailReq(mailReq);

        //BID_AUDIT("1_1_5","竞价审核")
        // 首位对应模板号，2位对应邮件标题参数subjectArgs,3位对应内容参数contextArgs
        String templateCode = MailTemplateEnum.BID_AUDIT.getTemplateCode();
        mailTemplateReq.setTemplateCode(templateCode);
        List<String>  subjectArgs = new ArrayList<>();
        subjectArgs.add("BID99283-3432");//竞价编号
        List<String>  contextArgs = new ArrayList<>();//共5个参数
        contextArgs.add("张三丰");
        contextArgs.add("太平人寿上海分公司财务办");
        contextArgs.add("采购经办人A");
        contextArgs.add("BID99283-3432");
        contextArgs.add("https://10.4.117.23:8080/4.html");
        mailTemplateReq.setSubjectArgList(subjectArgs);
        mailTemplateReq.setContentArgList(contextArgs);

        mailTemplateReq.setServiceModule("bidding");

        MailRsp mailRsp = mailApi.sendMailByTemplate(mailTemplateReq);
        return mailRsp;
    }

}
