package bidding.web.vo;

import lombok.Data;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;

/**
 * @author 张代春
 * @date 2018/4/18
 */
@Data
@Excel(sheetNames = {"sheet one"})
public class BatchDownLoadVo {

    /**
     * 主键.
     */
    private String id;
    /**
     * 竞价编号
     */
    private String biddingNo;
    /**
     * 序号
     */
    @ColumnName(column = "序号")
    private String sequence;

    /**
     * 商品Sku
     */
    @ColumnName(column = "商品编号")
    private String sku;

    /**
     * 商品数量
     */
    @ColumnName(column = "商品数量")
    private Integer num;

    /**
     * 收件人地址名
     */
    @ColumnName(column = "商品收货地址")
    private String memberAddressName;

    /**
     * 收件人姓名
     */
    @ColumnName(column = "商品收货人")
    private String memberName;

    /**
     * 收件人电话
     */
    @ColumnName(column = "商品收货人电话")
    private String tel;

    /**
     * 发票类型 1.增值税专用发票 2.增值税普通发票
     */
    @ColumnName(column = "发票类型")
    private String invoiceType;

    /**
     * 开票机构
     */
    @ColumnName(column = "开票机构")
    private String invoiceOrganization;
    /**
     * 发票抬头
     */
    @ColumnName(column = "发票抬头")
    private String invoiceTitle;
    /**
     * 公司地址及电话
     */
    @ColumnName(column = "公司地址及电话")
    private String companyAddressAndPhone;
    /**
     * 开户行及账号
     */
    @ColumnName(column = "开户行及账号")
    private String bankAndAccount;
    /**
     * 纳税人识别号
     */
    @ColumnName(column = "纳税人识别号")
    private String taxIdentification;
    /**
     * 发票收件人
     */
    @ColumnName(column = "发票收货人")
    private String consigneeName;
    /**
     * 发票收件人电话
     */
    @ColumnName(column = "发票收货人电话")
    private String consigneePhone;
    /**
     * 发票收件人地址
     */
    @ColumnName(column = "发票收件人地址")
    private String invoiceAddress;

}
