package bidding.web.vo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author taofeng
 * @date 2018/3/16
 * <p>
 * 竞价基本信息Vo
 **/
public class BiddingBaseInfoVo {

    /**
     * 竞价id.
     */
    private String id;

    /**
     * 竞价编号.
     */
    private String biddingCode;

    /**
     * 竞价描述.
     */
    private String biddingDescription;

    /**
     * 经办人/电话/邮箱
     * member.api.dto.core.CoreUserDto
     * coreUserApi.findByIsDeleteAndId
     */
    private String username;
    private String phone;
    private String email;

    /**
     * 竞价响应开始时间
     */
    private String startTime;
    /**
     * 竞价响应截止时间
     */
    private String endTime;

    /**
     * 经办人id.
     */
    private String operatorId;


    /**
     * 竞价周期.
     */
    private Integer biddingPeriod;

    /**
     * 确认竞价结果方式.
     */
    private BigDecimal wayforConfirmBiddingResult;

    /**
     * 上传附件
     */

    /**
     * 备注.
     */
    private String remark;

    private List<JcbdBiddingGroupMemberVo> jcbdBiddingGroupMembers;

    /**
     * 竞价状态.
     */
    private String status;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBiddingCode() {
        return biddingCode;
    }

    public void setBiddingCode(String biddingCode) {
        this.biddingCode = biddingCode;
    }

    public String getBiddingDescription() {
        return biddingDescription;
    }

    public void setBiddingDescription(String biddingDescription) {
        this.biddingDescription = biddingDescription;
    }

    public String getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public Integer getBiddingPeriod() {
        return biddingPeriod;
    }

    public void setBiddingPeriod(Integer biddingPeriod) {
        this.biddingPeriod = biddingPeriod;
    }

    public BigDecimal getWayforConfirmBiddingResult() {
        return wayforConfirmBiddingResult;
    }

    public void setWayforConfirmBiddingResult(BigDecimal wayforConfirmBiddingResult) {
        this.wayforConfirmBiddingResult = wayforConfirmBiddingResult;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<JcbdBiddingGroupMemberVo> getJcbdBiddingGroupMembers() {
        return jcbdBiddingGroupMembers;
    }

    public void setJcbdBiddingGroupMembers(List<JcbdBiddingGroupMemberVo> jcbdBiddingGroupMembers) {
        this.jcbdBiddingGroupMembers = jcbdBiddingGroupMembers;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
}
