package bidding.web.vo;

import lombok.Data;

import java.util.List;

/**
 * @author 张代春
 * @date 2018/4/8
 */
@Data
public class BiddingConformityListVo {
    /**
     * 审查小组成员memberId(当前登录用户)
     */
    private String biddingGroupMemberId;
    /**
     * 需求编号
     */
    private String demandCode;
    /**
     * 需求商品名称.
     */
    private String goodsDesription;
    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;
    /**
     * 规格参数.
     */
    private String specification;
    /**
     * 要求到货日期.
     */
    private String dateRequiredDelivery;
    /**
     * 最低采购数量.
     */
    private Long minPurchaseAmount;
    /**
     * 最高采购数量.
     */
    private Long maxPurchaseAmount;
    /**
     * 需求地址具体化
     */
    private List<String> demandAddressNumDtos;
    /**
     * 需求地址
     */
    private List<String> demandAddrList;
    /**
     * 符合性个数
     */
    private Integer conformityNum;
    /**
     * 响应供应商数
     */
    private Integer demandResponNum;

    /**
     * 已审查供应商数
     */
    private Integer providersAudited;
}
