package bidding.web.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 竞价需求响应vo
 *
 * Created by miaohao on 2018/3/23.
 */
@Data
public class BiddingDemandResponseVo {
    /**
     * 主键.
     */
    private String id;

    /**
     * 竞价需求.
     */
    private BiddingDemandVo biddingDemand;

    /**
     * 响应供应商id (竞价供应商表主键).
     */
    private String responseProviderId;

    /**
     * 商品标题
     */
    private String goodsTitle;

    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;

    /**
     * 商品规格.
     */
    private String goodsParams;

    /**
     * 服务承诺.
     */
    private String servicePromise;

    /**
     * 报价有效期
     */
    private String offerValidityTime;

    /**
     * sku.
     */
    private String sku;

    /**
     * 商品链接.
     */
    private String goodsLink;

    /**
     * 附件
     */
    private List<MallAttachmentVo> attachment;

    /**
     * 价格.
     */
    private BigDecimal price;

    /**
     * 供货周期.
     */
    private BigDecimal supplyPeriod;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 是否满足全部条件 0-不满足 1-满足
     */
    private String isAllAccord;

    /**
     * 供应商需求地址商品数量满足性响应列表
     */

    private List<JcbdProviderAddressResponseVo> providerAddressResponses;


    /**
     * 供应商符合性响应列表
     */

    private List<JcbdProviderConformanceRespVo> providerConformanceResps;

}
