package bidding.web.vo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author taofeng
 * @date 2018/3/20
 *
 * 竞价需求
 **/
@Data
public class BiddingDemandVo {

    /**
     * 主键.
     */
    private String id;

    /**
     * 需求编号.
     */
    private String demandCode;

    /**
     * 需求商品名称.
     */
    private String goodsDesription;

    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;

    /**
     * 规格参数.
     */
    private String specification;

    /**
     * 服务要求.
     */
    private String serviceRequirement;

    /**
     * 要求到货日期.
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateRequiredDelivery;

    private String dateRequiredDeliveryTime;

    /**
     * 最低采购数量.
     */
    private Long minPurchaseAmount;

    /**
     * 最高采购数量.
     */
    private Long maxPurchaseAmount;

    /**
     * 需求地址
     */
//    private String demandAddress;

    /**
     * 已购买数量.
     */
    private Integer purchaseNum;

    /**
     * 关联竞价id.
     */
    private String biddingId;

    /**
     * 关键竞价编号
     */
    private String biddingCode;

    /**
     * 竞价
     */
//    private JcbdBiddingDto jcbdBidding;

    /**
     * 竞价需求符合性列表
     */
    private List<JcbdBiddingConformanceVo> jcbdBiddingConformances;

    /**
     * 竞价供应商需求响应列表
     */
    private List<JcbdBiddingDemandResponseVo> jcbdBiddingDemandResponses;

    /**
     * 竞价购买记录例表
     */
    private List<JcbdBiddingPurchaseLogVo> jcbdBiddingPurchaseLogs;

    /**
     * 竞价需求地址列表
     */
    private List<JcbdDemandAddressNumVo> jcbdDemandAddressNums;
}
