package bidding.web.vo;

import java.io.Serializable;

/**
 * 审核人信息VO
 * @author li jilong 2018.6.11
 */
public class BiddingMemberInfoVO implements Serializable {

    /**
     * id 对应表core_user的ID列
     */
    protected String id;
    /**
     * 用户名 对应表core_user的USERNAME列
     */
    private String username;
    /**
     * 用户类型
     */
    private String userType;
    /**
     * 是否删除标志 对应表core_user的IS_DELETE列
     */
    private Boolean isDelete;
    /**
     * 是否禁用
     */
    private Boolean disabled;
    /**
     * 电话 对应表core_user的PHONE列
     */
    private String phone;
    /**
     * 邮箱 对应表core_user的EMAIL列
     */
    private String email;
    /**
     * 机构代码  对应表core_user的ORGANIZATION_ID列
     */
    private String organizationId;
    /**
     * 对应表core_company的id列
     */
    private String companyId;

    /**
     * 对应表core_company的NAME列
     */
    private String companyName;
    /**
     * 对应表core_company的CODE列
     */
    private String companyCode;

    /**
     * 对应表core_department的id列
     */
    private String departmentId;

    /**
     * 对应表core_department的NAME列
     */
    private String departmentName;
    /**
     * 对应表core_department的CODE列
     */
    private String departmentCode;
    /**
     * 技术审批人memberId对应表MEMBER的ID列
     */
    private String techAuditorMemberId;
    /**
     * 查询列表结果的公共companyId
     */
    private String searchRltCommCompanyId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public Boolean getDelete() {
        return isDelete;
    }

    public void setDelete(Boolean delete) {
        isDelete = delete;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public String getTechAuditorMemberId() {
        return techAuditorMemberId;
    }

    public void setTechAuditorMemberId(String techAuditorMemberId) {
        this.techAuditorMemberId = techAuditorMemberId;
    }

    public String getSearchRltCommCompanyId() {
        return searchRltCommCompanyId;
    }

    public void setSearchRltCommCompanyId(String searchRltCommCompanyId) {
        this.searchRltCommCompanyId = searchRltCommCompanyId;
    }

    @Override
    public String toString() {
        return "BiddingMemberInfoVO{" +
                "id='" + id + '\'' +
                ", username='" + username + '\'' +
                ", userType='" + userType + '\'' +
                ", isDelete=" + isDelete +
                ", disabled=" + disabled +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", organizationId='" + organizationId + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyName='" + companyName + '\'' +
                ", companyCode='" + companyCode + '\'' +
                ", departmentId='" + departmentId + '\'' +
                ", departmentName='" + departmentName + '\'' +
                ", departmentCode='" + departmentCode + '\'' +
                ", techAuditorMemberId='" + techAuditorMemberId + '\'' +
                ", searchRltCommCompanyId='" + searchRltCommCompanyId + '\'' +
                '}';
    }
}
