package bidding.web.vo;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 供应商竞价需求列表Vo
 * <p>
 * Created by miaohao on 2018/3/22.
 */
@Data
public class BiddingSupplierResposeListVo {
    /**
     * 需求id
     */
    private String demandId;
    /**
     * 需求编号
     */
    private String demandNo;
    /**
     * 需求商品名称
     */
    private String goodsDesription;
    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;
    /**
     * 规格参数.
     */
    private String specification;
    /**
     * 要求到货日期
     */
    private String requiredDeliveryDateTime;
    /**
     * 最低采购数量
     */
    private Integer lowestPurchaseNumber;
    /**
     * 最高采购数量
     */
    private Integer highestPurchaseNumber;
    /**
     * 竞价需求响应状态
     */
    private String demandResponseStatus;
    /**
     * 需求地址
     */
    private String demandAddress;
    /**
     * 价格.
     */
    private BigDecimal price;
    /**
     * 符合性审查数
     */
    private Integer conformanceNumber;
    /**
     * 响应供应商数
     */
    private Integer responseSupplierNumber;
}
