package bidding.web.vo;

import lombok.Data;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;
import java.io.Serializable;

/**
 * @author 张代春
 * @date 2018/4/8
 */
@Data
@Excel(sheetNames = {"sheet one"})
public class ExcelImportDataVo implements Serializable{
    /**
     * 商品Sku
     */
    @ColumnName(column = "商品编码")
    private String sku;
    /**
     * 商品数量
     */
    @ColumnName(column = "数量")
    private Integer num;

    /**
     * 收件人地址编码
     */
    @ColumnName(column = "商品收货地址编号")
    private String memberAddressCode;

    /**
     * 收件人详细地址
     */
    @ColumnName(column = "商品收货详细地址")
    private String memberDetailAddress;
    /**
     * 发票类型 1.增值税专用发票 2.增值税普通发票
     */
    @ColumnName(column = "发票类型")
    private String invoiceType;

    /**
     * 发票抬头
     */
    @ColumnName(column = "发票抬头")
    private String invoiceTitle;

    /**
     * 纳税人识别号
     */
    @ColumnName(column = "纳税人识别号")
    private String taxIdentification;

    /**
     * 发票收件地址码
     */
    @ColumnName(column = "发票收货地址编号")
    private String invoiceAddressCode;
    /**
     * 发票收件省地址码
     */
    private String invoiceProvinceAddressCode;
    /**
     * 发票收件地址码
     */
    private String invoiceCityAddressCode;
    /**
     * 发票收件详细地址
     */
    @ColumnName(column = "发票收货详细地址")
    private String invoiceDetailAddress;
    /**
     * 发票收件人
     */
    @ColumnName(column = "发票收件人")
    private String invoiceMember;
    /**
     * 发票收件人电话
     */
    @ColumnName(column = "发票收件人电话")
    private String invoiceMemberTel;

    /**
     * 收货人姓名
     */
    @ColumnName(column = "收货人姓名")
    private String memberName;
    /**
     * 收货人电话
     */
    @ColumnName(column = "收货人电话")
    private String memberTel;


    /**
     * 导入结果
     */
    @ColumnName(column = "导入结果")
    private String importResult;

}
