package bidding.web.vo;

import com.alibaba.fastjson.annotation.JSONField;
import dto.JcbdBiddingDto;
import lombok.Data;

import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import java.util.Date;
import java.util.List;

/**
 * @author taofeng
 * @date 2018/3/27
 **/
@Data
public class JcbdBdProviderVo {

    private String id;

    /**
     * 供应商id.storeId
     */
    private String providerId;

    /**
     * 供应商名称
     */
    private String providerName;

    /**
     * 关联竞价id.
     */
//    private JcbdBiddingVo jcbdBidding;

    /**
     * 供应商竞价状态.
     */
    private String status;

    /**
     * 响应状态
     */
    private String responseStatus;

    /**
     * 成交状态
     */
    private String dealStatus;

    /**
     * 符合性审查状态
     */
    private String conformanceCheckStatus;

    /**
     * 响应供应商联系人id.
     */
    private String contactsId;

    /**
     * 报价有效期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date offerValidity;

    /**
     * 联系人列表
     */
    private List<JcbdStoreContactsVo> jcbdStoreContactsVos;
}
