package bidding.web.vo;

import com.alibaba.fastjson.annotation.JSONField;
import dto.JcbdRoleOperationDto;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月24日18:16:06.
 */
@Data
public class JcbdBiddingVo {
    /**
     * 主键.
     */
    private String id;
    /**
     * 竞价小组成员机构部门姓名邮箱信息
     */
    private String groupMemberInfo;

    /**
     * 竞价编号.
     */
    private String biddingCode;

    /**
     * 竞价描述.
     */
    private String biddingDescription;

    /**
     * 竞价开始响应时间.
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date timeStartResponse;

    /**
     * 竞价截止响应时间.
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date timeEndResponse;

    /**
     * 竞价开始响应时间回显.
     */
    private String timeStartResponses;

    /**
     * 竞价截止响应时间回显.
     */
    private String timeEndResponses;

    /**
     * 竞价周期.
     */
    private Integer biddingPeriod;

    /**
     * 邀请供应商数.
     */
    private Integer providerInviteNum;

    /**
     * 响应供应商数.
     */
    private Integer providerResponseNum;

    /**
     * 竞价状态.
     */
    private String status;

    /**
     * 竞价状态描述
     */
    private String statusDescription;

    /**
     * 确认竞价结果方式.
     */
    private String wayForConfirmBiddingResult;

    /**
     * 经办人id.
     */
    private String operatorId;

    private String username;
    private String phone;
    private String email;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 竞价小组审核编号.
     */
    private String groupCheckNo;

    /**
     * 符合性审查编号.
     */
    private String conformanceNo;

    /**
     * 投票编号.
     */
    private String voteNo;

    /**
     * 竞价提交审核备注
     */
    private String bdCommitContent;

    /**
     * 竞价供应商列表
     */
    private List<JcbdBdProviderVo> jcbdBdProviders;

    /**
     * 供应商联系人信息
     */
    private List<JcbdStoreContactsVo> jcbdStoreContactsVos;

    /**
     * 竞价需求列表
     */
    private List<BiddingDemandVo> jcbdBiddingDemands;

    /**
     * 竞价小组成员列表
     */
    private List<JcbdBiddingGroupMemberVo> jcbdBiddingGroupMembers;

    /**
     * 竞价操作记录列表
     */
    private List<JcbdBiddingOperationLogVo> jcbdBiddingOperationLogs;

    /**
     * 竞价采购订单列表
     */
//    private List<JcbdOrderVo> jcbdOrders;

    /**
     * 竞价基本信息页附件列表**
     */
    private List<MallAttachmentVo> mallAttachmentVos;

    /**
     * 竞价结果审核页附件列表**
     */
    private List<MallAttachmentVo> bidresulMallAttachmentVos;

    /**
     * 操作
     */
    private List<JcbdRoleOperationDto> operation;

}
