package bidding.web.vo;

import lombok.Data;

/**
 * 供应商需求响应地址vo
 * Created by miaohao on 2018/3/23.
 */
@Data
public class JcbdProviderAddressResponseVo {

    /**
     * 不符合
     */
    public static final String FLAG_NOT_PASS = "0";
    /**
     * 符合
     */
    public static final String FLAG_PASS = "1";
    /**
     * 状态页面显示满足
     */
    public static final String RESPONSE_FULFILL = "满足";
    /**
     * 状态页面显示不满足
     */
    public static final String RESPONSE_FAIL = "不满足";

    /**
     * 需求地址id.
     */
    private String demandAddressId;

    /**
     * 省名称/最低采购数量/最高采购数量
     */
    private String provinceName;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 最低采购数量/最高采购数量/地区全称
     */
    private String content;

    /**
     * 需求数量.
     */
    private Long numberNeed;

    /**
     * 满足状态.
     */
    private String status;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 页面显示位置.
     */
    private Integer displayIndex;

}
