package bidding.web.vo;

import lombok.Data;

/**
 * 竞价需求符合性审查响应Vo
 * Created by miaohao on 2018/3/23.
 */
@Data
public class JcbdProviderConformanceRespVo {
    /**
     * 不符合
     */
    public static final String FLAG_NOT_PASS = "0";
    /**
     * 符合
     */
    public static final String FLAG_PASS = "1";
    /**
     * 状态页面显示符合
     */
    public static final String RESPONSE_FULFILL = "符合";
    /**
     * 状态页面显示不符合
     */
    public static final String RESPONSE_FAIL = "不符合";
    /**
     * 主键.
     */

    private String id;

    /**
     * 竞价需求符合性id.
     */
    private String biddingConformanceId;

    /**
     * 符合性内容.
     */
    private String conformance;

    /**
     * 符合状态.
     */
    private String status;

    /**
     * 符合性审查项符合状态 1-符合 0-不符合
     */
    private String conformanceStatus;
    /**
     * 备注.
     */
    private String remark;
    /**
     * 不通过的小组成员str
     */
    private String notPassMemberStr;
    /**
     * 供应商Id
     */
    private String supplierId;
}
