package bidding.web.vo;

import lombok.Data;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;

import java.math.BigDecimal;

/**
 * @author 张代春
 * @date 2018/4/3
 */
@Data
@Excel(sheetNames = {"sheet one"})
public class JcbdTempGoodsVo {
    /**
     * 主键.
     */
    private String id;

    /**
     * 临时订单
     */
    private BiddingQueryOperativeBuySaveVo jcbdTempOrder;

    /**
     * 商品Sku
     */
    @ColumnName(column = "商品编号")
    private String sku;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 商品数量
     */
    @ColumnName(column = "商品数量")
    private Integer num;

    /**
     * productFashionId
     */
    private String productFashionId;

    /**
     * goodsId
     */
    private String goodsId;

    /**
     * demandId
     */
    private String demandId;

    /**
     * demandCode
     */
    private String demandCode;
}
