package bidding.web.vo;

import dto.JcbdTempGoodsDto;
import lombok.Data;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;

import java.util.List;

/**
 * @author 张代春
 * @date 2018/4/4
 */
@Data
@Excel(sheetNames = {"sheet one"})
public class JcbdTempOrderVo {
    /**
     * 主键.
     */
    private String id;
    /**
     * 序号
     */
    private String sequence;
    /**
     * 竞价编号
     */
    private String biddingNo;

    /**
     * 收件人地址id（memberAddress表主键）
     */
    private String memberAddressId;

    /**
     * 收件人地址名
     */
    @ColumnName(column = "商品收货地址")
    private String memberAddressName;
    /**
     * 收件人地址省编码
     */
    private String memberProviceCode;
    /**
     * 收件人地址省名
     */
    private String memberProviceName;
    /**
     * 收件人地址市编码
     */
    private String memberCityCode;
    /**
     * 收件人地址市名
     */
    private String memberCityName;
    /**
     * 收件人地址县/区编码
     */
    private String memberAreaCode;
    /**
     * 收件人地址县/区名
     */
    private String memberAreaName;

    /**
     * 收件人地址镇编码
     */
    private String memberTownCode;

    /**
     * 收件人地址镇名
     */
    private String memberTownName;

    /**
     * 收件人姓名
     */
    @ColumnName(column = "商品收货人")
    private String memberName;

    /**
     * 收件人电话
     */
    @ColumnName(column = "商品收货人电话")
    private String tel;

    /**
     * 商品sku集合
     */
    private List<JcbdTempGoodsVo> jcbdTempGoodses;

    /**
     * 发票类型 1.增值税专用发票 2.增值税普通发票
     */
    @ColumnName(column = "发票类型")
    private String invoiceType;

    /**
     * 开票机构
     */
    @ColumnName(column = "开票机构")
    private String invoiceOrganization;

    /**
     * 发票抬头
     */
    @ColumnName(column = "发票抬头")
    private String invoiceTitle;

    /**
     * 公司地址及电话
     */
    @ColumnName(column = "公司地址及电话")
    private String companyAddressAndPhone;
    /**
     * 开户行及账号
     */
    @ColumnName(column = "开户行及账号")
    private String bankAndAccount;

    /**
     * 纳税人识别号
     */
    @ColumnName(column = "纳税人识别号")
    private String taxIdentification;

    /**
     * 是否同收件人
     */
    private boolean sameAsAchiever;
    /**
     * 发票收件人
     */
    @ColumnName(column = "发票收货人")
    private String consigneeName;
    /**
     * 发票收件人电话
     */
    @ColumnName(column = "发票收货人电话")
    private String consigneePhone;
    /**
     * 发票收件人地址
     */
    @ColumnName(column = "发票收件人地址")
    private String invoiceAddress;
    /**
     * 发票收件人省
     */
    private String consigneeProvinceCode;
    /**
     * 发票收件人省名
     */
    private String consigneeProvinceName;
    /**
     * 发票收件人市
     */
    private String consigneeCityCode;
    /**
     * 发票收件人市名
     */
    private String consigneeCityName;
    /**
     * 详细地址
     */
    private String addressDetail;
    
    /**
     * 发票收件地址是否同收件人地址:1是0否
     */
    private String consigneeFlag;

    /**
     * 发票机构companyId
     */
    private String companyId;
}
