package bidding.web.vo;

import lombok.Data;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;

import java.math.BigDecimal;

/**
 * @author 张代春
 * @date 2018/4/4
 */
@Data
@Excel(sheetNames = {"sheet one"})
public class TempBatchListVo {
    /**
     * sku
     */
    @ColumnName(column = "商品编码")
    private String sku;
    /**
     * 数量
     */
    private Integer num;
    /**
     * 单价
     */
    private BigDecimal price;
    /**
     * 总价
     */
    private BigDecimal totalPrice;
    /**
     * 收货地址Id
     */
    private String addressId;
    /**
     * 收货人
     */
    private String name;
    /**
     * 收货电话
     */
    private String tel;
    /**
     * 收货地址名
     */
    private String addressName;

}
