/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.config;

import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import utils.filter.CNTPSSOLoginCheckFilter;

@Configuration
@ComponentScan(basePackages={"utils.io"})
@ConfigurationProperties(prefix="security")
public class WebConfig {
    List<String> callbackignore;

    @Bean
    public CNTPSSOLoginCheckFilter frontEndLoginCheckFilter(@Value(value="${login.excludeUrls}") String excludeUrls, @Value(value="${login.loginUrl}") String loginUrl, @Value(value="${login.checkUrls}") String checkUrls, @Value(value="${login.defaultSuccessUrl}") String defaultSuccessUrl, @Value(value="${login.sso.authCookiesName}") String authCookiesName, @Value(value="${login.sso.tokenServerCertPath}") String tokenServerCertPath, @Value(value="${login.sso.appKeyStorePath}") String appKeyStorePath, @Value(value="${login.sso.appKeyStoreAlias}") String appKeyStoreAlias, @Value(value="${login.sso.appKeyStoreAliasPwd}") String appKeyStoreAliasPwd, @Value(value="${login.sso.keyStoreType}") String keyStoreType, @Value(value="${login.sso.appid}") String appid, @Value(value="${login.sso.returnUrl}") String returnUrl, @Value(value="${login.sso.serverUrl}") String serverUrl, @Value(value="${login.sso.authMethod:1}") String authMethod, @Value(value="${login.sso.logout.serverUrl}") String logoutServUrl, @Value(value="${login.forbidRoles}") String forbidRoles) {
        CNTPSSOLoginCheckFilter frontEndLoginCheckFilter = new CNTPSSOLoginCheckFilter();
        frontEndLoginCheckFilter.setExcludeUrls(excludeUrls);
        frontEndLoginCheckFilter.setLoginUrl(loginUrl);
        frontEndLoginCheckFilter.setCheckUrls(checkUrls);
        frontEndLoginCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);
        frontEndLoginCheckFilter.setAppid(appid);
        frontEndLoginCheckFilter.setAppKeyStoreAlias(appKeyStoreAlias);
        frontEndLoginCheckFilter.setAppKeyStoreAliasPwd(appKeyStoreAliasPwd);
        frontEndLoginCheckFilter.setAppKeyStorePath(appKeyStorePath);
        frontEndLoginCheckFilter.setAuthCookiesName(authCookiesName);
        frontEndLoginCheckFilter.setKeyStoreType(keyStoreType);
        frontEndLoginCheckFilter.setTokenServerCertPath(tokenServerCertPath);
        frontEndLoginCheckFilter.setReturnUrl(returnUrl);
        frontEndLoginCheckFilter.setServerUrl(serverUrl);
        frontEndLoginCheckFilter.setAuthMethod(authMethod);
        frontEndLoginCheckFilter.setLogoutServUrl(logoutServUrl);
        frontEndLoginCheckFilter.setIgnoreCallBackPattens(this.callbackignore);
        frontEndLoginCheckFilter.setForbidRoles(forbidRoles);
        return frontEndLoginCheckFilter;
    }

    public List<String> getCallbackignore() {
        return this.callbackignore;
    }

    public void setCallbackignore(List<String> callbackignore) {
        this.callbackignore = callbackignore;
    }
}

