/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import bidding.web.service.BiddingAuditorService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BiddingAuditIncomeInfoVo;
import bidding.web.vo.BiddingAuditInfoVo;
import bidding.web.vo.BiddingAuditValidateInfoVo;
import bidding.web.vo.QueryStatus;
import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.date.DateUtils;
import utils.web.ResponseMapUtils;
import workflow.vo.WorkFlowVo;

@RestController
@RequestMapping(value={"biddingAuditor"})
public class BiddingAuditorController {
    @Autowired
    BiddingAuditorService biddingAuditorService;
    @Autowired
    BiddingOperatorService biddingOperatorService;

    @RequestMapping(value={"/biddingResultAudit"})
    public BaseResponse biddingResultAudit(WorkFlowVo workFlowVo) {
        return this.biddingAuditorService.biddingResultAudit(workFlowVo);
    }

    @RequestMapping(value={"/querryBidding"})
    @ResponseBody
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, HttpServletRequest request, BiddingAuditInfoVo biddingAuditInfoVo) {
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (!Lang.isEmpty((Object)startTime)) {
                biddingAuditInfoVo.setBiddingStartTime(sdf.parse(startTime));
            }
            if (!Lang.isEmpty((Object)endTime)) {
                biddingAuditInfoVo.setBiddingEndTime(sdf.parse(endTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String workId = (String)request.getSession().getAttribute("BIDDING_AUDITOR_WORK_ID");
        Map resultMap = this.biddingOperatorService.audirQuerryPageBidding(jqueryDataTablesVo, workId, null, biddingAuditInfoVo);
        if (!Lang.isEmpty((Object)biddingAuditInfoVo.getBiddingStartTime())) {
            biddingAuditInfoVo.setStart(DateUtils.toString((Date)biddingAuditInfoVo.getBiddingStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (!Lang.isEmpty((Object)biddingAuditInfoVo.getBiddingEndTime())) {
            biddingAuditInfoVo.setEnd(DateUtils.toString((Date)biddingAuditInfoVo.getBiddingEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        biddingAuditInfoVo.setPageNo(jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength() + 1 + "");
        request.getSession().setAttribute("auditId", (Object)workId);
        request.getSession().setAttribute("auditBiddingTemp", (Object)JSON.toJSONString((Object)biddingAuditInfoVo));
        request.getSession().setAttribute("auditBiddingPageTemp", (Object)JSON.toJSONString((Object)jqueryDataTablesVo));
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/getAuditStatus"})
    public List<QueryStatus> getAllStatus() {
        List allStatusList = this.biddingOperatorService.getAuditStatus();
        return allStatusList;
    }

    @RequestMapping(value={"/getAuditInfo"})
    public BaseResponse<BiddingAuditValidateInfoVo> getAuditInfo(HttpServletRequest request, BiddingAuditIncomeInfoVo biddingAuditIncomeInfoVo) {
        String workId = (String)request.getSession().getAttribute("BIDDING_AUDITOR_WORK_ID");
        biddingAuditIncomeInfoVo.setWorkerId(workId);
        BaseResponse auditInfo = this.biddingAuditorService.getAuditInfo(biddingAuditIncomeInfoVo);
        if (auditInfo.isSuccess()) {
            request.getSession().setAttribute("BIDDING_AUDITOR_WORK_ID", (Object)((BiddingAuditValidateInfoVo)auditInfo.getResult()).getWorkerId());
            ((BiddingAuditValidateInfoVo)auditInfo.getResult()).setWorkerId(null);
        }
        return auditInfo;
    }
}

