/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import bidding.web.service.BiddingGroupService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BiddingChangeStateVo;
import bidding.web.vo.BiddingConformityAuditVO;
import bidding.web.vo.BiddingDemandAuditVo;
import bidding.web.vo.ResComplianceAuditVo;
import bidding.web.vo.VoteDetailVo;
import dto.JcbdBiddingOperationLogDto;
import javax.servlet.http.HttpServletRequest;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@RestController
@RequestMapping(value={"biddingGroup"})
public class BiddingGroupController {
    public static final Logger log = LoggerFactory.getLogger(BiddingGroupController.class);
    public static final String businessCode = "\u7ade\u4ef7\u91c7\u8d2d";
    @Autowired
    BiddingGroupService biddingGroupService;
    @Autowired
    BiddingOperatorService biddingOperatorService;

    @RequestMapping(value={"/saveComplianceAudit"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse saveComplianceAudit(@RequestBody BiddingConformityAuditVO biddingConformityAuditVO, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingConformityAuditVO.getBiddingNo()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        if ("BIDDING_GROUP_MEMBER".equals(biddingConformityAuditVO.getSource())) {
            String email = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
            if (!StringUtils.isEmpty((Object)email)) {
                biddingConformityAuditVO.setEmail(email);
                BaseResponse baseResponse = this.biddingGroupService.saveComplianceAudit(biddingConformityAuditVO);
                return baseResponse;
            }
        } else {
            String biddingMemberId = (String)request.getSession().getAttribute("member_id");
            if (!StringUtils.isEmpty((Object)biddingMemberId)) {
                biddingConformityAuditVO.setAuditorId(biddingMemberId);
                BaseResponse baseResponse = this.biddingGroupService.saveComplianceAudit(biddingConformityAuditVO);
                return baseResponse;
            }
        }
        return new BaseResponse("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
    }

    @RequestMapping(value={"/submitComplianceAudit"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse submitComplianceAudit(String biddingNo, HttpServletRequest request, String source) {
        if (this.biddingOperatorService.biddingIsFinish(biddingNo).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String email = null;
        String auditorId = null;
        if ("BIDDING_GROUP_MEMBER".equals(source)) {
            email = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        } else {
            auditorId = (String)request.getSession().getAttribute("member_id");
        }
        if (!StringUtils.isEmpty((Object)auditorId) || !StringUtils.isEmpty((Object)email)) {
            BaseResponse baseResponse = this.biddingGroupService.submitComplianceAuditResult(biddingNo, auditorId, email);
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("\u63d0\u4ea4\u7b26\u5408\u6027\u5ba1\u67e5");
                jcbdBiddingOperationLogDto.setRemark("");
                if (auditorId != null) {
                    this.biddingOperatorService.saveOperatorsLog(auditorId, biddingNo, jcbdBiddingOperationLogDto);
                } else if (email != null) {
                    this.biddingOperatorService.saveOperatorsLog(email, biddingNo, jcbdBiddingOperationLogDto);
                }
            }
            return baseResponse;
        }
        return new BaseResponse("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
    }

    @RequestMapping(value={"/submitComplianceAuditResult"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse submitComplianceAuditResult(String biddingNo, HttpServletRequest request, String source) {
        BaseResponse baseResponse = null;
        String email = null;
        String auditorId = null;
        if ("BIDDING_GROUP_MEMBER".equals(source)) {
            email = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        } else {
            auditorId = (String)request.getSession().getAttribute("member_id");
        }
        if (!StringUtils.isEmpty((Object)auditorId) || !StringUtils.isEmpty((Object)email)) {
            baseResponse = this.biddingGroupService.compeleteAudit(biddingNo, auditorId, email);
        }
        return baseResponse;
    }

    @RequestMapping(value={"/auditBidding"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse auditBidding(@RequestBody BiddingDemandAuditVo biddingDemandAuditVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingDemandAuditVo.getBiddingNo()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String email = null;
        String auditorId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)auditorId)) {
            email = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        }
        biddingDemandAuditVo.setEmail(email);
        biddingDemandAuditVo.setAuditorId(auditorId);
        String memberId = (String)request.getSession().getAttribute("member_id");
        log.info("login memberId{}", (Object)memberId);
        MemberDto memberDto = this.biddingOperatorService.getMember(memberId);
        if (!(Lang.isEmpty((Object)email) || Lang.isEmpty((Object)memberDto) || Lang.isEmpty((Object)memberDto.getCoreUser()) || email.equals(memberDto.getCoreUser().getEmail()))) {
            return new BaseResponse("\u8d26\u53f7\u767b\u5f55\u5f02\u5e38\uff01 ");
        }
        if (!(Lang.isEmpty((Object)email) && Lang.isEmpty((Object)auditorId) || biddingDemandAuditVo.getBiddingNo().isEmpty())) {
            BaseResponse baseResponse = this.biddingGroupService.auditBidding(biddingDemandAuditVo);
            if (baseResponse.isSuccess()) {
                String pass = "1";
                String noPass = "0";
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                if (pass.equals(biddingDemandAuditVo.getStatus())) {
                    jcbdBiddingOperationLogDto.setOperationContent("\u5ba1\u6838\u7ade\u4ef7\u901a\u8fc7");
                } else if (noPass.equals(biddingDemandAuditVo.getStatus())) {
                    jcbdBiddingOperationLogDto.setOperationContent("\u5ba1\u6838\u7ade\u4ef7\u4e0d\u901a\u8fc7");
                }
                if (biddingDemandAuditVo.getAuditMemo().isEmpty()) {
                    jcbdBiddingOperationLogDto.setRemark("\u540c\u610f");
                } else {
                    jcbdBiddingOperationLogDto.setRemark(biddingDemandAuditVo.getAuditMemo());
                }
                if (auditorId != null) {
                    this.biddingOperatorService.saveOperatorsLog(auditorId, biddingDemandAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);
                } else if (email != null) {
                    this.biddingOperatorService.saveOperatorsLog(email, biddingDemandAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);
                }
            }
            return baseResponse;
        }
        return new BaseResponse("\u5df2\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u5ba1\u6838 ");
    }

    @RequestMapping(value={"/voteConfirmSupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse voteConfirmSupplier(@RequestBody BiddingChangeStateVo changeStateVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(changeStateVo.getBiddingNo()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String auditorId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)changeStateVo.getBiddingNo()) && !Lang.isEmpty((Object)auditorId)) {
            BaseResponse baseResponse = this.biddingGroupService.voteConfirmSupplier(changeStateVo, auditorId);
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("\u5f00\u542f\u6295\u7968");
                jcbdBiddingOperationLogDto.setRemark("");
                this.biddingOperatorService.saveOperatorsLog(auditorId, changeStateVo.getBiddingNo(), jcbdBiddingOperationLogDto);
            }
            return baseResponse;
        }
        return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/vote"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse vote(@RequestBody VoteDetailVo voteDetailVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(voteDetailVo.getBusinessIdentifying()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        BaseResponse baseResponse = null;
        voteDetailVo.setBusinessCode(businessCode);
        String auditorEmail = null;
        String auditorId = null;
        if ("BIDDING_GROUP_MEMBER".equals(voteDetailVo.getSource())) {
            auditorEmail = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
            String memberId = (String)request.getSession().getAttribute("member_id");
            MemberDto memberDto = this.biddingOperatorService.getMember(memberId);
            if (!(Lang.isEmpty((Object)auditorEmail) || Lang.isEmpty((Object)memberDto) || Lang.isEmpty((Object)memberDto.getCoreUser()) || auditorEmail.equals(memberDto.getCoreUser().getEmail()))) {
                return new BaseResponse("\u6295\u7968\u5f02\u5e38");
            }
        } else {
            auditorId = (String)request.getSession().getAttribute("member_id");
        }
        if (!StringUtils.isEmpty((Object)auditorId) || !StringUtils.isEmpty((Object)auditorEmail)) {
            voteDetailVo.setVoteMemberId(auditorId);
            baseResponse = this.biddingGroupService.vote(voteDetailVo, auditorEmail);
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("\u6295\u7968");
                jcbdBiddingOperationLogDto.setRemark("");
                if (auditorId != null) {
                    this.biddingOperatorService.saveOperatorsLog(auditorId, voteDetailVo.getBusinessIdentifying(), jcbdBiddingOperationLogDto);
                } else if (auditorEmail != null) {
                    this.biddingOperatorService.saveOperatorsLog(auditorEmail, voteDetailVo.getBusinessIdentifying(), jcbdBiddingOperationLogDto);
                }
            }
        }
        return baseResponse;
    }

    @RequestMapping(value={"/restartComplianceAudit"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse restartComplianceAudit(@RequestBody ResComplianceAuditVo resComplianceAuditVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(resComplianceAuditVo.getBiddingNo()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String auditorId = (String)request.getSession().getAttribute("member_id");
        BaseResponse baseResponse = null;
        if (!StringUtils.isEmpty((Object)resComplianceAuditVo.getBiddingNo()) && (baseResponse = this.biddingGroupService.restartComplianceAudit(resComplianceAuditVo, auditorId)).isSuccess()) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("\u91cd\u65b0\u53d1\u8d77\u7b26\u5408\u6027\u5ba1\u67e5");
            jcbdBiddingOperationLogDto.setRemark("");
            this.biddingOperatorService.saveOperatorsLog(auditorId, resComplianceAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);
        }
        return baseResponse;
    }
}

