/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import bidding.api.vo.BiddingMemberLoginInfoVo;
import com.alibaba.fastjson.JSON;
import java.util.Base64;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.security.AesUtil;

@Controller
@RequestMapping(value={"biddingGroupMember"})
public class BiddingLoginController {
    @Value(value="${bidding.groupMember.login.params}")
    public String groupMemberLoginKey;
    @Value(value="${bidding.groupMember.loginUrl}")
    private String groupMemberLoginUrl;
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"check"})
    public String login(HttpSession session, String params) {
        BiddingMemberLoginInfoVo biddingMemberLoginInfoVo = null;
        try {
            biddingMemberLoginInfoVo = (BiddingMemberLoginInfoVo)JSON.parseObject((String)new String(AesUtil.Decrypt((String)new String(Base64.getDecoder().decode(params)), (String)this.groupMemberLoginKey)), BiddingMemberLoginInfoVo.class);
            this.logger.info("biddingMemberLoginInfoVo={}", (Object)JSON.toJSONString((Object)biddingMemberLoginInfoVo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        session.setAttribute("BIDDING_USER_EMAIL", (Object)biddingMemberLoginInfoVo.getEmail());
        session.setAttribute("BIDDING_MEMBER_ROLE", (Object)"BIDDING_GROUP_MEMBER");
        return "redirect:" + biddingMemberLoginInfoVo.getRedirectUrl() + "?biddingNo=" + biddingMemberLoginInfoVo.getBiddingNo() + "&source=" + "BIDDING_GROUP_MEMBER";
    }

    @RequestMapping(value={"getUrl"})
    @ResponseBody
    public String getUrl(String biddingNo, String email, String redirectUrl) {
        BiddingMemberLoginInfoVo biddingMemberLoginInfoVo = new BiddingMemberLoginInfoVo();
        biddingMemberLoginInfoVo.setBiddingNo(biddingNo);
        biddingMemberLoginInfoVo.setEmail(email);
        biddingMemberLoginInfoVo.setRedirectUrl(redirectUrl);
        String paramsJsonStr = JSON.toJSONString((Object)biddingMemberLoginInfoVo);
        try {
            String params = AesUtil.Encrypt((String)paramsJsonStr, (String)this.groupMemberLoginKey);
            params = new String(Base64.getEncoder().encode(params.getBytes()));
            String url = this.groupMemberLoginUrl + "?params=" + params;
            this.logger.info("url={}", (Object)url);
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

