/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BiddingAuditVo;
import bidding.web.vo.BiddingChangeStateVo;
import bidding.web.vo.BiddingDemandVo;
import bidding.web.vo.BiddingIssueRequestVo;
import bidding.web.vo.BiddingQueryOperativeBuySaveVo;
import bidding.web.vo.ExcelImportDataVo;
import bidding.web.vo.ImageVo;
import bidding.web.vo.JcbdBdProviderVo;
import bidding.web.vo.JcbdBiddingGroupMemberVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.JcbdTempGoodsVo;
import bidding.web.vo.QueryBiddingRequestVO;
import bidding.web.vo.SubmitResultVo;
import bidding.web.vo.TempPurchaseVo;
import bidding.web.vo.TianXianRequestVo;
import bidding.web.vo.TiaoXianCompanyVo;
import bidding.web.vo.UploadCountVo;
import bidding.web.vo.UploadSaveVo;
import bidding.web.vo.UserInformationVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOperateCode;
import definition.BiddingStatus;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdBiddingOperationLogDto;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import member.api.QueryInformationApi;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.JsonModel;
import member.api.vo.MemberAddressVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import store.api.dto.modeldto.core.StoreDto;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ReadExcelUtil;
import utils.web.ResponseMapUtils;
import workflow.definition.WorkFlowCode;

@RestController
@RequestMapping(value={"biddingOperator"})
public class BiddingOperatorController {
    @Autowired
    BiddingOperatorService biddingOperatorService;
    public static final Logger log = LoggerFactory.getLogger(BiddingOperatorController.class);
    private static final String CONSIGNEE_FLAG = "0";
    @MotanReferer
    QueryInformationApi queryInformationApi;
    public static final String VALUE_ADDED_TAX_SPECIAL_INVOICE = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
    public static final String VALUE_ADDED_TAX_NOMAL_INVOICE = "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968";
    @Autowired
    RedisTemplate redisTemplate;

    @RequestMapping(value={"/startComplianceAudit"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse startComplianceAudit(@RequestBody BiddingChangeStateVo biddingChangeStateVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingChangeStateVo.getBiddingNo()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)biddingChangeStateVo.getBiddingNo()) && !Lang.isEmpty((Object)biddingMemberId)) {
            BaseResponse baseResponse = this.biddingOperatorService.startComplianceAudit(biddingChangeStateVo, biddingMemberId);
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("\u5f00\u542f\u7b26\u5408\u6027\u5ba1\u67e5");
                jcbdBiddingOperationLogDto.setRemark("");
                this.biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingChangeStateVo.getBiddingNo(), jcbdBiddingOperationLogDto);
            }
            return baseResponse;
        }
        return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/reSendAuditEmail"}, method={RequestMethod.POST})
    public BaseResponse reSendAuditEmail(String biddingNo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingNo).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)biddingNo) && !Lang.isEmpty((Object)biddingMemberId)) {
            BaseResponse baseResponse = this.biddingOperatorService.reSendAuditEmail(biddingNo, biddingMemberId);
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("\u91cd\u53d1\u5ba1\u67e5\u90ae\u4ef6");
                jcbdBiddingOperationLogDto.setRemark("");
                this.biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingNo, jcbdBiddingOperationLogDto);
            }
            return baseResponse;
        }
        return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u83b7\u53d6\u5931\u8d25");
    }

    @RequestMapping(value={"/reSendBiddingAuditEmail"}, method={RequestMethod.POST})
    public BaseResponse reSendBiddingAuditEmail(String biddingNo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingNo).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)biddingNo)) {
            this.biddingOperatorService.mailOfGroupMembers(biddingNo, biddingMemberId);
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("\u91cd\u53d1\u5ba1\u6838\u90ae\u4ef6");
            jcbdBiddingOperationLogDto.setRemark("");
            this.biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingNo, jcbdBiddingOperationLogDto);
            return new BaseResponse(true, "\u53d1\u9001\u6210\u529f");
        }
        return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u83b7\u53d6\u5931\u8d25");
    }

    @RequestMapping(value={"/querryPageBidding"}, method={RequestMethod.POST})
    @ResponseBody
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, HttpServletRequest request, QueryBiddingRequestVO queryBiddingRequestVO) {
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        String biddingEmail = null;
        if (biddingMemberId == null) {
            biddingEmail = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        }
        ArrayList<String> biddingMemberRoles = new ArrayList<String>();
        String biddingMemberRole = (String)request.getSession().getAttribute("BIDDING_MEMBER_ROLE");
        if (Lang.isEmpty((Object)biddingEmail) && Lang.isEmpty((Object)biddingMemberId) && Lang.isEmpty((Object)biddingMemberRole)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        if (!Lang.isEmpty((Object)biddingMemberRole)) {
            biddingMemberRoles.add("BIDDING_OPERATOR");
            biddingMemberRoles.add(biddingMemberRole);
            request.getSession().setAttribute("operateIdentity", (Object)biddingMemberId);
        } else {
            biddingMemberRoles.add("BIDDING_GROUP_MEMBER");
            request.getSession().setAttribute("operateIdentity", (Object)biddingEmail);
        }
        Map resultMap = this.biddingOperatorService.querryPageBidding(jqueryDataTablesVo, biddingMemberId, biddingEmail, biddingMemberRoles, queryBiddingRequestVO);
        queryBiddingRequestVO.setPageNo(jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength() + 1 + "");
        request.getSession().setAttribute("operateBiddingTemp", (Object)JSON.toJSONString((Object)queryBiddingRequestVO));
        request.getSession().setAttribute("operateBiddingPageTemp", (Object)JSON.toJSONString((Object)jqueryDataTablesVo));
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/issueBidding"}, method={RequestMethod.POST})
    @ResponseBody
    public Map issueBidding(@RequestBody BiddingIssueRequestVo biddingIssueRequestVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingIssueRequestVo.getBiddingCode()).booleanValue()) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)biddingIssueRequestVo) || Lang.isEmpty((Object)biddingIssueRequestVo.getBiddingCode())) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4e0d\u5230\u7ade\u4ef7\u7f16\u53f7");
        }
        Map returnMap = this.biddingOperatorService.issueBidding(biddingIssueRequestVo, biddingMemberId);
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("\u53d1\u5e03\u7ade\u4ef7");
        jcbdBiddingOperationLogDto.setRemark("");
        this.biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingIssueRequestVo.getBiddingCode(), jcbdBiddingOperationLogDto);
        return returnMap;
    }

    @RequestMapping(value={"/getBiddingTime"}, method={RequestMethod.POST})
    @ResponseBody
    public Map getBiddingTime(String biddingCode) {
        JcbdBiddingVo jcbdBiddingVo = this.biddingOperatorService.getBiddingByBiddingCode(biddingCode);
        Integer a = jcbdBiddingVo.getBiddingPeriod();
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar ca = Calendar.getInstance();
        ca.add(5, a);
        date = ca.getTime();
        String s = DateUtils.toString((Date)date, (String)"yyyy-MM-dd");
        return ResponseMapUtils.success((Object)s);
    }

    @RequestMapping(value={"biddingCodeAndUser"}, method={RequestMethod.POST})
    public JcbdBiddingVo getBiddingCodeAndUser(HttpServletRequest request, JcbdBiddingVo jcbdBiddingVo) {
        String biddingCode = this.biddingOperatorService.getBiddingCode();
        jcbdBiddingVo.setBiddingCode(biddingCode);
        String biddingUserId = (String)request.getSession().getAttribute("member_id");
        JcbdBiddingVo biddingMember = this.biddingOperatorService.getOperator(biddingUserId);
        UserInformationVo memberCompanyInformation = this.biddingOperatorService.getMemberCompanyInformatio(biddingUserId);
        jcbdBiddingVo.setUsername(biddingMember.getUsername());
        jcbdBiddingVo.setPhone(biddingMember.getPhone());
        jcbdBiddingVo.setEmail(biddingMember.getEmail());
        jcbdBiddingVo.setGroupMemberInfo(new StringBuffer(memberCompanyInformation.getWholeJobName()).append(",").append(biddingMember.getUsername()).append(",").append(biddingMember.getEmail()).toString());
        List jcbdStoreContactsVoList = this.biddingOperatorService.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
        jcbdBiddingVo.setJcbdBdProviders(jcbdStoreContactsVoList);
        return jcbdBiddingVo;
    }

    @RequestMapping(value={"/biddingEdit"}, method={RequestMethod.POST})
    public Map biddingEdit(HttpServletRequest request, JcbdBiddingVo jcbdBiddingVo, @RequestParam(required=false) String imageVos) {
        String id = request.getParameter("biddingId");
        jcbdBiddingVo.setId(id);
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)memberId) || "".equals(memberId)) {
            return ResponseMapUtils.error((String)"\u7ecf\u529e\u4eba\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        String userId = (String)request.getSession().getAttribute("user_id");
        if (Lang.isEmpty((Object)userId) || "".equals(userId)) {
            return ResponseMapUtils.error((String)"\u7ecf\u529e\u4eba\u4fe1\u606f\u83b7\u53d6userId\u5931\u8d25");
        }
        JcbdBiddingVo operator = this.biddingOperatorService.getOperator(memberId);
        jcbdBiddingVo.setOperatorId(memberId);
        jcbdBiddingVo.setUsername(operator.getUsername());
        jcbdBiddingVo.setEmail(operator.getEmail());
        jcbdBiddingVo.setPhone(operator.getPhone());
        List imageVoList = JSON.parseArray((String)imageVos, ImageVo.class);
        String[] biddingGroups = request.getParameterValues("biddingGroup");
        String[] hiddenBiddingGroupMemberIds = request.getParameterValues("hiddenBiddingGroupMemberId");
        String[] hiddenBiddingSpliceStringIds = request.getParameterValues("hiddenBiddingSpliceStringIds");
        Map resultMap = this.biddingOperatorService.saveOrUpdateBiddingBaseInfo(jcbdBiddingVo, biddingGroups, hiddenBiddingGroupMemberIds, hiddenBiddingSpliceStringIds, imageVoList, userId);
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        if (Lang.isEmpty((Object)id)) {
            jcbdBiddingOperationLogDto.setOperationContent("\u4fdd\u5b58\u7ade\u4ef7");
            jcbdBiddingOperationLogDto.setRemark("");
        } else {
            jcbdBiddingOperationLogDto.setOperationContent("\u4fee\u6539\u7ade\u4ef7\u5e76\u4fdd\u5b58");
            jcbdBiddingOperationLogDto.setRemark("");
        }
        this.biddingOperatorService.saveOperatorsLog(memberId, jcbdBiddingVo.getBiddingCode(), jcbdBiddingOperationLogDto);
        return resultMap;
    }

    @RequestMapping(value={"/biddEdit"}, method={RequestMethod.POST})
    public JcbdBiddingVo bidEdit(HttpServletRequest request, String biddingCode) {
        JcbdBiddingVo biddingVo = this.biddingOperatorService.getBiddingByBiddingCode(biddingCode);
        if (!Lang.isEmpty((Object)biddingVo)) {
            String biddingUserId = (String)request.getSession().getAttribute("member_id");
            JcbdBiddingVo byMemberId = this.biddingOperatorService.getOperator(biddingUserId);
            biddingVo.setUsername(byMemberId.getUsername());
            biddingVo.setPhone(byMemberId.getPhone());
            biddingVo.setEmail(byMemberId.getEmail());
            List jcbdStoreContactsVoList = this.biddingOperatorService.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
            biddingVo.setJcbdBdProviders(jcbdStoreContactsVoList);
            return biddingVo;
        }
        return null;
    }

    @RequestMapping(value={"biddingDemandCode"}, method={RequestMethod.POST})
    public BiddingDemandVo getBiddingDemandCode(String biddingCode) {
        BiddingDemandVo biddingDemandVo = new BiddingDemandVo();
        String demandCode = this.biddingOperatorService.getDemandCode(biddingCode);
        biddingDemandVo.setDemandCode(demandCode);
        return biddingDemandVo;
    }

    @RequestMapping(value={"biddingDemandEdit"}, method={RequestMethod.POST})
    public String biddingDemandEdit(HttpServletRequest request, BiddingDemandVo biddingDemandVo) {
        String opertorsId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)biddingDemandVo.getBiddingId())) {
            return "biddingId_is_null";
        }
        String[] demandAddress = request.getParameterValues("demandAddress");
        String[] numberNeed = request.getParameterValues("numberNeed");
        String[] conformances = request.getParameterValues("conformance");
        this.biddingOperatorService.saveOrUpdateBiddingDemand(biddingDemandVo, demandAddress, numberNeed, conformances);
        return "success";
    }

    @RequestMapping(value={"/submitBiddingAudit"}, method={RequestMethod.POST})
    public String saveBiddingToAuditing(HttpServletRequest request, String biddingCode) {
        if (this.biddingOperatorService.biddingIsFinish(biddingCode).booleanValue()) {
            return "error";
        }
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)biddingCode)) {
            return "biddingCode_id_null";
        }
        if (Lang.isEmpty((Object)biddingMemberId)) {
            return "biddingMemberId_is_null";
        }
        this.biddingOperatorService.updateBiddingGroupCheckNo(biddingCode);
        JcbdBiddingVo jcbdBiddingVo = this.biddingOperatorService.findByBiddingCodeAndIsDelete(biddingCode);
        List biddingDemandVoList = this.biddingOperatorService.findByJcbdBiddingCodeAndIsDelete(biddingCode);
        if (Lang.isEmpty((Object)biddingDemandVoList)) {
            return "error";
        }
        BiddingChangeStateVo biddingChangeStateVo = new BiddingChangeStateVo();
        biddingChangeStateVo.setBiddingNo(biddingCode);
        biddingChangeStateVo.setOpcode(BiddingOperateCode.SUBMIT_BIDDING.getCode());
        if (jcbdBiddingVo.getStatus().equals(BiddingStatus.OM_SUBMIT_WAIT.getValue())) {
            biddingChangeStateVo.setCurrentState(BiddingStatus.OM_SUBMIT_WAIT.getValue());
        } else {
            biddingChangeStateVo.setCurrentState(BiddingStatus.OM_AUDIT_NO.getValue());
        }
        this.biddingOperatorService.changeBiddingState(biddingChangeStateVo);
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("\u63d0\u4ea4\u5ba1\u6838");
        jcbdBiddingOperationLogDto.setRemark("");
        this.biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingCode, jcbdBiddingOperationLogDto);
        this.biddingOperatorService.mailOfGroupMembers(biddingCode, biddingMemberId);
        return "success";
    }

    @RequestMapping(value={"/getBiddingBaseInfo"}, method={RequestMethod.POST})
    public JcbdBiddingVo auditBidding(String biddingNo, HttpServletRequest request) {
        JcbdBiddingVo jcbdBiddingVo = this.biddingOperatorService.getBiddingByBiddingCode(biddingNo);
        ArrayList<JcbdBiddingGroupMemberVo> jcbdBiddingGroupMembersNew = new ArrayList<JcbdBiddingGroupMemberVo>();
        if (!Lang.isEmpty((Object)jcbdBiddingVo.getJcbdBiddingGroupMembers())) {
            List jcbdBiddingGroupMembers = jcbdBiddingVo.getJcbdBiddingGroupMembers();
            for (JcbdBiddingGroupMemberVo jcbdBiddingGroupMember : jcbdBiddingGroupMembers) {
                String companyName = this.biddingOperatorService.getOperateInformation(jcbdBiddingGroupMember.getGroupMemberId()).getWholeJobName();
                jcbdBiddingGroupMember.setName(new StringBuffer(companyName).append(jcbdBiddingGroupMember.getName()).toString());
                jcbdBiddingGroupMembersNew.add(jcbdBiddingGroupMember);
            }
            jcbdBiddingVo.setJcbdBiddingGroupMembers(jcbdBiddingGroupMembersNew);
        }
        String operatorId = jcbdBiddingVo.getOperatorId();
        JcbdBiddingVo biddingVo = this.biddingOperatorService.getOperator(operatorId);
        jcbdBiddingVo.setUsername(biddingVo.getUsername());
        jcbdBiddingVo.setPhone(biddingVo.getPhone());
        jcbdBiddingVo.setEmail(biddingVo.getEmail());
        List jcbdBdProviders = jcbdBiddingVo.getJcbdBdProviders();
        List jcbdStoreList = this.biddingOperatorService.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
        for (int i = 0; i < jcbdStoreList.size(); ++i) {
            if (!((JcbdBdProviderVo)jcbdStoreList.get(i)).getProviderName().equals(((JcbdBdProviderVo)jcbdBdProviders.get(i)).getProviderName())) continue;
            ((JcbdBdProviderVo)jcbdStoreList.get(i)).setResponseStatus(((JcbdBdProviderVo)jcbdBdProviders.get(i)).getResponseStatus());
        }
        jcbdBiddingVo.setJcbdBdProviders(jcbdStoreList);
        Date timeStartResponse = jcbdBiddingVo.getTimeStartResponse();
        Date timeEndResponse = jcbdBiddingVo.getTimeEndResponse();
        if (!Lang.isEmpty((Object)timeStartResponse) || !Lang.isEmpty((Object)timeEndResponse)) {
            jcbdBiddingVo.setTimeStartResponses(DateUtils.dateToStr((Date)timeStartResponse, (String)"yyyy-MM-dd HH:mm:ss"));
            jcbdBiddingVo.setTimeEndResponses(DateUtils.dateToStr((Date)timeEndResponse, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return jcbdBiddingVo;
    }

    @RequestMapping(value={"/querryPageBiddingDemad"}, method={RequestMethod.POST})
    @ResponseBody
    public Map querryPageBiddingDemad(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u9519\u8bef");
        }
        Map resultMap = this.biddingOperatorService.querryPageBiddingDemad(jqueryDataTablesVo, biddingCode);
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/queryResponseOutline"}, method={RequestMethod.POST})
    @ResponseBody
    public Map queryResponseOutline(String biddingCode, String demandCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)demandCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u9700\u6c42\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingOperatorService.queryResponseOutline(biddingCode, demandCode);
        resultMap.put("demandCode", demandCode);
        return resultMap;
    }

    @RequestMapping(value={"/queryDemandResponse"}, method={RequestMethod.POST})
    public Map queryDemandResponse(String biddingCode, String demandCode, String supplierId) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)demandCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u9700\u6c42\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingOperatorService.queryDemandResponse(biddingCode, demandCode, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/submitResultAudit"}, method={RequestMethod.POST})
    public Map submitResultAudit(@RequestBody SubmitResultVo submitResultVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(submitResultVo.getBiddingCode()).booleanValue()) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)submitResultVo.getBiddingCode())) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)memberId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        Map resultAudit = this.biddingOperatorService.submitResultAudit(submitResultVo, memberId);
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("\u63d0\u4ea4\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6838");
        jcbdBiddingOperationLogDto.setRemark("");
        this.biddingOperatorService.saveOperatorsLog(memberId, submitResultVo.getBiddingCode(), jcbdBiddingOperationLogDto);
        return resultAudit;
    }

    @RequestMapping(value={"/findBidDemandPage"}, method={RequestMethod.POST})
    public Map findBidDemandPage(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return null;
        }
        Map resultMap = this.biddingOperatorService.getBiddingDemandList(jqueryDataTablesVo, biddingCode);
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/getBiddingDemandInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public BiddingDemandVo findBidDemand(BiddingDemandVo biddingDemandVo) {
        BiddingDemandVo bidDemand = this.biddingOperatorService.getBiddingDemandInfo(biddingDemandVo.getDemandCode());
        return bidDemand;
    }

    @RequestMapping(value={"/deleteBidDemand"}, method={RequestMethod.POST})
    public BaseResponse deleteBidDemand(BiddingDemandVo biddingDemandVo) {
        BaseResponse baseResponse = null;
        if (!Lang.isEmpty((Object)biddingDemandVo)) {
            baseResponse = this.biddingOperatorService.deleteBidDemand(biddingDemandVo.getDemandCode());
        }
        return baseResponse;
    }

    @RequestMapping(value={"/OpenbidPrice"}, method={RequestMethod.POST})
    public BaseResponse OpenbidPrice(JcbdBiddingVo jcbdBiddingVo, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        String biddingCode = jcbdBiddingVo.getBiddingCode();
        if (this.biddingOperatorService.biddingIsFinish(biddingCode).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        BaseResponse baseResponse = this.biddingOperatorService.openPrice(biddingCode);
        if (baseResponse.isSuccess()) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("\u5f00\u542f\u62a5\u4ef7");
            jcbdBiddingOperationLogDto.setRemark("");
            this.biddingOperatorService.saveOperatorsLog(memberId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return baseResponse;
    }

    @RequestMapping(value={"/randomProvider"}, method={RequestMethod.POST})
    public BaseResponse randomProvider(JcbdBiddingVo jcbdBiddingVo, HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        String biddingCode = jcbdBiddingVo.getBiddingCode();
        if (this.biddingOperatorService.biddingIsFinish(biddingCode).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        BaseResponse baseResponse = this.biddingOperatorService.randomConfirmSupplier(biddingCode);
        if (baseResponse.isSuccess()) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("\u7cfb\u7edf\u968f\u673a\u9009\u62e9\u4f9b\u5e94\u5546");
            jcbdBiddingOperationLogDto.setRemark("");
            this.biddingOperatorService.saveOperatorsLog(memberId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return baseResponse;
    }

    @RequestMapping(value={"/biddingResult"}, method={RequestMethod.POST})
    public Map biddingResult(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        Map resultMap = this.biddingOperatorService.getBiddingResultDemandList(jqueryDataTablesVo, biddingCode);
        return resultMap;
    }

    @RequestMapping(value={"/queryBiddingDemandResponse"}, method={RequestMethod.POST})
    public Map queryBiddingDemandResponse(String biddingCode, String demandCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)demandCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u9700\u6c42\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingOperatorService.queryBiddingDemandResponse(biddingCode, demandCode);
        resultMap.put("demandCode", demandCode);
        return resultMap;
    }

    @RequestMapping(value={"/defaultAddress"}, method={RequestMethod.POST})
    public MemberAddressVo defaultAddress(String memberId) {
        MemberAddressVo memberAddressVo = this.biddingOperatorService.defaultAddress(memberId);
        return memberAddressVo;
    }

    @RequestMapping(value={"/defaultAddressList"}, method={RequestMethod.POST})
    public Set<String> defaultAddressList(HttpServletRequest request) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        List memberAddressVos = this.biddingOperatorService.defaultAddressList(memberId);
        HashSet<String> addressSet = new HashSet<String>();
        if (!Lang.isEmpty((Object)memberAddressVos)) {
            for (MemberAddressVo memberAddressVo : memberAddressVos) {
                addressSet.add(memberAddressVo.getProvinceName() + " " + memberAddressVo.getCityName());
            }
        } else {
            addressSet.add(null);
        }
        return addressSet;
    }

    @RequestMapping(value={"/auditSku"}, method={RequestMethod.POST})
    public Map auditSku(BiddingAuditVo biddingAuditVo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingAuditVo.getBiddingNo()).booleanValue()) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)biddingMemberId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingOperatorService.auditSku(biddingAuditVo, biddingMemberId);
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        String pass = "1";
        String noPass = CONSIGNEE_FLAG;
        if (pass.equals(biddingAuditVo.getStatus())) {
            jcbdBiddingOperationLogDto.setOperationContent("\u5546\u54c1\u7f16\u7801\u5ba1\u6838\u901a\u8fc7");
        } else if (noPass.equals(biddingAuditVo.getStatus())) {
            jcbdBiddingOperationLogDto.setOperationContent("\u5546\u54c1\u7f16\u7801\u5ba1\u6838\u4e0d\u901a\u8fc7");
        }
        jcbdBiddingOperationLogDto.setRemark("");
        this.biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);
        return resultMap;
    }

    @RequestMapping(value={"/saveOrderGoodsInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse saveOrderGoodsInfo(@RequestBody BiddingQueryOperativeBuySaveVo biddingQueryOperativeBuySaveVo) {
        if (this.biddingOperatorService.biddingIsFinish(biddingQueryOperativeBuySaveVo.getBiddingNo()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        if (!Lang.isEmpty((Object)biddingQueryOperativeBuySaveVo.getBiddingNo())) {
            BaseResponse baseResponse = this.biddingOperatorService.saveOrderGoodsInfo(biddingQueryOperativeBuySaveVo);
            return baseResponse;
        }
        return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/queryOrderInfo"})
    @ResponseBody
    public BaseResponse queryOrderInfo(String biddingNo) {
        if (!Lang.isEmpty((Object)biddingNo)) {
            BaseResponse baseResponse = this.biddingOperatorService.queryTempOrderInfo(biddingNo);
            return baseResponse;
        }
        return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/updateOrderInfo"})
    @ResponseBody
    public BaseResponse updateOrderInfo(String temOrderId) {
        if (!Lang.isEmpty((Object)temOrderId)) {
            BaseResponse baseResponse = this.biddingOperatorService.updateTempOrderInfo(temOrderId);
            return baseResponse;
        }
        return new BaseResponse("\u4e34\u65f6\u8ba2\u5355ID\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/deleteOrderInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse deleteOrderInfo(@RequestBody List<String> temOrderId) {
        BaseResponse baseResponse = null;
        if (!Lang.isEmpty(temOrderId)) {
            baseResponse = this.biddingOperatorService.deleteTempOrderInfo(temOrderId);
            return baseResponse;
        }
        return new BaseResponse("\u4e34\u65f6\u8ba2\u5355ID\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/queryPermitGoodsInfo"})
    @ResponseBody
    public BaseResponse queryPermitGoodsInfo(String biddingNo) {
        if (!Lang.isEmpty((Object)biddingNo)) {
            BaseResponse baseResponse = this.biddingOperatorService.queryPermitGoodsInfo(biddingNo);
            return baseResponse;
        }
        return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/excel/receiverImport"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse importExcel(HttpServletRequest req, String biddingNo) {
        if (this.biddingOperatorService.biddingIsFinish(biddingNo).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        MultipartHttpServletRequest mReq = (MultipartHttpServletRequest)req;
        MultipartFile file = mReq.getFile("file");
        String fileName = file.getOriginalFilename();
        int startRow = 2;
        if (Lang.isEmpty((Object)fileName)) {
            return new BaseResponse("\u83b7\u53d6\u4e0d\u5230\u6587\u4ef6\u540d");
        }
        ArrayList<ExcelImportDataVo> importDataVoList = new ArrayList<ExcelImportDataVo>();
        try {
            InputStream inputStream = file.getInputStream();
            List excelData = ReadExcelUtil.readExcel((InputStream)inputStream, (String)file.getOriginalFilename());
            if (excelData.size() > 1002) {
                return new BaseResponse("\u6700\u591a\u53ef\u6dfb\u52a01000\u6761\u6570\u636e\uff0c\u65e0\u6cd5\u4e0a\u4f20\uff0c\u8bf7\u8fd4\u56de\u4fee\u6539");
            }
            Integer falseDataCount = 0;
            Integer successDataCount = 0;
            for (int i = startRow; i < excelData.size(); ++i) {
                Comparable<Boolean> aBoolean;
                Object identificationCode;
                Integer n;
                Integer n2;
                List excelRow = (List)excelData.get(i);
                boolean emptyRow = true;
                for (int j = 1; j < 14; ++j) {
                    if (Lang.isEmpty(excelRow.get(j))) continue;
                    emptyRow = false;
                    break;
                }
                if (emptyRow) continue;
                ExcelImportDataVo importDataVo = new ExcelImportDataVo();
                if (excelRow.size() <= 2) continue;
                if (Lang.isEmpty(excelRow.get(1))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u7f16\u53f7\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    Integer j = falseDataCount;
                    n2 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                Object sku = (String)excelRow.get(1);
                Comparable<Boolean> notNull = this.biddingOperatorService.goodIsNull(biddingNo, (String)sku);
                if (!notNull.booleanValue()) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u7f16\u53f7\u4e0d\u5b58\u5728");
                    importDataVoList.add(importDataVo);
                    Integer n3 = falseDataCount;
                    n = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                if (Lang.isEmpty(excelRow.get(2))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u6570\u91cf\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    sku = falseDataCount;
                    falseDataCount = falseDataCount + 1;
                    notNull = falseDataCount;
                    continue;
                }
                if (Lang.isEmpty(excelRow.get(3))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u6536\u8d27\u5730\u5740\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    sku = falseDataCount;
                    falseDataCount = falseDataCount + 1;
                    notNull = falseDataCount;
                    continue;
                }
                Object address = new String[5];
                Object addressCode = excelRow.get(3).toString().split("_");
                for (int k = 0; k < ((String[])addressCode).length; ++k) {
                    address[k] = addressCode[k];
                }
                Object detailAddress = excelRow.get(4).toString();
                String memberName = excelRow.get(12).toString();
                String memberTel = excelRow.get(13).toString();
                Boolean aBoolean2 = this.biddingOperatorService.queryAddressExist(address);
                if (!aBoolean2.booleanValue()) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u6536\u8d27\u5730\u5740\u4e0d\u5b58\u5728");
                    importDataVoList.add(importDataVo);
                    Integer n4 = falseDataCount;
                    Integer n5 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                MemberAddressDto memberAddressDto = this.addressInfoHandel(address, (String)detailAddress, memberName, memberTel);
                if (Lang.isEmpty((Object)memberAddressDto)) {
                    return new BaseResponse("\u6279\u91cf\u4e0a\u4f20\u6536\u8d27\u5730\u5740\u4fdd\u5b58\u5931\u8d25");
                }
                importDataVo.setMemberAddressCode(memberAddressDto.getId());
                importDataVo.setMemberName(excelRow.get(12).toString());
                importDataVo.setMemberTel(excelRow.get(13).toString());
                if (Lang.isEmpty(excelRow.get(4))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u6536\u8d27\u8be6\u7ec6\u5730\u5740\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    falseDataCount = falseDataCount + 1;
                    addressCode = falseDataCount;
                    continue;
                }
                if (Lang.isEmpty(excelRow.get(5))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u53d1\u7968\u7c7b\u578b\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    falseDataCount = falseDataCount + 1;
                    addressCode = falseDataCount;
                    continue;
                }
                if (VALUE_ADDED_TAX_NOMAL_INVOICE.equals(excelRow.get(5)) && Lang.isEmpty(excelRow.get(6))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u53d1\u7968\u62ac\u5934\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    falseDataCount = falseDataCount + 1;
                    addressCode = falseDataCount;
                    continue;
                }
                if (VALUE_ADDED_TAX_SPECIAL_INVOICE.equals(excelRow.get(5))) {
                    if (Lang.isEmpty(excelRow.get(7))) {
                        importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u672a\u586b\u5199");
                        importDataVoList.add(importDataVo);
                        address = falseDataCount;
                        falseDataCount = falseDataCount + 1;
                        addressCode = falseDataCount;
                        continue;
                    }
                    identificationCode = excelRow.get(7).toString();
                    aBoolean = this.biddingOperatorService.queryIdentificationCode((String)identificationCode);
                    if (!aBoolean.booleanValue()) {
                        importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5b58\u5728");
                        importDataVoList.add(importDataVo);
                        detailAddress = falseDataCount;
                        n = falseDataCount = Integer.valueOf(falseDataCount + 1);
                        continue;
                    }
                }
                if (Lang.isEmpty(excelRow.get(8))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u6536\u8d27\u5730\u5740\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    identificationCode = falseDataCount;
                    falseDataCount = falseDataCount + 1;
                    aBoolean = falseDataCount;
                    continue;
                }
                address = new String[5];
                addressCode = excelRow.get(8).toString().split("_");
                for (int l = 0; l < ((String[])addressCode).length; ++l) {
                    address[l] = addressCode[l];
                }
                Boolean aBoolean3 = this.biddingOperatorService.queryAddressExist(address);
                if (!aBoolean3.booleanValue()) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u6536\u8d27\u5730\u5740\u4e0d\u5b58\u5728");
                    importDataVoList.add(importDataVo);
                    n = falseDataCount;
                    Integer n6 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                importDataVo.setInvoiceProvinceAddressCode(address[0]);
                importDataVo.setInvoiceCityAddressCode(address[1]);
                importDataVo.setInvoiceAddressCode(excelRow.get(8).toString());
                importDataVo.setInvoiceDetailAddress(excelRow.get(9).toString());
                if (Lang.isEmpty(excelRow.get(9))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u5546\u54c1\u6536\u8d27\u8be6\u7ec6\u5730\u5740\u672a\u586b\u5199");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    n2 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                if (Lang.isEmpty(excelRow.get(10))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u53d1\u7968\u6536\u4ef6\u4eba\u4e3a\u7a7a");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    n2 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                if (Lang.isEmpty(excelRow.get(11))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u53d1\u7968\u6536\u4ef6\u4eba\u7535\u8bdd\u4e3a\u7a7a");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    n2 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                if (Lang.isEmpty(excelRow.get(12))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u6536\u8d27\u4eba\u4e3a\u7a7a");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    n2 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                if (Lang.isEmpty(excelRow.get(13))) {
                    importDataVo.setImportResult("\u5bfc\u5165\u5931\u8d25\uff1a\u6536\u8d27\u4eba\u7535\u8bdd\u4e3a\u7a7a");
                    importDataVoList.add(importDataVo);
                    address = falseDataCount;
                    n2 = falseDataCount = Integer.valueOf(falseDataCount + 1);
                    continue;
                }
                importDataVo.setSku(excelRow.get(1).toString());
                importDataVo.setNum(Integer.valueOf(Integer.parseInt(excelRow.get(2).toString())));
                importDataVo.setMemberDetailAddress(excelRow.get(4).toString());
                importDataVo.setInvoiceType(excelRow.get(5).toString());
                importDataVo.setInvoiceTitle(excelRow.get(6).toString());
                importDataVo.setTaxIdentification(excelRow.get(7).toString());
                importDataVo.setInvoiceMember(excelRow.get(10).toString());
                importDataVo.setInvoiceMemberTel(excelRow.get(11).toString());
                importDataVo.setImportResult("\u5bfc\u5165\u6210\u529f");
                importDataVoList.add(importDataVo);
                address = successDataCount;
                n2 = successDataCount = Integer.valueOf(successDataCount + 1);
            }
            UploadSaveVo uploadSaveVo = new UploadSaveVo();
            uploadSaveVo.setBiddingNo(biddingNo);
            uploadSaveVo.setImportDataVoList(importDataVoList);
            UploadCountVo uploadCountVo = new UploadCountVo();
            uploadCountVo.setFalseDataCount(falseDataCount);
            uploadCountVo.setSuccessDataCount(successDataCount);
            BaseResponse baseResponse = this.uploadSave(uploadSaveVo);
            if (baseResponse.isSuccess()) {
                req.getSession().setAttribute("UPLOAD_RESULT_DATA", (Object)JSON.toJSONString(importDataVoList));
                return new BaseResponse(true, "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f", (Object)uploadCountVo);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25{}", (Throwable)e);
            return new BaseResponse("\u6587\u4ef6\u5bfc\u5165\u51fa\u9519");
        }
        return new BaseResponse("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
    }

    public MemberAddressDto addressInfoHandel(String[] address, String detailAddress, String memberName, String memberTel) {
        MemberAddressDto memberAddress = this.biddingOperatorService.findMemberAddress(address, detailAddress, memberName, memberTel);
        if (Lang.isEmpty((Object)memberAddress)) {
            MemberAddressDto saveStatues = this.biddingOperatorService.saveExcelImportData(address, detailAddress, memberName, memberTel);
            return saveStatues;
        }
        return memberAddress;
    }

    public BaseResponse uploadSave(UploadSaveVo uploadSaveVo) {
        if (this.biddingOperatorService.biddingIsFinish(uploadSaveVo.getBiddingNo()).booleanValue()) {
            return new BaseResponse("\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        BiddingQueryOperativeBuySaveVo biddingQueryOperativeBuySaveVo = new BiddingQueryOperativeBuySaveVo();
        try {
            List importDataVoList;
            if (!Lang.isEmpty((Object)uploadSaveVo) && !Lang.isEmpty((Object)(importDataVoList = uploadSaveVo.getImportDataVoList()))) {
                for (ExcelImportDataVo excelImportData : importDataVoList) {
                    if (!"\u5bfc\u5165\u6210\u529f".equals(excelImportData.getImportResult())) continue;
                    long time1 = System.currentTimeMillis();
                    biddingQueryOperativeBuySaveVo.setBiddingNo(uploadSaveVo.getBiddingNo());
                    ArrayList<JcbdTempGoodsVo> jcbdTempGoodsVoList = new ArrayList<JcbdTempGoodsVo>();
                    JcbdTempGoodsVo jcbdTempGoodsVo = new JcbdTempGoodsVo();
                    JcbdBiddingDemandResponseDto demandResponseDto = this.biddingOperatorService.findGoodsPriceBySku(uploadSaveVo.getBiddingNo(), excelImportData.getSku());
                    long time2 = System.currentTimeMillis();
                    log.info("\u6839\u636esku\u67e5\u8be2\u4f9b\u5e94\u5546\u54cd\u5e94\u4ef7\u683c{}", (Object)(time2 - time1));
                    if (!Lang.isEmpty((Object)demandResponseDto)) {
                        jcbdTempGoodsVo.setPrice(demandResponseDto.getPrice());
                        jcbdTempGoodsVo.setDemandId(demandResponseDto.getJcbdBiddingDemand().getId());
                    }
                    String goodsId = this.biddingOperatorService.findGoodsIdBySku(excelImportData.getSku());
                    long time3 = System.currentTimeMillis();
                    log.info("\u6839\u636esku\u67e5\u8be2goodsId{}", (Object)(time3 - time2));
                    jcbdTempGoodsVo.setGoodsId(goodsId);
                    String productFashionId = this.biddingOperatorService.findProductFashionId(excelImportData.getSku());
                    long time4 = System.currentTimeMillis();
                    log.info("\u6839\u636esku\u67e5\u8be2productfashionId{}", (Object)(time4 - time3));
                    jcbdTempGoodsVo.setProductFashionId(productFashionId);
                    jcbdTempGoodsVo.setSku(excelImportData.getSku());
                    jcbdTempGoodsVo.setNum(excelImportData.getNum());
                    jcbdTempGoodsVoList.add(jcbdTempGoodsVo);
                    biddingQueryOperativeBuySaveVo.setJcbdTempGoodses(jcbdTempGoodsVoList);
                    biddingQueryOperativeBuySaveVo.setMemberAddressId(excelImportData.getMemberAddressCode());
                    if (VALUE_ADDED_TAX_NOMAL_INVOICE.equals(excelImportData.getInvoiceType())) {
                        biddingQueryOperativeBuySaveVo.setInvoiceType("007");
                    } else {
                        biddingQueryOperativeBuySaveVo.setInvoiceType("004");
                    }
                    biddingQueryOperativeBuySaveVo.setInvoiceTitle(excelImportData.getInvoiceTitle());
                    biddingQueryOperativeBuySaveVo.setTaxIdentification(excelImportData.getTaxIdentification());
                    biddingQueryOperativeBuySaveVo.setConsigneeProvinceCode(excelImportData.getInvoiceProvinceAddressCode());
                    biddingQueryOperativeBuySaveVo.setConsigneeCityCode(excelImportData.getInvoiceCityAddressCode());
                    biddingQueryOperativeBuySaveVo.setAddressDetail(excelImportData.getInvoiceDetailAddress());
                    biddingQueryOperativeBuySaveVo.setConsigneeFlag(CONSIGNEE_FLAG);
                    biddingQueryOperativeBuySaveVo.setConsigneeName(excelImportData.getInvoiceMember());
                    biddingQueryOperativeBuySaveVo.setConsigneePhone(excelImportData.getInvoiceMemberTel());
                    this.biddingOperatorService.saveOrderGoodsInfo(biddingQueryOperativeBuySaveVo);
                    long time5 = System.currentTimeMillis();
                    log.info("\u6a21\u677f\u4fdd\u5b58{}", (Object)(time5 - time4));
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e34\u65f6\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25{}", (Throwable)e);
            return new BaseResponse("\u4e34\u65f6\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25");
        }
        return new BaseResponse(true, "\u4e34\u65f6\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/getOrderFee"})
    @ResponseBody
    public BaseResponse getOrderFee(@RequestBody TempPurchaseVo tempPurchaseVo, HttpServletRequest request) {
        BaseResponse baseResponse = null;
        String memberId = (String)request.getSession().getAttribute("member_id");
        if (!Lang.isEmpty((Object)memberId)) {
            baseResponse = this.biddingOperatorService.getOrderFee(tempPurchaseVo, memberId);
            return baseResponse;
        }
        return new BaseResponse("\u5f53\u524d\u7528\u6237Id\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/checkGoodNums"})
    @ResponseBody
    public BaseResponse checkGoodNums(String biddingCode) {
        BaseResponse baseResponse = this.biddingOperatorService.checkGoodNums(biddingCode);
        return baseResponse;
    }

    @RequestMapping(value={"/submitTemOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse submitTemOrder(@RequestBody TempPurchaseVo tempPurchaseVo, HttpServletRequest request) {
        BaseResponse baseResponse = null;
        String memberId = (String)request.getSession().getAttribute("member_id");
        Boolean compareResult = this.biddingOperatorService.compareCurrentMemberId(memberId, tempPurchaseVo.getBiddingCode());
        String lockFlag = memberId + tempPurchaseVo.getRequestId();
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)lockFlag);
        if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
            boundValueOperations.expire(1L, TimeUnit.DAYS);
            try {
                if (compareResult.booleanValue()) {
                    baseResponse = this.biddingOperatorService.commitJcbdOrderData(tempPurchaseVo, memberId);
                    if (baseResponse.isSuccess()) {
                        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                        jcbdBiddingOperationLogDto.setOperationContent("\u6267\u884c\u91c7\u8d2d");
                        jcbdBiddingOperationLogDto.setRemark("");
                        long start = System.currentTimeMillis();
                        this.biddingOperatorService.saveOperatorsLog(memberId, tempPurchaseVo.getBiddingCode(), jcbdBiddingOperationLogDto);
                        log.info("\u4fdd\u5b58\u65e5\u5fd7\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
                    }
                    baseResponse.setResult(null);
                    return baseResponse;
                }
                return new BaseResponse("\u5f53\u524d\u767b\u5f55\u7528\u6237\u72b6\u6001\u6709\u8bef");
            }
            catch (Exception e) {
                log.error("[memberId:{}]\u4e0b\u5355\u5931\u8d25....", (Object)memberId, (Object)e);
                return new BaseResponse(false, "\u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        log.error("\u8ba2\u5355\u91cd\u590d\u63d0\u4ea4,tempPurchaseVo={}", (Object)JSON.toJSONString((Object)tempPurchaseVo));
        return new BaseResponse(false, "\u8ba2\u5355\u91cd\u590d\u63d0\u4ea4");
    }

    @RequestMapping(value={"/companyInfo", "/companyInfo.json"})
    @ResponseBody
    public Map getCompanyInvoiceInfo(String companyId, String companyLevel) {
        if (Lang.isEmpty((Object)companyId)) {
            return null;
        }
        HashMap<String, CoreCompanyDto> map = new HashMap<String, CoreCompanyDto>();
        CoreCompanyDto coreCompany = this.biddingOperatorService.getCoreCompanyInfoById(companyId);
        map.put("company", coreCompany);
        return map;
    }

    @RequestMapping(value={"/checkLimit"})
    @ResponseBody
    public BaseResponse checkLimit(String biddingCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return new BaseResponse(false, "\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
        }
        return this.biddingOperatorService.checkLimit(biddingCode);
    }

    @RequestMapping(value={"findbiddingLog"}, method={RequestMethod.POST})
    public Map findbiddingLog(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u72b6\u6001\u65e0\u64cd\u4f5c\u8bb0\u5f55");
        }
        Map resultMap = this.biddingOperatorService.findbiddingLog(jqueryDataTablesVo, biddingCode);
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/finishBidding"}, method={RequestMethod.POST})
    public Map finishBidding(String biddingNo, String remark, HttpServletRequest request) {
        String biddingMemberId = (String)request.getSession().getAttribute("member_id");
        if (Lang.isEmpty((Object)biddingNo)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u7f16\u53f7\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)biddingMemberId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("\u7ade\u4ef7\u7ec8\u6b62");
        jcbdBiddingOperationLogDto.setRemark(remark);
        this.biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingNo, jcbdBiddingOperationLogDto);
        return this.biddingOperatorService.finishBidding(biddingNo, remark, biddingMemberId);
    }

    @RequestMapping(value={"/voteDetailsQuery"}, method={RequestMethod.GET})
    public Map voteDetailsQuery(String biddingNo, Map map) {
        if (!Lang.isEmpty((Object)biddingNo)) {
            List voteQueryResultVos = this.biddingOperatorService.voteDetailsQuery(biddingNo);
            map.put("voteQueryResultVos", voteQueryResultVos);
        }
        return ResponseMapUtils.success((Object)map);
    }

    @RequestMapping(value={"getVoteStatus"})
    public BaseResponse<Boolean> getVoteStatus(String biddingNo, HttpServletRequest request, String source) {
        if ("BIDDING_GROUP_MEMBER".equals(source)) {
            String string = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        }
        String memberId = (String)request.getSession().getAttribute("member_id");
        return this.biddingOperatorService.getVoteStatus(biddingNo, memberId);
    }

    @RequestMapping(value={"/deleteBidding"}, method={RequestMethod.POST})
    public Map deleteBidding(String biddingNo) {
        if (Lang.isEmpty((Object)biddingNo)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u7f16\u53f7\u5931\u8d25");
        }
        return this.biddingOperatorService.deleteBidding(biddingNo);
    }

    @RequestMapping(value={"getBiddingResultTiaoXianCompany"})
    public TiaoXianCompanyVo getBiddingResultTiaoXianCompany(HttpServletRequest request, String biddingNo) {
        String userId = (String)request.getSession().getAttribute("user_id");
        return this.biddingOperatorService.getBiddingResultTiaoXian(userId, biddingNo);
    }

    @RequestMapping(value={"getBiddingOrderiaoXianCompany"})
    public TiaoXianCompanyVo getBiddingOrderiaoXianCompany(HttpServletRequest request, BigDecimal totalMoney) {
        String userId = (String)request.getSession().getAttribute("user_id");
        TianXianRequestVo tianXianRequestVo = new TianXianRequestVo();
        tianXianRequestVo.setUserId(userId);
        tianXianRequestVo.setUseCode(WorkFlowCode.BIDDING_ORDER_WORKFLOW_CODE.getCode());
        tianXianRequestVo.setTotalMoney(totalMoney);
        return this.biddingOperatorService.getBiddingOrderTiaoXian(tianXianRequestVo);
    }

    @RequestMapping(value={"companyJsTree"})
    @ResponseBody
    public List<JsonModel> jstree(HttpServletRequest request) {
        List list = this.biddingOperatorService.jsTree();
        return list;
    }

    @RequestMapping(value={"compJsTree"})
    @ResponseBody
    public List<JsonModel> compJsTree(HttpServletRequest request) {
        String userId = (String)request.getSession().getAttribute("user_id");
        ArrayList<JsonModel> list = new ArrayList();
        try {
            list = this.biddingOperatorService.compJsTree(userId, "R_JC_BUYERDEAL");
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u9009\u62e9\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u7ed3\u6784\u6811\u6570\u636e\u51fa\u9519:", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    @RequestMapping(value={"getBiddingMember.do"})
    @ResponseBody
    public Map getBiddingMember(String selectedCompanyOrDepartmentName, String selectedCompanyOrDepartmentId, String nameLike, String emailLike, Pageable pageable, HttpServletRequest request, JqueryDataTablesVo jqueryDataTablesVo) {
        Map returnMap = new HashMap(16);
        try {
            String userId = (String)request.getSession().getAttribute("user_id");
            String nameLikeU8 = null;
            if (!Lang.isEmpty((Object)nameLike)) {
                nameLikeU8 = URLDecoder.decode(nameLike, "UTF-8");
            }
            returnMap = this.biddingOperatorService.getTechAuditorListBySearchCondition(jqueryDataTablesVo, selectedCompanyOrDepartmentName, selectedCompanyOrDepartmentId, nameLikeU8, emailLike, false, userId, GlobalContants.ROLE_CODE_JC_JJXZ, pageable);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u5217\u8868\u6570\u636e\u51fa\u9519:", (Throwable)e);
            e.printStackTrace();
        }
        return ResponseMapUtils.success(returnMap);
    }
}

