/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingOrderManagerService;
import bidding.web.vo.BiddingInformationVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.JcbdMallOrderVo;
import bidding.web.vo.OrderAuditInfoVo;
import bidding.web.vo.OrderTrackRespVo;
import bidding.web.vo.QueryStatus;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import dto.BiddingOrderInfoDto;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import member.api.QueryOrderApi;
import member.api.dto.shop.MemberInVoiceDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import outsideapi.vo.OrderShippingPackageVo;
import query.BiddingOrderManagerListQuery;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.data.BeanMapper;
import utils.web.ResponseMapUtils;

@RestController
@RequestMapping(value={"biddingOperator"})
public class BiddingOrderManagerController {
    @Autowired
    BiddingOrderManagerService biddingOrderManagerService;
    @Autowired
    BiddingOperatorService biddingOperatorService;
    @MotanReferer
    QueryOrderApi queryOrderApi;

    @RequestMapping(value={"/getBiddingOrderMangerList"}, method={RequestMethod.POST})
    public Map getBiddingOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingOrderManagerListQuery biddingOrderManagerListQuery, HttpServletRequest request, Pageable pageable) {
        String orderSTime = request.getParameter("orderSTime");
        String orderETime = request.getParameter("orderETime");
        String confSTime = request.getParameter("confSTime");
        String confETime = request.getParameter("confETime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (!Lang.isEmpty((Object)orderSTime)) {
                biddingOrderManagerListQuery.setOrderStartTime(sdf.parse(orderSTime));
            }
            if (!Lang.isEmpty((Object)orderETime)) {
                biddingOrderManagerListQuery.setOrderEndTime(sdf.parse(orderETime));
            }
            if (!Lang.isEmpty((Object)confSTime)) {
                biddingOrderManagerListQuery.setConfStartTime(sdf.parse(confSTime));
            }
            if (!Lang.isEmpty((Object)confETime)) {
                biddingOrderManagerListQuery.setConfEndTime(sdf.parse(confETime));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (Lang.isEmpty((Object)biddingOrderManagerListQuery.getStatus())) {
            biddingOrderManagerListQuery.setStatus(null);
        }
        String memeberId = (String)request.getSession().getAttribute("member_id");
        biddingOrderManagerListQuery.setMemeberId(memeberId);
        Map resultMap = this.biddingOrderManagerService.getBiddingOrderMangerList(jqueryDataTablesVo, biddingOrderManagerListQuery, pageable);
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/getAllStatus"}, method={RequestMethod.GET})
    public List<QueryStatus> getAllStatus() {
        List allStatusList = this.biddingOrderManagerService.getAllStatus();
        return allStatusList;
    }

    @RequestMapping(value={"/updateStatusByOrderNo"}, method={RequestMethod.POST})
    public JcbdMallOrderVo updateStatusByOrderNo(String status, String orderNo) {
        JcbdMallOrderVo jcbdMallOrderVo = this.biddingOrderManagerService.updateStatusByOrderNo(status, orderNo);
        return jcbdMallOrderVo;
    }

    @RequestMapping(value={"/deleteJcbdMallOrderByOrderNo"}, method={RequestMethod.POST})
    public JcbdMallOrderVo deleteJcbdMallOrderByOrderNo(String status, String orderNo) {
        JcbdMallOrderVo jcbdMallOrderVo = this.biddingOrderManagerService.deleteJcbdMallOrderByOrderNo(orderNo);
        return jcbdMallOrderVo;
    }

    @RequestMapping(value={"/getBiddingOrderInfoVo"}, method={RequestMethod.POST})
    public String getBiddingOrderInfoVo(String orderNo, String biddingCode, String status, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HttpSession session = request.getSession();
        Object memberId = session.getAttribute("member_id");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("orderNo", orderNo);
        params.put("memberId", memberId);
        Map orderMap = this.queryOrderApi.queryOrderDetail(params);
        if (!Lang.isEmpty((Object)orderMap)) {
            OrderMainDto orderMain = (OrderMainDto)orderMap.get("orderMain");
            if (!Lang.isEmpty((Object)orderMain)) {
                List orderItems = orderMain.getOrderItems();
                ArrayList items = new ArrayList();
                ArrayList<OrderItemDto> orderItemDtos = new ArrayList<OrderItemDto>();
                for (OrderItemDto orderItem : orderItems) {
                    OrderItemDto orderItemDto = (OrderItemDto)BeanMapper.map((Object)orderItem, OrderItemDto.class);
                    orderItemDtos.add(orderItemDto);
                }
                items.add(orderItemDtos);
                orderMap.put("items", items);
                ArrayList<String> orderNos = new ArrayList<String>();
                String orderNo1 = orderMain.getOrderNo();
                orderNos.add(orderNo1);
                orderMap.put("orderNos", orderNos);
            }
            map.putAll(orderMap);
        }
        BiddingOrderInfoDto orderInfoDto = this.biddingOrderManagerService.getOrderInfoByOrderNo(orderNo);
        map.put("orderInfoDto", orderInfoDto);
        this.biddingOrderManagerService.getFlowSteps(orderInfoDto.getReviewNo(), map);
        List uploadFiles = this.biddingOrderManagerService.getOrderUploadFiles(orderNo);
        OrderAuditInfoVo businessWorkFlowInfo = this.biddingOrderManagerService.getBusinessWorkFlowInfo(orderNo, null);
        if (!Lang.isEmpty((Object)businessWorkFlowInfo)) {
            map.put("businessWorkFlowInfo", businessWorkFlowInfo);
        }
        if (!uploadFiles.isEmpty()) {
            map.put("uploadFiles", uploadFiles);
        }
        map.put("invoiceTypeMap", MemberInVoiceDto.INVOICETYPEMAP);
        String orderStatus = request.getParameter("status");
        map.put("status", orderStatus);
        Map orderTrackResp = (Map)map.get("orderTrackResp");
        ArrayList<OrderTrackRespVo> orderTrackRespVoList = new ArrayList<OrderTrackRespVo>();
        OrderTrackRespVo orderTrackRespVo = null;
        if (!Lang.isEmpty((Object)orderTrackResp)) {
            for (String key : orderTrackResp.keySet()) {
                orderTrackRespVo = new OrderTrackRespVo();
                orderTrackRespVo.setKey(key);
                OrderShippingPackageVo orderShippingTrackVo = (OrderShippingPackageVo)orderTrackResp.get(key);
                orderTrackRespVo.setOrderShippingTrackVo((OrderShippingPackageVo)BeanMapper.map((Object)orderShippingTrackVo, OrderShippingPackageVo.class));
                orderTrackRespVoList.add(orderTrackRespVo);
            }
        }
        map.put("orderTrackRespVo", orderTrackRespVoList);
        String biddingUserId = (String)request.getSession().getAttribute("member_id");
        JcbdBiddingVo biddingVo = this.biddingOperatorService.getOperator(biddingUserId);
        BiddingInformationVo biddingInformationVo = (BiddingInformationVo)BeanMapper.map((Object)biddingVo, BiddingInformationVo.class);
        biddingInformationVo.setBiddingCode(biddingCode);
        map.put("biddingInformationVo", biddingInformationVo);
        List jcbdRoleOperationDtos = this.biddingOrderManagerService.getOpertionByStatus(status);
        map.put("jcbdRoleOperationDtos", jcbdRoleOperationDtos);
        String orderInfoJsonString = JSON.toJSONString(map);
        return orderInfoJsonString;
    }
}

