/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingProviderService;
import bidding.web.vo.BiddingBaseInfoVo;
import bidding.web.vo.BiddingDemandResponseVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.QueryBiddingRequestVO;
import bidding.web.vo.SupplierBiddingResponseVo;
import bidding.web.vo.UpdateSkuVo;
import com.alibaba.fastjson.JSON;
import definition.BiddingStatus;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingOperationLogDto;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.web.ResponseMapUtils;

@RestController
@RequestMapping(value={"biddingProvider"})
public class BiddingProviderController {
    @Autowired
    BiddingProviderService biddingProviderService;
    @Autowired
    BiddingOperatorService biddingOperatorService;

    @RequestMapping(value={"/querryPageBidding"}, method={RequestMethod.POST})
    @ResponseBody
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, HttpServletRequest request, QueryBiddingRequestVO queryBiddingRequestVO) {
        String biddingMemberId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        String biddingMemberRole = (String)request.getSession().getAttribute("BIDDING_MEMBER_ROLE");
        ArrayList<String> biddingMemberRoles = new ArrayList<String>();
        biddingMemberRoles.add(biddingMemberRole);
        if (Lang.isEmpty((Object)biddingMemberId) || Lang.isEmpty(biddingMemberRoles)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.querryPageBidding(jqueryDataTablesVo, biddingMemberId, biddingMemberRoles, queryBiddingRequestVO);
        queryBiddingRequestVO.setPageNo(jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength() + 1 + "");
        request.getSession().setAttribute("supplierId", (Object)biddingMemberId);
        request.getSession().setAttribute("supplierBiddingTemp", (Object)JSON.toJSONString((Object)queryBiddingRequestVO));
        request.getSession().setAttribute("supplierBiddingPageTemp", (Object)JSON.toJSONString((Object)jqueryDataTablesVo));
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/querryPageBiddingDemad"}, method={RequestMethod.POST})
    @ResponseBody
    public Map querryPageBiddingDemad(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.querryPageBiddingDemand(jqueryDataTablesVo, biddingCode, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/saveBiddingDemadResp"}, method={RequestMethod.POST})
    @ResponseBody
    public Map saveBiddingDemadResp(@RequestBody BiddingDemandResponseVo biddingDemandResponseVo, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (Lang.isEmpty((Object)biddingDemandResponseVo)) {
            return ResponseMapUtils.error((String)"\u4f20\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.saveBiddingDemadResp(biddingDemandResponseVo, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/submitResp"}, method={RequestMethod.POST})
    @ResponseBody
    public Map submitResp(@RequestBody SupplierBiddingResponseVo supplierBiddingResponseVo, HttpServletRequest request) {
        String signValue = (String)request.getSession().getAttribute("SESSION_TPCLOUD_SIGN_VALUE");
        if (Lang.isEmpty((Object)signValue)) {
            return ResponseMapUtils.error((String)"\u975e\u6cd5\u8bf7\u6c42");
        }
        if (!signValue.equals(supplierBiddingResponseVo.getSignValue())) {
            return ResponseMapUtils.error((String)"\u975e\u6cd5\u8bf7\u6c42");
        }
        request.getSession().setAttribute("SESSION_TPCLOUD_SIGN_VALUE", (Object)"");
        if (this.biddingOperatorService.biddingIsFinish(supplierBiddingResponseVo.getJcbdBiddingNo()).booleanValue()) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String userId = (String)request.getSession().getAttribute("user_id");
        if (Lang.isEmpty((Object)userId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        String loginId = (String)request.getSession().getAttribute("SESSION_D_VENDER_LXR_ID");
        if (Lang.isEmpty((Object)supplierId) || Lang.isEmpty((Object)loginId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        JcbdBiddingVo biddingByBiddingCode = this.biddingOperatorService.getBiddingByBiddingCode(supplierBiddingResponseVo.getJcbdBiddingNo());
        JcbdBdProviderDto providerInfo = null;
        if (!Lang.isEmpty((Object)biddingByBiddingCode)) {
            providerInfo = this.biddingProviderService.getProviderByBiddingNoAndSupplierId(biddingByBiddingCode.getId(), supplierId);
        }
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        if (BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue().equals(providerInfo.getStatus())) {
            jcbdBiddingOperationLogDto.setOperationContent("\u7ade\u4ef7\u54cd\u5e94");
            jcbdBiddingOperationLogDto.setRemark("");
        } else if (BiddingStatus.SUPPLIER_RESPONSE_YES.getValue().equals(providerInfo.getStatus()) || BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue().equals(providerInfo.getStatus()) || BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue().equals(providerInfo.getStatus())) {
            jcbdBiddingOperationLogDto.setOperationContent("\u4fee\u6539\u54cd\u5e94");
            jcbdBiddingOperationLogDto.setRemark("");
        }
        Map resultMap = this.biddingProviderService.submitResp(supplierBiddingResponseVo, userId, supplierId);
        String status = (String)resultMap.get("status");
        if ("success".equals(status)) {
            this.biddingOperatorService.saveOperatorsLog(loginId, supplierBiddingResponseVo.getJcbdBiddingNo(), jcbdBiddingOperationLogDto);
        }
        return resultMap;
    }

    @RequestMapping(value={"/checkIsAllRespond"}, method={RequestMethod.POST})
    @ResponseBody
    public Map checkIsAllRespond(String biddingCode, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.checkIsAllRespond(biddingCode, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/checkDemadIsAllAccord"}, method={RequestMethod.POST})
    @ResponseBody
    public Map checkDemadIsAllAccord(String biddingCode, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.checkDemadIsAllAccord(biddingCode, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/sureResult"}, method={RequestMethod.POST})
    public Map sureResult(String biddingCode, String signValue, HttpServletRequest request) {
        String exitSignValue = (String)request.getSession().getAttribute("SESSION_TPCLOUD_SIGN_VALUE");
        if (Lang.isEmpty((Object)exitSignValue)) {
            return ResponseMapUtils.error((String)"\u975e\u6cd5\u8bf7\u6c42");
        }
        if (!exitSignValue.equals(signValue)) {
            return ResponseMapUtils.error((String)"\u975e\u6cd5\u8bf7\u6c42");
        }
        request.getSession().setAttribute("SESSION_TPCLOUD_SIGN_VALUE", (Object)"");
        if (this.biddingOperatorService.biddingIsFinish(biddingCode).booleanValue()) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        String loginId = (String)request.getSession().getAttribute("SESSION_D_VENDER_LXR_ID");
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)supplierId) || Lang.isEmpty((Object)loginId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.sureResult(biddingCode, signValue, supplierId);
        String status = (String)resultMap.get("status");
        if ("success".equals(status)) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("\u786e\u8ba4\u7ade\u4ef7\u7ed3\u679c");
            jcbdBiddingOperationLogDto.setRemark("");
            this.biddingOperatorService.saveOperatorsLog(loginId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return resultMap;
    }

    @RequestMapping(value={"/querryPageSku"}, method={RequestMethod.POST})
    public Map querryPageSku(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.querryPageSku(jqueryDataTablesVo, biddingCode, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/updateSku"}, method={RequestMethod.POST})
    public Map updateSku(UpdateSkuVo updateSkuVo, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        String loginId = (String)request.getSession().getAttribute("SESSION_D_VENDER_LXR_ID");
        if (Lang.isEmpty((Object)supplierId) || Lang.isEmpty((Object)loginId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)updateSkuVo.getBiddingNo())) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)updateSkuVo.getDemandNo())) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u54cd\u5e94\u9700\u6c42\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.updateSku(updateSkuVo, supplierId, loginId);
        return resultMap;
    }

    @RequestMapping(value={"/submitSkuAudit"}, method={RequestMethod.POST})
    public Map submitSkuAudit(String biddingCode, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingCode).booleanValue()) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        String loginId = (String)request.getSession().getAttribute("SESSION_D_VENDER_LXR_ID");
        if (Lang.isEmpty((Object)supplierId) || Lang.isEmpty((Object)loginId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.submitSkuAudit(biddingCode, supplierId);
        String status = (String)resultMap.get("status");
        if ("success".equals(status)) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("\u63d0\u4ea4\u5546\u54c1\u7f16\u7801\u5ba1\u6838");
            jcbdBiddingOperationLogDto.setRemark("");
            this.biddingOperatorService.saveOperatorsLog(loginId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return resultMap;
    }

    @RequestMapping(value={"/findUrlBySku"}, method={RequestMethod.POST})
    public Map findUrlBySku(String sku, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)sku)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6sku\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.findUrlBySku(sku, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/getBiddingDemadDetail"}, method={RequestMethod.POST})
    public BiddingDemandResponseVo getBiddingDemadDetail(String biddingNo, String demandCode, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        return this.biddingProviderService.getBiddingDemadDetail(supplierId, demandCode, biddingNo);
    }

    @RequestMapping(value={"/getBiddingDetail"}, method={RequestMethod.POST})
    public BiddingBaseInfoVo getBiddingDemadDetail(String biddingNo) {
        return this.biddingProviderService.getBiddingDetail(biddingNo);
    }

    @RequestMapping(value={"/checkModifySku"}, method={RequestMethod.POST})
    public Map checkModifySku(String biddingCode, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.checkModifySku(biddingCode, supplierId);
        return resultMap;
    }

    @RequestMapping(value={"/responseGiveUp"}, method={RequestMethod.POST})
    public Map responseGiveUp(String biddingNo, HttpServletRequest request) {
        if (this.biddingOperatorService.biddingIsFinish(biddingNo).booleanValue()) {
            return ResponseMapUtils.error((String)"\u5f53\u524d\u7ade\u4ef7\u5df2\u7ec8\u6b62");
        }
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        String loginId = (String)request.getSession().getAttribute("SESSION_D_VENDER_LXR_ID");
        if (Lang.isEmpty((Object)supplierId) || Lang.isEmpty((Object)loginId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingProviderService.responseGiveUp(biddingNo, supplierId);
        String status = (String)resultMap.get("status");
        if ("success".equals(status)) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("\u653e\u5f03\u54cd\u5e94");
            jcbdBiddingOperationLogDto.setRemark("");
            this.biddingOperatorService.saveOperatorsLog(loginId, biddingNo, jcbdBiddingOperationLogDto);
        }
        return resultMap;
    }

    @RequestMapping(value={"/loadQrcode"}, method={RequestMethod.POST})
    public Map loadQrcode(HttpServletRequest request, String businessCode, String operateType) {
        String account = (String)request.getSession().getAttribute("SESSION_D_VENDER_ORGANIZATION_CODE");
        Map resultMap = this.biddingProviderService.loadQrcode(account, businessCode, operateType);
        return resultMap;
    }

    @RequestMapping(value={"/getAccToken"}, method={RequestMethod.POST})
    public Map getAccToken(String eventId) {
        return this.biddingProviderService.getAccToken(eventId);
    }

    @RequestMapping(value={"/getSignResult"})
    public Map getSignResult(HttpServletRequest request, String accToken) {
        Map signResultMap = this.biddingProviderService.getSignResult(accToken);
        request.getSession(true).setAttribute("SESSION_TPCLOUD_SIGN_VALUE", signResultMap.get("data"));
        return signResultMap;
    }
}

