/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingQueryService;
import bidding.web.vo.BiddingConformityQueryVo;
import bidding.web.vo.BiddingPriceParityVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.PriceParityInfoVo;
import definition.BiddingStatus;
import dto.BiddingPriceParityDto;
import dto.JcbdBiddingDto;
import dto.PriceParityInfoDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.data.BeanMapper;
import utils.web.ResponseMapUtils;

@RestController
@RequestMapping(value={"biddingQuery"})
public class BiddingQueryController {
    @Autowired
    BiddingQueryService biddingQueryService;
    @Autowired
    BiddingOperatorService biddingOperatorService;
    public static final Logger log = LoggerFactory.getLogger(BiddingQueryController.class);

    @RequestMapping(value={"queryBiddingDemand"})
    public void queryBiddingDemand(String biddingNo) {
    }

    @RequestMapping(value={"biddingQueryList"})
    public List<JcbdBiddingDto> findAllJcbdBidding() {
        List jcbdBiddingDtoList = this.biddingQueryService.findAllJcbdBidding();
        return jcbdBiddingDtoList;
    }

    @RequestMapping(value={"queryBiddingPriceParity"})
    @ResponseBody
    public BiddingPriceParityVo queryBiddingPriceParity(String biddingNo) {
        BiddingPriceParityVo biddingPriceParityVo = null;
        BiddingPriceParityDto biddingPriceParityDto = null;
        if (!Lang.isEmpty((Object)biddingNo)) {
            BaseResponse biddingPriceParityDtoBaseResponse = this.biddingQueryService.queryBiddingPriceParity(biddingNo);
            biddingPriceParityDto = (BiddingPriceParityDto)biddingPriceParityDtoBaseResponse.getResult();
            biddingPriceParityVo = (BiddingPriceParityVo)BeanMapper.map((Object)biddingPriceParityDto, BiddingPriceParityVo.class);
        }
        return biddingPriceParityVo;
    }

    @RequestMapping(value={"querySupplierResponse"})
    @ResponseBody
    public BiddingPriceParityVo querySupplierResponse(String biddingNo) {
        BiddingPriceParityVo supplierDemandResponse = new BiddingPriceParityVo();
        ArrayList<PriceParityInfoVo> priceParityInfosVos = new ArrayList<PriceParityInfoVo>();
        if (!StringUtils.isEmpty((Object)biddingNo)) {
            BaseResponse biddingPriceParityDtoBaseResponse = this.biddingQueryService.queryBiddingPriceParity(biddingNo);
            List priceParityInfosDtos = ((BiddingPriceParityDto)biddingPriceParityDtoBaseResponse.getResult()).getPriceParityInfosDtos();
            for (PriceParityInfoDto priceParityInfoDto : priceParityInfosDtos) {
                if (!priceParityInfoDto.getSupplierStatus().equals(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue())) continue;
                PriceParityInfoVo priceParityInfoVo = (PriceParityInfoVo)BeanMapper.map((Object)priceParityInfoDto, PriceParityInfoVo.class);
                priceParityInfosVos.add(priceParityInfoVo);
            }
        }
        supplierDemandResponse.setPriceParityInfosDtos(priceParityInfosVos);
        return supplierDemandResponse;
    }

    @RequestMapping(value={"/querryBiddingDemandList"})
    @ResponseBody
    public Map querryPageBiddingDemad(String biddingNo, HttpServletRequest request, JqueryDataTablesVo jqueryDataTablesVo, String source) {
        BiddingConformityQueryVo biddingConformityQueryVo = new BiddingConformityQueryVo();
        String sessionMemberId = (String)request.getSession().getAttribute("member_id");
        String sessionEmail = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        String email = null;
        String memberId = null;
        if ("BIDDING_GROUP_MEMBER".equals(source)) {
            email = sessionEmail;
        } else {
            memberId = sessionMemberId;
        }
        Map resultMap = new HashMap();
        if (!Lang.isEmpty((Object)memberId) || !Lang.isEmpty((Object)email)) {
            biddingConformityQueryVo.setMemberId(memberId);
            biddingConformityQueryVo.setBiddingCode(biddingNo);
            biddingConformityQueryVo.setEmail(email);
            resultMap = this.biddingQueryService.querryPageBiddingDemad(biddingConformityQueryVo, jqueryDataTablesVo);
        }
        return ResponseMapUtils.success(resultMap);
    }

    @RequestMapping(value={"/queryResponseOutline"}, method={RequestMethod.POST})
    @ResponseBody
    public Map queryResponseOutline(String biddingCode, String demandCode, HttpServletRequest request, String source) {
        String sessionMemberId = (String)request.getSession().getAttribute("member_id");
        String sessionEmail = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        String email = null;
        String memberId = null;
        if ("BIDDING_GROUP_MEMBER".equals(source)) {
            email = sessionEmail;
        } else {
            memberId = sessionMemberId;
        }
        BiddingConformityQueryVo biddingConformityQueryVo = new BiddingConformityQueryVo();
        biddingConformityQueryVo.setBiddingCode(biddingCode);
        biddingConformityQueryVo.setDemandCode(demandCode);
        biddingConformityQueryVo.setMemberId(memberId);
        biddingConformityQueryVo.setEmail(email);
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)demandCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u9700\u6c42\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingQueryService.queryResponseOutline(biddingConformityQueryVo);
        resultMap.put("demandCode", demandCode);
        return resultMap;
    }

    @RequestMapping(value={"/queryDemandResponse"}, method={RequestMethod.POST})
    public Map queryDemandResponse(String biddingCode, String demandCode, String supplierId, HttpServletRequest request, String source) {
        String sessionMemberId = (String)request.getSession().getAttribute("member_id");
        String sessionEmail = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        String email = null;
        String memberId = null;
        if ("BIDDING_GROUP_MEMBER".equals(source)) {
            email = sessionEmail;
        } else {
            memberId = sessionMemberId;
        }
        BiddingConformityQueryVo biddingConformityQueryVo = new BiddingConformityQueryVo();
        biddingConformityQueryVo.setBiddingCode(biddingCode);
        biddingConformityQueryVo.setDemandCode(demandCode);
        biddingConformityQueryVo.setProviderId(supplierId);
        if (!Lang.isEmpty((Object)memberId) || !Lang.isEmpty((Object)email)) {
            biddingConformityQueryVo.setMemberId(memberId);
            biddingConformityQueryVo.setEmail(email);
        }
        if (Lang.isEmpty((Object)biddingCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)demandCode)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u9700\u6c42\u4fe1\u606f\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)supplierId)) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        Map resultMap = this.biddingQueryService.queryDemandResponse(biddingConformityQueryVo);
        return resultMap;
    }

    @RequestMapping(value={"/auditorQuerryBiddingDemandList"})
    @ResponseBody
    public Map auditorQuerryBiddingDemandList(String biddingNo, HttpServletRequest request, JqueryDataTablesVo jqueryDataTablesVo, String source) {
        BiddingConformityQueryVo biddingConformityQueryVo = new BiddingConformityQueryVo();
        JcbdBiddingVo biddingVo = this.biddingOperatorService.getBiddingByBiddingCode(biddingNo);
        String memberId = biddingVo.getOperatorId();
        Map resultMap = new HashMap();
        if (!Lang.isEmpty((Object)memberId)) {
            biddingConformityQueryVo.setMemberId(memberId);
            biddingConformityQueryVo.setBiddingCode(biddingNo);
            resultMap = this.biddingQueryService.querryPageBiddingDemad(biddingConformityQueryVo, jqueryDataTablesVo);
        }
        return ResponseMapUtils.success(resultMap);
    }
}

