/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller;

import api.query.BiddingQueryApi;
import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingOrderManagerService;
import bidding.web.service.BiddingSupplierOrderManagerService;
import bidding.web.vo.BiddingInformationVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.OrderTrackRespVo;
import bidding.web.vo.QueryStatus;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import dto.BiddingOrderInfoDto;
import dto.BiddingSupplierOrderMangerDto;
import dto.JcbdBiddingDto;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import member.api.QueryOrderApi;
import member.api.dto.shop.MemberInVoiceDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import outsideapi.vo.OrderShippingPackageVo;
import query.BiddingSupplierOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.data.BeanMapper;
import utils.excel.excelcreate.ExcelCreateUtil;
import utils.excel.excelcreate.vo.ExcelInfoVo;
import utils.web.ResponseMapUtils;

@RestController
@RequestMapping(value={"supplierOperator"})
public class BiddingSupplierOrderManagerController {
    private static final Logger log = LoggerFactory.getLogger(BiddingSupplierOrderManagerController.class);
    @Autowired
    BiddingOrderManagerService biddingOrderManagerService;
    @Autowired
    BiddingSupplierOrderManagerService biddingSupplierOrderManagerService;
    @MotanReferer
    QueryOrderApi queryOrderApi;
    @MotanReferer
    BiddingQueryApi biddingQueryApi;
    @Autowired
    BiddingOperatorService biddingOperatorService;

    @RequestMapping(value={"/getBiddingSupplierOrderMangerList"}, method={RequestMethod.POST})
    public Map getBiddingSupplierOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, HttpServletRequest request, Pageable pageable) {
        String orderSTime = request.getParameter("orderSTime");
        String orderETime = request.getParameter("orderETime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (!Lang.isEmpty((Object)orderSTime)) {
                orderSTime = orderSTime + " 00:00:00";
                biddingSupplierOrderManagerListQuery.setOrderStartTime(sdf.parse(orderSTime));
            }
            if (!Lang.isEmpty((Object)orderETime)) {
                orderETime = orderETime + " 23:59:59";
                biddingSupplierOrderManagerListQuery.setOrderEndTime(sdf.parse(orderETime));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (Lang.isEmpty((Object)biddingSupplierOrderManagerListQuery.getStatus())) {
            biddingSupplierOrderManagerListQuery.setStatus(null);
        }
        String biddingMemberId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        biddingSupplierOrderManagerListQuery.setProviderId(biddingMemberId);
        Map resultMap = this.biddingSupplierOrderManagerService.getBiddingSupplierOrderMangerList(jqueryDataTablesVo, biddingSupplierOrderManagerListQuery, pageable);
        return ResponseMapUtils.success((Object)resultMap);
    }

    @RequestMapping(value={"/downloadExcel"}, method={RequestMethod.POST})
    public void download(HttpServletResponse response, BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, HttpServletRequest request, Pageable pageable) {
        String orderSTime = request.getParameter("orderSTime");
        String orderETime = request.getParameter("orderETime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (!Lang.isEmpty((Object)orderSTime)) {
                biddingSupplierOrderManagerListQuery.setOrderStartTime(sdf.parse(orderSTime));
            }
            if (!Lang.isEmpty((Object)orderETime)) {
                biddingSupplierOrderManagerListQuery.setOrderEndTime(sdf.parse(orderETime));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (Lang.isEmpty((Object)biddingSupplierOrderManagerListQuery.getStatus())) {
            biddingSupplierOrderManagerListQuery.setStatus(null);
        }
        Page page = this.biddingSupplierOrderManagerService.getSupplierOrderMangerList(biddingSupplierOrderManagerListQuery, pageable);
        List dtoList = page.getContent();
        String fileName = "supplierOrderManager.xls";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelInfoVo excelInfoVo = new ExcelInfoVo(BiddingSupplierOrderMangerDto.class, dtoList, (OutputStream)outputStream, fileName);
            ExcelCreateUtil.create((ExcelInfoVo)excelInfoVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/getAllSupplierStatus"}, method={RequestMethod.GET})
    public List<QueryStatus> getAllSupplierStatus() {
        List allStatusList = this.biddingSupplierOrderManagerService.getAllSupplierStatus();
        return allStatusList;
    }

    @PostMapping(value={"confirmOrder"})
    public BaseResponse<List<String>> confirmOrder(@RequestParam(value="mallOrderNos") String mallOrderNos, String signValue, HttpServletRequest request) {
        String existSignValue = (String)request.getSession().getAttribute("SESSION_TPCLOUD_SIGN_VALUE");
        if (Lang.isEmpty((Object)existSignValue)) {
            return new BaseResponse(false, "\u975e\u6cd5\u8bf7\u6c42");
        }
        if (!existSignValue.equals(signValue)) {
            return new BaseResponse(false, "\u975e\u6cd5\u8bf7\u6c42");
        }
        request.getSession().setAttribute("SESSION_TPCLOUD_SIGN_VALUE", (Object)"");
        String biddingMemberId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5f00\u59cb ###");
        log.info("\u8bf7\u6c42\u53c2\u6570 mallOrderNos : {}", (Object)mallOrderNos);
        List mallOrderIdList = JSONArray.parseArray((String)mallOrderNos, String.class);
        BaseResponse baseResponse = this.biddingSupplierOrderManagerService.confirmOrder(mallOrderIdList, biddingMemberId, signValue);
        log.info("### \u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u7ed3\u675f, \u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - methodStartTime));
        return baseResponse;
    }

    @PostMapping(value={"deleteMallOrder"})
    public BaseResponse deleteMallOrder(@RequestParam(value="mallOrderNo") String mallOrderNo) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u4f9b\u5e94\u5546\u8ba2\u5355\u5220\u9664 ###");
        log.info("\u8bf7\u6c42\u53c2\u6570 mallOrderNo : {}", (Object)mallOrderNo);
        BaseResponse baseResponse = this.biddingSupplierOrderManagerService.deleteMallOrder(mallOrderNo);
        log.info("### \u4f9b\u5e94\u5546\u8ba2\u5355\u5220\u9664, \u603b\u8017\u65f6 {} ms ###", (Object)(System.currentTimeMillis() - methodStartTime));
        return baseResponse;
    }

    @RequestMapping(value={"/getSupplierOrderDetailInfo"}, method={RequestMethod.POST})
    public String getBiddingOrderInfoVo(String orderNo, String biddingCode, String status, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HttpSession session = request.getSession();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("orderNo", orderNo);
        Map orderMap = this.queryOrderApi.queryOrderDetail(params);
        if (!Lang.isEmpty((Object)orderMap)) {
            OrderMainDto orderMain = (OrderMainDto)orderMap.get("orderMain");
            if (!Lang.isEmpty((Object)orderMain)) {
                List orderItems = orderMain.getOrderItems();
                ArrayList items = new ArrayList();
                ArrayList<OrderItemDto> orderItemDtos = new ArrayList<OrderItemDto>();
                for (OrderItemDto orderItem : orderItems) {
                    OrderItemDto orderItemDto = (OrderItemDto)BeanMapper.map((Object)orderItem, OrderItemDto.class);
                    orderItemDtos.add(orderItemDto);
                }
                items.add(orderItemDtos);
                orderMap.put("items", items);
                ArrayList<String> orderNos = new ArrayList<String>();
                String orderNo1 = orderMain.getOrderNo();
                orderNos.add(orderNo1);
                orderMap.put("orderNos", orderNos);
            }
            map.putAll(orderMap);
        }
        BiddingOrderInfoDto orderInfoDto = this.biddingOrderManagerService.getOrderInfoByOrderNo(orderNo);
        map.put("orderInfoDto", orderInfoDto);
        this.biddingOrderManagerService.getFlowSteps(orderInfoDto.getReviewNo(), map);
        List uploadFiles = this.biddingOrderManagerService.getOrderUploadFiles(orderNo);
        if (!uploadFiles.isEmpty()) {
            map.put("uploadFiles", uploadFiles);
        }
        map.put("invoiceTypeMap", MemberInVoiceDto.INVOICETYPEMAP);
        String orderStatus = request.getParameter("status");
        map.put("status", orderStatus);
        Map orderTrackResp = (Map)map.get("orderTrackResp");
        ArrayList<OrderTrackRespVo> orderTrackRespVoList = new ArrayList<OrderTrackRespVo>();
        OrderTrackRespVo orderTrackRespVo = null;
        if (!Lang.isEmpty((Object)orderTrackResp)) {
            for (String key : orderTrackResp.keySet()) {
                orderTrackRespVo = new OrderTrackRespVo();
                orderTrackRespVo.setKey(key);
                OrderShippingPackageVo orderShippingTrackVo = (OrderShippingPackageVo)orderTrackResp.get(key);
                orderTrackRespVo.setOrderShippingTrackVo((OrderShippingPackageVo)BeanMapper.map((Object)orderShippingTrackVo, OrderShippingPackageVo.class));
                orderTrackRespVoList.add(orderTrackRespVo);
            }
        }
        map.put("orderTrackRespVo", orderTrackRespVoList);
        JcbdBiddingDto jcbdBiddingDto = this.biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);
        JcbdBiddingVo biddingVo = this.biddingOperatorService.getOperator(jcbdBiddingDto.getOperatorId());
        BiddingInformationVo biddingInformationVo = (BiddingInformationVo)BeanMapper.map((Object)biddingVo, BiddingInformationVo.class);
        biddingInformationVo.setBiddingCode(biddingCode);
        map.put("biddingInformationVo", biddingInformationVo);
        List jcbdRoleOperationDtos = this.biddingOrderManagerService.getSuperlierOpertionByStatus(status);
        map.put("jcbdRoleOperationDtos", jcbdRoleOperationDtos);
        String orderInfoJsonString = JSON.toJSONString(map);
        return orderInfoJsonString;
    }
}

