/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller.page.operator;

import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BatchDownLoadVo;
import bidding.web.vo.ExcelImportDataVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.JcbdTempGoodsVo;
import bidding.web.vo.JcbdTempOrderVo;
import bidding.web.vo.QueryBiddingRequestVO;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Splitter;
import definition.BiddingStatus;
import dto.JcbdBiddingGroupMemberDto;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import query.BiddingOperatorQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.excel.excelcreate.ExcelCreateUtil;
import utils.excel.excelcreate.vo.ExcelInfoVo;

@Controller
@RequestMapping(value={"/operator"})
public class BiddingOperatorPageController {
    @Autowired
    BiddingOperatorService biddingOperatorService;

    @RequestMapping(value={"/conformanceCheck"})
    public String conformanceCheck() {
        return "/bidding/operator/biddingConformanceCheck";
    }

    @RequestMapping(value={"/biddingManage"})
    public String biddingManage(Map model, HttpServletRequest request) {
        List userRoleCodeList;
        String memberId = (String)request.getSession().getAttribute("member_id");
        String biddingEmail = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
        ArrayList<String> biddingMemberRoles = new ArrayList<String>();
        boolean JC_CGJBR_FLAG = false;
        String rolesStr = (String)request.getSession().getAttribute("ROLE_CODES");
        if (!Lang.isEmpty((Object)rolesStr) && !Lang.isEmpty((Object)(userRoleCodeList = Splitter.on((String)",").trimResults().splitToList((CharSequence)rolesStr)))) {
            for (String userRole : userRoleCodeList) {
                if (!GlobalContants.ROLE_CODE_JC_CGJBR.equals(userRole)) continue;
                JC_CGJBR_FLAG = true;
                break;
            }
        }
        if (JC_CGJBR_FLAG) {
            biddingMemberRoles.add("BIDDING_OPERATOR");
            biddingMemberRoles.add("BIDDING_GROUP_MEMBER");
        } else {
            biddingMemberRoles.add("BIDDING_GROUP_MEMBER");
        }
        List biddingStatuses = this.biddingOperatorService.getAllStatusByRoles(biddingMemberRoles);
        QueryBiddingRequestVO biddingVO = new QueryBiddingRequestVO();
        String operateBiddingTempStr = (String)request.getSession().getAttribute("operateBiddingTemp");
        if (!Lang.isEmpty((Object)operateBiddingTempStr)) {
            biddingVO = (QueryBiddingRequestVO)JSON.parseObject((String)operateBiddingTempStr, QueryBiddingRequestVO.class);
        }
        JqueryDataTablesVo pageVo = new JqueryDataTablesVo();
        String operateBiddingPageTempStr = (String)request.getSession().getAttribute("operateBiddingPageTemp");
        if (!Lang.isEmpty((Object)operateBiddingPageTempStr)) {
            pageVo = (JqueryDataTablesVo)JSON.parseObject((String)operateBiddingPageTempStr, JqueryDataTablesVo.class);
        }
        String biddingMemberRole = (String)request.getSession().getAttribute("BIDDING_MEMBER_ROLE");
        String operateIdentity = (String)request.getSession().getAttribute("operateIdentity");
        Boolean sameUserFlag = false;
        sameUserFlag = Lang.isEmpty((Object)biddingMemberRole) ? Boolean.valueOf(Lang.equals((Object)operateIdentity, (Object)biddingEmail)) : Boolean.valueOf(Lang.equals((Object)operateIdentity, (Object)memberId));
        if (sameUserFlag.booleanValue()) {
            model.put("pageVo", pageVo);
            model.put("biddingVO", biddingVO);
        } else {
            model.put("pageVo", new JqueryDataTablesVo());
            model.put("biddingVO", new QueryBiddingRequestVO());
        }
        model.put("statuses", biddingStatuses);
        model.put("roles", biddingMemberRoles);
        return "/bidding/operator/bidManage";
    }

    @RequestMapping(value={"/editBidding"})
    public String editBidding() {
        return "/bidding/operator/editBidding";
    }

    @RequestMapping(value={"/auditBidding"})
    public String auditBidding() {
        return "/bidding/operator/auditBidding";
    }

    @RequestMapping(value={"/releaseBidding"})
    public String releaseBidding() {
        return "/bidding/operator/releaseBidding";
    }

    @RequestMapping(value={"/startComplianceAudit"})
    public String startComplianceAudit() {
        return "/bidding/operator/startComplianceAudit";
    }

    @RequestMapping(value={"/complianceAudit"})
    public String complianceAudit(HttpServletRequest request, Map model, String source, String biddingNo) {
        if ("BIDDING_GROUP_MEMBER".equals(source)) {
            String email = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
            String memberId = (String)request.getSession().getAttribute("member_id");
            MemberDto memberDto = this.biddingOperatorService.getMember(memberId);
            if (!(Lang.isEmpty((Object)email) || Lang.isEmpty((Object)memberDto) || Lang.isEmpty((Object)memberDto.getCoreUser()) || email.equals(memberDto.getCoreUser().getEmail()))) {
                return "error";
            }
            JcbdBiddingVo jcbd = this.biddingOperatorService.getBiddingByBiddingCode(biddingNo);
            JcbdBiddingGroupMemberDto groupStatus = this.biddingOperatorService.findGroupStatus(email, jcbd.getId());
            if (!BiddingStatus.OM_CONFORM_AUDIT_IN.getValue().equals(groupStatus.getStatus())) {
                model.put("complianceAuditFlag", "hadOperator");
            }
        }
        return "/bidding/operator/complianceAudit";
    }

    @RequestMapping(value={"/auditAgain"})
    public String auditAgain() {
        return "/bidding/operator/auditAgain";
    }

    @RequestMapping(value={"/startQuotedPrice"})
    public String startQuotedPrice() {
        return "/bidding/operator/startQuotedPrice";
    }

    @RequestMapping(value={"/systemConfirmSupplier"})
    public String systemConfirmSupplier() {
        return "/bidding/operator/systemConfirmSupplier";
    }

    @RequestMapping(value={"/voteConfirmSupplier"})
    public String voteConfirmSupplier() {
        return "/bidding/operator/voteConfirmSupplier";
    }

    @RequestMapping(value={"/vote"})
    public String vote() {
        return "/bidding/operator/vote";
    }

    @RequestMapping(value={"/submitBiddingResultAudit"})
    public String submitBiddingResultAudit() {
        return "/bidding/operator/submitBiddingResultAudit";
    }

    @RequestMapping(value={"/auditSku"})
    public String auditSku() {
        return "/bidding/operator/auditSku";
    }

    @RequestMapping(value={"/conductProcurement"})
    public String conductProcurement(HttpServletRequest request, Map model) {
        String memberId = (String)request.getSession().getAttribute("member_id");
        CoreCompanyDto companyInfo = this.biddingOperatorService.getCompanyInfo(memberId);
        model.put("company", companyInfo);
        return "/bidding/operator/conductProcurement";
    }

    @RequestMapping(value={"/queryBidding"})
    public String queryBidding(String biddingNo, HttpServletRequest request, Map model) {
        BiddingOperatorQuery biddingOperatorQuery = new BiddingOperatorQuery();
        biddingOperatorQuery.setBiddingNo(biddingNo);
        Object memberIdObj = request.getSession().getAttribute("member_id");
        if (memberIdObj != null) {
            biddingOperatorQuery.setMemberId(String.valueOf(memberIdObj));
        } else {
            String email = (String)request.getSession().getAttribute("BIDDING_USER_EMAIL");
            biddingOperatorQuery.setEmail(email);
        }
        List operates = this.biddingOperatorService.getRoleBiddingOperates(biddingOperatorQuery);
        List titles = this.biddingOperatorService.findBiddingShowTitle(biddingNo);
        model.put("operates", operates);
        model.put("showTitles", titles);
        return "/bidding/operator/queryBidding";
    }

    @RequestMapping(value={"/orderManage"})
    public String orderManage() {
        return "/bidding/operator/orderManage";
    }

    @RequestMapping(value={"/orderDetail"})
    public String orderDetail() {
        return "/bidding/operator/orderDetail";
    }

    @RequestMapping(value={"/downLoadResult"})
    public void downLoadResult(HttpServletRequest request, HttpServletResponse response) {
        Object importDataVoListObj = request.getSession().getAttribute("UPLOAD_RESULT_DATA");
        List importDataVoList = null;
        if (importDataVoListObj != null) {
            importDataVoList = JSON.parseArray((String)importDataVoListObj.toString(), ExcelImportDataVo.class);
        }
        String fileName = "downLoadResult.xls";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelInfoVo excelInfoVo = new ExcelInfoVo(ExcelImportDataVo.class, importDataVoList, (OutputStream)outputStream, fileName);
            ExcelCreateUtil.create((ExcelInfoVo)excelInfoVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/downLoadList"})
    public void downLoadList(HttpServletResponse response, String biddingNo) {
        BaseResponse baseResponse = this.biddingOperatorService.findAllTempOrder(biddingNo);
        List result = (List)baseResponse.getResult();
        ArrayList<BatchDownLoadVo> batchDownLoad = new ArrayList<BatchDownLoadVo>();
        int sequence = 1;
        for (JcbdTempOrderVo tempOrder : result) {
            List jcbdTempGoodses = tempOrder.getJcbdTempGoodses();
            if ("004".equals(tempOrder.getInvoiceType())) {
                tempOrder.setInvoiceType("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968");
            } else {
                tempOrder.setInvoiceType("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
            }
            for (JcbdTempGoodsVo tempGoodsVo : jcbdTempGoodses) {
                tempOrder.setSequence(String.valueOf(sequence++));
                BatchDownLoadVo batchDownLoadVo = (BatchDownLoadVo)BeanMapper.map((Object)tempOrder, BatchDownLoadVo.class);
                batchDownLoadVo.setSku(tempGoodsVo.getSku());
                batchDownLoadVo.setNum(tempGoodsVo.getNum());
                batchDownLoad.add(batchDownLoadVo);
            }
        }
        String fileName = "tempOrder.xls";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ExcelInfoVo excelInfoVo = new ExcelInfoVo(BatchDownLoadVo.class, batchDownLoad, (OutputStream)outputStream, fileName);
            ExcelCreateUtil.create((ExcelInfoVo)excelInfoVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

