/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.controller.page.supplier;

import bidding.web.service.BiddingProviderService;
import bidding.web.vo.BiddingBaseInfoVo;
import bidding.web.vo.QueryBiddingRequestVO;
import com.alibaba.fastjson.JSON;
import dto.JcbdBdProviderDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.date.DateUtils;

@Controller
@RequestMapping(value={"/supplier"})
public class BiddingSupplierPageController {
    @Autowired
    BiddingProviderService biddingProviderService;

    @RequestMapping(value={"/supplierBidManage"})
    public String supplierBidManage(Map model, HttpServletRequest request) {
        String supplierId;
        String biddingMemberId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        ArrayList<String> biddingMemberRoles = new ArrayList<String>();
        biddingMemberRoles.add("BIDDING_SUPPLIER");
        List biddingStatuses = this.biddingProviderService.getAllStatusByRoles(biddingMemberRoles);
        QueryBiddingRequestVO biddingVO = new QueryBiddingRequestVO();
        String supplierBiddingTempStr = (String)request.getSession().getAttribute("supplierBiddingTemp");
        if (!Lang.isEmpty((Object)supplierBiddingTempStr)) {
            biddingVO = (QueryBiddingRequestVO)JSON.parseObject((String)supplierBiddingTempStr, QueryBiddingRequestVO.class);
        }
        JqueryDataTablesVo pageVo = new JqueryDataTablesVo();
        String supplierBiddingPageTempStr = (String)request.getSession().getAttribute("supplierBiddingPageTemp");
        if (!Lang.isEmpty((Object)supplierBiddingPageTempStr)) {
            pageVo = (JqueryDataTablesVo)JSON.parseObject((String)supplierBiddingPageTempStr, JqueryDataTablesVo.class);
        }
        if (Lang.equals((Object)(supplierId = (String)request.getSession().getAttribute("supplierId")), (Object)biddingMemberId)) {
            model.put("pageVo", pageVo);
            model.put("biddingVO", biddingVO);
        } else {
            model.put("pageVo", new JqueryDataTablesVo());
            model.put("biddingVO", new QueryBiddingRequestVO());
        }
        model.put("statuses", biddingStatuses);
        return "/bidding/supplier/supplierBidManage";
    }

    @RequestMapping(value={"/querySupplierBidding"})
    public String querySupplierBidding(String biddingNo, Map model, HttpServletRequest request) {
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        if (!Lang.isEmpty((Object)supplierId)) {
            List titles = this.biddingProviderService.findBiddingShowTitle(biddingNo, supplierId);
            List operates = this.biddingProviderService.getSupplierBiddingOperateByBiddingCode(biddingNo, supplierId);
            model.put("operates", operates);
            model.put("showTitles", titles);
        }
        return "/bidding/supplier/querySupplierBidding";
    }

    @RequestMapping(value={"/supplierBidRelevant"})
    public String supplierBidRelevant(Map model, String biddingNo, HttpServletRequest request) {
        JcbdBdProviderDto provider;
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        BiddingBaseInfoVo biddingBaseInfoVo = this.biddingProviderService.getBiddingDetail(biddingNo);
        String offerValidity = null;
        if (!(Lang.isEmpty((Object)supplierId) || Lang.isEmpty((Object)biddingBaseInfoVo.getId()) || Lang.isEmpty((Object)(provider = this.biddingProviderService.getProviderByBiddingNoAndSupplierId(biddingBaseInfoVo.getId(), supplierId)).getOfferValidity()))) {
            offerValidity = DateUtils.dateToStr((Date)provider.getOfferValidity(), (String)"yyyy-MM-dd");
        }
        model.put("baseInfo", biddingBaseInfoVo);
        model.put("offerValidity", offerValidity);
        return "/bidding/supplier/supplierBidRelevant";
    }

    @RequestMapping(value={"/supplierBidResult"})
    public String supplierBidResult(Map model, String biddingNo, HttpServletRequest request) {
        JcbdBdProviderDto provider;
        BiddingBaseInfoVo biddingBaseInfoVo = this.biddingProviderService.getBiddingDetail(biddingNo);
        String supplierId = (String)request.getSession().getAttribute("SESSION_PERMIT_STORE_ID");
        String offerValidity = null;
        if (!(Lang.isEmpty((Object)supplierId) || Lang.isEmpty((Object)biddingBaseInfoVo.getId()) || Lang.isEmpty((Object)(provider = this.biddingProviderService.getProviderByBiddingNoAndSupplierId(biddingBaseInfoVo.getId(), supplierId)).getOfferValidity()))) {
            offerValidity = DateUtils.dateToStr((Date)provider.getOfferValidity(), (String)"yyyy-MM-dd");
        }
        model.put("baseInfo", biddingBaseInfoVo);
        model.put("offerValidity", offerValidity);
        return "/bidding/supplier/supplierBidResult";
    }

    @RequestMapping(value={"/supplierModifySku"})
    public String supplierModifySku() {
        return "/bidding/supplier/supplierModifySku";
    }

    @RequestMapping(value={"/supplierOrderManage"})
    public String supplierOrderManage() {
        return "/bidding/supplier/supplierOrderManage";
    }

    @RequestMapping(value={"/supplierOrderDetail"})
    public String supplierOrderDetail() {
        return "/bidding/supplier/supplierOrderDetailQuery";
    }
}

