/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.query.BiddingMainQueryApi;
import bidding.web.service.BiddingAuditorService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BiddingAuditIncomeInfoVo;
import bidding.web.vo.BiddingAuditValidateInfoVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import dto.JcbdBiddingOperationLogDto;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.data.Encodes;
import utils.security.Digests;
import workflow.api.WorkFlowQueryApi;
import workflow.api.WorkFlowServiceApi;
import workflow.definition.AuditBusinessCode;
import workflow.dto.WfWorkFlowLogDto;
import workflow.query.WorkFlowInfoQuery;
import workflow.vo.WorkFlowVo;

@Service
public class BiddingAuditorServiceImpl
implements BiddingAuditorService {
    private static final Logger log = LoggerFactory.getLogger(BiddingAuditorServiceImpl.class);
    @MotanReferer
    WorkFlowServiceApi workFlowServiceApi;
    @MotanReferer
    WorkFlowQueryApi workFlowQueryApi;
    @Value(value="${bidding.result.baseurl}")
    private String biddingResultBaseUrl;
    @Value(value="${bid.trading.limit}")
    private String limit;
    @Autowired
    BiddingOperatorService biddingOperatorService;
    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;

    public BaseResponse biddingResultAudit(WorkFlowVo workFlowVo) {
        BaseResponse baseResponse = new BaseResponse(true, "\u5ba1\u6838\u6210\u529f");
        Boolean isCorrect = this.workFlowQueryApi.checkCorrectOrderById(workFlowVo.getWorkFlowLogId());
        if (isCorrect.booleanValue()) {
            WfWorkFlowLogDto workFlowLog = this.workFlowQueryApi.findById(workFlowVo.getWorkFlowLogId());
            try {
                this.workFlowServiceApi.handleWorkFlow(workFlowVo);
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("\u5ba1\u6838\u7ade\u4ef7\u7ed3\u679c");
                jcbdBiddingOperationLogDto.setRemark(workFlowVo.getReason());
                this.biddingOperatorService.saveAuditOperatorsLog(workFlowLog.getWorkerId(), workFlowVo.getOrderId(), jcbdBiddingOperationLogDto);
                return baseResponse;
            }
            catch (Exception e) {
                log.error("\u7ade\u4ef7\u5ba1\u6838\u51fa\u9519workFlowVo={}", (Object)JSON.toJSONString((Object)workFlowVo), (Object)e);
            }
        }
        baseResponse.setSuccess(false);
        baseResponse.setResultMessage("\u5ba1\u6838\u53c2\u6570\u9519\u8bef");
        return baseResponse;
    }

    public BaseResponse<BiddingAuditValidateInfoVo> getAuditInfo(BiddingAuditIncomeInfoVo biddingAuditIncomeInfoVo) {
        BiddingAuditValidateInfoVo biddingAuditValidateInfoVo = new BiddingAuditValidateInfoVo();
        WfWorkFlowLogDto workFlowLog = null;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{biddingAuditIncomeInfoVo.getBiddingNo()})) {
            WorkFlowInfoQuery workFlowInfoQuery = new WorkFlowInfoQuery();
            workFlowInfoQuery.setWorkerIds(Arrays.asList(biddingAuditIncomeInfoVo.getWorkerId()));
            workFlowInfoQuery.setBusinessCode(AuditBusinessCode.BIDDING_RESULT_AUDIT.getBusinessCode());
            workFlowInfoQuery.setBusinessNo(biddingAuditIncomeInfoVo.getBiddingNo());
            List wfWorkFlowLogDtos = this.workFlowQueryApi.findByWorkFlowInfoQuery(workFlowInfoQuery);
            if (wfWorkFlowLogDtos != null && !wfWorkFlowLogDtos.isEmpty()) {
                workFlowLog = (WfWorkFlowLogDto)wfWorkFlowLogDtos.get(0);
            }
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{biddingAuditIncomeInfoVo.getEncryptId()}) && (workFlowLog = this.workFlowQueryApi.findByEncryptIdAndPass(biddingAuditIncomeInfoVo.getEncryptId(), null)) == null) {
            return new BaseResponse(false, "\u627e\u4e0d\u5230\u5bf9\u5e94\u5ba1\u6838\u8bb0\u5f55", (Object)biddingAuditValidateInfoVo);
        }
        if (workFlowLog == null) {
            return new BaseResponse(false, "\u627e\u4e0d\u5230\u5bf9\u5e94\u5ba1\u6838\u8bb0\u5f55", (Object)biddingAuditValidateInfoVo);
        }
        biddingAuditValidateInfoVo.setBiddingNo(workFlowLog.getOrderId());
        biddingAuditValidateInfoVo.setFlowLogId(workFlowLog.getId());
        biddingAuditValidateInfoVo.setWorkerId(workFlowLog.getWorkerId());
        BigDecimal price = this.biddingMainQueryApi.getBiddingGeneralBudget(biddingAuditValidateInfoVo.getBiddingNo());
        biddingAuditValidateInfoVo.setPrice(price);
        if (price.compareTo(new BigDecimal(this.limit)) > 0) {
            biddingAuditValidateInfoVo.setShowPrompt(Boolean.valueOf(true));
        } else {
            biddingAuditValidateInfoVo.setShowPrompt(Boolean.valueOf(false));
        }
        return new BaseResponse(true, "\u67e5\u8be2\u5ba1\u6838\u4fe1\u606f\u6210\u529f", (Object)biddingAuditValidateInfoVo);
    }

    private String encriptAttestation(WfWorkFlowLogDto workFlowLog, String url) {
        String attestation = Encodes.encodeHex((byte[])Digests.sha1((byte[])url.getBytes(), (byte[])workFlowLog.getSalt().getBytes(), (int)1024));
        return attestation;
    }
}

