/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import bidding.web.service.BiddingCompanyService;
import bidding.web.vo.JsonModel;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.List;
import member.api.CoreCompDepartUserApi;
import member.api.dto.core.CoreCompanyDto;
import member.model.core.CoreCompany;
import member.model.repository.core.CompanyRepos;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BiddingCompanyServiceImpl
implements BiddingCompanyService {
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @Autowired
    CompanyRepos companyRepos;

    public List<JsonModel> companyTree(String userId, String positionDtoCode) {
        CoreCompanyDto coreCompanyDto = this.coreCompDepartUserApi.getCompanyByUserIdAndPositon(userId, positionDtoCode);
        CoreCompany coreCompany = this.companyRepos.findById(coreCompanyDto.getId());
        ArrayList<JsonModel> companyTree = new ArrayList<JsonModel>();
        this.getChildCompany(coreCompany, companyTree);
        this.getParentCompny(coreCompany, companyTree);
        return companyTree;
    }

    private void getParentCompny(CoreCompany company, List<JsonModel> companyTree) {
        CoreCompany companyParent = company.getParent();
        JsonModel jsonModel = new JsonModel();
        jsonModel.setId(company.getId());
        if (companyParent.getCompanyLevel() == CoreCompanyDto.COMPANY_LEVEL_ONE) {
            jsonModel.setParent("#");
        } else {
            jsonModel.setParent(companyParent.getId());
        }
        jsonModel.setText(company.getName());
        jsonModel.setIcon("false");
        jsonModel.setType1("company");
        companyTree.add(jsonModel);
        if (company.getCompanyLevel() != CoreCompanyDto.COMPANY_LEVEL_TWO) {
            this.getParentCompny(companyParent, companyTree);
        }
    }

    private void getChildCompany(CoreCompany companyParent, List<JsonModel> companyTree) {
        List childCompany = companyParent.getChild();
        if (childCompany == null) {
            return;
        }
        for (CoreCompany company : childCompany) {
            JsonModel jsonModel = new JsonModel();
            jsonModel.setId(company.getId());
            jsonModel.setParent(companyParent.getId());
            jsonModel.setText(company.getName());
            jsonModel.setIcon("false");
            jsonModel.setType1("company");
            companyTree.add(jsonModel);
            this.getChildCompany(company, companyTree);
        }
    }
}

