/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.BiddingConformityReviewApi;
import api.BiddingMainApi;
import api.BiddingVoteApi;
import api.query.BiddingConformityReviewQueryApi;
import api.query.BiddingMainQueryApi;
import api.query.BiddingQueryApi;
import bidding.web.service.BiddingGroupService;
import bidding.web.service.impl.BiddingOperatorServiceImpl;
import bidding.web.vo.BiddingChangeStateVo;
import bidding.web.vo.BiddingConformityAuditVO;
import bidding.web.vo.BiddingDemandAuditVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.ResComplianceAuditVo;
import bidding.web.vo.VoteDetailVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingBusinessCode;
import definition.BiddingOperateCode;
import definition.BiddingStatus;
import definition.ConformanceAuditThreshold;
import definition.MailTemplateEnum;
import dto.BiddingAuditDTO;
import dto.BiddingChangeStateDto;
import dto.BiddingConformityAuditDTO;
import dto.BiddingStateResponseDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingGroupMemberDto;
import dto.VoteDetailDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import message.MailModule;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.mail.vo.MailTemplateReq;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingGroupServiceImpl
implements BiddingGroupService {
    public static final Logger log = LoggerFactory.getLogger(BiddingGroupServiceImpl.class);
    @MotanReferer
    BiddingConformityReviewApi biddingConformityReviewApi;
    @MotanReferer
    BiddingMainApi biddingMainApi;
    @MotanReferer
    MailApi mailApi;
    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;
    @MotanReferer
    BiddingVoteApi biddingVoteApi;
    @MotanReferer
    BiddingQueryApi biddingQueryApi;
    @Value(value="${spring.mail.username}")
    String mailFrom;
    @MotanReferer
    BiddingConformityReviewQueryApi biddingConformityReviewQueryApi;
    @Autowired
    BiddingOperatorServiceImpl biddingOperatorService;

    public BaseResponse saveComplianceAudit(BiddingConformityAuditVO biddingConformityAuditVO) {
        BiddingConformityAuditDTO conformityAudit = (BiddingConformityAuditDTO)BeanMapper.map((Object)biddingConformityAuditVO, BiddingConformityAuditDTO.class);
        BaseResponse baseResponse = this.biddingConformityReviewApi.saveBiddingConformityReviewAuditData(conformityAudit);
        log.info("\u4fdd\u5b58\u7b26\u5408\u6027\u5ba1\u67e5:{}", (Object)JSON.toJSONString((Object)conformityAudit));
        if (!Lang.isEmpty((Object)biddingConformityAuditVO.getAuditorId())) {
            this.biddingOperatorService.getOperatorName(biddingConformityAuditVO.getAuditorId());
        }
        return baseResponse;
    }

    public BaseResponse submitComplianceAuditResult(String biddingCode, String auditorId, String email) {
        BaseResponse isLastSubmit = this.biddingConformityReviewApi.isLastBiddingConformityReviewSubmit(biddingCode);
        this.biddingMainApi.changeBiddingGroupMemberStatus(biddingCode, auditorId, BiddingStatus.M_CONFORM_AUDIT_OK.getValue(), email);
        if (((Boolean)isLastSubmit.getResult()).booleanValue()) {
            BaseResponse supplierCount = this.biddingConformityReviewApi.getBiddingComformanceAuditAvailableCount(biddingCode);
            if ((Integer)supplierCount.getResult() >= ConformanceAuditThreshold.Threshold.getValue()) {
                BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(biddingCode);
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_IN.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.IN_CONFORMITY_REVIEW_PASS.getCode());
                BiddingStateResponseDto biddingStateResponseDto = this.biddingMainApi.changeBiddingState(biddingChangeStateDto);
                if (BiddingStatus.OM_CONFORM_AUDIT_YES.getValue().equals(biddingStateResponseDto.getBiddingState())) {
                    return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
                }
                return new BaseResponse(false, "\u64cd\u4f5c\u5931\u8d25");
            }
            BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
            biddingChangeStateDto.setBiddingNo(biddingCode);
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_IN.getValue());
            biddingChangeStateDto.setOpcode(BiddingOperateCode.IN_CONFORMITY_REVIEW_NO_PASS.getCode());
            BiddingStateResponseDto biddingStateResponseDto = this.biddingMainApi.changeBiddingState(biddingChangeStateDto);
            if (biddingStateResponseDto.getBiddingState().equals(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue())) {
                return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
            }
            return new BaseResponse("\u64cd\u4f5c\u5931\u8d25");
        }
        return new BaseResponse(true, "\u7b49\u5f85\u5176\u4ed6\u5c0f\u7ec4\u6210\u5458\u63d0\u4ea4\u5ba1\u67e5");
    }

    public BaseResponse auditBidding(BiddingDemandAuditVo biddingDemandAuditVo) {
        BiddingAuditDTO biddingAudit = (BiddingAuditDTO)BeanMapper.map((Object)biddingDemandAuditVo, BiddingAuditDTO.class);
        BaseResponse baseResponse = this.biddingMainApi.auditBiddingDemand(biddingAudit);
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        return new BaseResponse(true, "\u7ade\u4ef7\u5ba1\u6838\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
    }

    public BaseResponse voteConfirmSupplier(BiddingChangeStateVo changeStateVo, String auditorId) {
        JcbdBiddingVo biddingByBiddingCode = this.biddingOperatorService.getBiddingByBiddingCode(changeStateVo.getBiddingNo());
        if (!Lang.isEmpty((Object)biddingByBiddingCode)) {
            if (BiddingStatus.OM_VOTE_EVEN.getValue().equals(biddingByBiddingCode.getStatus())) {
                changeStateVo.setCurrentState(BiddingStatus.OM_VOTE_EVEN.getValue());
                changeStateVo.setOpcode(BiddingOperateCode.VOTE_CONFIRM_SUPPLIER.getCode());
                this.biddingMainApi.updateBiddingVoteNo(changeStateVo.getBiddingNo());
            } else if (BiddingStatus.OM_RESULT_SELECT_WAIT_VOTE.getValue().equals(biddingByBiddingCode.getStatus())) {
                changeStateVo.setCurrentState(BiddingStatus.OM_RESULT_SELECT_WAIT_VOTE.getValue());
                changeStateVo.setOpcode(BiddingOperateCode.VOTE_CONFIRM_SUPPLIER.getCode());
                this.biddingMainApi.updateBiddingVoteNo(changeStateVo.getBiddingNo());
            }
        }
        BiddingChangeStateDto changeStateDto = (BiddingChangeStateDto)BeanMapper.map((Object)changeStateVo, BiddingChangeStateDto.class);
        log.info("\u5f00\u542f\u6295\u7968\u53d8\u66f4\u7ade\u4ef7\u72b6\u6001\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)changeStateDto));
        BiddingStateResponseDto responseDto = this.biddingMainApi.changeBiddingState(changeStateDto);
        if (!BiddingStatus.OM_VOTING.getValue().equals(responseDto.getBiddingState())) {
            log.info("\u5f00\u542f\u6295\u7968\u7ade\u4ef7\u72b6\u6001\u53d8\u66f4\u5f02\u5e38:\u8fd4\u56de\u503c{},\u9884\u671f\u503c{}", (Object)responseDto.getBiddingState(), (Object)BiddingStatus.OM_VOTING.getValue());
            return new BaseResponse("\u7ade\u4ef7\u72b6\u6001\u5f02\u5e38");
        }
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        String companyName = this.biddingOperatorService.getOperateInformation(auditorId).getWholeJobName();
        JcbdBiddingVo jcbdBiddingVo = this.biddingOperatorService.getBiddingByBiddingCode(changeStateVo.getBiddingNo());
        JcbdBiddingVo operator = this.biddingOperatorService.getOperator(jcbdBiddingVo.getOperatorId());
        List byBiddingNoAndStatus = this.biddingQueryApi.findByBiddingNoAndStatus(changeStateVo.getBiddingNo(), BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
        String providerNum = String.valueOf(byBiddingNoAndStatus.size());
        try {
            BaseResponse biddingGroupMembers = this.biddingConformityReviewQueryApi.findBiddingGroupMember(changeStateDto.getBiddingNo());
            int size = ((List)biddingGroupMembers.getResult()).size();
            String[] sendEmail = new String[size];
            if (biddingGroupMembers.isSuccess()) {
                for (int i = 0; i < size; ++i) {
                    sendEmail[i] = ((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getEmail();
                    mailReq.setTo(new String[]{sendEmail[i]});
                    mailReq.setFrom(operator.getEmail());
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel("jc");
                    mailTemplateReq.setMailReq(mailReq);
                    String templateCode = MailTemplateEnum.BID_VOTE_START.getTemplateCode();
                    String redirectUrl = "/operator/vote";
                    String url = this.biddingOperatorService.makeLoginUrl(StringUtils.join((Object[])new String[]{sendEmail[i]}), changeStateDto.getBiddingNo(), redirectUrl);
                    mailTemplateReq.setTemplateCode(templateCode);
                    ArrayList<String> subjectArgs = new ArrayList<String>();
                    subjectArgs.add(changeStateDto.getBiddingNo());
                    ArrayList<String> contextArgs = new ArrayList<String>();
                    if (!Lang.isEmpty((Object)((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getName())) {
                        contextArgs.add(((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getName());
                    } else {
                        contextArgs.add(((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getEmail());
                    }
                    contextArgs.add(providerNum);
                    contextArgs.add(companyName);
                    contextArgs.add(operator.getUsername());
                    contextArgs.add(changeStateDto.getBiddingNo());
                    contextArgs.add(url);
                    contextArgs.add(url);
                    mailTemplateReq.setSubjectArgList(subjectArgs);
                    mailTemplateReq.setContentArgList(contextArgs);
                    mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                    MailRsp mailRsp = this.mailApi.sendMailByTemplate(mailTemplateReq);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u51fa\u9519\uff1a{}", (Throwable)e);
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public BaseResponse vote(VoteDetailVo voteDetailVo, String auditorEmail) {
        voteDetailVo.setBusinessCode(BiddingBusinessCode.BIDDING_VOTE_TO_SUPPLIER.getValue());
        voteDetailVo.setBusinessDescription(BiddingBusinessCode.BIDDING_VOTE_TO_SUPPLIER.getDescription());
        JcbdBiddingDto jcbdBiddingDto = this.biddingMainQueryApi.queryBidding(voteDetailVo.getBusinessIdentifying());
        voteDetailVo.setVoteNo(jcbdBiddingDto.getVoteNo());
        VoteDetailDto voteDetailDto = (VoteDetailDto)BeanMapper.map((Object)voteDetailVo, VoteDetailDto.class);
        voteDetailDto.setVoteEmail(auditorEmail);
        BaseResponse baseResponse = this.biddingVoteApi.voteSelectionSupplier(voteDetailDto);
        if (baseResponse.isSuccess()) {
            return new BaseResponse(true, "\u6295\u7968\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        }
        return baseResponse;
    }

    public BaseResponse restartComplianceAudit(ResComplianceAuditVo resComplianceAuditVo, String auditorId) {
        int i;
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        BiddingChangeStateDto biddingChangeStateDto = (BiddingChangeStateDto)BeanMapper.map((Object)resComplianceAuditVo, BiddingChangeStateDto.class);
        biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue());
        biddingChangeStateDto.setOpcode(BiddingOperateCode.RESTART_CONFORMITY_REVIEW.getCode());
        String companyName = this.biddingOperatorService.getOperateInformation(auditorId).getWholeJobName();
        JcbdBiddingVo jcbdBiddingVo = this.biddingOperatorService.getBiddingByBiddingCode(resComplianceAuditVo.getBiddingNo());
        JcbdBiddingVo operator = this.biddingOperatorService.getOperator(jcbdBiddingVo.getOperatorId());
        BiddingStateResponseDto responseDto = this.biddingMainApi.changeBiddingState(biddingChangeStateDto);
        if (!Lang.isEmpty((Object)responseDto) && !responseDto.getBiddingState().equals(BiddingStatus.OM_CONFORM_AUDIT_IN.getValue())) {
            return new BaseResponse("\u64cd\u4f5c\u5931\u8d25");
        }
        List mails = resComplianceAuditVo.getMails();
        ArrayList<JcbdBiddingGroupMemberDto> complianceBiddingGroupMembers = new ArrayList<JcbdBiddingGroupMemberDto>();
        ArrayList noComplianceBiddingGroupMembers = new ArrayList();
        BaseResponse biddingGroupMembers = this.biddingConformityReviewQueryApi.findBiddingGroupMember(resComplianceAuditVo.getBiddingNo());
        if (!Lang.isEmpty((Object)mails) && !Lang.isEmpty((Object)biddingGroupMembers)) {
            for (JcbdBiddingGroupMemberDto biddingGroupMember : (List)biddingGroupMembers.getResult()) {
                for (int j = 0; j < mails.size(); ++j) {
                    if (!((String)mails.get(j)).equals(biddingGroupMember.getEmail())) continue;
                    complianceBiddingGroupMembers.add(biddingGroupMember);
                }
            }
            if (!Lang.isEmpty(complianceBiddingGroupMembers)) {
                for (JcbdBiddingGroupMemberDto complianceBiddingGroupMember : complianceBiddingGroupMembers) {
                    for (i = 0; i < ((List)biddingGroupMembers.getResult()).size(); ++i) {
                        if (!complianceBiddingGroupMember.getEmail().equals(((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getEmail())) continue;
                        ((List)biddingGroupMembers.getResult()).remove(i);
                    }
                }
            }
            if (!Lang.isEmpty((Object)biddingGroupMembers)) {
                for (JcbdBiddingGroupMemberDto noComplianceBiddingGroupMember : (List)biddingGroupMembers.getResult()) {
                    this.biddingMainApi.changeBiddingGroupMemberStatus(resComplianceAuditVo.getBiddingNo(), noComplianceBiddingGroupMember.getGroupMemberId(), BiddingStatus.M_CONFORM_AUDIT_OK.getValue(), noComplianceBiddingGroupMember.getEmail());
                }
            }
            if (!Lang.isEmpty(complianceBiddingGroupMembers)) {
                for (JcbdBiddingGroupMemberDto complianceBiddingGroupMember : complianceBiddingGroupMembers) {
                    this.biddingConformityReviewQueryApi.deleteComplianceAudit(resComplianceAuditVo.getBiddingNo(), complianceBiddingGroupMember.getEmail(), complianceBiddingGroupMember.getGroupMemberId());
                }
            }
        }
        try {
            int size = complianceBiddingGroupMembers.size();
            String[] sendEmail = new String[size];
            if (biddingGroupMembers.isSuccess()) {
                for (i = 0; i < size; ++i) {
                    sendEmail[i] = ((JcbdBiddingGroupMemberDto)complianceBiddingGroupMembers.get(i)).getEmail();
                    mailReq.setTo(new String[]{sendEmail[i]});
                    mailReq.setFrom(operator.getEmail());
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel("jc");
                    mailTemplateReq.setMailReq(mailReq);
                    String templateCode = MailTemplateEnum.BID_CONFORMANCE_AUDIT_UNLOCK.getTemplateCode();
                    mailTemplateReq.setTemplateCode(templateCode);
                    String redirectUrl = "/operator/complianceAudit";
                    String url = this.biddingOperatorService.makeLoginUrl(StringUtils.join((Object[])new String[]{sendEmail[i]}), biddingChangeStateDto.getBiddingNo(), redirectUrl);
                    ArrayList<String> subjectArgs = new ArrayList<String>();
                    subjectArgs.add(resComplianceAuditVo.getBiddingNo());
                    ArrayList<String> contextArgs = new ArrayList<String>();
                    if (!Lang.isEmpty((Object)((JcbdBiddingGroupMemberDto)complianceBiddingGroupMembers.get(i)).getName())) {
                        contextArgs.add(((JcbdBiddingGroupMemberDto)complianceBiddingGroupMembers.get(i)).getName());
                    } else {
                        contextArgs.add(((JcbdBiddingGroupMemberDto)complianceBiddingGroupMembers.get(i)).getEmail());
                    }
                    contextArgs.add(companyName);
                    contextArgs.add(operator.getUsername());
                    contextArgs.add(resComplianceAuditVo.getBiddingNo());
                    contextArgs.add(url);
                    contextArgs.add(url);
                    mailTemplateReq.setSubjectArgList(subjectArgs);
                    mailTemplateReq.setContentArgList(contextArgs);
                    mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                    MailRsp mailRsp = this.mailApi.sendMailByTemplate(mailTemplateReq);
                }
            }
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u51fa\u9519\uff1a{}", (Throwable)e);
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
        }
    }

    public BaseResponse compeleteAudit(String biddingNo, String auditorId, String email) {
        BaseResponse baseResponse = this.biddingMainApi.changeGroupMemberConfomanceCheck(biddingNo, auditorId, email);
        BaseResponse biddingConformityReviewAuditComplished = this.biddingConformityReviewApi.isBiddingConformityReviewAuditComplished(biddingNo, auditorId, email);
        if (!biddingConformityReviewAuditComplished.isSuccess()) {
            this.biddingMainApi.cancelGroupMemberConfomanceCheck(biddingNo, auditorId, email);
        }
        return biddingConformityReviewAuditComplished;
    }
}

